/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ooh_aStatistiques = new Arbre('Facturation/Articles/list-statistiqueArticle.tmpl', 'ooh-listeStatistiques');
var ooh_qListSA = new QueryHttp("Facturation/Articles/getDataListSA.tmpl");

var ooh_pageCourante;
var ooh_nbPages;



function ooh_initOngletStatistiques() {
  try {

		ooh_enableCriteres();
		ooh_changeVue();
		ooh_aStatistiques.deleteTree();
		document.getElementById('ooh-categorieAchats').collapsed = !gShowElemFour;

  } catch (e) {
  	recup_erreur(e);
  }
}


function ooh_enableCriteres() {
	try {

		var periode = document.getElementById('ooh-periode').value;

		document.getElementById("ooh-dateDebut").disabled = periode!="DD";
		document.getElementById("ooh-dateFin").disabled = periode!="DD";
		document.getElementById('ooh-nbMois').disabled = periode!="DM";

	} catch (e) {
    recup_erreur(e);
  }
}


function ooh_changeVue() {
	try {

		var vue = document.getElementById('ooh-vue').value;

		if (vue=="T") {
			document.getElementById('ooh-colDateDocument').collapsed = true;
			document.getElementById('ooh-colNumDocument').collapsed = true;
			document.getElementById('ooh-colDateDocument').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('ooh-colNumDocument').setAttribute("ignoreincolumnpicker", true);
		}
		else {
			document.getElementById('ooh-colDateDocument').collapsed = false;
			document.getElementById('ooh-colNumDocument').collapsed = false;
			document.getElementById('ooh-colDateDocument').removeAttribute("ignoreincolumnpicker");
			document.getElementById('ooh-colNumDocument').removeAttribute("ignoreincolumnpicker");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooh_changeCategorie() {
	try {

		if (!gAccesCoutAchat) {

			var categorie = document.getElementById('ooh-categorie').value;

			if (categorie=="A") {
				document.getElementById('ooh-colMontantCAHT').collapsed = true;
				document.getElementById('ooh-boxTotalHT').collapsed = true;
				document.getElementById('ooh-colMontantCAHT').setAttribute("ignoreincolumnpicker", true);
			}
			else {
				document.getElementById('ooh-colMontantCAHT').collapsed = false;
				document.getElementById('ooh-boxTotalHT').collapsed = false;
				document.getElementById('ooh-colMontantCAHT').removeAttribute("ignoreincolumnpicker");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooh_initCriteres() {
	try {

		document.getElementById('ooh-type').value = "F";
		document.getElementById('ooh-vue').value = "T";
		document.getElementById('ooh-categorie').value = "V";
		document.getElementById('ooh-periode').value = "MC";
		document.getElementById('ooh-dateDebut').value = "";
		document.getElementById('ooh-dateFin').value = "";
		document.getElementById('ooh-nbMois').value = "12";

		ooh_enableCriteres();
		ooh_changeVue();
		ooh_listerStatistiques();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_listerStatistiques() {
	try {

		var typeStatistique = document.getElementById('ooh-type').value;
		var vue = document.getElementById('ooh-vue').value;
		var categorie = document.getElementById('ooh-categorie').value;
		var periode = document.getElementById('ooh-periode').value;
		var dateDebut = document.getElementById('ooh-dateDebut').value;
		var dateFin = document.getElementById('ooh-dateFin').value;
		var nbMois = document.getElementById('ooh-nbMois').value;
		var nbLignesParPage = document.getElementById('ooh-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (periode=="DM" && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {

			ooh_pageCourante = 1;
			ooh_nbPages = 1;
			document.getElementById('ooh-pageDeb').value = 1;
			document.getElementById('ooh-pageFin').value = 1;
			document.getElementById('ooh-bPrec').disabled = true;
			document.getElementById('ooh-bSuiv').disabled = true;

			document.getElementById('ooh-listeStatistiques').disabled = true;
			document.getElementById('ooh-bEditionCsv').disabled = true;
			ooh_aStatistiques.deleteTree();

			ooh_qListSA.setParam("Article_Id", ofa_articleId);
			ooh_qListSA.setParam("Type_Statistique", typeStatistique);
			ooh_qListSA.setParam("Vue", vue);
			ooh_qListSA.setParam("Categorie", categorie);
			ooh_qListSA.setParam("Periode", periode);
			ooh_qListSA.setParam("Date_Debut", dateDebut);
			ooh_qListSA.setParam("Date_Fin", dateFin);
			ooh_qListSA.setParam("Nb_Mois", nbMois);
			ooh_qListSA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			ooh_qListSA.setParam("Current_Page", ooh_pageCourante);

			var result = ooh_qListSA.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('ooh-totalHT').value = contenu.getAttribute("Total_HT");
			document.getElementById('ooh-qteTotale').value = contenu.getAttribute("Qte_Totale");
			ooh_nbPages = contenu.getAttribute("Nb_Pages");

			ooh_aStatistiques.setParam("List_Item_Id", contenu.getAttribute("List_Item_Id"));
			ooh_aStatistiques.setParam("List_Avoir_Item_Id", contenu.getAttribute("List_Avoir_Item_Id"));
			ooh_aStatistiques.setParam("List_Comp_Id", contenu.getAttribute("List_Comp_Id"));
			ooh_aStatistiques.setParam("List_Avoir_Comp_Id", contenu.getAttribute("List_Avoir_Comp_Id"));
			ooh_aStatistiques.setParam("Type_Statistique", typeStatistique);
			ooh_aStatistiques.setParam("Categorie", categorie);
			ooh_aStatistiques.setParam("Vue", vue);
			ooh_aStatistiques.initTree(ooh_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_initPagination() {
	try {

		document.getElementById('ooh-pageDeb').value = ooh_pageCourante;
		document.getElementById('ooh-pageFin').value = (ooh_nbPages>0?ooh_nbPages:1);
		document.getElementById('ooh-bPrec').disabled = (ooh_pageCourante==1);
		document.getElementById('ooh-bSuiv').disabled = (ooh_pageCourante>=ooh_nbPages); // peut se produire si ooh_nbPages=0

		ooh_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_pressOnPagePrec() {
	try {

		ooh_pageCourante--;
		ooh_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_pressOnPageSuiv() {
	try {

		ooh_pageCourante++;
		ooh_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_majPagination() {
	try {

		document.getElementById('ooh-pageDeb').value = ooh_pageCourante;
		document.getElementById('ooh-bPrec').disabled = (ooh_pageCourante==1);
		document.getElementById('ooh-bSuiv').disabled = (ooh_pageCourante==ooh_nbPages);

		document.getElementById('ooh-listeStatistiques').disabled = true;
		document.getElementById('ooh-bEditionCsv').disabled = true;

		ooh_qListSA.setParam("Current_Page", ooh_pageCourante);
		var result = ooh_qListSA.execute();
		var contenu = result.responseXML.documentElement;

		ooh_aStatistiques.setParam("List_Item_Id", contenu.getAttribute("List_Item_Id"));
		ooh_aStatistiques.setParam("List_Avoir_Item_Id", contenu.getAttribute("List_Avoir_Item_Id"));
		ooh_aStatistiques.setParam("List_Comp_Id", contenu.getAttribute("List_Comp_Id"));
		ooh_aStatistiques.setParam("List_Avoir_Comp_Id", contenu.getAttribute("List_Avoir_Comp_Id"));
		ooh_aStatistiques.initTree(ooh_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_afterMajPagination() {
	try {

		document.getElementById('ooh-listeStatistiques').disabled = false;
		document.getElementById('ooh-bEditionCsv').disabled = (ooh_aStatistiques.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ooh_listerStatistiques();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ooh_pressOnEditionCsv() {
	try {

		var typeStatistique = document.getElementById('ooh-type').value;
		var vue = document.getElementById('ooh-vue').value;
		var categorie = document.getElementById('ooh-categorie').value;
		var periode = document.getElementById('ooh-periode').value;
		var dateDebut = document.getElementById('ooh-dateDebut').value;
		var dateFin = document.getElementById('ooh-dateFin').value;
		var nbMois = document.getElementById('ooh-nbMois').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (periode=="DM" && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Articles/csvStatistiqueArticle.tmpl");

			qEditionCsv.setParam("Article_Id", ofa_articleId);
			qEditionCsv.setParam("Type_Statistique", typeStatistique);
			qEditionCsv.setParam("Vue", vue);
			qEditionCsv.setParam("Categorie", categorie);
			qEditionCsv.setParam("Periode", periode);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Nb_Mois", nbMois);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
