/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/banques.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");


var gProfil;
var gConfig;
var gSiteWeb;
var gReadOnly;



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gConfig = getConfig();
		gSiteWeb = gConfig.isECommerce();

		gProfil = getProfil();
		gReadOnly = gProfil.isReadOnlyGC_TClients();

		document.getElementById('deck').selectedIndex = 0;
  	omc_init();
  	ofc_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}



function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		if (currentDeck==1) {
			ofc_demandeEnregistrement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuClients() {
	try {

		document.getElementById('ofc-pdfClient').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuClients').collapsed = true;
		document.getElementById('bRetourClient').collapsed = true;

		document.activeElement.blur();
		omc_listerClients();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFicheClient() {
  try {

		document.getElementById('ofc-pdfClient').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('ofc-deckClient').selectedIndex = 0;
		document.getElementById('bMenuClients').collapsed = false;
		document.getElementById('bRetourClient').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
