/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oom_aTarifMarqueClient = new Arbre("Facturation/Clients/list-tarifMarqueClient.tmpl", "oom-listeTarifs");
var oom_aTarifs = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oom-tarifId");
var oom_aMarques = new Arbre("ComboListe/combo-marquesArticle.tmpl","oom-marqueId");

var oom_tarMarId;
var oom_curMarque = "";
var oom_curTarif = "";



function oom_initOngletMarques() {
	try {

		document.getElementById('oom-boxRAZ').collapsed = gReadOnly;
		document.getElementById('oom-rowTarifMarque').collapsed = gReadOnly;

		oom_nouveauTarifMarqueClient();

		oom_aTarifMarqueClient.setParam("Client_Id", ofc_clientId);
		oom_aTarifMarqueClient.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function oom_chargerMarques(selection) {
	try {

		oom_curMarque = selection;
		oom_aMarques.setParam("Selection", oom_curMarque);
		oom_aMarques.initTree(oom_initMarque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_initMarque() {
  try {

		document.getElementById('oom-marqueId').value = oom_curMarque;

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_chargerTarifs(selection) {
	try {

		oom_curTarif = selection;
		oom_aTarifs.setParam("Selection", oom_curTarif);
		oom_aTarifs.initTree(oom_initTarif);

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_initTarif() {
  try {

		document.getElementById('oom-tarifId').value = oom_curTarif;

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_nouveauTarifMarqueClient() {
	try {

		oom_tarMarId = "";

		oom_chargerMarques("");
		oom_chargerTarifs("");
		document.getElementById("oom-bSupprimerTarifMarqueClient").disabled = true;
		document.getElementById("oom-marqueId").disabled = false;

		oom_aTarifMarqueClient.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_enregistrerTarifMarqueClient() {
	try {

		var marqueId = document.getElementById("oom-marqueId").value;
		var tarifId = document.getElementById("oom-tarifId").value;

		if (isEmpty(marqueId)) {
			showWarning("Veuillez sp\u00E9cifier une marque");
		}
		else if (isEmpty(tarifId)) {
			showWarning("Veuillez sp\u00E9cifier un tarif");
		}
		else {
			var qSave;

			if (isEmpty(oom_tarMarId)) {
				qSave = new QueryHttp("Facturation/Clients/createTarifMarqueClient.tmpl");
				qSave.setParam("Client_Id", ofc_clientId);
				qSave.setParam("Marque_Id", marqueId);
			}
			else {
				qSave = new QueryHttp("Facturation/Clients/updateTarifMarqueClient.tmpl");
				qSave.setParam("Tar_Mar_Id", oom_tarMarId);
			}

			qSave.setParam("Tarif_Id", tarifId);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oom_aTarifMarqueClient.initTree();
			oom_nouveauTarifMarqueClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_supprimerTarifMarqueClient() {
	try {

		var qDelete = new QueryHttp("Facturation/Clients/deleteTarifMarqueClient.tmpl");
		qDelete.setParam("Tar_Mar_Id", oom_tarMarId);
		qDelete.execute();

		oom_aTarifMarqueClient.initTree();
		oom_nouveauTarifMarqueClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_pressOnListeTarifMarqueClient() {
	try {

		if (oom_aTarifMarqueClient.isSelected()) {
			oom_tarMarId = oom_aTarifMarqueClient.getSelectedCellText("oom-colTarMarId");

			oom_chargerMarques(oom_aTarifMarqueClient.getSelectedCellText("oom-colMarqueId"));
			oom_chargerTarifs(oom_aTarifMarqueClient.getSelectedCellText("oom-colTarifId"));

			document.getElementById("oom-bSupprimerTarifMarqueClient").disabled = false;
			document.getElementById("oom-marqueId").disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_razTarifMarqueClient() {
	try {

		if (window.confirm("Confirmez-vous la suppression de tous les tarifs par marques sp\u00E9cifiques li\u00E9s \u00E0 ce client ?")) {
			var qDelete = new QueryHttp("Facturation/Clients/deleteTarifMarqueClientByClientId.tmpl");
			qDelete.setParam("Client_Id", ofc_clientId);
			qDelete.execute();

			oom_aTarifMarqueClient.initTree();
			oom_nouveauTarifMarqueClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
