/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Client_Id
		- 2 : ArrondiHT
		- 3 : ArrondiTTC
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");


var aSites = new Arbre('ComboListe/combo-sitesWeb.tmpl','siteWeb');
var aFamilles1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille1');
var aFamilles2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille2');
var aFamilles3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille3');
var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'marque');
var aAttributs1 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut1');
var aAttributs2 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut2');
var aAttributs3 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut3');
var aAttributs4 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut4');
var aAttributs5 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut5');
var aAttributs6 = new Arbre('ComboListe/combo-attributs.tmpl', 'attribut6');

var aArticles = new Arbre("Facturation/Clients/list-ficheArticlePrixClient.tmpl", "listeArticles");
var qListFA = new QueryHttp("Facturation/Articles/getDataListFA.tmpl");

var pageCourante;
var nbPages;

var circonstAttr1 = false;
var circonstAttr2 = false;
var circonstAttr3 = false;
var circonstAttr4 = false;
var circonstAttr5 = false;
var circonstAttr6 = false;

var groupeAttr1;
var groupeAttr2;
var groupeAttr3;
var groupeAttr4;
var groupeAttr5;
var groupeAttr6;

var calculPossible = false;
var modified = false;

var argClientId;
var argArrondiHT;
var argArrondiTTC;



function init() {
	try {

		window.addEventListener("close", quitterPopup, false);

		argClientId = window.arguments[1];
		argArrondiHT = window.arguments[2];
		argArrondiTTC = window.arguments[3];

		aArticles.setParam("Client_Id", argClientId);

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		groupeAttr1 = contenu.getAttribute("Groupe_Id_1");
		groupeAttr2 = contenu.getAttribute("Groupe_Id_2");
		groupeAttr3 = contenu.getAttribute("Groupe_Id_3");
		groupeAttr4 = contenu.getAttribute("Groupe_Id_4");
		groupeAttr5 = contenu.getAttribute("Groupe_Id_5");
		groupeAttr6 = contenu.getAttribute("Groupe_Id_6");

		if (!isEmpty(groupeAttr1)) {
			document.getElementById('lblAttribut1').value = contenu.getAttribute('Intitule_1') +" :";
			document.getElementById('colAttribut1').setAttribute("label", contenu.getAttribute('Intitule_1'));
			circonstAttr1 = (contenu.getAttribute('Circonst_1')=="true");
			aAttributs1.setParam("Groupe_Id", groupeAttr1);
			aAttributs1.setParam("Search_Mode", true);
			aAttributs1.initTree();
		}
		else {
			document.getElementById('lblAttribut1').value = "Att. Princ. 1 :";
			document.getElementById('lblAttribut1').disabled = true;
			document.getElementById('attribut1').disabled = true;
			document.getElementById("colAttribut1").collapsed = true;
			document.getElementById("colAttribut1").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr2)) {
			document.getElementById('lblAttribut2').value = contenu.getAttribute('Intitule_2') +" :";
			document.getElementById('colAttribut2').setAttribute("label", contenu.getAttribute('Intitule_2'));
			circonstAttr2 = (contenu.getAttribute('Circonst_2')=="true");
			aAttributs2.setParam("Groupe_Id", groupeAttr2);
			aAttributs2.setParam("Search_Mode", true);
			aAttributs2.initTree();
		}
		else {
			document.getElementById('lblAttribut2').value = "Att. Princ. 2 :";
			document.getElementById('lblAttribut2').disabled = true;
			document.getElementById('attribut2').disabled = true;
			document.getElementById("colAttribut2").collapsed = true;
			document.getElementById("colAttribut2").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr3)) {
			document.getElementById('lblAttribut3').value = contenu.getAttribute('Intitule_3') +" :";
			document.getElementById('colAttribut3').setAttribute("label", contenu.getAttribute('Intitule_3'));
			circonstAttr3 = (contenu.getAttribute('Circonst_3')=="true");
			aAttributs3.setParam("Groupe_Id", groupeAttr3);
			aAttributs3.setParam("Search_Mode", true);
			aAttributs3.initTree();
		}
		else {
			document.getElementById('lblAttribut3').value = "Att. Princ. 3 :";
			document.getElementById('lblAttribut3').disabled = true;
			document.getElementById('attribut3').disabled = true;
			document.getElementById("colAttribut3").collapsed = true;
			document.getElementById("colAttribut3").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr4)) {
			document.getElementById('lblAttribut4').value = contenu.getAttribute('Intitule_4') +" :";
			document.getElementById('colAttribut4').setAttribute("label", contenu.getAttribute('Intitule_4'));
			circonstAttr4 = (contenu.getAttribute('Circonst_4')=="true");
			aAttributs4.setParam("Groupe_Id", groupeAttr4);
			aAttributs4.setParam("Search_Mode", true);
			aAttributs4.initTree();
		}
		else {
			document.getElementById('lblAttribut4').value = "Att. Princ. 4 :";
			document.getElementById('lblAttribut4').disabled = true;
			document.getElementById('attribut4').disabled = true;
			document.getElementById("colAttribut4").collapsed = true;
			document.getElementById("colAttribut4").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr5)) {
			document.getElementById('lblAttribut5').value = contenu.getAttribute('Intitule_5') +" :";
			document.getElementById('colAttribut5').setAttribute("label", contenu.getAttribute('Intitule_5'));
			circonstAttr5 = (contenu.getAttribute('Circonst_5')=="true");
			aAttributs5.setParam("Groupe_Id", groupeAttr5);
			aAttributs5.setParam("Search_Mode", true);
			aAttributs5.initTree();
		}
		else {
			document.getElementById('lblAttribut5').value = "Att. Princ. 5 :";
			document.getElementById('lblAttribut5').disabled = true;
			document.getElementById('attribut5').disabled = true;
			document.getElementById("colAttribut5").collapsed = true;
			document.getElementById("colAttribut5").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(groupeAttr6)) {
			document.getElementById('lblAttribut6').value = contenu.getAttribute('Intitule_6') +" :";
			document.getElementById('colAttribut6').setAttribute("label", contenu.getAttribute('Intitule_6'));
			circonstAttr6 = (contenu.getAttribute('Circonst_6')=="true");
			aAttributs6.setParam("Groupe_Id", groupeAttr6);
			aAttributs6.setParam("Search_Mode", true);
			aAttributs6.initTree();
		}
		else {
			document.getElementById('lblAttribut6').value = "Att. Princ. 6 :";
			document.getElementById('lblAttribut6').disabled = true;
			document.getElementById('attribut6').disabled = true;
			document.getElementById("colAttribut6").collapsed = true;
			document.getElementById("colAttribut6").setAttribute("ignoreincolumnpicker", true);
		}

		aMarques.setParam("Search_Mode", true);
		aMarques.initTree();

		aFamilles1.setParam("Search_Mode", true);
		aFamilles2.setParam("Search_Mode", true);
		aFamilles3.setParam("Search_Mode", true);

		document.getElementById('famille2').disabled = true;
		document.getElementById('famille3').disabled = true;
		aFamilles1.initTree();

		if (getConfig().isECommerce()) {
	  	aSites.initTree();
			document.getElementById("row-siteWeb").collapsed = false;
		}

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "Tarif_Id");
		aTarifsVente.initTree();

		document.getElementById('reference').focus();

	} catch (e) {
  	recup_erreur(e);
	}
}


function chargerFamilles2() {
	try {

		var famille1 = document.getElementById('famille1').value;

		document.getElementById('famille2').value = "";
		document.getElementById('famille2').disabled = isEmpty(famille1);

		aFamilles3.deleteTree();
		document.getElementById('famille3').value = "";
		document.getElementById('famille3').disabled = true;

		aFamilles2.setParam('Parent_Id', famille1);
		aFamilles2.initTree(manageCirconstAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles3() {
	try {

		var famille2 = document.getElementById('famille2').value;

		document.getElementById('famille3').value = "";
		document.getElementById('famille3').disabled = isEmpty(famille2);

		aFamilles3.setParam('Parent_Id', famille2);
		aFamilles3.initTree(manageCirconstAttributs);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerArticles();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function manageCirconstAttributs() {
	try {

		var famille1 = document.getElementById('famille1').value;
		var famille2 = document.getElementById('famille2').value;
		var famille3 = document.getElementById('famille3').value;

		var familleId = !isEmpty(famille3)?famille3:!isEmpty(famille2)?famille2:famille1;

		if (!isEmpty(familleId)) {
			var qCirc = new QueryHttp("Facturation/Commun/existGroupeAttributFamilleArticle.tmpl");
			qCirc.setParam("Famille_Id", familleId);

			if (circonstAttr1 && !isEmpty(groupeAttr1)) {
				qCirc.setParam("Groupe_Id", groupeAttr1);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut1').disabled = true;
					document.getElementById('attribut1').value = "";
				}
				else {
					document.getElementById('attribut1').disabled = false;
				}
			}

			if (circonstAttr2 && !isEmpty(groupeAttr2)) {
				qCirc.setParam("Groupe_Id", groupeAttr2);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut2').disabled = true;
					document.getElementById('attribut2').value = "";
				}
				else {
					document.getElementById('attribut2').disabled = false;
				}
			}

			if (circonstAttr3 && !isEmpty(groupeAttr3)) {
				qCirc.setParam("Groupe_Id", groupeAttr3);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut3').disabled = true;
					document.getElementById('attribut3').value = "";
				}
				else {
					document.getElementById('attribut3').disabled = false;
				}
			}

			if (circonstAttr4 && !isEmpty(groupeAttr4)) {
				qCirc.setParam("Groupe_Id", groupeAttr4);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut4').disabled = true;
					document.getElementById('attribut4').value = "";
				}
				else {
					document.getElementById('attribut4').disabled = false;
				}
			}

			if (circonstAttr5 && !isEmpty(groupeAttr5)) {
				qCirc.setParam("Groupe_Id", groupeAttr5);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut5').disabled = true;
					document.getElementById('attribut5').value = "";
				}
				else {
					document.getElementById('attribut5').disabled = false;
				}
			}

			if (circonstAttr6 && !isEmpty(groupeAttr6)) {
				qCirc.setParam("Groupe_Id", groupeAttr6);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('attribut6').disabled = true;
					document.getElementById('attribut6').value = "";
				}
				else {
					document.getElementById('attribut6').disabled = false;
				}
			}
		}
		else {
			document.getElementById('attribut1').disabled = isEmpty(groupeAttr1);
			document.getElementById('attribut2').disabled = isEmpty(groupeAttr2);
			document.getElementById('attribut3').disabled = isEmpty(groupeAttr3);
			document.getElementById('attribut4').disabled = isEmpty(groupeAttr4);
			document.getElementById('attribut5').disabled = isEmpty(groupeAttr5);
			document.getElementById('attribut6').disabled = isEmpty(groupeAttr6);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById('famille2').disabled = true;
		document.getElementById('famille3').disabled = true;
		aFamilles2.deleteTree();
		aFamilles3.deleteTree();

		document.getElementById('reference').value = "";
		document.getElementById('refModele').value = "";
		document.getElementById('designation').value = "";
		document.getElementById('marque').value = "";
		document.getElementById('famille1').value = "";
		document.getElementById('famille2').value = "";
		document.getElementById('famille3').value = "";
		document.getElementById('attribut1').value = "";
		document.getElementById('attribut2').value = "";
		document.getElementById('attribut3').value = "";
		document.getElementById('attribut4').value = "";
		document.getElementById('attribut5').value = "";
		document.getElementById('attribut6').value = "";
		document.getElementById('siteWeb').value = "";
		document.getElementById('actif').checked = true;

		document.getElementById('Prix_HT').value = "";
		document.getElementById('Prix_TTC').value = "";
		document.getElementById('Coeff').value = "";
		document.getElementById('Taux_Marque').value = "";
		document.getElementById('Taux_Marge').value = "";
		document.getElementById('Tarif_Id').value = "";
		document.getElementById("infoart").collapsed = false;
		document.getElementById("nb_article_mod").collapsed = true;
		document.getElementById('infoReference').value = "";
		document.getElementById('infoDesignation').value = "";
		document.getElementById('infoPrixRevient').value = "";
		calculPossible = false;

		manageCirconstAttributs();

		listerArticles();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerArticles() {
	try {

		var reference = document.getElementById('reference').value;
		var refModele = document.getElementById('refModele').value;
		var designation = document.getElementById('designation').value;
		var marque = document.getElementById('marque').value;
		var famille1 = document.getElementById('famille1').value;
		var famille2 = document.getElementById('famille2').value;
		var famille3 = document.getElementById('famille3').value;
		var attribut1 = document.getElementById('attribut1').value;
		var attribut2 = document.getElementById('attribut2').value;
		var attribut3 = document.getElementById('attribut3').value;
		var attribut4 = document.getElementById('attribut4').value;
		var attribut5 = document.getElementById('attribut5').value;
		var attribut6 = document.getElementById('attribut6').value;
		var siteWeb = document.getElementById('siteWeb').value;
		var actif = document.getElementById('actif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeArticles').disabled = true;
		document.getElementById('bToutSelectionner').disabled = true;
		document.getElementById('bToutDeselectionner').disabled = true;
		document.getElementById('Prix_HT').disabled = true;
		document.getElementById('Prix_TTC').disabled = true;
		document.getElementById('Coeff').disabled = true;
		document.getElementById('Taux_Marque').disabled = true;
		document.getElementById('Taux_Marge').disabled = true;
		document.getElementById('Tarif_Id').disabled = true;
		document.getElementById('bValiderTarif').disabled = true;
		aArticles.deleteTree();

		qListFA.setParam("Reference", reference);
		qListFA.setParam("Ref_Modele", refModele);
		qListFA.setParam("Designation", designation);
		qListFA.setParam("Marque", marque);
		qListFA.setParam("Famille_1", famille1);
		qListFA.setParam("Famille_2", famille2);
		qListFA.setParam("Famille_3", famille3);
		qListFA.setParam("Attribut_1", attribut1);
		qListFA.setParam("Attribut_2", attribut2);
		qListFA.setParam("Attribut_3", attribut3);
		qListFA.setParam("Attribut_4", attribut4);
		qListFA.setParam("Attribut_5", attribut5);
		qListFA.setParam("Attribut_6", attribut6);
		qListFA.setParam("Type_Article", "");
		qListFA.setParam("Site_Web", siteWeb);
		qListFA.setParam("Actif", actif);
		qListFA.setParam("Vente_Achat", "V");
		qListFA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListFA.setParam("Current_Page", pageCourante);

		var result = qListFA.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listArticleId = contenu.getAttribute("List_Article_Id");

		aArticles.setParam("List_Article_Id", listArticleId);
		aArticles.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeArticles').disabled = true;

		qListFA.setParam("Current_Page", pageCourante);
		var result = qListFA.execute();
		var listArticleId = result.responseXML.documentElement.getAttribute("List_Article_Id");

		aArticles.setParam("List_Article_Id", listArticleId);
		aArticles.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeArticles').disabled = false;
		document.getElementById('bToutSelectionner').disabled = false;
		document.getElementById('bToutDeselectionner').disabled = false;
		document.getElementById('Prix_HT').disabled = false;
		document.getElementById('Prix_TTC').disabled = false;
		document.getElementById('Coeff').disabled = false;
		document.getElementById('Taux_Marque').disabled = false;
		document.getElementById('Taux_Marge').disabled = false;
		document.getElementById('Tarif_Id').disabled = false;
		document.getElementById('bValiderTarif').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeArticles() {
	try {

		document.getElementById('Prix_HT').value = "";
		document.getElementById('Prix_TTC').value = "";
		document.getElementById('Coeff').value = "";
		document.getElementById('Taux_Marque').value = "";
		document.getElementById('Taux_Marge').value = "";
		document.getElementById('Tarif_Id').value = "";

		var nbSelection = aArticles.nbSelection();

		if (nbSelection==0) {
			document.getElementById("infoart").collapsed = false;
			document.getElementById("nb_article_mod").collapsed = true;
			document.getElementById('infoReference').value = "";
			document.getElementById('infoDesignation').value = "";
			document.getElementById('infoPrixRevient').value = "";
			document.getElementById("Tarif_Id").collapsed = true;
			document.getElementById("lblTarif_Id").collapsed = true;
			calculPossible = false;
		}
		else if (nbSelection==1) {
			var currentIndex = aArticles.getCurrentIndex();
			document.getElementById("infoart").collapsed = false;
			document.getElementById("nb_article_mod").collapsed = true;
			document.getElementById('infoReference').value = aArticles.getCellText(currentIndex,'colReference');
			document.getElementById('infoDesignation').value = aArticles.getCellText(currentIndex,'colDesignation');
			document.getElementById('infoPrixRevient').value = aArticles.getCellText(currentIndex,'colPrixRevient');
			document.getElementById("Tarif_Id").collapsed = true;
			document.getElementById("lblTarif_Id").collapsed = true;
			calculPossible = (currentIndex!=-1);
		}
		else {
			document.getElementById("infoart").collapsed = true;
			document.getElementById("nb_article_mod").collapsed = false;
			document.getElementById('infoReference').value = "";
			document.getElementById('infoDesignation').value = "";
			document.getElementById('infoPrixRevient').value = "";
			document.getElementById("Tarif_Id").collapsed = false;
			document.getElementById("lblTarif_Id").collapsed = false;
			document.getElementById("label_article_mod").value = " Nouveau tarif pour les "+ nbSelection +" articles s\u00E9lectionn\u00E9s : ";
			calculPossible = false;
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function selectAll() {
	try {

		aArticles.selectAll();

	}	catch(e) {
		recup_erreur(e);
	}
}


function unselectAll() {
	try {

		aArticles.clearSelection();

	}	catch(e) {
		recup_erreur(e);
	}
}


function calculerTarif(origine) {
	try {

		if (calculPossible) {

			var nfHT = new Arrondi(argArrondiHT);
			var nfTTC = new Arrondi(argArrondiTTC);
			var nf6 = new NumberFormat("0.######", false);
			var nf4 = new NumberFormat("0.####", false);

			var currentIndex = aArticles.getCurrentIndex();
			var tva = parseFloat(aArticles.getCellText(currentIndex,"colTauxTVA"))/100 + 1;

			var pr = parseFloat(aArticles.getCellText(currentIndex,"colPrixRevient"));
			var baseHT = parseFloat(aArticles.getCellText(currentIndex,"colTarifHT"));

			if (origine=="h" && !isEmpty(document.getElementById('Prix_HT').value)) {
				var pvht = parseFloat(document.getElementById('Prix_HT').value);
				document.getElementById('Coeff').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
				document.getElementById('Prix_TTC').value = nfTTC.round(pvht * tva);
				document.getElementById('Taux_Marque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
				document.getElementById('Taux_Marge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
			else if (origine=="c" && !isEmpty(document.getElementById('Coeff').value)) {
				var pourcPV = parseFloat(document.getElementById('Coeff').value);
				var pvht = nfHT.round(baseHT * (1+pourcPV/100));
				document.getElementById('Prix_HT').value = nfHT.round(pvht);
				document.getElementById('Prix_TTC').value = nfTTC.round(pvht * tva);
				document.getElementById('Taux_Marque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
				document.getElementById('Taux_Marge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
			else if (origine=="t" && !isEmpty(document.getElementById('Prix_TTC').value)) {
				var pvht = nfHT.round(parseFloat(document.getElementById('Prix_TTC').value) / tva);
				document.getElementById('Prix_HT').value = nfHT.round(pvht);
				document.getElementById('Coeff').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
				document.getElementById('Taux_Marque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
				document.getElementById('Taux_Marge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
			else if (origine=="g" && !isEmpty(document.getElementById('Taux_Marge').value)) {
				var pvht = nfHT.round(pr * (1 + parseFloat(document.getElementById('Taux_Marge').value)/100));
				document.getElementById('Prix_HT').value = nfHT.round(pvht);
				document.getElementById('Coeff').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
				document.getElementById('Prix_TTC').value = nfTTC.round(pvht * tva);
				document.getElementById('Taux_Marque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			}
			else if (!isEmpty(document.getElementById('Taux_Marque').value)) {
				if (parseFloat(document.getElementById('Taux_Marque').value)>=100) {
					showWarning("Le taux de marque doit \u00EAtre inf\u00E9rieur \u00E0 100 % !");
				}
				else {
					var pvht = nfHT.round(pr / (1 - parseFloat(document.getElementById('Taux_Marque').value)/100));
					document.getElementById('Prix_HT').value = nfHT.round(pvht);
					document.getElementById('Coeff').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
					document.getElementById('Prix_TTC').value = nfTTC.round(pvht * tva);
					document.getElementById('Taux_Marge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
				}
			}
			else {
				document.getElementById('Taux_Marge').value = "";
				document.getElementById('Prix_HT').value = "";
				document.getElementById('Coeff').value = "";
				document.getElementById('Prix_TTC').value = "";
			}
		}
		else {
			if (origine=="h") {
				document.getElementById('Prix_TTC').value = "";
				document.getElementById('Coeff').value = "";
				document.getElementById('Taux_Marque').value = "";
				document.getElementById('Taux_Marge').value = "";
				document.getElementById('Tarif_Id').value = "";
			}
			else if (origine=="t") {
				document.getElementById('Prix_HT').value = "";
				document.getElementById('Coeff').value = "";
				document.getElementById('Taux_Marque').value = "";
				document.getElementById('Taux_Marge').value = "";
				document.getElementById('Tarif_Id').value = "";
			}
			else if (origine=="c") {
				document.getElementById('Prix_HT').value = "";
				document.getElementById('Prix_TTC').value = "";
				document.getElementById('Taux_Marque').value = "";
				document.getElementById('Taux_Marge').value = "";
				document.getElementById('Tarif_Id').value = "";
			}
			else if (origine=="m") {
				document.getElementById('Prix_HT').value = "";
				document.getElementById('Prix_TTC').value = "";
				document.getElementById('Coeff').value = "";
				document.getElementById('Taux_Marge').value = "";
				document.getElementById('Tarif_Id').value = "";
			}
			else if (origine=="g") {
				document.getElementById('Prix_HT').value = "";
				document.getElementById('Prix_TTC').value = "";
				document.getElementById('Coeff').value = "";
				document.getElementById('Taux_Marque').value = "";
				document.getElementById('Tarif_Id').value = "";
			}
			else {
				document.getElementById('Prix_HT').value = "";
				document.getElementById('Prix_TTC').value = "";
				document.getElementById('Coeff').value = "";
				document.getElementById('Taux_Marque').value = "";
				document.getElementById('Taux_Marge').value = "";
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function valider() {
	try {

		if (aArticles.nbSelection()>0) {

			var prixHT = document.getElementById("Prix_HT").value;
			var prixTTC = document.getElementById("Prix_TTC").value;
			var tauxMarque = document.getElementById("Taux_Marque").value;
			var tauxMarge = document.getElementById("Taux_Marge").value;
			var coeff = document.getElementById('Coeff').value;
			var tarifId = document.getElementById('Tarif_Id').value;

			if (!isEmpty(prixHT) && (!isPositiveOrNull(prixHT) || !checkNumber(prixHT,14,4))) {
				showWarning("Prix de vente HT incorrect !");
			}
			else if (!isEmpty(prixTTC) && (!isPositiveOrNull(prixTTC) || !checkNumber(prixTTC,14,4))) {
				showWarning("Prix de vente TTC incorrect !");
			}
			else if (!isEmpty(coeff) && (parseFloat(coeff)<-100 || !checkNumber(coeff,12,4))) {
				showWarning("Pourcentage sur prix de vente incorrect !");
			}
			else if (!isEmpty(tauxMarque) && (parseFloat(tauxMarque)>=100 || !checkNumber(tauxMarque,12,6))) {
				showWarning("Taux de marque incorrect");
			}
			else if (!isEmpty(tauxMarge) && !checkNumber(tauxMarge,12,4)) {
				showWarning("Taux de marge incorrect");
			}
			else {
				var nb = 0;

				if (isEmpty(prixHT)) { nb++; }
				if (isEmpty(prixTTC)) { nb++; }
				if (isEmpty(coeff)) { nb++; }
				if (isEmpty(tauxMarque)) { nb++; }
				if (isEmpty(tauxMarge)) { nb++; }
				if (isEmpty(tarifId)) { nb++; }

				if (nb==6) {
					showWarning("Veuillez remplir un champ !");
				}
				else {
					var qSave = new QueryHttp("Facturation/Clients/saveAllPrixClient.tmpl");

					qSave.setParam("Client_Id", argClientId);
					qSave.setParam("Prix_HT", prixHT);
					qSave.setParam("Prix_TTC", prixTTC);
					qSave.setParam("Pourcentage_PV", coeff);
					qSave.setParam("Taux_Marque", tauxMarque);
					qSave.setParam("Taux_Marge", tauxMarge);

					// slection unique
					if (calculPossible) {
						var articleId = aArticles.getSelectedCellText("colArticleId");

						qSave.setParam("Type", 1);
						qSave.setParam("Article_Id", articleId);

						qSave.execute();

						aArticles.initTree();
					}
					// slection multiple
					else {
						var listArticleId = "";

						var start = {};
						var end = {};

						for (var i=0; i<aArticles.getRangeCount(); i++){
							aArticles.getRangeAt(i,start,end);
							for (var j=start.value; j<=end.value; j++) {
								listArticleId += aArticles.getCellText(j, "colArticleId") +",";
							}
						}

						qSave.setParam("Type", 2);
						qSave.setParam("Tarif_Id", tarifId);
						qSave.setParam("List_Article_Id", listArticleId);

						qSave.execute();

						aArticles.initTree(unselectAll);
					}

					modified = true;
				}
			}
		}
		else {
			showWarning("Veuillez s\u00E9lectionner un ou plusieurs articles");
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function quitterPopup() {
	try {

		if (modified) {
			window.arguments[0]();
		}
		window.close();

	}	catch(e){
		recup_erreur(e);
	}
}


