/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/calculDocument.js");


var gConfig;
var etablissementDefaut;
var depotDefaut;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gConfig = getConfig();

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		var result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

  	document.getElementById('deck').selectedIndex = 0;
  	oecf_init();
		orcf_init();
		omcf_init();

		if (!isEmpty(ParamValeur("Commande_Id"))) {
			oecf_commandeId = ParamValeur("Commande_Id");
			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bMenuCommandes').collapsed = false;
			oecf_chargerCommande();
		}

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuCommandes() {
	try {

		document.getElementById('oecf-pdfCommande').setAttribute("src", "");
		document.getElementById('orcf-pdfBonReception').setAttribute("src", "");
		document.getElementById('orcf-pdfEtiquettes').setAttribute("src", "");
		document.getElementById('omcf-pdfCommandes').setAttribute("src", "");
		document.getElementById('omcf-deckMenu').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuCommandes').collapsed = true;
		document.getElementById('bRetourCommande').collapsed = true;
		document.getElementById('bRetourBR').collapsed = true;

		document.activeElement.blur();
		omcf_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourCommande() {
  try {

		document.getElementById('oecf-pdfCommande').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('oecf-deckCommande').selectedIndex = 0;
		document.getElementById('bRetourCommande').collapsed = true;
		document.getElementById('bRetourBR').collapsed = true;
		oecf_chargerCommande();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonReception() {
  try {

		document.getElementById('orcf-pdfBonReception').setAttribute("src", "");
		document.getElementById('orcf-pdfEtiquettes').setAttribute("src", "");
		document.getElementById('orcf-pdfEtiqLot').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('orcf-deckBonReception').selectedIndex = 0;
		document.getElementById('bRetourBR').collapsed = true;
		orcf_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oecf_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		switch (currentDeck) {
			case 1: return oecf_demandeEnregistrement(); break;
			case 2: return orcf_demandeEnregistrement(); break;
			default: return false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
