/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oecf_aLignes = new Arbre('Facturation/Commandes/list-ligneCommandeFournisseur.tmpl', 'oecf-articles');
var oecf_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oecf-Mode_Reg');
var oecf_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "oecf-Responsable");
var oecf_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oecf-etablissement');
var oecf_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oecf-depot');
var oecf_aVersion = new Arbre("Facturation/Commandes/list-versionCommandeFournisseur.tmpl", "oecf-listeVersion");
var oecf_aAcomptes = new Arbre("Facturation/Commandes/list-acompteFournisseur.tmpl", "oecf-listeAcomptes");
var oecf_aListeHistorique = new Arbre("Facturation/Commandes/list-historiqueCommandeFournisseur.tmpl", "oecf-listeHistorique");
var oecf_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oecf-codeTVAFraisPort");
var oecf_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oecf-langueDefaut");
var oecf_aTarifQte = new Arbre("Facturation/Articles/list-prixFournisseurQuantite.tmpl", "oecf-listTarifQte");
var oecf_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oecf-Secteur");

var oecf_commandeId = "";
var oecf_fournisseurId;
var oecf_qteMinimum = 0;
var oecf_multiple = 0;
var oecf_modeLigne;
var oecf_tauxTVAPort;
var oecf_codeTVAPort = "";
var oecf_montantHT = 0;
var oecf_typeRistourne = 'P';
var oecf_typeRemiseFP = 'P';
var oecf_typeRemise = 'P';
var oecf_acompte = 0;
var oecf_mode;
var oecf_bloque = false;
var oecf_modifie = false;
var oecf_etatCommande;
var oecf_soldee;
var oecf_currentIndex = 0;
var oecf_toSelectLigne = null;
var oecf_curResponsable;
var oecf_curModeReg;
var oecf_curEtablissement;
var oecf_curDepot;
var oecf_selPoleActivite;
var oecf_codesTvaInactifs = "";
var oecf_cfChiffre;
var oecf_defautCfChiffre;
var oecf_insertionLigneId = 0;
var oecf_acompteId = "";
var oecf_defModeReglement;
var oecf_langueDefaut;
var oecf_uniteDefaut;
var oecf_actReassortCC;
var oecf_ligneId;
var oecf_articleId;
var oecf_typeLigne;

var oecf_nfqte = new NumberFormat("0.00", false);
var oecf_fqte = new NumberFormat("0.###", true);
var oecf_fpu = new NumberFormat("0.00##", true);
var oecf_nfmt = new NumberFormat("0.00", true);



function oecf_init() {
  try {

		document.getElementById('oecf-rowFax').collapsed = !gConfig.isShowFax();

		document.getElementById('oecf-symboleUniteVolume').value = gConfig.getSymboleUniteVolume();
		document.getElementById('oecf-symboleUnitePoids').value = gConfig.getSymboleUnitePoids();

		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();
		var gcfDateRecepLigne = gConfig.isGCFDateRecepLigne();
		var gcfDateLivraison = gConfig.isGCFDateLivraison();
		var gcfDateLivLigne = gConfig.isGCFDateLivLigne() && gcfDateLivraison;
		var actDispoFour = gConfig.isActDispoFour();
		oecf_defModeReglement = gConfig.getDefModeReglementF();
		oecf_actReassortCC = gConfig.isActReassortCC();
		oecf_uniteDefaut = gConfig.getUniteDefaut();

		if (!actUnites) {
			document.getElementById('oecf-ColSymboleUnite').collapsed = true;
			document.getElementById('oecf-ColSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oecf-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oecf-ColNb_Pieces').collapsed = true;
			document.getElementById('oecf-ColNb_Pieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oecf-fieldNbPieces').collapsed = true;
		}

		if (!gcfDateLivraison) {
			document.getElementById('oecf-rowDateLivraison').collapsed = true;
		}

		if (!gcfDateRecepLigne) {
			document.getElementById('oecf-colDateReception').collapsed = true;
			document.getElementById('oecf-colDateReception').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oecf-fieldDateReception').collapsed = true;
		}

		if (!gcfDateLivLigne) {
			document.getElementById('oecf-colDateLivraison').collapsed = true;
			document.getElementById('oecf-colDateLivraison').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oecf-fieldDateLivraison').collapsed = true;
		}

		if (!actDispoFour) {
			document.getElementById('oecf-colDispoFournisseur').collapsed = true;
			document.getElementById('oecf-colDispoFournisseur').setAttribute('ignoreincolumnpicker', true);
		}

		oecf_defautCfChiffre = gConfig.isCFChiffre();

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("oecf-colAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("oecf-colAttribut"+ i).collapsed = true;
				document.getElementById("oecf-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "oecf-Unite");
		aUnite.initTree(oecf_initUnite);

		var aIncoterms = new Arbre("ComboListe/combo-incoterms.tmpl", "oecf-incoterm");
		aIncoterms.initTree();

		var aPaysDed = new Arbre("ComboListe/combo-pays.tmpl", "oecf-codePaysDed");
		aPaysDed.setParam("Only_UE", true);
    aPaysDed.initTree();

		if (oecf_actReassortCC) {
			document.getElementById('oecf-bConsulterCommandesClients').collapsed = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_initUnite() {
	try {

    document.getElementById('oecf-Unite').selectedIndex = 0;
		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oecf-Code_Pays_Fact");
    aPays.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_rechargerTVA() {
	try {

		oecf_codeTVAPort = "";

		oecf_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oecf-Code_Pays_Fact").value);
    oecf_aCodesTVAFraisPort.setParam("Selection", oecf_codeTVAPort);
    oecf_aCodesTVAFraisPort.initTree(oecf_initCodeTVAFraisPort);

		oecf_listeTVA();

	} catch (e) {
		recup_erreur(e);
	}
}


function isZoneUE(codePays) {
	try {

		var qGet = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
		qGet.setParam("Code_Pays", codePays);
		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute("Zone_UE")=="true";

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_initCodeTVAFraisPort() {
  try {

    document.getElementById('oecf-codeTVAFraisPort').value = (document.getElementById("oecf-Code_Pays_Fact").value=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(document.getElementById("oecf-Code_Pays_Fact").value));
    oecf_codeTVAPort = document.getElementById('oecf-codeTVAFraisPort').value;
    oecf_tauxTVAPort = getTva(oecf_codeTVAPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oecf_listeTVA() {
  try {

  	oecf_calculTotaux();

		var codePays = document.getElementById("oecf-Code_Pays_Fact").value;

    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oecf-Code_TVA");
    aCode.setParam("Code_Pays", codePays);
		aCode.setParam("Selection", oecf_codesTvaInactifs);
    aCode.initTree(oecf_selectTVA);

		if (codePays!="FR" && !isZoneUE(codePays)) {
			document.getElementById("oecf-rowCodePaysDed").collapsed = false;
		}
		else {
			document.getElementById("oecf-codePaysDed").value = "";
			document.getElementById("oecf-rowCodePaysDed").collapsed = true;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oecf_selectTVA() {
  try {

		var codePays = document.getElementById('oecf-Code_Pays_Fact').value;
    document.getElementById('oecf-Code_TVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));

  } catch (e) {
    recup_erreur(e);
  }
}



function oecf_chargerResponsables(selection) {
	try {

		oecf_curResponsable = selection;
		oecf_aResponsables.setParam("Selection", oecf_curResponsable);
		oecf_aResponsables.initTree(oecf_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_initResponsable() {
  try {

		document.getElementById('oecf-Responsable').value = oecf_curResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_chargerPolesActivite(selection) {
	try {

		oecf_selPoleActivite = selection;
		oecf_aPolesActivite.setParam("Selection", oecf_selPoleActivite);
		oecf_aPolesActivite.initTree(oecf_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_initPoleActivite() {
  try {

		document.getElementById('oecf-Secteur').value = oecf_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_chargerEtablissement(selection) {
	try {

		oecf_curEtablissement = selection;
		oecf_aEtablissements.setParam("Selection", selection);
		oecf_aEtablissements.initTree(oecf_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}

function oecf_initEtablissement() {
	try {

		document.getElementById('oecf-etablissement').value = oecf_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_chargerDepot(selection) {
	try {

		if (isEmpty(selection)) {
			// ne se produira QUE si la commande est dj cre et non modifiable, et qu'elle est relie  un bon de livraison fournisseur
			document.getElementById('oecf-rowDepot').collapsed = true;
			document.getElementById('oecf-rowDepotLibelle').collapsed = false;
			oecf_aDepots.deleteTree();
		} else {
			oecf_curDepot = selection;
			oecf_aDepots.setParam("Depot_Quarantaine", false);
			oecf_aDepots.setParam("Selection", selection);
			oecf_aDepots.initTree(oecf_initDepot);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_initDepot() {
	try {

		document.getElementById('oecf-depot').value = oecf_curDepot;
		document.getElementById('oecf-rowDepot').collapsed = false;
		document.getElementById('oecf-rowDepotLibelle').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_switchRistourne() {
	try {

		if (oecf_typeRistourne=='P') {
			document.getElementById('oecf-bRistourne').setAttribute("class", "bIcoEuro");
			oecf_typeRistourne = 'M';
		}
		else {
			document.getElementById('oecf-bRistourne').setAttribute("class", "bIcoPourcentage");
			oecf_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_switchRemise() {
	try {

		if (oecf_typeRemise=='P') {
			document.getElementById('oecf-bRemise').setAttribute("class", "bIcoEuro");
			oecf_typeRemise = 'M';
		}
		else {
			document.getElementById('oecf-bRemise').setAttribute("class", "bIcoPourcentage");
			oecf_typeRemise = 'P';
		}
		oecf_calculTotaux();
		oecf_setModifie(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_switchRemiseFP() {
	try {

		if (oecf_typeRemiseFP=='P') {
			document.getElementById('oecf-bRemiseFP').setAttribute("class", "bIcoEuro");
			oecf_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oecf-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oecf_typeRemiseFP = 'P';
		}
		oecf_calculTotaux();
		oecf_setModifie(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_chargerModesReglements(selection) {
	try {
		oecf_curModeReg = selection;
		oecf_aModesReglements.setParam("Selection", oecf_curModeReg);
		oecf_aModesReglements.initTree(oecf_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_initModeReglement() {
	try {

    document.getElementById('oecf-Mode_Reg').value=oecf_curModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oecf-bSupprimer').disabled = true;
		document.getElementById('oecf-bBasculer').disabled = true;
		document.getElementById('oecf-bMoveUp').disabled = true;
		document.getElementById('oecf-bMoveDown').disabled = true;
		document.getElementById('oecf-bMoveFirst').disabled = true;
		document.getElementById('oecf-bMoveLast').disabled = true;
		document.getElementById('oecf-bMultiSuppression').disabled = true;
		document.getElementById('oecf-bCommentaire').disabled = true;

		oecf_modeLigne = "C";
		oecf_typeLigne = typeLigne;
		oecf_ligneId = "";

		oecf_formatLigne(typeLigne);
		var codePays = document.getElementById('oecf-Code_Pays_Fact').value;

		if (typeLigne=="S") {
			oecf_articleId = articleId;

			var reference = document.getElementById("oecf-Reference").value;

			if (oecf_mode!="C" && oecf_dejaPresente(reference)) {
				showWarning("Attention, cet article est d\u00E9j\u00E0 pr\u00E9sent dans la commande");
			}

			var qInfos = new QueryHttp("Facturation/Articles/getInfosArticleAchat.tmpl");
			qInfos.setParam("Article_Id", articleId);
			qInfos.setParam("Fournisseur_Id", oecf_fournisseurId);
			var result = qInfos.execute();

			var contenu = result.responseXML.documentElement;

			var quantite = 1;
			oecf_qteMinimum = oecf_nfqte.format(contenu.getAttribute("Qte_Minimum"));
			oecf_multiple = oecf_nfqte.format(contenu.getAttribute("Multiple"));

			// trouve la quantit minimale a commander par rapport  la oecf_qteMinimum et au oecf_multiple
			if (oecf_multiple!=0 && oecf_qteMinimum!=0) {
				//prend la valeur entire suprieure de  oecf_qteMinimum/oecf_multiple et la multiplie par le oecf_multiple
				//marche pour oecf_qteMinimum>=oecf_multiple et oecf_qteMinimum<=oecf_multiple
				quantite = oecf_nfqte.format(Math.ceil(oecf_qteMinimum/oecf_multiple)*oecf_multiple);
			}
			else if (oecf_qteMinimum!=0) {
				quantite = oecf_qteMinimum;
			}
			else if (oecf_multiple!=0) {
				quantite = oecf_multiple;
			}

			document.getElementById("oecf-Designation").value = contenu.getAttribute("Designation");
			document.getElementById("oecf-Nb_Pieces").value = "";
			document.getElementById("oecf-Quantite").value = quantite;
			document.getElementById('oecf-Unite').value = contenu.getAttribute("Unite_Id");
			document.getElementById("oecf-PU").value = contenu.getAttribute("Prix_Unitaire");
			document.getElementById('oecf-Ristourne').value = contenu.getAttribute("PRistourne");
			if (parseFloat(contenu.getAttribute("PRistourne"))>0) {
				oecf_typeRistourne = 'P';
				document.getElementById('oecf-bRistourne').setAttribute("class", "bIcoPourcentage");
			}
			document.getElementById("oecf-Code_TVA").value = (codePays=="FR"?contenu.getAttribute("Code_TVA"):getCodeTvaZero(codePays));
			document.getElementById('oecf-dateReceptionLC').value = contenu.getAttribute("Date_Reception");
			document.getElementById('oecf-dateLivraisonLC').value = "";
			if (quantite>1) {
				oecf_calcPrixAchat();
			}
			// apercu article
			if (!isEmpty(oecf_fournisseurId)) {
				document.getElementById("oecf-boxFournisseur").collapsed = true;
				document.getElementById("oecf-boxApercuArticle").collapsed = false;
				document.getElementById("oecf-apercuReference").value = reference;
				document.getElementById("oecf-apercuDesignation").value = contenu.getAttribute("Designation");
				document.getElementById("oecf-apercuRefFournisseur").value = contenu.getAttribute("Ref_Fournisseur");
				document.getElementById("oecf-apercuPrixUnitaire").value = oecf_fpu.format(contenu.getAttribute("Prix_Unitaire"));
				document.getElementById("oecf-apercuRistourne").value = oecf_fqte.format(contenu.getAttribute("PRistourne"));
				document.getElementById("oecf-apercuQteMinimale").value = oecf_fqte.format(oecf_qteMinimum);
				document.getElementById("oecf-apercuMultiple").value = oecf_fqte.format(oecf_multiple);
				oecf_aTarifQte.setParam("Article_Id", articleId);
				oecf_aTarifQte.setParam("Fournisseur_Id", oecf_fournisseurId);
				oecf_aTarifQte.initTree();
			}
		}
		else {
			oecf_articleId = "";
			document.getElementById('oecf-Reference').value = "";
			document.getElementById('oecf-Designation').value = "";
			document.getElementById("oecf-Nb_Pieces").value = "";
			document.getElementById('oecf-Quantite').value = 1;
			document.getElementById('oecf-Unite').value = oecf_uniteDefaut;
			document.getElementById('oecf-PU').value = "";
			document.getElementById('oecf-Ristourne').value = "0.00";
			document.getElementById('oecf-Code_TVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));
			document.getElementById('oecf-dateReceptionLC').value = "";
			document.getElementById('oecf-dateLivraisonLC').value = "";
			document.getElementById('oecf-Reference').focus();
			oecf_insertionLigneId = 0;
			document.getElementById('oecf-bAjouterLigne').disabled = true;
			document.getElementById('oecf-bConsulterCommandesClients').disabled = true;
			document.getElementById('oecf-Act_Insert').collapsed = true;
			oecf_aLignes.setCellSrc(oecf_currentIndex, 'oecf-ColReference', "");
			document.getElementById("oecf-boxFournisseur").collapsed = false;
			document.getElementById("oecf-boxApercuArticle").collapsed = true;
			oecf_aTarifQte.deleteTree();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('oecf-Reference').setAttribute('readonly', true);
				document.getElementById('oecf-Designation').setAttribute('readonly', true);
				document.getElementById('oecf-Quantite').disabled = false;
				document.getElementById('oecf-PU').disabled = false;
				document.getElementById('oecf-Ristourne').disabled = false;
				document.getElementById('oecf-bRistourne').disabled = false;
				document.getElementById('oecf-Code_TVA').disabled = false;
				document.getElementById('oecf-dateReceptionLC').disabled = false;
				document.getElementById('oecf-dateLivraisonLC').disabled = false;
				document.getElementById('oecf-bValider').disabled = false;
				document.getElementById('oecf-bAnnuler').disabled = false;
				if (oecf_modeLigne=="M" && !oecf_modifie && oecf_etatCommande!="T") { document.getElementById('oecf-bBasculer').disabled = false; }
				break;

			case "I":
				document.getElementById('oecf-Reference').removeAttribute('readonly');
				document.getElementById('oecf-Designation').removeAttribute('readonly');
				document.getElementById('oecf-Nb_Pieces').disabled = false;
				document.getElementById('oecf-Quantite').disabled = false;
				document.getElementById('oecf-Unite').disabled = false;
				document.getElementById('oecf-PU').disabled = false;
				document.getElementById('oecf-Ristourne').disabled = false;
				document.getElementById('oecf-bRistourne').disabled = false;
				document.getElementById('oecf-Code_TVA').disabled = false;
				document.getElementById('oecf-dateReceptionLC').disabled = false;
				document.getElementById('oecf-dateLivraisonLC').disabled = false;
				document.getElementById('oecf-bValider').disabled = false;
				document.getElementById('oecf-bAnnuler').disabled = false;
				if (oecf_modeLigne=="M" && !oecf_modifie && oecf_etatCommande!="T") { document.getElementById('oecf-bBasculer').disabled = false; }
				break;

			default:
				var codePays = document.getElementById('oecf-Code_Pays_Fact').value;
				document.getElementById('oecf-Reference').value = "";
				document.getElementById('oecf-Designation').value = "";
				document.getElementById('oecf-Nb_Pieces').value = "";
				document.getElementById('oecf-Quantite').value = "";
				document.getElementById('oecf-Unite').value = oecf_uniteDefaut;
				document.getElementById('oecf-PU').value = "";
				document.getElementById('oecf-Ristourne').value = "";
				oecf_ligneId = "";
				document.getElementById('oecf-Code_TVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));
				document.getElementById('oecf-dateReceptionLC').value = "";
				document.getElementById('oecf-dateLivraisonLC').value = "";
				document.getElementById('oecf-Reference').setAttribute('readonly', true);
				document.getElementById('oecf-Designation').setAttribute('readonly', true);
				document.getElementById('oecf-Nb_Pieces').disabled = true;
				document.getElementById('oecf-Quantite').disabled = true;
				document.getElementById('oecf-Unite').disabled = true;
				document.getElementById('oecf-PU').disabled = true;
				document.getElementById('oecf-Ristourne').disabled = true;
				document.getElementById('oecf-bRistourne').disabled = true;
				document.getElementById('oecf-Code_TVA').disabled = true;
				document.getElementById('oecf-dateReceptionLC').disabled = true;
				document.getElementById('oecf-dateLivraisonLC').disabled = true;
				document.getElementById('oecf-bSupprimer').disabled = true;
				document.getElementById('oecf-bMoveUp').disabled = true;
				document.getElementById('oecf-bMoveDown').disabled = true;
				document.getElementById('oecf-bMoveFirst').disabled = true;
				document.getElementById('oecf-bMoveLast').disabled = true;
				document.getElementById('oecf-bMultiSuppression').disabled = true;
				document.getElementById('oecf-bCommentaire').disabled = true;
				document.getElementById('oecf-bBasculer').disabled = true;
				document.getElementById('oecf-bValider').disabled = true;
				document.getElementById('oecf-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_basculerLigne() {
	try {

		var url = "chrome://opensi/content/facturation/user/commandes/transferer_article.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oecf_retourBasculerLigne, oecf_ligneId);

  } catch (e) {
  	recup_erreur(e);
	}
}


function oecf_transfertMultiArticles() {
	try {
		var url = "chrome://opensi/content/facturation/user/commandes/popup-transfertMultiArticles.xul?"+ cookie() +"&Commande_Id="+ oecf_commandeId;
	  window.openDialog(url,'','chrome,modal,centerscreen',oecf_retourBasculerLigne);
	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_consulterCommandesClients() {
	try {

		if (oecf_aLignes.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commandes/popup-commandesClientsArticle.xul?"+ cookie() +"&Commande_Id="+ oecf_commandeId +"&Ligne_Id="+ oecf_aLignes.getSelectedCellText('oecf-colLigneId');
		  window.openDialog(url,'','chrome,modal,centerscreen');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_retourBasculerLigne() {
	try {

		oecf_ajouterLigne("I");
		oecf_aLignes.initTree(oecf_afterRefreshArticles);

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_solderMultiLignes() {
	try {

		var url = "chrome://opensi/content/facturation/user/commandes/popup-soldeMultiLignes.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oecf_retourSolderMultiLignes, oecf_commandeId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_retourSolderMultiLignes() {
	try {

		oecf_chargerCommande();

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_dejaPresente(reference) {
  try {

		var trouve = false;

		for (var i=0; i<oecf_aLignes.nbLignes(); i++) {
			if (oecf_aLignes.getCellText(i, "oecf-ColReference")==reference) {
				trouve = true;
				break;
			}
		}

		return trouve;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_pressOnWindow(ev) {
	try {

		if (ev.altKey && oecf_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oecf_rechercherStock();
        	break;
    	}
		}
		else if (ev.ctrlKey && oecf_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oecf_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();
				oecf_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oecf_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oecf_retourRechercherStock, "A", reference, null, true, oecf_fournisseurId, null, null, true, gConfig.isGCFRechIntegrale());

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_retourRechercherStock(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oecf-Reference').value = reference;
			document.getElementById('oecf-Quantite').focus();
			oecf_ajouterLigne("S", articleId);
		}
		else {
			oecf_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_rechercherReference() {
	try {

		var reference = document.getElementById('oecf-Reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam('Reference', reference);
		qSearch.setParam('Vente_Achat', "A");
		qSearch.setParam("No_Forfait", true);
		if (oecf_fournisseurId!="") { qSearch.setParam('Fournisseur_Id', oecf_fournisseurId); }
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oecf-Reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oecf-Quantite').focus();
			oecf_ajouterLigne("S", articleId);
		}
		else {
			oecf_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oecf_mode=="C") {
			ok = oecf_enregistrerCommande();
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/Commandes/addLigneCommandeFournisseur.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Commande_Id", oecf_commandeId);
			qAdd.execute();

			oecf_calculerPoids();
			oecf_ajouterLigne("I");
			oecf_aLignes.initTree(oecf_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oecf_ouvrirLigne() {
  try {

		if (oecf_aLignes.isSelected()) {

			if (oecf_aLignes.nbSelection()==1) {

				if ((oecf_etatCommande=="N" || oecf_etatCommande=="P" || (oecf_etatCommande=="T" && oecf_mode=="M")) && !oecf_bloque) {

					var i = oecf_aLignes.getCurrentIndex();
					oecf_aLignes.setCellSrc(i, 'oecf-ColReference', "");
					oecf_currentIndex = i;

					document.getElementById('oecf-bMoveUp').disabled = true;
					document.getElementById('oecf-bMoveDown').disabled = true;
					document.getElementById('oecf-bMoveFirst').disabled = true;
					document.getElementById('oecf-bMoveLast').disabled = true;
					document.getElementById('oecf-bMultiSuppression').disabled = true;

					if (oecf_mode=="M") {
						if (oecf_aLignes.getCellText(i,'oecf-colTypeLigne')=="C") {
							oecf_ajouterLigne("I");
						}
						else {
							document.getElementById('oecf-bAjouterLigne').disabled = false || oecf_etatCommande=="T";
							document.getElementById('oecf-bConsulterCommandesClients').disabled = false;
							oecf_insertionLigneId = 0;
							document.getElementById('oecf-Act_Insert').collapsed = true;

							oecf_modeLigne = "M";
		  				document.getElementById('oecf-bSupprimer').disabled = false;
							document.getElementById('oecf-bCommentaire').disabled = false;

			  			document.getElementById("oecf-Reference").value = oecf_aLignes.getCellText(i,'oecf-ColReference');
				  		document.getElementById("oecf-Designation").value = oecf_aLignes.getCellText(i,'oecf-ColDesignation');
				  		document.getElementById("oecf-Nb_Pieces").value = oecf_aLignes.getCellText(i,'oecf-ColNb_Pieces');
				  		document.getElementById("oecf-Quantite").value = oecf_aLignes.getCellText(i,'oecf-ColQuantite');
				  		document.getElementById("oecf-Unite").value = oecf_aLignes.getCellText(i,'oecf-ColUnite');
				  		document.getElementById("oecf-PU").value = oecf_aLignes.getCellText(i,'oecf-ColPU');
				  		document.getElementById("oecf-Code_TVA").value = oecf_aLignes.getCellText(i,'oecf-ColCode_TVA');
				  		document.getElementById("oecf-Ristourne").value = oecf_aLignes.getCellValue(i,'oecf-ColRistourne');
							oecf_typeRistourne = oecf_aLignes.getSelectedCellText('oecf-colTypeRistourne');
							document.getElementById('oecf-bRistourne').setAttribute("class", (oecf_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
							document.getElementById("oecf-dateReceptionLC").value = oecf_aLignes.getCellText(i, 'oecf-colDateReception');
							document.getElementById("oecf-dateLivraisonLC").value = oecf_aLignes.getCellText(i, 'oecf-colDateLivraison');
				  		oecf_typeLigne = oecf_aLignes.getCellText(i,'oecf-colTypeLigne');
				  		oecf_ligneId = oecf_aLignes.getCellText(i,'oecf-colLigneId');
							oecf_articleId = oecf_aLignes.getCellText(i,'oecf-colArticleId');

							oecf_qteMinimum = oecf_nfqte.format(oecf_aLignes.getCellText(i,'oecf-ColQte_Minimum'));
							oecf_multiple = oecf_nfqte.format(oecf_aLignes.getCellText(i,'oecf-ColMultiple'));

				  		oecf_formatLigne(oecf_typeLigne);

							// apercu article
							if (!isEmpty(oecf_fournisseurId) && !isEmpty(oecf_articleId)) {
								document.getElementById("oecf-boxFournisseur").collapsed = true;
								document.getElementById("oecf-boxApercuArticle").collapsed = false;
								document.getElementById("oecf-apercuReference").value = oecf_aLignes.getCellText(i,'oecf-ColReference');
								document.getElementById("oecf-apercuDesignation").value = oecf_aLignes.getCellText(i,'oecf-ColDesignation');
								document.getElementById("oecf-apercuRefFournisseur").value = oecf_aLignes.getCellText(i,'oecf-ColRefFournisseur');
								document.getElementById("oecf-apercuPrixUnitaire").value = oecf_fpu.format(oecf_aLignes.getCellText(i,'oecf-colCondPrixUnitaire'));
								document.getElementById("oecf-apercuRistourne").value = oecf_fqte.format(oecf_aLignes.getCellText(i,'oecf-colCondRistourne'));
								document.getElementById("oecf-apercuQteMinimale").value = oecf_fqte.format(oecf_qteMinimum);
								document.getElementById("oecf-apercuMultiple").value = oecf_fqte.format(oecf_multiple);
								oecf_aTarifQte.setParam("Article_Id", oecf_articleId);
								oecf_aTarifQte.setParam("Fournisseur_Id", oecf_fournisseurId);
								oecf_aTarifQte.initTree();
							}
							else {
								document.getElementById("oecf-boxFournisseur").collapsed = false;
								document.getElementById("oecf-boxApercuArticle").collapsed = true;
								oecf_aTarifQte.deleteTree();
							}
	      		}
					}

					if (oecf_mode!="C" && (oecf_etatCommande!="T" && oecf_etatCommande!="C" && oecf_etatCommande!="A") && oecf_aLignes.getCellText(i,'oecf-colTypeLigne')!="C") {
						// on ignore les lignes de commentaires
						var firstIndex = 0;
						var lastIndex = oecf_aLignes.nbLignes()-1;
						if (oecf_aLignes.getCellText(firstIndex,'oecf-colTypeLigne')=="C") { firstIndex++; }
						if (oecf_aLignes.getCellText(lastIndex,'oecf-colTypeLigne')=="C") { lastIndex--; }

						document.getElementById('oecf-bMoveUp').disabled = (i==firstIndex);
						document.getElementById('oecf-bMoveDown').disabled = (i==lastIndex);
						document.getElementById('oecf-bMoveFirst').disabled = (i==firstIndex);
						document.getElementById('oecf-bMoveLast').disabled = (i==lastIndex);
					}
				}

				document.getElementById('oecf-bSolderLigne').disabled = oecf_etatCommande!="T" || oecf_bloque || oecf_mode=="M" || oecf_aLignes.getSelectedCellText('oecf-colTypeLigne')=="C" || oecf_aLignes.getSelectedCellText('oecf-ColSoldee')=="true";

				if (oecf_actReassortCC) {
					var qExLiaisonCommandesClients = new QueryHttp("Facturation/Commandes/getNbLiaisonCommandesClients.tmpl");
					qExLiaisonCommandesClients.setParam('Ligne_Id', oecf_aLignes.getSelectedCellText('oecf-colLigneId'));
					var result = qExLiaisonCommandesClients.execute();

					var nbLiaisonCommandesClients = result.responseXML.documentElement.getAttribute("NbLiaisonCommandesClients");
					document.getElementById('oecf-bConsulterCommandesClients').disabled = nbLiaisonCommandesClients==0;
				}
			}
			else {
				if (oecf_mode!="V") {
					oecf_ajouterLigne("I");
					document.getElementById('oecf-bMultiSuppression').disabled = false;
				}
				document.getElementById('oecf-bSolderLigne').disabled = true;
				document.getElementById('oecf-bConsulterCommandesClients').disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_ajouterLigneAvant() {
  try {

		if (oecf_aLignes.isSelected() && oecf_mode=="M") {
			var idx = oecf_aLignes.getCurrentIndex();
			var ligneId = oecf_aLignes.getCellText(idx,'oecf-colLigneId');
			oecf_annulerLigne();
			oecf_aLignes.setCellSrc(idx, 'oecf-ColReference', "chrome://opensi/content/design/insertbefore.png");
			oecf_insertionLigneId = ligneId;
			oecf_currentIndex = idx;
			document.getElementById('oecf-Act_Insert').collapsed = false;
			document.getElementById('oecf-Reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_pressOnLigneCommande(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			oecf_ajouterLigneAvant();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_ouvrirCommentaire() {
  try {

		if (!oecf_bloque && oecf_aLignes.isSelected() && oecf_mode=="M") {
			if (oecf_aLignes.getSelectedCellText('oecf-colTypeLigne')=="C") {
				oecf_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_deplacerLigne(moveType) {
	try {

		if (oecf_aLignes.isSelected() && oecf_mode!="C" && oecf_etatCommande!="T" && oecf_etatCommande!="C"
					&& oecf_etatCommande!="A" && oecf_aLignes.getSelectedCellText('oecf-colTypeLigne')!="C") {

			document.getElementById('oecf-bMoveUp').disabled = true;
			document.getElementById('oecf-bMoveDown').disabled = true;
			document.getElementById('oecf-bMoveFirst').disabled = true;
			document.getElementById('oecf-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Commandes/moveLigneCommandeFournisseur.tmpl");
			qMove.setParam("Ligne_Id", oecf_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oecf_toSelectLigne = oecf_ligneId;
				oecf_ajouterLigne("I");
				oecf_aLignes.initTree(oecf_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_validerLigne() {
  try {

		var reference = document.getElementById("oecf-Reference").value;
		var designation = document.getElementById("oecf-Designation").value;
		var nb_pieces = document.getElementById("oecf-Nb_Pieces").value;
		var quantite = document.getElementById("oecf-Quantite").value;
		var unite = document.getElementById("oecf-Unite").value;
		var prixUnitaire = document.getElementById("oecf-PU").value;
		var ristourne = document.getElementById("oecf-Ristourne").value;
		var code_tva = document.getElementById("oecf-Code_TVA").value;
		var dateReception = document.getElementById("oecf-dateReceptionLC").value;
		var dateLivraison = document.getElementById("oecf-dateLivraisonLC").value;
  	var ok = true;

		if (isEmpty(nb_pieces)) nb_pieces = 0;

		var typeLigne = oecf_typeLigne;	// sauvegarde du type ligne avant appel ventuel  l'enregistrement du document

		if (oecf_mode=="C") {
			ok = oecf_enregistrerCommande();
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else if (!isPositiveOrNullInteger(nb_pieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect");	}
			else if (isEmpty(ristourne) || (oecf_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (typeLigne=='S' && parseFloat(quantite)<parseFloat(oecf_qteMinimum)) { showWarning("La quantit\u00E9 doit \u00EAtre sup\u00E9rieure ou \u00E9gale \u00E0 la quantit\u00E9 minimale : "+oecf_qteMinimum);	}
			else if (typeLigne=='S' && parseFloat(oecf_multiple)!=0 && ((parseIntBis(parseFloat(quantite)*1000)%parseIntBis(parseFloat(oecf_multiple)*1000))!=0)) { showWarning("La quantit\u00E9 doit \u00EAtre un multiple de : "+oecf_multiple); }
			else if (!isEmpty(dateReception) && !isDate(dateReception)) { showWarning("Date de r\u00E9ception pr\u00E9vue incorrecte"); }
			else if (!isEmpty(dateLivraison) && !isDate(dateLivraison)) { showWarning("Date de livraison demand\u00E9e incorrecte"); }
			else {
				// bug vrification pour quantit multiple corrige en passant par des entiers

				var msg = "Attention cette r\u00E9f\u00E9rence n'existe pas dans votre base article. Elle ne sera donc pas prise en compte dans la gestion des stocks. Voulez-vous continuer ?";

				if (typeLigne=='S' || (oecf_modeLigne=='M' || window.confirm(msg))) {
					if (oecf_modeLigne=="C" && oecf_insertionLigneId==0) {
						oecf_currentIndex = oecf_aLignes.nbLignes();
					}

					var qSave;

					if (oecf_modeLigne=="C") {
						qSave = new QueryHttp("Facturation/Commandes/createLigneCommandeFournisseur.tmpl");
						qSave.setParam("Commande_Id", oecf_commandeId);
					}
					else {
						qSave = new QueryHttp("Facturation/Commandes/updateLigneCommandeFournisseur.tmpl");
						qSave.setParam("Ligne_Id", oecf_ligneId);
					}

					qSave.setParam("Reference", reference);
					qSave.setParam("Designation", designation);
					qSave.setParam("Quantite", quantite);
					qSave.setParam("Nb_Pieces", nb_pieces);
					qSave.setParam("Unite", unite);
					qSave.setParam("Prix", prixUnitaire);
					qSave.setParam("Ristourne", ristourne);
					qSave.setParam("Type_Ristourne", oecf_typeRistourne);
					qSave.setParam("Code_TVA", code_tva);
					qSave.setParam("Date_Reception", dateReception);
					qSave.setParam("Date_Livraison", dateLivraison);
					qSave.setParam("Insertion_Ligne_Id", oecf_insertionLigneId);

					var result = qSave.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
					else {
						if (oecf_etatCommande!="T" && result.responseXML.documentElement.getAttribute('Stock_Depasse')=="true") {
							showWarning("Le stock virtuel du produit sera sup\u00E9rieur au stock maximum !");
						}

						oecf_checkAcomptePossible();

						oecf_ajouterLigne("I");
						oecf_aLignes.initTree(oecf_afterRefreshArticles);

						if (typeLigne=='S') {
							oecf_calculerPoids();
						}

						if (result.responseXML.documentElement.getAttribute("Maj_Prix")=="true" && window.confirm("Le prix d'achat de l'article a \u00E9volu\u00E9. Voulez-vous mettre \u00E0 jour la fiche article ?")) {
							var qMajPrix = new QueryHttp("Facturation/Commandes/updatePrixAchatArticle.tmpl");
							qMajPrix.setParam("Prix_Achat", prixUnitaire);
							qMajPrix.setParam("Reference", reference);
							qMajPrix.setParam("Fournisseur_Id", oecf_fournisseurId);
							qMajPrix.execute();
						}
					}
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_annulerLigne() {
  try {

  	oecf_aLignes.clearSelection();
		oecf_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oecf_ligneId)) {
			listLigneId = oecf_ligneId;
			maxIndex = oecf_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oecf_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oecf_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oecf_aLignes.getCellText(v,'oecf-colTypeLigne')!="C") {
			  		listLigneId += oecf_aLignes.getCellText(v,'oecf-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Commandes/deleteLigneCommandeFournisseur.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var nbNonSup = parseIntBis(result.responseXML.documentElement.getAttribute('Nb_Non_Sup'));
				if (nbNonSup>0) {
					showWarning("Attention : "+ nbNonSup +" lignes de la s\u00E9lection n'ont pas pu \u00EAtre supprim\u00E9es");
				}

				oecf_checkAcomptePossible();

				oecf_currentIndex = maxIndex-1;
				oecf_calculerPoids();
				oecf_ajouterLigne("I");
				oecf_aLignes.initTree(oecf_afterRefreshArticles);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_appliquerRistourne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oecf_aLignes.isSelected()) {
			var start = new Object();
			var end = new Object();
			var numRanges = oecf_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oecf_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oecf_aLignes.getCellText(v,'oecf-colTypeLigne')!="C") {
			  		listLigneId += oecf_aLignes.getCellText(v,'oecf-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CF", listLigneId);

			oecf_checkAcomptePossible();

			oecf_currentIndex = maxIndex;
			oecf_ajouterLigne("I");
			oecf_aLignes.initTree(oecf_afterRefreshArticles);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_validerCommande() {
  try {

    if (demandeEnregistrement()) {

			var montantBase = oecf_montantHT;
			var remise = document.getElementById('oecf-Remise').value;
			var modeReglement = document.getElementById('oecf-Mode_Reg').value;

		  if (oecf_aLignes.nbLignes()<=0) { showWarning("La commande ne contient aucune ligne !"); }
		  else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
			else if (isEmpty(remise) || (oecf_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
				showWarning("Remise incorrecte !");
			}
		  else if (window.confirm("Etes-vous s\u00FBr de vouloir valider la commande ?")) {

		  	var qValider = new QueryHttp("Facturation/Commandes/validerCommande.tmpl");
		  	qValider.setParam("Commande_Id", oecf_commandeId);
		  	var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
		  		oecf_chargerCommande();
		  	}
			}
    }

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_annulerCommande() {
  try {

	  if (window.confirm("Etes-vous s\u00FBr de vouloir annuler la commande ?")) {

	  	var qAnnuler = new QueryHttp("Facturation/Commandes/annulerCommande.tmpl");
	  	qAnnuler.setParam("Commande_Id", oecf_commandeId);
	  	var result = qAnnuler.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
	  	else {
	  		showWarning("La commande est annul\u00E9e !");
	  		oecf_chargerCommande();
	  	}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_enregistrerCommande() {
  try {

  	var ok=false;

    if (oecf_mode != 'C' && (oecf_aLignes.nbLignes()<=0)) {
	    showWarning("La commande ne contient aucune ligne !");
    }
		else {

			var raison_sociale = document.getElementById('oecf-Denomination').value;
      var adresse_fact = document.getElementById('oecf-Adresse_Fact').value;
      var adresse2_fact = document.getElementById('oecf-Adresse_2_Fact').value;
			var adresse_3_fact = document.getElementById('oecf-Adresse_3_Fact').value;
      var cp_fact = document.getElementById('oecf-CP_Fact').value;
      var ville_fact = document.getElementById('oecf-Ville_Fact').value;
			var code_pays_fact = document.getElementById('oecf-Code_Pays_Fact').value;
			var civ_inter = document.getElementById('oecf-Civ_Inter').value;
			var nom_inter = document.getElementById('oecf-Nom_Inter').value;
			var prenom_inter = document.getElementById('oecf-Prenom_Inter').value;
			var telInter1 = document.getElementById('oecf-Tel_Inter_1').value;
			var telInter2 = document.getElementById('oecf-Tel_Inter_2').value;
			var fax_inter = document.getElementById('oecf-Fax_Inter').value;
			var email_inter = document.getElementById('oecf-Email_Inter').value;
			var refCommande = document.getElementById('oecf-refCommande').value;
			var etablissement = document.getElementById('oecf-etablissement').value;
			var depotStock = document.getElementById('oecf-depot').value;
			var incoterm = document.getElementById('oecf-incoterm').value;
			var codePaysDed = document.getElementById('oecf-codePaysDed').value;
			var dateReception = document.getElementById('oecf-Date_Reception').value;
			var dateLivraison = document.getElementById('oecf-dateLivraison').value;
			var modeReglement = document.getElementById('oecf-Mode_Reg').value;
			var secteurActivite = document.getElementById('oecf-Secteur').value;
  	  var frais_port = document.getElementById('oecf-Frais_Port').value;
	    var escompte = document.getElementById('oecf-Escompte').value;
			var remise = document.getElementById('oecf-Remise').value;
	    var remiseFP = document.getElementById('oecf-RemiseFP').value;
			var tauxRemise = 0;
			var montantRemise = 0;
			var tauxRemiseFP = 0;
			var montantRemiseFP = 0;

			var montantBase = oecf_montantHT;

			oecf_codeTVAPort = document.getElementById('oecf-codeTVAFraisPort').value;
			oecf_tauxTVAPort = getTva(oecf_codeTVAPort);

			if (isEmpty(remise) || (oecf_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
    	else if (isEmpty(frais_port) || !isPositiveOrNull(frais_port)) { showWarning("Frais de port incorrects !"); }
    	else if (isEmpty(remiseFP) || (oecf_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(frais_port))) { showWarning("Remise sur frais de port incorrecte !"); }
    	else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
			else if (isEmpty(raison_sociale) || isEmpty(adresse_fact) || isEmpty(ville_fact) ) { showWarning("Vous devez indiquer les coordonn\u00E9es du fournisseur avant d'enregistrer la commande !"); }
			else if (!isEmpty(telInter1) && !isPhone(telInter1)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
			else if (!isEmpty(telInter2) && !isPhone(telInter2)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
			else if (!isEmpty(fax_inter) && !isPhone(fax_inter)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
			else if (!isEmpty(email_inter) && !isEmail(email_inter)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
			else if (!isEmpty(dateReception) && !isDate(dateReception)) { showWarning("Date de r\u00E9ception pr\u00E9vue incorrecte !"); }
			else if (!isEmpty(dateLivraison) && !isDate(dateLivraison)) { showWarning("Date de livraison demand\u00E9e incorrecte"); }
			else {

				frais_port = parseFloat(frais_port);
				remise = parseFloat(remise);
				remiseFP = parseFloat(remiseFP);

				var qEnregistrer;
				if (oecf_mode=="C") {
					qEnregistrer = new QueryHttp("Facturation/Commandes/creerCommande.tmpl");
				}
				else {
					qEnregistrer = new QueryHttp("Facturation/Commandes/modifierCommande.tmpl");
					qEnregistrer.setParam("Commande_Id", oecf_commandeId);
				}

	  	  if (oecf_typeRemise=='P') {
					tauxRemise = remise;
				}
				else {
					tauxRemise = (montantBase>0?remise/montantBase*100:0);
					montantRemise = remise;
				}

				if (oecf_typeRemiseFP=='P') {
					tauxRemiseFP = remiseFP;
				}
				else {
					tauxRemiseFP = (frais_port>0?remiseFP/frais_port*100:0);
					montantRemiseFP = remiseFP;
				}

				qEnregistrer.setParam("Fournisseur_Id", oecf_fournisseurId);
				qEnregistrer.setParam("Util_R", document.getElementById('oecf-Responsable').value);
				qEnregistrer.setParam("Ref_Commande", refCommande);
				qEnregistrer.setParam("Date_Reception", dateReception);
				qEnregistrer.setParam("Date_Livraison", dateLivraison);
				qEnregistrer.setParam("Intitule", document.getElementById('oecf-Intitule').value);
				qEnregistrer.setParam("Mode_Reg", modeReglement);
				qEnregistrer.setParam("Pole_Activite", secteurActivite);
				qEnregistrer.setParam("Commentaires_Fin", document.getElementById('oecf-Commentaires_Fin').value);
				qEnregistrer.setParam("Commentaires_Int", document.getElementById('oecf-Commentaires_Int').value);
				qEnregistrer.setParam("Etab_Id", etablissement);
				qEnregistrer.setParam("Depot_Id", depotStock);
				qEnregistrer.setParam("Incoterm", incoterm);
				qEnregistrer.setParam("Code_Pays_Ded", codePaysDed);
				qEnregistrer.setParam("PRemise", tauxRemise);
				qEnregistrer.setParam("MRemise", montantRemise);
				qEnregistrer.setParam("PRemise_FP", tauxRemiseFP);
				qEnregistrer.setParam("MRemise_FP", montantRemiseFP);
				qEnregistrer.setParam("Escompte", escompte);
				qEnregistrer.setParam("Frais_Port", frais_port);
				qEnregistrer.setParam("Code_TVA_Port", oecf_codeTVAPort);
				qEnregistrer.setParam("Taux_TVA_Port", oecf_tauxTVAPort);
				qEnregistrer.setParam("Denomination", raison_sociale);
				qEnregistrer.setParam("Adresse_1", adresse_fact);
				qEnregistrer.setParam("Adresse_2", adresse2_fact);
				qEnregistrer.setParam("Adresse_3", adresse_3_fact);
				qEnregistrer.setParam("Code_Postal", cp_fact);
				qEnregistrer.setParam("Ville", ville_fact);
				qEnregistrer.setParam("Code_Pays", code_pays_fact);
				qEnregistrer.setParam("Civ_Inter", civ_inter);
				qEnregistrer.setParam("Nom_Inter", nom_inter);
				qEnregistrer.setParam("Prenom_Inter", prenom_inter);
				qEnregistrer.setParam("Tel_Inter_1", telInter1);
				qEnregistrer.setParam("Tel_Inter_2", telInter2);
				qEnregistrer.setParam("Fax_Inter", fax_inter);
				qEnregistrer.setParam("Email_Inter", email_inter);

  	  	var result = qEnregistrer.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
	    		if (oecf_mode=="C") {
			    	oecf_commandeId = result.responseXML.documentElement.getAttribute("Commande_Id");
				  	oecf_chargerCommande();
  				}
					else if (oecf_mode=="M") {
		  			if (oecf_aLignes.isSelected()) {
		  				if (oecf_aLignes.getSelectedCellText("oecf-colTypeLigne")=="S") {
		  					document.getElementById('oecf-bBasculer').disabled = false;
		  				}
						}
						if (oecf_etatCommande=="T") {
							oecf_chargerCommande();
						}
  	  		}
  	  		oecf_setModifie(false);
        	ok = true;
				}
  		}
    }

    return ok;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_calculTotaux() {
  try {

		var fournisseurConnu = (oecf_fournisseurId!="");

		if (oecf_mode!='V') {
	    document.getElementById('oecf-Code_Pays_Fact').disabled = (oecf_bloque || oecf_aLignes.nbLignes()>0);
	    document.getElementById('oecf-bChercherAdr').disabled = (oecf_bloque || !fournisseurConnu || oecf_aLignes.nbLignes()>0);
		}

		var taux_escompte = parseFloat(document.getElementById('oecf-Escompte').value);
		var frais_port = parseFloat(document.getElementById('oecf-Frais_Port').value);
		var remise = parseFloat(document.getElementById('oecf-Remise').value);
		var remiseFP = parseFloat(document.getElementById('oecf-RemiseFP').value);

		if ((oecf_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oecf_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(taux_escompte) && isPositiveOrNull(frais_port)) {

			var calculDocument = new CalculDocument();
			if (oecf_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(frais_port);
			if (oecf_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oecf-codeTVAFraisPort').value, getTva(document.getElementById('oecf-codeTVAFraisPort').value));
			calculDocument.setEscompteP(taux_escompte);
			calculDocument.setAcompte(oecf_acompte);

			for (var i=0;i<oecf_aLignes.nbLignes();i++) {
				if (oecf_aLignes.getCellText(i,'oecf-colTypeLigne')!="C") {
					var montantLigne = oecf_aLignes.getCellText(i,'oecf-ColTotal');
					var codeTVA = oecf_aLignes.getCellText(i,'oecf-ColCode_TVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			document.getElementById('oecf-MontantHT').value = calculDocument.getMontantHT();
			document.getElementById('oecf-MontantRemise').value = calculDocument.getRemiseM();
			document.getElementById('oecf-MontantFrais_Port').value = calculDocument.getFraisPortBruts();
			document.getElementById('oecf-MontantRemiseFP').value = calculDocument.getRemiseFPM();
			document.getElementById('oecf-TotalHT').value = calculDocument.getTotalHT();
			document.getElementById('oecf-TVA').value = calculDocument.getTotalTVA();
			document.getElementById('oecf-MontantEscompte').value = calculDocument.getEscompteM();
			document.getElementById('oecf-NetCommercial').value = calculDocument.getNetCommercial();
			document.getElementById('oecf-MontantAcompte').value = calculDocument.getAcompte();
			document.getElementById('oecf-TotalTTC').value = calculDocument.getTotalTTC();

			oecf_montantHT = calculDocument.getMontantHTSansFormat();

			document.getElementById('oecf-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
			document.getElementById('oecf-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
			document.getElementById('oecf-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
			document.getElementById('oecf-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_calculerPoids() {
	try {

		var qPoids = new QueryHttp("Facturation/Commandes/getPoidsTotal.tmpl");
		qPoids.setParam("Commande_Id", oecf_commandeId);
		var result = qPoids.execute();

		document.getElementById('oecf-poidsTotal').value = result.responseXML.documentElement.getAttribute("Poids");
		document.getElementById('oecf-volumeTotal').value = result.responseXML.documentElement.getAttribute("Volume");

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_afterRefreshArticles() {
	try {

		if (oecf_toSelectLigne!=null) {
			for (var i=0; i<oecf_aLignes.nbLignes(); i++) {
				if (oecf_aLignes.getCellText(i, "oecf-colLigneId")==oecf_toSelectLigne && oecf_aLignes.getCellText(i, "oecf-colTypeLigne")!="C") {
					oecf_aLignes.select(i);
					break;
				}
			}
			oecf_toSelectLigne = null;
		}
		oecf_aLignes.ensureRowIsVisible(oecf_currentIndex);

		document.getElementById('oecf-bBasculerMulti').disabled = (oecf_bloque || (oecf_etatCommande!="N" && oecf_etatCommande!="P") || oecf_aLignes.nbLignes()==0);
		document.getElementById('oecf-bExporterCommande').disabled = (oecf_commandeId==null || oecf_aLignes.nbLignes()==0);
		oecf_calculTotaux();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_demandeEnregistrement() {
  try {

		document.getElementById('oecf-bEnregistrer').focus();
		// a permet de perdre le focus sur les lments "textbox"
		// et valider l'vnement onchange en cas d'appui sur la croix de fermeture
		var ok = true;

		if (oecf_modifie) {
			ok = false;
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la commande ?")) {
				ok = oecf_enregistrerCommande();
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oecf_setModifie(m) {
  try {

  	oecf_modifie = m;

		if (m) {
			document.getElementById('oecf-tabCommande').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oecf-bBasculer').disabled = true;
			document.getElementById('oecf-bBasculerMulti').disabled = true;
		}
		else {
			document.getElementById('oecf-tabCommande').setAttribute('image', null);
			document.getElementById('oecf-bBasculerMulti').disabled = (oecf_bloque || (oecf_etatCommande!="N" && oecf_etatCommande!="P") || oecf_aLignes.nbLignes()==0);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}



function oecf_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oecf_retourRechercherFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function oecf_retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

		oecf_fournisseurId = fournisseurId;
		oecf_setModifie(true);
		oecf_charger_coordfact();

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_rechercherAdr() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdrCom.xul?"+ cookie() +"&Fournisseur_Id="+ oecf_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oecf_reporterAdr);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_reporterAdr(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contactId, depotId) {
  try {

		document.getElementById("oecf-Denomination").value = nom;
		document.getElementById("oecf-Adresse_Fact").value = adr1;
		document.getElementById("oecf-Adresse_2_Fact").value = adr2;
		document.getElementById("oecf-Adresse_3_Fact").value = adr3;
		document.getElementById("oecf-CP_Fact").value = cp;
		document.getElementById("oecf-Ville_Fact").value = ville;
	  document.getElementById("oecf-Code_Pays_Fact").value = code_pays;
	  if (!isEmpty(depotId)) { oecf_chargerDepot(depotId); }
		oecf_rechargerTVA();

	  if (!isEmpty(contactId)) {
	  	var qLoad = new QueryHttp("Facturation/Fournisseurs/loadContactFournisseur.tmpl");
	  	qLoad.setParam("Contact_Id", contactId);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oecf_reporterInter(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		oecf_setModifie(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_rechercherInterlocuteur() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInterFournisseur.xul?"+ cookie() +"&Fournisseur_Id="+ oecf_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oecf_reporterInter);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_reporterInter(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oecf-Civ_Inter").value = civ;
		document.getElementById("oecf-Nom_Inter").value = nom;
		document.getElementById("oecf-Prenom_Inter").value = prenom;
		document.getElementById("oecf-Tel_Inter_1").value = tel1;
		document.getElementById("oecf-Tel_Inter_2").value = tel2;
		document.getElementById("oecf-Fax_Inter").value = fax;
		document.getElementById("oecf-Email_Inter").value = email;

		oecf_setModifie(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_charger_coordfact() {
  try {

		var qGet = new QueryHttp("Facturation/Fournisseurs/getDefautDocumentAchat.tmpl");
		qGet.setParam("Fournisseur_Id", oecf_fournisseurId);
	  var result = qGet.execute();

	  var contenu = result.responseXML.documentElement;

		document.getElementById("oecf-numFournisseur").value = contenu.getAttribute("Num_Fournisseur");

		document.getElementById("oecf-Denomination").value = contenu.getAttribute("Denomination");
		document.getElementById("oecf-Adresse_Fact").value = contenu.getAttribute("Adresse_1");
		document.getElementById("oecf-Adresse_2_Fact").value = contenu.getAttribute("Adresse_2");
		document.getElementById("oecf-Adresse_3_Fact").value = contenu.getAttribute("Adresse_3");
		document.getElementById("oecf-CP_Fact").value = contenu.getAttribute("Code_Postal");
		document.getElementById("oecf-Ville_Fact").value = contenu.getAttribute("Ville");
		document.getElementById("oecf-Code_Pays_Fact").value = contenu.getAttribute("Code_Pays");

		document.getElementById("oecf-Civ_Inter").value = contenu.getAttribute("Civ_Inter");
		document.getElementById("oecf-Nom_Inter").value = contenu.getAttribute("Nom_Inter");
		document.getElementById("oecf-Prenom_Inter").value = contenu.getAttribute("Prenom_Inter");
		document.getElementById("oecf-Tel_Inter_1").value = contenu.getAttribute("Tel_Inter_1");
		document.getElementById("oecf-Tel_Inter_2").value = contenu.getAttribute("Tel_Inter_2");
		document.getElementById("oecf-Fax_Inter").value = contenu.getAttribute("Fax_Inter");
		document.getElementById("oecf-Email_Inter").value = contenu.getAttribute("Email_Inter");

		document.getElementById('oecf-Indications').value = contenu.getAttribute("Indications");
		document.getElementById('oecf-Remise').value = contenu.getAttribute("Taux_Remise");
		document.getElementById('oecf-bRemise').setAttribute("class", "bIcoPourcentage");
		oecf_typeRemise = 'P';
		oecf_cfChiffre = contenu.getAttribute("CF_Chiffre")=="true";

		oecf_rechargerTVA();

		var depotId = contenu.getAttribute('Depot_Defaut');
		if (!isEmpty(depotId)) {
			oecf_chargerDepot(depotId);
		}

		var dateReception = contenu.getAttribute('Date_Reception');
		if (!isEmpty(dateReception)) {
			document.getElementById('oecf-Date_Reception').value = dateReception;
		}

		oecf_chargerResponsables(contenu.getAttribute('Util_R'));
		oecf_chargerPolesActivite(contenu.getAttribute("Pole_Activite"));
		oecf_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));

		var francoPort = contenu.getAttribute('Franco_Port')=="true";
		var montantFranco = contenu.getAttribute("Montant_Franco");
		oecf_majFrancoPort(francoPort, montantFranco);

		oecf_ajouterLigne("I");

		document.getElementById('oecf-bChercherInter').disabled = false;
		document.getElementById('oecf-bChercherAdr').disabled = false;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_debloquerInterface(statut) {
	try {

		document.getElementById('oecf-listeVersion').disabled = false;
		document.getElementById('oecf-articles').disabled = false;
		document.getElementById('oecf-listeAcomptes').disabled = false;
		document.getElementById('oecf-listeHistorique').disabled = false;
		document.getElementById('oecf-tabBoxCommande').selectedIndex = 0;

		document.getElementById('oecf-bEnregistrer').disabled = oecf_bloque;
		document.getElementById('oecf-bValiderCommande').disabled = oecf_bloque;
		document.getElementById('oecf-bBloquerCommande').disabled = false;
		document.getElementById('oecf-bDebloquerCommande').disabled = false;
		document.getElementById('oecf-bVisualiser').disabled = false;
		document.getElementById('oecf-bApercu').disabled = false;
		document.getElementById('oecf-bReception').disabled = oecf_bloque;
		document.getElementById('oecf-bSolderCommande').disabled = oecf_bloque;
		document.getElementById('oecf-bAnnulerCommande').disabled = oecf_bloque;
		document.getElementById('oecf-bSupprimerCommande').disabled = oecf_bloque;
		document.getElementById('oecf-bNouvelAcompte').disabled=oecf_bloque;
		document.getElementById('oecf-bCopierCommande').disabled=oecf_bloque;
		document.getElementById('oecf-bAjouterLigne').disabled = true;
		document.getElementById('oecf-bBasculerMulti').disabled = true;
		document.getElementById('oecf-bImporterLignes').disabled = true;
		document.getElementById('oecf-bExporterCommande').disabled = true;
		document.getElementById('oecf-bSolderLigne').disabled = true;
		document.getElementById('oecf-bSolderMulti').disabled = true;

		oecf_ajouterLigne("I");

		switch (statut) {
	    case 'N':
			case 'P':
				document.getElementById('oecf-bReception').collapsed = true;
	      document.getElementById('oecf-bEnregistrer').collapsed = oecf_bloque;
	      document.getElementById('oecf-bValiderCommande').collapsed = isEmpty(oecf_commandeId) || oecf_bloque;
	      document.getElementById('oecf-bSupprimerCommande').collapsed = (isEmpty(oecf_commandeId) || statut!='P');
				document.getElementById('oecf-bRechFournisseur').collapsed = !isEmpty(oecf_commandeId);
				document.getElementById('oecf-bBloquerCommande').collapsed = (isEmpty(oecf_commandeId) || oecf_bloque);
				document.getElementById('oecf-bDebloquerCommande').collapsed = (isEmpty(oecf_commandeId) || !oecf_bloque);
				document.getElementById('oecf-bCopierCommande').collapsed = (isEmpty(oecf_commandeId));
				document.getElementById('oecf-bSolderCommande').collapsed = true;
				document.getElementById('oecf-bAnnulerCommande').collapsed = (isEmpty(oecf_commandeId) || statut=='P');
				document.getElementById('oecf-bModifier').collapsed = true;
				document.getElementById('oecf-bChercherInter').disabled = oecf_bloque;
				document.getElementById('oecf-bChercherAdr').disabled = oecf_bloque;
				document.getElementById('oecf-bBasculerMulti').collapsed = false;
				document.getElementById('oecf-bBasculer').collapsed = false;
				document.getElementById('oecf-bSolderMulti').collapsed = true;
				document.getElementById('oecf-bSolderLigne').collapsed = true;
	      break;
	    case 'A':
	    case 'T':
	    case 'C':
	    	oecf_mode = "V";
				document.getElementById('oecf-bEnregistrer').collapsed = true;
				document.getElementById('oecf-bRechFournisseur').collapsed = true;
	    	document.getElementById('oecf-bReception').collapsed = false;
				document.getElementById('oecf-bCopierCommande').collapsed = false;
	    	document.getElementById('oecf-bAnnulerCommande').collapsed = (statut!='T');
	    	document.getElementById('oecf-bSolderCommande').collapsed = (statut!='T' || oecf_soldee);
	    	document.getElementById('oecf-bBloquerCommande').collapsed = (statut!='T' || oecf_bloque);
				document.getElementById('oecf-bDebloquerCommande').collapsed = (statut!='T' || !oecf_bloque);
				document.getElementById('oecf-bValiderCommande').collapsed = true;
				document.getElementById('oecf-bSupprimerCommande').collapsed = true;
				document.getElementById('oecf-bModifier').collapsed = (statut!='T');
				document.getElementById('oecf-bModifier').disabled = (statut!='T');
				document.getElementById('oecf-bChercherInter').disabled = true;
				document.getElementById('oecf-bChercherAdr').disabled = true;
				document.getElementById('oecf-bBasculerMulti').collapsed = true;
				document.getElementById('oecf-bBasculer').collapsed = true;
				document.getElementById('oecf-bSolderMulti').collapsed = statut!='T';
				document.getElementById('oecf-bSolderLigne').collapsed = statut!='T';
				oecf_formatLigne("");
	      break;
	  }

		document.getElementById('oecf-bVisualiser').collapsed = isEmpty(oecf_commandeId) || statut=='P';
		document.getElementById('oecf-bApercu').collapsed = statut!='P';

		var disabled = (oecf_mode=="V" || oecf_bloque);

		if (disabled) {
			document.getElementById('oecf-Denomination').setAttribute('readonly', true);
			document.getElementById('oecf-Adresse_Fact').setAttribute('readonly', true);
			document.getElementById('oecf-Adresse_2_Fact').setAttribute('readonly', true);
			document.getElementById('oecf-Adresse_3_Fact').setAttribute('readonly', true);
			document.getElementById('oecf-CP_Fact').setAttribute('readonly', true);
			document.getElementById('oecf-Ville_Fact').setAttribute('readonly', true);
			document.getElementById('oecf-Code_Pays_Fact').disabled = true;
			document.getElementById("oecf-Civ_Inter").disabled = true;
			document.getElementById("oecf-Nom_Inter").setAttribute('readonly', true);
			document.getElementById("oecf-Prenom_Inter").setAttribute('readonly', true);
			document.getElementById("oecf-Tel_Inter_1").setAttribute('readonly', true);
			document.getElementById("oecf-Tel_Inter_2").setAttribute('readonly', true);
			document.getElementById("oecf-Fax_Inter").setAttribute('readonly', true);
			document.getElementById("oecf-Email_Inter").setAttribute('readonly', true);
		}
		else {
			document.getElementById('oecf-Denomination').removeAttribute('readonly');
			document.getElementById('oecf-Adresse_Fact').removeAttribute('readonly');
			document.getElementById('oecf-Adresse_2_Fact').removeAttribute('readonly');
			document.getElementById('oecf-Adresse_3_Fact').removeAttribute('readonly');
			document.getElementById('oecf-CP_Fact').removeAttribute('readonly');
			document.getElementById('oecf-Ville_Fact').removeAttribute('readonly');
			document.getElementById('oecf-Code_Pays_Fact').disabled = false;
			document.getElementById("oecf-Civ_Inter").disabled = false;
			document.getElementById("oecf-Nom_Inter").removeAttribute('readonly');
			document.getElementById("oecf-Prenom_Inter").removeAttribute('readonly');
			document.getElementById("oecf-Tel_Inter_1").removeAttribute('readonly');
			document.getElementById("oecf-Tel_Inter_2").removeAttribute('readonly');
			document.getElementById("oecf-Fax_Inter").removeAttribute('readonly');
			document.getElementById("oecf-Email_Inter").removeAttribute('readonly');
		}

		document.getElementById('oecf-Reference').disabled = disabled;
		document.getElementById('oecf-Designation').disabled = disabled;
		document.getElementById('oecf-Nb_Pieces').disabled = disabled;
		document.getElementById('oecf-Quantite').disabled = disabled;
		document.getElementById('oecf-Unite').disabled = disabled;
		document.getElementById('oecf-PU').disabled = disabled;
		document.getElementById('oecf-Ristourne').disabled = disabled;
		document.getElementById('oecf-bRistourne').disabled = disabled;
		document.getElementById('oecf-Code_TVA').disabled = disabled;
		document.getElementById('oecf-dateReceptionLC').disabled = disabled;
		document.getElementById('oecf-dateLivraisonLC').disabled = disabled;
		document.getElementById('oecf-bArticle').disabled = disabled;
		document.getElementById('oecf-bCommentaire').disabled = disabled;
		document.getElementById('oecf-bAnnuler').disabled = disabled;
		document.getElementById('oecf-bValider').disabled = disabled;

		document.getElementById('oecf-refCommande').disabled = disabled;
		document.getElementById('oecf-Intitule').disabled = disabled;
		document.getElementById('oecf-Date_Reception').disabled = disabled;
		document.getElementById('oecf-dateLivraison').disabled = disabled;
		document.getElementById('oecf-Responsable').disabled = disabled;
		document.getElementById('oecf-Secteur').disabled = disabled;
		document.getElementById('oecf-Indications').disabled = disabled;
		document.getElementById('oecf-etablissement').disabled = disabled;
		document.getElementById('oecf-depot').disabled = disabled;
		document.getElementById('oecf-incoterm').disabled = disabled;
		document.getElementById('oecf-codePaysDed').disabled = disabled;
		document.getElementById('oecf-Commentaires_Fin').disabled = disabled;
		document.getElementById('oecf-Commentaires_Int').disabled = disabled;
		document.getElementById('oecf-bChoisirMentions').disabled = disabled;
		document.getElementById('oecf-Mode_Reg').disabled = disabled;
		document.getElementById('oecf-bRemise').disabled = disabled;
		document.getElementById('oecf-Remise').disabled = disabled;
		document.getElementById('oecf-Frais_Port').disabled = disabled;
		document.getElementById('oecf-codeTVAFraisPort').disabled = disabled;
		document.getElementById('oecf-bRemiseFP').disabled = disabled;
		document.getElementById('oecf-RemiseFP').disabled = disabled;
		document.getElementById('oecf-Escompte').disabled = disabled;

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_nouvelleCommande() {
  try {

		document.getElementById('oecf-deckCommande').selectedIndex = 0;
  	oecf_commandeId = "";
		oecf_etatCommande = "";
		oecf_soldee = false;
		oecf_fournisseurId = "";
		oecf_bloque = false;
		oecf_codesTvaInactifs = "";
		oecf_codeTVAPort = "";
		oecf_cfChiffre = oecf_defautCfChiffre;
		oecf_mode = "C";

		document.getElementById('oecf-Denomination').value = "";
    document.getElementById('oecf-Adresse_Fact').value = "";
    document.getElementById('oecf-Adresse_2_Fact').value = "";
		document.getElementById('oecf-Adresse_3_Fact').value = "";
    document.getElementById('oecf-CP_Fact').value = "";
    document.getElementById('oecf-Ville_Fact').value = "";
    document.getElementById('oecf-Code_Pays_Fact').value = "FR";
    document.getElementById('oecf-Civ_Inter').value = 0;
    document.getElementById('oecf-Nom_Inter').value = "";
    document.getElementById('oecf-Prenom_Inter').value = "";
    document.getElementById('oecf-Tel_Inter_1').value = "";
    document.getElementById('oecf-Tel_Inter_2').value = "";
    document.getElementById('oecf-Fax_Inter').value = "";
    document.getElementById('oecf-Email_Inter').value = "";
		oecf_rechargerTVA();

		document.getElementById('oecf-Commentaires_Fin').value = "";
		document.getElementById('oecf-Commentaires_Int').value = "";
		document.getElementById('oecf-Numero').value = "";
		document.getElementById('oecf-refCommande').value = "";
		document.getElementById('oecf-Intitule').value = "";
		document.getElementById('oecf-Date_Reception').value = "";
		document.getElementById('oecf-dateLivraison').value = "";
		document.getElementById('oecf-Indications').value = "";
		document.getElementById('oecf-date_cmd').value = getDateCourante();
		document.getElementById('oecf-Remise').value = "0.00";
		document.getElementById('oecf-Escompte').value = "0.00";
		document.getElementById('oecf-Frais_Port').value = "0.00";
		document.getElementById('oecf-codeTVAFraisPort').selectedIndex = 0;
		document.getElementById('oecf-RemiseFP').value = "0.00";
		document.getElementById('oecf-incoterm').value = "";
		document.getElementById('oecf-codePaysDed').value = "";

		document.getElementById('oecf-rowFrancoPort').collapsed = true;
		document.getElementById('oecf-lblFrancoPort').value = "";
		document.getElementById('oecf-poidsTotal').value = 0;
		document.getElementById('oecf-volumeTotal').value = 0;

		document.getElementById('oecf-MontantHT').value = "0.00";
		document.getElementById('oecf-MontantRemise').value = "0.00";
		document.getElementById('oecf-MontantFrais_Port').value = "0.00";
		document.getElementById('oecf-MontantRemiseFP').value = "0.00";
		document.getElementById('oecf-MontantAcompte').value = "0.00"
		document.getElementById('oecf-TotalHT').value = "0.00";
		document.getElementById('oecf-TVA').value = "0.00";
		document.getElementById('oecf-MontantEscompte').value = "0.00";
		document.getElementById('oecf-TotalTTC').value = "0.00";

		oecf_montantHT = 0;

		document.getElementById('oecf-rowRemiseHT').collapsed = true;
		document.getElementById('oecf-rowRemiseFPHT').collapsed = true;
		document.getElementById('oecf-rowEscompteHT').collapsed = true;

		document.getElementById('oecf-rowNetCommercialHT').collapsed = true;
		document.getElementById('oecf-NetCommercial').value = "0.00";

		document.getElementById('oecf-Creation').setAttribute("label", "");
		document.getElementById('oecf-Modification').setAttribute("label", "");
		document.getElementById('oecf-Fiche').setAttribute("label", "");
		document.getElementById('oecf-numFournisseur').value = "";
		document.getElementById('oecf-etat_cmd').value = "Nouvelle";

		oecf_chargerResponsables(getProfil().getLoggedUser());
		oecf_chargerModesReglements(oecf_defModeReglement);
		oecf_chargerEtablissement(etablissementDefaut);
		oecf_chargerDepot(depotDefaut);
		oecf_chargerPolesActivite("");

		document.getElementById('oecf-boxNouvelAcompte').collapsed = true;
    document.getElementById('oecf-tabHistorique').collapsed = true;
		document.getElementById('oecf-tabVersionDocument').collapsed = true;
		document.getElementById('oecf-tabAcomptes').collapsed = true;
    oecf_aAcomptes.deleteTree();
    oecf_aListeHistorique.deleteTree();

		oecf_aLignes.deleteTree();
		oecf_debloquerInterface('N');

		oecf_typeRistourne = 'P';
		document.getElementById('oecf-bRistourne').setAttribute("class", "bIcoPourcentage");

		document.getElementById('oecf-colQteRecep').collapsed = true;
		document.getElementById('oecf-colQteRecep').setAttribute("ignoreincolumnpicker", true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_majFrancoPort(francoPort, montantFranco) {
	try {

		var lblFrancoPort = "";
		if (!francoPort) { lblFrancoPort = "Non"; }
		else { lblFrancoPort = (parseFloat(montantFranco)==0?"Oui":oecf_nfmt.format(montantFranco) +" \u20AC"); }
		document.getElementById('oecf-lblFrancoPort').value = lblFrancoPort;
		document.getElementById('oecf-rowFrancoPort').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_chargerCommande() {
  try {

		document.getElementById('oecf-deckCommande').selectedIndex = 0;
		oecf_mode = "M";

		var qLoad = new QueryHttp("Facturation/Commandes/loadCommandeFournisseur.tmpl");
		qLoad.setParam("Commande_Id", oecf_commandeId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

    document.getElementById('oecf-Denomination').value = contenu.getAttribute('Denomination');
    document.getElementById('oecf-Adresse_Fact').value = contenu.getAttribute('Adresse_1');
    document.getElementById('oecf-Adresse_2_Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oecf-Adresse_3_Fact').value = contenu.getAttribute('Adresse_3');
    document.getElementById('oecf-CP_Fact').value = contenu.getAttribute('Code_Postal');
    document.getElementById('oecf-Ville_Fact').value = contenu.getAttribute('Ville');
    document.getElementById('oecf-Code_Pays_Fact').value = contenu.getAttribute('Code_Pays');
		oecf_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');
    document.getElementById('oecf-Civ_Inter').value = contenu.getAttribute('Civ_Inter');
    document.getElementById('oecf-Nom_Inter').value = contenu.getAttribute('Nom_Inter');
    document.getElementById('oecf-Prenom_Inter').value = contenu.getAttribute('Prenom_Inter');
    document.getElementById('oecf-Tel_Inter_1').value = contenu.getAttribute('Tel_Inter_1');
    document.getElementById('oecf-Tel_Inter_2').value = contenu.getAttribute('Tel_Inter_2');
    document.getElementById('oecf-Fax_Inter').value = contenu.getAttribute('Fax_Inter');
    document.getElementById('oecf-Email_Inter').value = contenu.getAttribute('Email_Inter');

		oecf_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oecf-Remise').value = (oecf_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oecf-bRemise').setAttribute("class", (oecf_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oecf_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oecf-RemiseFP').value = (oecf_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oecf-bRemiseFP').setAttribute("class", (oecf_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

		document.getElementById('oecf-Escompte').value = contenu.getAttribute('Escompte');
		document.getElementById('oecf-Frais_Port').value = contenu.getAttribute('Frais_Port');
		oecf_acompte = contenu.getAttribute('Acompte');
		document.getElementById('oecf-Commentaires_Fin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oecf-Commentaires_Int').value = contenu.getAttribute('Commentaires_Int');
    document.getElementById('oecf-date_cmd').value = contenu.getAttribute('Date_Commande');
    oecf_chargerResponsables(contenu.getAttribute('Util_R'));
		oecf_chargerModesReglements(contenu.getAttribute('Mode_Reg'));
    oecf_chargerEtablissement(contenu.getAttribute('Etab_Id'));
    oecf_chargerDepot(contenu.getAttribute('Depot_Id'));

		document.getElementById('oecf-Intitule').value = contenu.getAttribute('Intitule');
		document.getElementById('oecf-Date_Reception').value = contenu.getAttribute('Date_Reception');
		document.getElementById('oecf-dateLivraison').value = contenu.getAttribute('Date_Livraison');
		document.getElementById('oecf-refCommande').value = contenu.getAttribute('Ref_Commande');
		document.getElementById('oecf-incoterm').value = contenu.getAttribute('Incoterm');
		document.getElementById('oecf-codePaysDed').value = contenu.getAttribute('Code_Pays_Ded');
		oecf_chargerPolesActivite(contenu.getAttribute("Pole_Activite"));

		oecf_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oecf_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');
		oecf_bloque = (contenu.getAttribute('Bloque')=="true");

    document.getElementById('oecf-Creation').label = "Commande cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur');
		document.getElementById('oecf-Modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
		document.getElementById('oecf-Fiche').label = "Commande N\u00B0 "+ contenu.getAttribute('Numero');
		document.getElementById('oecf-Numero').value = contenu.getAttribute('Numero');

		document.getElementById('oecf-tabVersionDocument').collapsed = false;
		document.getElementById('oecf-tabAcomptes').collapsed = false;

    oecf_initVersion();
    oecf_calculerPoids();
		oecf_setModifie(false);

		oecf_etatCommande = contenu.getAttribute('Etat');
		oecf_soldee = contenu.getAttribute('Soldee')=="true";

		if ((oecf_etatCommande!="N" && oecf_etatCommande!="P") || gConfig.isHistoAvantValidCF()) {
			document.getElementById('oecf-tabHistorique').collapsed = false;
			document.getElementById('oecf-histoAvantVal').collapsed = oecf_etatCommande=="N" || oecf_etatCommande=="P" || !gConfig.isHistoAvantValidCF();
			document.getElementById('oecf-histoAvantVal').checked = oecf_etatCommande=="N" || oecf_etatCommande=="P";
			oecf_listerHistorique();
		}
		else {
			document.getElementById('oecf-tabHistorique').collapsed = true;
			oecf_aListeHistorique.deleteTree();
		}

		if (oecf_etatCommande=="N") { document.getElementById('oecf-etat_cmd').value = "Non valid\u00E9e"; }
		else if (oecf_etatCommande=="P") { document.getElementById('oecf-etat_cmd').value = "En pr\u00E9paration"; }
		else if (oecf_etatCommande=="T") { document.getElementById('oecf-etat_cmd').value = "En cours"; }
		else if (oecf_etatCommande=="A") { document.getElementById('oecf-etat_cmd').value = "Annul\u00E9e"; }
		else if (oecf_etatCommande=="C") { document.getElementById('oecf-etat_cmd').value = "Cl\u00F4tur\u00E9e"; }

		oecf_fournisseurId = contenu.getAttribute('Fournisseur_Id');
		var fournisseurConnu = (oecf_fournisseurId!="");
		document.getElementById('oecf-numFournisseur').value = contenu.getAttribute('Num_Fournisseur');

		oecf_debloquerInterface(oecf_etatCommande);
		document.getElementById('oecf-bBasculerMulti').disabled = (oecf_bloque || (oecf_etatCommande!="N" && oecf_etatCommande!="P") || oecf_aLignes.nbLignes()==0);
		document.getElementById('oecf-bImporterLignes').disabled = (oecf_bloque || (oecf_etatCommande!="P" && oecf_etatCommande!="N") || !fournisseurConnu);
		document.getElementById('oecf-bExporterCommande').disabled = (oecf_commandeId==null || oecf_aLignes.nbLignes()==0);
		document.getElementById('oecf-bSolderMulti').disabled = (oecf_bloque || oecf_etatCommande!="T" || oecf_soldee);

		if ((oecf_etatCommande=='N' || oecf_etatCommande=='P') && !oecf_bloque) {
			document.getElementById('oecf-bChercherInter').disabled = (!fournisseurConnu);
			document.getElementById('oecf-bChercherAdr').disabled = (!fournisseurConnu);
			oecf_ajouterLigne("I");
		}

		document.getElementById('oecf-bOuvrirCommentairesCaches').disabled=false;

		var existeFacture = (contenu.getAttribute("Existe_Facture")=="true");
		var acomptePossible = ((oecf_etatCommande=="N" || ((oecf_etatCommande=="P" || oecf_etatCommande=="T") && !existeFacture)) && contenu.getAttribute("Autoriser_Acompte")=="true");
		document.getElementById('oecf-boxNouvelAcompte').collapsed=!acomptePossible;
		oecf_aAcomptes.setParam("Commande_Id", oecf_commandeId);
		oecf_aAcomptes.initTree();

		if (fournisseurConnu) {
			var francoPort = contenu.getAttribute('Franco_Port')=="true";
			var montantFranco = contenu.getAttribute("Montant_Franco");
			oecf_majFrancoPort(francoPort, montantFranco);

			oecf_cfChiffre = contenu.getAttribute('CF_Chiffre')=="true";
			document.getElementById('oecf-Indications').value = contenu.getAttribute("Indications");
		}
		else {
			oecf_cfChiffre = oecf_defautCfChiffre;
		}

		oecf_aLignes.setParam("Commande_Id", oecf_commandeId);
		oecf_aLignes.initTree(chargerCommande2);

		if (oecf_etatCommande=="T" || oecf_etatCommande=="C") {
			document.getElementById('oecf-colQteRecep').collapsed = false;
			document.getElementById('oecf-colQteRecep').removeAttribute("ignoreincolumnpicker");
		}
		else {
			document.getElementById('oecf-colQteRecep').collapsed = true;
			document.getElementById('oecf-colQteRecep').setAttribute("ignoreincolumnpicker", true);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerCommande2() {
	try {

		var fournisseurConnu = (oecf_fournisseurId!="");
		document.getElementById('oecf-bBasculerMulti').disabled = (oecf_bloque || (oecf_etatCommande!="N" && oecf_etatCommande!="P") || oecf_aLignes.nbLignes()==0);
		document.getElementById('oecf-bImporterLignes').disabled = (oecf_bloque || (oecf_etatCommande!="P" && oecf_etatCommande!="N") || !fournisseurConnu);
		document.getElementById('oecf-bExporterCommande').disabled = (oecf_commandeId==null || oecf_aLignes.nbLignes()==0);
		document.getElementById('oecf-bSolderMulti').disabled = (oecf_bloque || oecf_etatCommande!="T" || oecf_soldee);

		oecf_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oecf-Code_Pays_Fact").value);
		oecf_aCodesTVAFraisPort.setParam("Selection", oecf_codeTVAPort);
		oecf_aCodesTVAFraisPort.initTree(oecf_selectionTvaPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_selectionTvaPort() {
   try {

		 document.getElementById('oecf-codeTVAFraisPort').value = oecf_codeTVAPort;
     oecf_tauxTVAPort = getTva(oecf_codeTVAPort);
     oecf_listeTVA();

   } catch (e) {
     recup_erreur(e);
   }
}


function oecf_checkAcomptePossible() {
	try {

		var qAcompte = new QueryHttp("Facturation/Commandes/checkAcomptePossible.tmpl");
		qAcompte.setParam("Commande_Id", oecf_commandeId);
		var result = qAcompte.execute();
		var contenu = result.responseXML.documentElement;

		var existeFacture = (contenu.getAttribute("Existe_Facture")=="true");
		var acomptePossible = ((oecf_etatCommande=="N" || ((oecf_etatCommande=="P" || oecf_etatCommande=="T") && !existeFacture)) && contenu.getAttribute("Autoriser_Acompte")=="true");
		document.getElementById('oecf-boxNouvelAcompte').collapsed=!acomptePossible;
		oecf_acompte = contenu.getAttribute('Acompte');

		oecf_aAcomptes.setParam("Commande_Id", oecf_commandeId);
		oecf_aAcomptes.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_supprimerCommande() {
	try {

		if (window.confirm("Confirmez-vous la suppression de la commande ?")) {
			var qDelete = new QueryHttp("Facturation/Commandes/supprimerCommande.tmpl");
			qDelete.setParam("Commande_Id", oecf_commandeId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La commande a \u00E9t\u00E9 supprim\u00E9e !");
				retourMenuCommandes();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_solderCommande() {
	try {

		if (window.confirm("Voulez-vous vraiment solder cette commande ?\n(Attention plus aucune r\u00E9ception possible !)")) {

			var qSolder = new QueryHttp("Facturation/Commandes/solderCommande.tmpl");
			qSolder.setParam("Commande_Id", oecf_commandeId);
			var result = qSolder.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La commande a \u00E9t\u00E9 sold\u00E9e avec succ\u00E8s !");
				oecf_chargerCommande();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_nouvelAcompte() {
	try {
    var params = "&Commande_Id="+ oecf_commandeId;
    params += "&Code_Pays="+ document.getElementById("oecf-Code_Pays_Fact").value;
    params += "&Fournisseur_Id="+ oecf_fournisseurId;

		var url = "chrome://opensi/content/facturation/user/commandes/popup-creerAcompte.xul?"+ cookie() + params;
		window.openDialog(url,'','chrome,modal,centerscreen',oecf_retourAcompte);
	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_retourAcompte() {
	try {

		document.getElementById('oecf-bAnnulerAcompte').disabled = true;
		document.getElementById('oecf-bReediterAcompte').disabled = true;

		oecf_checkAcomptePossible();
		oecf_calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_pressOnListeAcomptes() {
	try {
		if (oecf_aAcomptes.isSelected()) {
			var i = oecf_aAcomptes.getCurrentIndex();
			var statut = oecf_aAcomptes.getCellText(i, 'oecf-colStatut');
			var impute = oecf_aAcomptes.getCellText(i, 'oecf-colImpute');
			document.getElementById('oecf-bAnnulerAcompte').disabled=(statut=="A" || impute=="true");
			document.getElementById('oecf-bReediterAcompte').disabled=false;
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_annulerAcompte() {
	try {

		if (oecf_aAcomptes.isSelected() && window.confirm("Voulez-vous annuler cet acompte ?")) {

			var acompteId = oecf_aAcomptes.getSelectedCellText('oecf-colAcompteId');

			var qAnnulerAcompte = new QueryHttp("Facturation/Commandes/cancelAcompteFournisseur.tmpl");
			qAnnulerAcompte.setParam("Acompte_Id", acompteId);

			var result = qAnnulerAcompte.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oecf_aAcomptes.initTree(oecf_retourAcompte);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_reediterAcompte() {
	try {

		if (oecf_aAcomptes.isSelected()) {
			var acompteId = oecf_aAcomptes.getSelectedCellText('oecf-colAcompteId');
			oecf_editerAcompte(acompteId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_editerAcompte(acompteId) {
  try {

		oecf_acompteId = acompteId;
		document.getElementById('oecf-boxEditionCF').collapsed = true;

		var qGenPdf = new QueryHttp("Facturation/Commandes/pdfAcompte.tmpl");
		qGenPdf.setParam('Acompte_Id', acompteId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oecf-pdfCommande').setAttribute("src", page);
		document.getElementById("bRetourCommande").collapsed = false;
		document.getElementById("oecf-deckCommande").selectedIndex = 1;

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_bloquerCommande() {
  try {

		if (window.confirm("Voulez-vous bloquer la commande ?")) {
    	if (demandeEnregistrement()) {
				var qLock = new QueryHttp("Facturation/Commandes/lockCommandeFournisseur.tmpl");
  			qLock.setParam("Commande_Id", oecf_commandeId);
  			var result = qLock.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
      		oecf_chargerCommande();
				}
    	}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oecf_debloquerCommande() {
  try {

		if (window.confirm("Voulez-vous d\u00E9bloquer la commande ?")) {
			var qUnlock = new QueryHttp("Facturation/Commandes/unlockCommandeFournisseur.tmpl");
  		qUnlock.setParam("Commande_Id", oecf_commandeId);
  		var result = qUnlock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oecf_chargerCommande();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_visualiserCommande() {
  try {

    if (demandeEnregistrement()) {
		  var modeReglement = document.getElementById('oecf-Mode_Reg').value;
		  if (oecf_aLignes.nbLignes()<=0) { showWarning("La commande ne contient aucune ligne !"); }
		  else if (isEmpty(modeReglement) && oecf_mode!="V") { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		  else {
				oecf_acompteId = "";
				document.getElementById('oecf-Chiffre').checked = oecf_cfChiffre;
				document.getElementById('oecf-boxEditionCF').collapsed = false;

				var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
				qLangueDefaut.setParam("Type_Doc", "CF");
				qLangueDefaut.setParam("Doc_Id", oecf_commandeId);
				var result = qLangueDefaut.execute();
				oecf_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

				oecf_aLangues.setParam("Selection", oecf_langueDefaut);
				oecf_aLangues.initTree(oecf_initLangue);
		  }
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_initLangue() {
	try {

		document.getElementById('oecf-langueDefaut').value = oecf_langueDefaut;
		oecf_editerCommande();

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_editerCommande() {
  try {

		document.getElementById('oecf-pdfCommande').setAttribute("src", "");
		document.getElementById("bRetourCommande").collapsed = false;
		document.getElementById("oecf-deckCommande").selectedIndex = 1;

		oecf_acompteId = "";
		var chiffre = document.getElementById('oecf-Chiffre').checked;
		var langue = document.getElementById('oecf-langueDefaut').value;

		var oecf_qGenPdf = new QueryHttp("Facturation/Commandes/pdfCommandeFournisseur.tmpl");
		oecf_qGenPdf.setParam('Commande_Id', oecf_commandeId);
	  oecf_qGenPdf.setParam("CF_Chiffre", chiffre);
	  oecf_qGenPdf.setParam('Langue_Id', langue);

		var result = oecf_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oecf-pdfCommande').setAttribute("src", page);

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_receptionCommande() {
  try {

		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('bMenuCommandes').collapsed = false;
		document.getElementById('bRetourCommande').collapsed = false;
		orcf_commandeId = oecf_commandeId;
		orcf_start();

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_modifierCommande() {
	try {

		document.getElementById('oecf-bModifier').disabled = true;
		document.getElementById('oecf-bSolderLigne').disabled = true;
		document.getElementById('oecf-bSolderMulti').disabled = true;
		document.getElementById('oecf-bImporterLignes').disabled = false;

		document.getElementById('oecf-Commentaires_Fin').disabled = false;
		document.getElementById('oecf-Commentaires_Int').disabled = false;
		document.getElementById('oecf-Mode_Reg').disabled = false;
		document.getElementById('oecf-bRemise').disabled = false;
		document.getElementById('oecf-Remise').disabled = false;
		document.getElementById('oecf-Frais_Port').disabled = false;
		document.getElementById('oecf-codeTVAFraisPort').disabled = false;
		document.getElementById('oecf-bRemiseFP').disabled = false;
		document.getElementById('oecf-RemiseFP').disabled = false;
		document.getElementById('oecf-Escompte').disabled = false;

		document.getElementById('oecf-Secteur').disabled = false;
		document.getElementById('oecf-Responsable').disabled = false;
		document.getElementById('oecf-Date_Reception').disabled = false;
		document.getElementById('oecf-dateLivraison').disabled = false;
		document.getElementById('oecf-Intitule').disabled = false;
		document.getElementById('oecf-refCommande').disabled = false;
		document.getElementById('oecf-etablissement').disabled = false;
		document.getElementById('oecf-incoterm').disabled = false;
		document.getElementById('oecf-codePaysDed').disabled = false;

		document.getElementById('oecf-Reference').disabled = false;
		document.getElementById('oecf-Designation').disabled = false;
		document.getElementById('oecf-bArticle').disabled = false;

		oecf_mode = "M";

		document.getElementById('oecf-bAnnulerCommande').collapsed = true;
		document.getElementById('oecf-bSolderCommande').collapsed = true;
		document.getElementById('oecf-bCopierCommande').collapsed = true;
		document.getElementById('oecf-bReception').collapsed = true;
		document.getElementById('oecf-bBloquerCommande').collapsed = true;
		document.getElementById('oecf-bDebloquerCommande').collapsed = true;
		document.getElementById('oecf-bVisualiser').collapsed = true;
		document.getElementById('oecf-bApercu').collapsed = true;
		document.getElementById('oecf-bEnregistrer').collapsed = false;

		oecf_aLignes.clearSelection();
		oecf_ajouterLigne("I");

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_editerCommentaire() {
  try {

		if (oecf_aLignes.isSelected()) {
			var ligneId = oecf_aLignes.getSelectedCellText('oecf-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CF", ligneId);

			oecf_aLignes.initTree(oecf_afterRefreshArticles);
			oecf_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "CF", oecf_commandeId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oecf-Commentaires_Fin').value;
		var commentairesInt = document.getElementById('oecf-Commentaires_Int').value;
		var readOnly = (oecf_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oecf_retourEditerCommentaires, "CF", oecf_commandeId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oecf-Commentaires_Fin').value = commentairesFin;
		document.getElementById('oecf-Commentaires_Int').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oecf_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oecf_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oecf_choisirMentions() {
  try {

  	var ok = true;

  	if (oecf_mode=="C") {
			ok = oecf_enregistrerCommande();
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CF", oecf_commandeId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oecf_initVersion() {
	try {

		oecf_aVersion.setParam("Commande_Id", oecf_commandeId);
		oecf_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}

function oecf_exportLignes() {
  try {

	  var qeditCommande = new QueryHttp("Facturation/Commandes/csvLignesCommande.tmpl");
	  qeditCommande.setParam("Commande_Id", oecf_commandeId);
	  var result = qeditCommande.execute();

	  var errors = new Errors(result);

		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oecf_importLignes() {
  try {

	  var url = "chrome://opensi/content/facturation/user/commandes/popup-importerLignes.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oecf_retourImportFichier, oecf_commandeId, oecf_etatCommande!='T');

  } catch (e) {
    recup_erreur(e);
  }
}


function oecf_retourImportFichier() {
	try {

		oecf_aLignes.initTree(oecf_afterRefreshArticles);

	} catch (e) {
	  recup_erreur(e);
	}
}


function oecf_copierCommande() {
	try {

		var ok = true;
		if (oecf_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la commande ?")) {
				ok = oecf_enregistrerCommande();
			}
		}

		if (ok) {
			var qCopier = new QueryHttp("Facturation/Commandes/duplicateCommandeFournisseur.tmpl");
	  	qCopier.setParam("Commande_Id", oecf_commandeId);
	  	var result = qCopier.execute();

	  	var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oecf_commandeId = result.responseXML.documentElement.getAttribute('Commande_Id');
				oecf_chargerCommande();
			}
		}

	} catch (e) {
	  recup_erreur(e);
	}
}


function oecf_afficherFichiers() {
	try {

    var ok = true;
		if (oecf_mode=="C") {
			ok = oecf_enregistrerCommande();
		}

		if (ok) {
  	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CF", oecf_commandeId, false);
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function oecf_envoyerMail() {
	try {

		var typeDoc = isEmpty(oecf_acompteId)?"CF":"FAF";
		var docId = isEmpty(oecf_acompteId)?oecf_commandeId:oecf_acompteId;
		var chiffre = document.getElementById('oecf-Chiffre').checked;
		var langue = document.getElementById('oecf-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', typeDoc, docId, langue, chiffre);

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_solderLigne() {
	try {

		if (oecf_aLignes.isSelected() && oecf_aLignes.getSelectedCellText('oecf-colTypeLigne')!="C") {
			if (oecf_aLignes.getSelectedCellText('oecf-ColSoldee')=="true") {
				showWarning("La ligne est d\u00E9j\u00E0 sold\u00E9e");
			}
			else if (window.confirm("Confirmez-vous le solde de la ligne s\u00E9lectionn\u00E9e ?\n(Attention plus aucune r\u00E9ception possible !)")) {
				var qSettle = new QueryHttp("Facturation/Commandes/settleLigneCommandeFournisseur.tmpl");
	  		qSettle.setParam("Ligne_Id", oecf_aLignes.getSelectedCellText('oecf-colLigneId'));
	  		var result = qSettle.execute();

	  		var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oecf_chargerCommande();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_calcPrixAchat() {
	try {

		var quantite = document.getElementById('oecf-Quantite').value;

		if (!isEmpty(oecf_fournisseurId) && isPositive(quantite)) {
			var qPrix = new QueryHttp("Facturation/Commandes/computePrixAchatQuantite.tmpl");
	 		qPrix.setParam("Fournisseur_Id", oecf_fournisseurId);
			qPrix.setParam("Article_Id", document.getElementById('oecf-Reference').value);
			qPrix.setParam("Quantite", quantite);

			var result = qPrix.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;
				if (contenu.getAttribute('Has_Prix')=="true") {
					document.getElementById('oecf-PU').value = contenu.getAttribute('Prix_Achat');
					document.getElementById('oecf-Ristourne').value = contenu.getAttribute('PRistourne');
					if (parseFloat(contenu.getAttribute('PRistourne'))>0) {
						oecf_typeRistourne = 'P';
						document.getElementById('oecf-bRistourne').setAttribute("class", "bIcoPourcentage");
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_listerHistorique() {
	try {

		var exclureTotaux = document.getElementById('oecf-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('oecf-histoAvantVal').checked;
		oecf_aListeHistorique.setParam("Commande_Id", oecf_commandeId);
		oecf_aListeHistorique.setParam("Exclure_Totaux", exclureTotaux);
		oecf_aListeHistorique.setParam("Histo_Avant_Val", histoAvantVal);
		oecf_aListeHistorique.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oecf_editerHistoriqueCSV() {
	try {

		var exclureTotaux = document.getElementById('oecf-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('oecf-histoAvantVal').checked;

		var qEditionCsv = new QueryHttp("Facturation/Commandes/csvHistoriqueCommandeFournisseur.tmpl");
		qEditionCsv.setParam("Commande_Id", oecf_commandeId);
		qEditionCsv.setParam("Exclure_Totaux", exclureTotaux);
		qEditionCsv.setParam("Histo_Avant_Val", histoAvantVal);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
