/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depot');
var aPrepCom = new Arbre('Facturation/Reassort/list-ligneReassort.tmpl', 'tree-prepcom');
var aPrepComTotaux = new Arbre('Facturation/Reassort/list-totauxCommandes.tmpl', 'tree-totaux');
var aVentilation = new Arbre('Facturation/Commandes/liste-ventilationReassort.tmpl', 'tree-ventilation');
var aFournisseurs = new Arbre('Facturation/Commandes/liste-fournisseursPrepa.tmpl', 'FournDest');
var aFournPrinc = new Arbre('Facturation/Reassort/combo-fournisseursPCF.tmpl', 'Fournisseur_Id');

var aCC = new Arbre('Facturation/Commandes/liste-reassortCommandesClients.tmpl', 'tree-cc');
var qMajEtatReassortir = new QueryHttp("Facturation/Commandes/modifierEtatReassortir.tmpl");

var qMajQte = new QueryHttp("Facturation/Commandes/modifierQtePrep.tmpl");
var qBascule = new QueryHttp("Facturation/Commandes/basculerQtePrepa.tmpl");

var currentDepot = "";
var currentModeReassort = "S";
var actReassortCC = false;
var reassortId = 0;
var listeSelectedMode = "A";



function init() {
  try {

  	listeSelectedMode = "A";
  	document.getElementById('Quantite').value = "";
  	document.getElementById('Quantite').disabled = true;
		document.getElementById('bChgQte').disabled = true;
		document.getElementById('QteTrans').value = "";
		document.getElementById('QteTrans').disabled = true;
		document.getElementById('bTransQte').disabled = true;
		document.getElementById('FournDest').disabled = true;
		document.getElementById('breinitprep').disabled = true;
		document.getElementById('choixTypeButtonSeuils').disabled = true;
		document.getElementById('choixTypeButtonCC').disabled = true;
		document.getElementById('bGenCom').disabled = true;
		document.getElementById('Marque_Id').disabled = true;
		document.getElementById('Fournisseur_Id').disabled = true;
		document.getElementById('bCocher').disabled = true;
		document.getElementById('bDecocher').disabled = true;
		document.getElementById('tree-prepcom').disabled = true;
		document.getElementById('tree-cc').disabled = true;
		document.getElementById('tree-totaux').disabled = true;
		document.getElementById('tree-ventilation').disabled = true;
		document.getElementById('depot').disabled = true;
		document.getElementById('modeReassort').disabled = true;
		document.getElementById('bEditionCSV').disabled = true;

		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Quarantaine", false);
		aDepots.initTree(initDepot);

		var config = getConfig();

		var actDispoFour = config.isActDispoFour();
		actReassortCC = config.isActReassortCC();

		if (!actDispoFour) {
			document.getElementById('ColDispo').collapsed = true;
			document.getElementById('ColDispo').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('ColStockFour').collapsed = true;
			document.getElementById('ColStockFour').setAttribute('ignoreincolumnpicker', true);
		}

		if (actReassortCC) {
			document.getElementById('choixType').collapsed = false;
			document.getElementById('colGroupeCFReaCC').collapsed = false;
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("ColAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("ColAttribut"+ i).collapsed = true;
				document.getElementById("ColAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'Marque_Id');
		aMarques.initTree();

  } catch (e) {
  	recup_erreur(e);
  }
}


function initDepot() {
	try {

		currentDepot = "";
		currentModeReassort = "S";
		document.getElementById('depot').value = "";
		document.getElementById('depot').disabled = false;
		document.getElementById('modeReassort').value = "S";
		document.getElementById('modeReassort').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function switchType(codeType) {
  try {

		switch (codeType) {
			case 'A':
				document.getElementById('commandesAReassortir').collapsed = true;
				listeSelectedMode = "A";
				break;
			case 'C':
				document.getElementById('commandesAReassortir').collapsed = false;
				listeSelectedMode = "C";
				break;
		}
		document.getElementById("ColDont_Reserve").setAttribute("collapsed", listeSelectedMode=="C");
		document.getElementById("ColSVAvant").setAttribute("collapsed", listeSelectedMode=="C");

		aVentilation.deleteTree();
		aPrepCom.setParam("Type_CC", listeSelectedMode=="C");
		aPrepCom.initTree(initPreparation);

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnDepot() {
	try {

		currentDepot = document.getElementById('depot').value;

		aPrepCom.deleteTree();
		aCC.deleteTree();
		aPrepComTotaux.deleteTree();
		aVentilation.deleteTree();

		document.getElementById('Quantite').value = "";
  	document.getElementById('Quantite').disabled = true;
		document.getElementById('bChgQte').disabled = true;
		document.getElementById('QteTrans').value = "";
		document.getElementById('QteTrans').disabled = true;
		document.getElementById('bTransQte').disabled = true;
		document.getElementById('FournDest').disabled = true;
		document.getElementById('breinitprep').disabled = true;
		document.getElementById('choixTypeButtonSeuils').disabled = true;
		document.getElementById('choixTypeButtonCC').disabled = true;
		document.getElementById('bGenCom').disabled = true;
		document.getElementById('Marque_Id').disabled = true;
		document.getElementById('Marque_Id').value = "";
		document.getElementById('Fournisseur_Id').disabled = true;
		document.getElementById('Fournisseur_Id').value = "";
		document.getElementById('bCocher').disabled = true;
		document.getElementById('bDecocher').disabled = true;
		document.getElementById('tree-prepcom').disabled = true;
		document.getElementById('tree-cc').disabled = true;
		document.getElementById('tree-totaux').disabled = true;
		document.getElementById('tree-ventilation').disabled = true;
		document.getElementById('lblQteReassort').value = "";
		document.getElementById('lblQteTotale').value = "";
		document.getElementById('lblArticle').value = "";
		document.getElementById('msgImpossible').collapsed = true;
		document.getElementById('bEditionCSV').disabled = true;

		if (!isEmpty(currentDepot)) {
			var qPossible = new QueryHttp("Facturation/Commandes/isPreparationPossible.tmpl");
			qPossible.setParam("Depot_Id", currentDepot);
			var result = qPossible.execute();

			if (result.responseXML.documentElement.getAttribute('Possible')=="true") {
				currentModeReassort = result.responseXML.documentElement.getAttribute('Mode_Reassort');
				document.getElementById('depot').disabled = true;
				document.getElementById('modeReassort').disabled = true;
				document.getElementById('modeReassort').value = currentModeReassort;
				document.getElementById('pmbox').collapsed = false;
				document.getElementById('pm').setAttribute('mode', 'undetermined');

				var qGenBPC = new QueryHttp("Facturation/Commandes/generateReassort.tmpl");
				qGenBPC.setParam("Depot_Id", currentDepot);
				qGenBPC.setParam("Mode_Reassort", currentModeReassort);
				qGenBPC.execute(endReassort);
			}
			else {
				document.getElementById('msgImpossible').collapsed = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnModeReassort() {
	try {

		if (!isEmpty(currentDepot)) {
			if (window.confirm("Le changement de mode de r\u00E9assort implique de r\u00E9initialiser la pr\u00E9paration.\nVoulez-vous poursuivre ?")) {
				currentModeReassort = document.getElementById('modeReassort').value;
				reinitialiserBPC();
			}
			else {
				// remise du mode de rassort  la valeur actuelle
				document.getElementById('modeReassort').value = currentModeReassort;
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnReinitialiser() {
	try {

		if (window.confirm("Voulez-vous r\u00E9initialiser la pr\u00E9paration ?")) {
			reinitialiserBPC();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnEditionCSV() {
	try {

		var marqueId = document.getElementById('Marque_Id').value;
		var fournisseurId = document.getElementById('Fournisseur_Id').value;
		var typeCC = (listeSelectedMode=="C");

		var qEditionCsv = new QueryHttp("Facturation/Reassort/csvLigneReassort.tmpl");

		qEditionCsv.setParam("Reassort_Id", reassortId);
		qEditionCsv.setParam("Type_CC", typeCC);
		qEditionCsv.setParam("Marque_Id", marqueId);
		qEditionCsv.setParam("Fournisseur_Id", fournisseurId);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initPreparation() {
	try {

		aFournPrinc.setParam("Reassort_Id", reassortId);
		aFournPrinc.initTree();

		if (actReassortCC) {
			aCC.setParam("Reassort_Id", reassortId);
			aCC.setParam("Statut_Paiement", "");
			aCC.initTree(initPreparationSuiteCC);
		}
		else {
			aPrepComTotaux.setParam("Reassort_Id", reassortId);
			aPrepComTotaux.initTree(initCommandesPrep);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initPreparationCC() {
	try {

		aPrepCom.setParam("Reassort_Id", reassortId);
		aPrepCom.setParam("Marque_Id", document.getElementById('Marque_Id').value);
		aPrepCom.setParam("Fournisseur_Id", document.getElementById('Fournisseur_Id').value);
		aPrepCom.initTree(initPreparationSuiteCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPreparationSuiteCC() {
	try {

		compterLignesCochees();
		aPrepComTotaux.setParam("Reassort_Id", reassortId);
		aPrepComTotaux.initTree(initCommandesPrep);

	} catch (e) {
		recup_erreur(e);
	}
}


function initCommandesPrep() {
	try {

		document.getElementById('depot').disabled = false;
		document.getElementById('modeReassort').disabled = false;
		document.getElementById('bGenCom').disabled = false;
		document.getElementById('bCocher').disabled = false;
		document.getElementById('bDecocher').disabled = false;
		document.getElementById('breinitprep').disabled = false;
		document.getElementById('choixTypeButtonSeuils').disabled = false;
		document.getElementById('choixTypeButtonCC').disabled = false;
		document.getElementById('tree-prepcom').disabled = false;
		document.getElementById('tree-cc').disabled = false;
		document.getElementById('tree-totaux').disabled = false;
		document.getElementById('tree-ventilation').disabled = false;
		document.getElementById('Marque_Id').disabled = false;
		document.getElementById('Fournisseur_Id').disabled = false;
		document.getElementById('statutPaiement').disabled = false;
		document.getElementById('bEditionCSV').disabled = false;

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function endReassort(result) {
	try {

		reassortId = result.responseXML.documentElement.getAttribute('Reassort_Id');

		aPrepCom.setParam("Reassort_Id", reassortId);
		aPrepCom.setParam("Marque_Id", "");
		aPrepCom.setParam("Fournisseur_Id", "");
		aPrepCom.initTree(initPreparation);

	} catch (e) {
		recup_erreur(e);
	}
}


function filtrerListeCC() {
  try {

		var qMajAllEtatReassortir = new QueryHttp("Facturation/Commandes/modifierToutEtatReassortir.tmpl");
		qMajAllEtatReassortir.setParam("Reassortir", false);
		qMajAllEtatReassortir.setParam("Reassort_Id", reassortId);
		qMajAllEtatReassortir.execute();

		aCC.setParam("Statut_Paiement", document.getElementById('statutPaiement').value);
		aCC.initTree(filtrerListeCC_2);

	} catch (e) {
  	recup_erreur(e);
  }
}


function filtrerListeCC_2() {
  try {

		toutCocherCommande(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function compterLignesCochees() {
	try {

		var nbCoches = 0;

		for (var i=0; i<aCC.nbLignes(); i++) {
			if (aCC.getCellValue(i, "colSelect")=="true") {
				nbCoches++;
			}
  	}

		document.getElementById('lblNbLignesCochees').value = nbCoches;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeCC(ev) {
	try {

		if (ev.keyCode==32 && aCC.isSelected()) {
			aCC.setSelectedCellValue("colSelect", aCC.getSelectedCellValue("colSelect")=="false");

			qMajEtatReassortir.setParam("Cde_Reassort_Id", aCC.getSelectedCellText('colCde_Reassort_Id'));
			qMajEtatReassortir.setParam("Reassortir", aCC.getSelectedCellValue('colSelect'));
			qMajEtatReassortir.execute();

			initPreparationCC();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function modifierEtatReassortir(tree, event) {
  //creation d'objets pour passage par reference
  var row = new Object();
  var col = new Object();
  var child = new Object();

  //recuperation des infos sur la cellule clicke
  tree.treeBoxObject.getCellAt(event.clientX, event.clientY, row, col, child);

  //recuperation des valeurs passes par reference
  row = row.value;
  col = col.value;

  //si la cellule est dans une colonne de type checkbox
  if(col.type == Components.interfaces.nsITreeColumn.TYPE_CHECKBOX) {
		qMajEtatReassortir.setParam("Cde_Reassort_Id", aCC.getCellText(row,'colCde_Reassort_Id'));
		qMajEtatReassortir.setParam("Reassortir", aCC.getCellValue(row,'colSelect'));
		qMajEtatReassortir.execute();

		initPreparationCC();
	}
}


function genererBC() {
  try {

		var nbCoche = 0;
		var listFournisseurId = "";
		var listGrpFourId = "";

		for (var i=0; i<aPrepComTotaux.nbLignes(); i++) {
			if (aPrepComTotaux.getCellValue(i, "colSelFournisseur")=="true") {
				listFournisseurId += (nbCoche>0?",":"") + aPrepComTotaux.getCellText(i, "colFournisseurId");
				nbCoche++;
			}
			if (aPrepComTotaux.getCellValue(i, "colGroupeCFReaCC")=="true") {
				listGrpFourId += aPrepComTotaux.getCellText(i, "colFournisseurId") +",";
			}
		}

		if (nbCoche==0) {
			showWarning("Veuillez s\u00E9lectionner au moins une commande");
		}
  	else if (window.confirm("Voulez-vous g\u00E9n\u00E9rer les bons de commande s\u00E9lectionn\u00E9s ?")) {
			document.getElementById('lblCalcRea').collapsed = true;
			document.getElementById('lblGenCF').collapsed = false;
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

	  	document.getElementById('Quantite').value = "";
	  	document.getElementById('Quantite').disabled = true;
			document.getElementById('bChgQte').disabled = true;
			document.getElementById('QteTrans').value = "";
			document.getElementById('QteTrans').disabled = true;
			document.getElementById('bTransQte').disabled = true;
			document.getElementById('FournDest').disabled = true;
			document.getElementById('breinitprep').disabled = true;
			document.getElementById('choixTypeButtonSeuils').disabled = true;
			document.getElementById('choixTypeButtonCC').disabled = true;
			document.getElementById('bGenCom').disabled = true;
			document.getElementById('Marque_Id').disabled = true;
			document.getElementById('Marque_Id').value = "";
			document.getElementById('Fournisseur_Id').disabled = true;
			document.getElementById('Fournisseur_Id').value = "";
			document.getElementById('statutPaiement').disabled = true;
			document.getElementById('statutPaiement').value = "";
			document.getElementById('bCocher').disabled = true;
			document.getElementById('bDecocher').disabled = true;
			document.getElementById('tree-prepcom').disabled = true;
			document.getElementById('tree-cc').disabled = true;
			document.getElementById('tree-totaux').disabled = true;
			document.getElementById('tree-ventilation').disabled = true;
			document.getElementById('depot').disabled = true;
			document.getElementById('modeReassort').disabled = true;
			document.getElementById('bEditionCSV').disabled = true;

			var qGenBC = new QueryHttp("Facturation/Commandes/validReassort.tmpl");
			qGenBC.setParam("Depot_Id", currentDepot);
			qGenBC.setParam("List_Fournisseur_Id", listFournisseurId);
			qGenBC.setParam("List_Grp_Four_Id", listGrpFourId);
			qGenBC.execute(goToCommandes);
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function reinitialiserBPC() {
  try {

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

	  aPrepCom.deleteTree();
		aPrepComTotaux.deleteTree();
		aVentilation.deleteTree();
		if (actReassortCC) {
			aCC.deleteTree();
			document.getElementById('tree-cc').disabled = true;
		}
		document.getElementById('Quantite').value = "";
	  document.getElementById('Quantite').disabled = true;
		document.getElementById('bChgQte').disabled = true;
		document.getElementById('QteTrans').value = "";
		document.getElementById('QteTrans').disabled = true;
		document.getElementById('bTransQte').disabled = true;
		document.getElementById('FournDest').disabled = true;
		document.getElementById('breinitprep').disabled = true;
		document.getElementById('choixTypeButtonSeuils').disabled = true;
		document.getElementById('choixTypeButtonCC').disabled = true;
		document.getElementById('bGenCom').disabled = true;
		document.getElementById('Marque_Id').disabled = true;
		document.getElementById('Marque_Id').value = "";
		document.getElementById('Fournisseur_Id').disabled = true;
		document.getElementById('Fournisseur_Id').value = "";
		document.getElementById('statutPaiement').disabled = true;
		document.getElementById('statutPaiement').value = "";
		document.getElementById('bCocher').disabled = true;
		document.getElementById('bDecocher').disabled = true;
		document.getElementById('tree-prepcom').disabled = true;
		document.getElementById('tree-totaux').disabled = true;
		document.getElementById('tree-ventilation').disabled = true;
		document.getElementById('depot').disabled = true;
		document.getElementById('modeReassort').disabled = true;
		document.getElementById('lblQteReassort').value = "";
		document.getElementById('lblQteTotale').value = "";
		document.getElementById('lblArticle').value = "";
		document.getElementById('bEditionCSV').disabled = true;
		document.getElementById('lblNbLignesCochees').value = 0;

		var qreinitBPC = new QueryHttp("Facturation/Commandes/resetReassort.tmpl");
		qreinitBPC.setParam("Depot_Id", currentDepot);
		qreinitBPC.setParam("Mode_Reassort", currentModeReassort);
		qreinitBPC.execute(endReassort);

	} catch (e) {
  	recup_erreur(e);
  }
}


function filtrerPrepCom() {
  try {

		aVentilation.deleteTree();

		document.getElementById('Quantite').value = "";
	  document.getElementById('Quantite').disabled = true;
		document.getElementById('bChgQte').disabled = true;
		document.getElementById('QteTrans').value = "";
		document.getElementById('QteTrans').disabled = true;
		document.getElementById('bTransQte').disabled = true;
		document.getElementById('FournDest').disabled = true;
		document.getElementById('lblQteReassort').value = "";
		document.getElementById('lblQteTotale').value = "";
		document.getElementById('lblArticle').value = "";

		aPrepCom.setParam("Marque_Id", document.getElementById('Marque_Id').value);
		aPrepCom.setParam("Fournisseur_Id", document.getElementById('Fournisseur_Id').value);
		aPrepCom.initTree();

	} catch (e) {
  	recup_erreur(e);
  }
}


function reporterQte() {
  try {

		if (aVentilation.isSelected()) {
			document.getElementById('Quantite').value = aVentilation.getSelectedCellText('ColQuantite');
			document.getElementById('Quantite').disabled = false;
			document.getElementById('bChgQte').disabled = false;

			document.getElementById('QteTrans').value = aVentilation.getSelectedCellText('ColQuantite');
			document.getElementById('QteTrans').disabled = false;
			document.getElementById('bTransQte').disabled = false;
			document.getElementById('FournDest').disabled = false;

			document.getElementById('FournDest').value = "";
			aFournisseurs.setParam('Fournisseur_Id', aVentilation.getSelectedCellText('ColFournisseur_Id'));
			aFournisseurs.setParam('Ligne_Id', aVentilation.getSelectedCellText('ColLigne_Reassort'));
			aFournisseurs.initTree();

			if (document.getElementById('boxQteTrans').collapsed) {
				document.getElementById('Quantite').select();
			}
			else {
				document.getElementById('QteTrans').select();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function loadVentilation() {
  try {

		if (aPrepCom.isSelected()) {
			document.getElementById('Quantite').value = "";
			document.getElementById('Quantite').disabled = true;
			document.getElementById('bChgQte').disabled = true;

			document.getElementById('QteTrans').value = "";
			document.getElementById('QteTrans').disabled = true;
			document.getElementById('bTransQte').disabled = true;
			document.getElementById('FournDest').disabled = true;

			document.getElementById('lblQteReassort').value = aPrepCom.getSelectedCellText('ColQte_Theorique');
			document.getElementById('lblArticle').value = aPrepCom.getSelectedCellText('ColReference') +" - "+ aPrepCom.getSelectedCellText('ColDesignation');
			aVentilation.setParam('Ligne_Id', aPrepCom.getSelectedCellText('ColLigne_Id'));
			aVentilation.initTree(initVentilation);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function initVentilation() {
  try {

		var qteTotale = 0;

		for (var i=0; i<aVentilation.nbLignes(); i++) {
			qteTotale += parseFloat(aVentilation.getCellText(i, "ColQteTotale"));
  	}

		document.getElementById('lblQteTotale').value = qteTotale;

		if (aPrepCom.isSelected()) {
			aPrepCom.setSelectedCellText('ColSVApres', qteTotale + parseFloat(aPrepCom.getSelectedCellText('ColSVAvant')));
		}

		var qteReassort = parseFloat(document.getElementById('lblQteReassort').value);
		document.getElementById('lblQteTotale').setAttribute("style", (qteTotale!=qteReassort?"font-weight:bold;color:#FF0000":"font-weight:bold"));

	} catch (e) {
  	recup_erreur(e);
  }
}


function changerQuantite() {
  try {

		var quantite = document.getElementById('Quantite').value;
		var qteMinimum = aVentilation.getSelectedCellText('ColQte_Minimum');
		var multiple = aVentilation.getSelectedCellText('ColMultiple');

		if (isEmpty(quantite) || !isPositiveOrNull(quantite)) {
			showWarning("Quantit\u00E9 incorrecte");
			document.getElementById('Quantite').select();
		}
		else if (quantite<qteMinimum) {
			showWarning("La quantit\u00E9 doit \u00EAtre sup\u00E9rieure ou \u00E9gale \u00E0 la quantit\u00E9 minimale : "+ qteMinimum);
			document.getElementById('Quantite').select();
		}
		else if (multiple>0 && quantite%multiple>0) {
			showWarning("La quantit\u00E9 doit \u00EAtre un multiple de "+ multiple);
			document.getElementById('Quantite').select();
		}
		else {
			qMajQte.setParam("Quantite", quantite);
			qMajQte.setParam("Fournisseur_Id", aVentilation.getSelectedCellText('ColFournisseur_Id'));
			qMajQte.setParam("Ligne_Id", aVentilation.getSelectedCellText('ColLigne_Reassort'));
			qMajQte.execute();

			loadVentilation();
  		aPrepComTotaux.initTree();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function keypress(ev, id) {
  try {

		if (ev.keyCode==13) {
			if (id=="Quantite") {
				changerQuantite();
			}
			else if (id=="QteTrans") {
				transQuantite();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function goToCommandes() {
  try {

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

		window.location = "chrome://opensi/content/facturation/user/commandes/gestionCommandes.xul?Provenance=Prep&Depot_Prep="+ currentDepot;

	} catch (e) {
  	recup_erreur(e);
  }
}


function toutCocherCommande(b) {
	try {

		var listCdeReassortId = "";

		for (var i=0; i<aCC.nbLignes(); i++) {
			aCC.setCellValue(i, "colSelect", b);
			listCdeReassortId += aCC.getCellText(i, "colCde_Reassort_Id") +",";
		}
  	aPrepCom.deleteTree();
		aPrepComTotaux.deleteTree();
		aVentilation.deleteTree();

		document.getElementById('Quantite').value = "";
  	document.getElementById('Quantite').disabled = true;
		document.getElementById('bChgQte').disabled = true;
		document.getElementById('QteTrans').value = "";
		document.getElementById('QteTrans').disabled = true;
		document.getElementById('bTransQte').disabled = true;
		document.getElementById('FournDest').disabled = true;
		document.getElementById('breinitprep').disabled = true;
		document.getElementById('choixTypeButtonSeuils').disabled = true;
		document.getElementById('choixTypeButtonCC').disabled = true;
		document.getElementById('bGenCom').disabled = true;
		document.getElementById('Marque_Id').disabled = true;
		document.getElementById('Fournisseur_Id').disabled = true;
		document.getElementById('bCocher').disabled = true;
		document.getElementById('bDecocher').disabled = true;
		document.getElementById('tree-prepcom').disabled = true;
		document.getElementById('tree-totaux').disabled = true;
		document.getElementById('tree-ventilation').disabled = true;
		document.getElementById('depot').disabled = true;
		document.getElementById('modeReassort').disabled = true;
		document.getElementById('lblQteReassort').value = "";
		document.getElementById('lblQteTotale').value = "";
		document.getElementById('lblArticle').value = "";

		var qMajAllEtatReassortir = new QueryHttp("Facturation/Commandes/modifierToutEtatReassortir.tmpl");
		qMajAllEtatReassortir.setParam("Reassortir", b);

		if (isEmpty(document.getElementById('statutPaiement').value)) {
			qMajAllEtatReassortir.setParam("Reassort_Id", reassortId);
		}
		else {
			qMajAllEtatReassortir.setParam("List_Cde_Reassort_Id", listCdeReassortId);
		}

		qMajAllEtatReassortir.execute();

		initPreparationCC();

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocherCF(b) {
	try {

		for (var i=0; i<aPrepComTotaux.nbLignes(); i++) {
			aPrepComTotaux.setCellValue(i, "colSelFournisseur", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/commandes/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function switchMode() {
  try {

		var b = document.getElementById('boxQteTrans').collapsed;
		document.getElementById('boxQteAff').collapsed = b;
		document.getElementById('boxQteTrans').collapsed = !b;

	} catch (e) {
  	recup_erreur(e);
  }
}


function transQuantite() {
  try {

		var quantite = document.getElementById('QteTrans').value;
		var fournDest = document.getElementById('FournDest').value;
		var quantiteMax = aVentilation.getSelectedCellText('ColQuantite');

		if (isEmpty(quantite) || !isPositiveOrNull(quantite) || quantite==0) {
			showWarning("Quantit\u00E9 \u00E0 basculer incorrecte");
			document.getElementById('QteTrans').select();
		}
		else if (isEmpty(fournDest)) {
			showWarning("Veuillez s\u00E9lectionner un fournisseur de destination");
		}
		else if (quantite>quantiteMax) {
			showWarning("Quantit\u00E9 \u00E0 basculer sup\u00E9rieure \u00E0 la quantit\u00E9 affect\u00E9e");
			document.getElementById('QteTrans').select();
		}
		else {
			qBascule.setParam("Quantite", quantite);
			qBascule.setParam("Fourn_Orig", aVentilation.getSelectedCellText('ColFournisseur_Id'));
			qBascule.setParam("Fourn_Dest", fournDest);
			qBascule.setParam("Ligne_Id", aVentilation.getSelectedCellText('ColLigne_Reassort'));
			qBascule.execute();

			loadVentilation();
  		aPrepComTotaux.initTree();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
