/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omc_aCommerciaux = new Arbre("Facturation/Commerciaux/list-ficheCommercial.tmpl", "omc-listeCommerciaux");



function omc_init() {
	try {

		omc_loadChiffresCles();
		omc_listerCommerciaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnNouveauCommercial() {
	try {

		document.getElementById("bMenuCommerciaux").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		ofc_nouveauCommercial();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_initCriteres() {
	try {

		document.getElementById('omc-actif').checked = true;

		omc_listerCommerciaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_listerCommerciaux() {
	try {

		var actif = document.getElementById('omc-actif').checked;

		document.getElementById('omc-listeCommerciaux').disabled = true;

		omc_aCommerciaux.setParam("Actif", actif);
		omc_aCommerciaux.initTree(omc_afterListerCommerciaux);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_afterListerCommerciaux() {
	try {

		document.getElementById('omc-listeCommerciaux').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omc_listerCommerciaux();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_pressOnListeCommerciaux(ev) {
	try {

		if (ev.keyCode==13) {
			omc_ouvrirCommercial();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_ouvrirCommercial() {
  try {

  	if (omc_aCommerciaux.isSelected()) {

			ofc_commercialId = omc_aCommerciaux.getSelectedCellText('omc-colCommercialId');
			document.getElementById('bMenuCommerciaux').collapsed = false;

			ofc_chargerCommercial();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Facturation/Commerciaux/getStatsFicheCommercial.tmpl");
		var result = qStats.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("omc-nbFCTotal").value = contenu.getAttribute("Nb_FC_Total");
		document.getElementById("omc-nbFCTotalActif").value = contenu.getAttribute("Nb_FC_Total_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}
