/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ooh_aHistorique = new Arbre("Facturation/Commerciaux/list-commissionnement.tmpl", "ooh-listeCommissions");

var ooh_currentCommissionnementId;



function ooh_initOngletHistorique() {
	try {

		document.getElementById('ooh-bEditionPDF').disabled = true;

		ooh_aHistorique.setParam("Commercial_Id", ofc_commercialId);
		ooh_aHistorique.initTree();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooh_selectOnListeCommissions() {
	try {

		if (ooh_aHistorique.isSelected()) {
			ooh_currentCommissionnementId = ooh_aHistorique.getSelectedCellText('ooh-colCommissionnementId');

			document.getElementById('ooh-bEditionPDF').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooh_editerCommissionnement() {
	try {

		if (ooh_aHistorique.isSelected()) {

			var qEdit = new QueryHttp("Facturation/Commerciaux/pdf_commissionnement.tmpl");
			qEdit.setParam("Commissionnement_Id", ooh_currentCommissionnementId);
			var result = qEdit.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('ofc-pdfCommercial').setAttribute("src", page);

				document.getElementById('ofc-deckCommercial').selectedIndex = 1;
				document.getElementById('bRetourCommercial').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
