/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oos_aStats = new Arbre("Facturation/Commerciaux/statistiques_commercial.tmpl", "oos-listeStatistiques");



function oos_initOngletStatistiques() {
	try {

		oos_aStats.deleteTree();

		document.getElementById('oos-periode').value = "MC";
		document.getElementById('oos-niveauDetail').value = "N";
		oos_enableDates(false);
		oos_resetCommissionnement();

		document.getElementById('oos-lblPeriode').value = "P\u00E9riode";
		document.getElementById('oos-caHT').value = "";
		document.getElementById('oos-caTTC').value = "";
		document.getElementById('oos-montantCommissions').value = "";

	} catch (e) {
		recup_erreur(e);
  }
}


function oos_enableDates(b) {
	try {

		document.getElementById("oos-dateDebut").disabled = !b;
		document.getElementById("oos-dateFin").disabled = !b;

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_pressOnCritere() {
	try {

		oos_resetCommissionnement();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_resetCommissionnement() {
	try {

		document.getElementById("oos-boxCommissionnement").collapsed = true;
		document.getElementById('oos-montantAjustement').value = "0";
		document.getElementById('oos-typeAjustement').value = "D";
		document.getElementById('oos-commentaires').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_listerStatistiques() {
	try {

		var periode = document.getElementById('oos-periode').value;
		var dateDebut = document.getElementById('oos-dateDebut').value;
		var dateFin = document.getElementById('oos-dateFin').value;
		var niveauDetail = document.getElementById('oos-niveauDetail').value;

		if (periode=="DD" && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (periode=="DD" && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (periode=="DD" && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			// spcifique des tmpl
			dateDebut = periode=="DD"?prepareDateJava(dateDebut):periode;
			dateFin = periode=="DD"?prepareDateJava(dateFin):"";

			document.getElementById('oos-colClient').collapsed = niveauDetail!="C";
			document.getElementById('oos-colMarque').collapsed = niveauDetail!="M";
			document.getElementById('oos-colFamille1').collapsed = niveauDetail!="F1" && niveauDetail!="F2" && niveauDetail!="F3";
			document.getElementById('oos-colFamille2').collapsed = niveauDetail!="F2" && niveauDetail!="F3";
			document.getElementById('oos-colFamille3').collapsed = niveauDetail!="F3";
			document.getElementById('oos-colArticle').collapsed = niveauDetail!="A";

			oos_aStats.setParam("Commercial_Id", ofc_commercialId);
			oos_aStats.setParam("Date_Debut", dateDebut);
			oos_aStats.setParam("Date_Fin", dateFin);
			oos_aStats.setParam("Filtre", niveauDetail);
			oos_aStats.initTree();

			var qGet = new QueryHttp("Facturation/Commerciaux/totaux_remuneration.tmpl");
			qGet.setParam("Commercial_Id", ofc_commercialId);
			qGet.setParam("Date_Debut", dateDebut);
			qGet.setParam("Date_Fin", dateFin);
			qGet.setParam("Filtre", niveauDetail);
			var result = qGet.execute();
			var contenu = result.responseXML.documentElement;

			document.getElementById('oos-lblPeriode').value = "P\u00E9riode du "+ contenu.getAttribute("dd") +" au "+ contenu.getAttribute("df");
			document.getElementById('oos-caHT').value = contenu.getAttribute("caht");
			document.getElementById('oos-caTTC').value = contenu.getAttribute("cattc");
			document.getElementById('oos-montantCommissions').value = contenu.getAttribute("commission");

			document.getElementById("oos-boxCommissionnement").collapsed = !gDirection || parseFloat(contenu.getAttribute("commission"))==0;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oos_checkPeriode() {
	try {

		var periode = document.getElementById('oos-periode').value;
		var dateDebut = document.getElementById('oos-dateDebut').value;
		var dateFin = document.getElementById('oos-dateFin').value;

		// spcifique du tmpl
		dateDebut = periode=="DD"?prepareDateJava(dateDebut):periode;
		dateFin = periode=="DD"?prepareDateJava(dateFin):"";

		var qExist = new QueryHttp("Facturation/Commerciaux/existePeriodeCommissionnement.tmpl");
		qExist.setParam("Commercial_Id", ofc_commercialId);
		qExist.setParam("Date_Debut", dateDebut);
		qExist.setParam("Date_Fin", dateFin);
		var result = qExist.execute();

		return (result.responseXML.documentElement.getAttribute("Exist")=="false");

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_validerCommissionnement() {
	try {

		var periode = document.getElementById('oos-periode').value;
		var dateDebut = document.getElementById('oos-dateDebut').value;
		var dateFin = document.getElementById('oos-dateFin').value;
		var niveauDetail = document.getElementById('oos-niveauDetail').value;
		var montantAjustement = parseFloat(document.getElementById('oos-montantAjustement').value);
		var typeAjustement = document.getElementById('oos-typeAjustement').value;
		var commentaires = document.getElementById('oos-commentaires').value;

		if (periode=="DD" && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (periode=="DD" && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (periode=="DD" && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (isEmpty(montantAjustement) || !isPositiveOrNull(montantAjustement)) { showWarning("L'ajustement doit \u00EAtre un nombre positif !"); }
		else if (window.confirm(oos_checkPeriode()?"Confirmez-vous le commissionnement du commercial pour la p\u00E9riode indiqu\u00E9e ?":"La p\u00E9riode choisie a d\u00E9j\u00E0 \u00E9t\u00E9 commissionn\u00E9e. Voulez-vous quand-m\u00EAme continuer ?")) {

			if (typeAjustement=="D") { montantAjustement *= -1; }

			// spcifique du tmpl
			dateDebut = periode=="DD"?prepareDateJava(dateDebut):periode;
			dateFin = periode=="DD"?prepareDateJava(dateFin):"";

			var qEditionPdf = new QueryHttp("Facturation/Commerciaux/pdf_commissionnement.tmpl");

			qEditionPdf.setParam("Commercial_Id", ofc_commercialId);
			qEditionPdf.setParam("Date_Debut", dateDebut);
			qEditionPdf.setParam("Date_Fin", dateFin);
			qEditionPdf.setParam("Filtre", niveauDetail);
			qEditionPdf.setParam("Montant_Ajustement", montantAjustement);
			qEditionPdf.setParam("Commentaires", commentaires);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oos_initOngletStatistiques();
				ooh_initOngletHistorique();

				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('ofc-pdfCommercial').setAttribute("src", page);

				document.getElementById('ofc-deckCommercial').selectedIndex = 1;
				document.getElementById('bRetourCommercial').collapsed = false;
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}
