/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var tmpl;
var resultId;
var typeElement = ParamValeur("Type_Element");


function init() {
  try {

  	var titre = "";
		switch (typeElement) {
			case "FCLIENT" :
				titre = "NOUVELLE FAMILLE";
				tmpl = "Config/gc/tiers/createFamilleClient.tmpl";
				resultId = "Famille_Id";
				break;
			case "FFOURN" :
				titre = "NOUVELLE FAMILLE";
				tmpl = "Config/gc/tiers/createFamilleFournisseur.tmpl";
				resultId = "Famille_Id";
				break;
			case "FART" :
				titre = "NOUVELLE FAMILLE";
				tmpl = "Config/gc/articles/createFamilleArticle.tmpl";
				resultId = "Famille_Id";
				break;
			case "MARQUE" :
				titre = "NOUVELLE MARQUE";
				tmpl = "Config/gc/articles/createMarqueArticle.tmpl";
				resultId = "Marque_Id";
				break;
			case "ATTRIBUT" :
				tmpl = "Config/gc/articles/createAttribut.tmpl";
				resultId = "Attribut_Id";
				titre = "NOUVELLE VALEUR D'ATTRIBUT "+ ParamValeur("Intitule_Groupe").toUpperCase();
				if (getConfig().isSpecPCAFT()) {
					document.getElementById("libelle").removeAttribute("maxlength");
				}
				break;
			case "CONDIT" :
				titre = "NOUVEAU CONDITIONNEMENT";
				tmpl = "Config/gc/articles/createConditionnementArticle.tmpl";
				resultId = "Conditionnement_Id";
				break;
		}
		document.getElementById('lblTitre').value = titre;
		document.getElementById('libelle').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function valider() {
  try {

  	var libelle = document.getElementById('libelle').value;

  	if (isEmpty(libelle)) {
			showWarning("Veuillez saisir un libell\u00E9");
		}
  	else {
			var qCreate = new QueryHttp(tmpl);
			qCreate.setParam("Libelle", libelle);
			qCreate.setParam("Actif", true);
			if (typeElement=="ATTRIBUT") {
				qCreate.setParam("Groupe_Id", ParamValeur("Groupe_Id"));
			}
			else if (typeElement=="FART") {
				qCreate.setParam("Parent_Id", ParamValeur("Parent_Id"));
			}
			var result = qCreate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.arguments[0](result.responseXML.documentElement.getAttribute(resultId));
				window.close();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}
