/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Identifiant client
		- 2 : Lecture seule
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var currentContact=-1;
var clientId;
var adresseContact = "";
var readOnly;

var aContacts = new Arbre("Facturation/Clients/list-contactClient.tmpl", "tree-contacts");


function init() {
  try {

		clientId = window.arguments[1];
		readOnly = window.arguments[2];

		document.getElementById('boxValider').collapsed = readOnly;
		document.getElementById('boxQuitter').collapsed = !readOnly;

		if (readOnly) {
			document.getElementById('Contact').collapsed = true;
			document.getElementById('bQuitter').focus();
		}

		var qGetCriteresActifs = new QueryHttp("CRM/GestionContacts/getCriteres.tmpl");
		var result = qGetCriteresActifs.execute();
		var contenu = result.responseXML.documentElement;

		var libCritere1 = contenu.getAttribute("Label_1");
		var libCritere2 = contenu.getAttribute("Label_2");
		var libCritere3 = contenu.getAttribute("Label_3");
		var libCritere4 = contenu.getAttribute("Label_4");
		var libCritere5 = contenu.getAttribute("Label_5");

		var actCritere1 = (contenu.getAttribute("Actif_1")=="true");
		var actCritere2 = (contenu.getAttribute("Actif_2")=="true");
		var actCritere3 = (contenu.getAttribute("Actif_3")=="true");
		var actCritere4 = (contenu.getAttribute("Actif_4")=="true");
		var actCritere5 = (contenu.getAttribute("Actif_5")=="true");

		document.getElementById("Critere_1").setAttribute("label", libCritere1);
		document.getElementById("Critere_2").setAttribute("label", libCritere2);
		document.getElementById("Critere_3").setAttribute("label", libCritere3);
		document.getElementById("Critere_4").setAttribute("label", libCritere4);
		document.getElementById("Critere_5").setAttribute("label", libCritere5);

		document.getElementById("Critere_1").collapsed = !actCritere1;
		document.getElementById("Critere_2").collapsed = !actCritere2;
		document.getElementById("Critere_3").collapsed = !actCritere3;
		document.getElementById("Critere_4").collapsed = !actCritere4;
		document.getElementById("Critere_5").collapsed = !actCritere5;

		document.getElementById("ColCritere1").setAttribute("tooltiptext", libCritere1);
		document.getElementById("ColCritere2").setAttribute("tooltiptext", libCritere2);
		document.getElementById("ColCritere3").setAttribute("tooltiptext", libCritere3);
		document.getElementById("ColCritere4").setAttribute("tooltiptext", libCritere4);
		document.getElementById("ColCritere5").setAttribute("tooltiptext", libCritere5);

		document.getElementById("ColCritere1").setAttribute("label", libCritere1);
		document.getElementById("ColCritere2").setAttribute("label", libCritere2);
		document.getElementById("ColCritere3").setAttribute("label", libCritere3);
		document.getElementById("ColCritere4").setAttribute("label", libCritere4);
		document.getElementById("ColCritere5").setAttribute("label", libCritere5);

		if (!actCritere1) {	document.getElementById("ColCritere1").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere2) {	document.getElementById("ColCritere2").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere3) {	document.getElementById("ColCritere3").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere4) {	document.getElementById("ColCritere4").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere5) {	document.getElementById("ColCritere5").setAttribute("ignoreincolumnpicker", true); }

		document.getElementById("ColCritere1").setAttribute("hidden", !actCritere1);
		document.getElementById("ColCritere2").setAttribute("hidden", !actCritere2);
		document.getElementById("ColCritere3").setAttribute("hidden", !actCritere3);
		document.getElementById("ColCritere4").setAttribute("hidden", !actCritere4);
		document.getElementById("ColCritere5").setAttribute("hidden", !actCritere5);

		aContacts.setParam("Client_Id", clientId);
		aContacts.initTree();
		nouveauContact();

  } catch (e) {
    recup_erreur(e);
  }
}


function nouveauContact() {
	try {

		aContacts.clearSelection();

		currentContact=-1;

	  document.getElementById('Civilite').value = "0";
		document.getElementById('Nom').value = "";
		document.getElementById('Prenom').value = "";
		document.getElementById('Fonction').value = "";
		document.getElementById('Denomination').value = "";
		document.getElementById('Adresse_1').value = "";
		document.getElementById('Adresse_2').value = "";
		document.getElementById('Adresse_3').value = "";
		document.getElementById('Code_Postal').value = "";
		document.getElementById('Ville').value = "";
		document.getElementById('Pays').value = "";
		document.getElementById('tel1').value = "";
		document.getElementById('tel2').value = "";
		document.getElementById('Fax').value = "";
		document.getElementById('Email').value = "";
		document.getElementById('Relation').value = "0";
		document.getElementById('Principal_Fact').checked = false;
		document.getElementById('Principal_Liv').checked = false;
		document.getElementById('Principal_Envoi').checked = false;
		document.getElementById('Principal_Devis').checked = false;
		document.getElementById('Principal').checked = false;
		document.getElementById('Principal').disabled = false;
		document.getElementById('Infos').value = "";
		document.getElementById('Actif').checked = true;
		document.getElementById('Critere_1').checked = false;
		document.getElementById('Critere_2').checked = false;
		document.getElementById('Critere_3').checked = false;
		document.getElementById('Critere_4').checked = false;
		document.getElementById('Critere_5').checked = false;
		adresseContact = "";

		document.getElementById('bNouveauContact').collapsed = true;
		document.getElementById('bSupprimerContact').collapsed = true;
		document.getElementById('bModifierContact').collapsed = true;
		document.getElementById('bCreerContact').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function changergroupbox(check) {
	try {

		window.resizeTo(1000,check?800:400);
		document.getElementById('Group_Contact').collapsed=!check;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerContact() {
	try {

		if (aContacts.isSelected()) {

			currentContact = aContacts.getSelectedCellValue('ColCiv');
			document.getElementById('Nom').value = aContacts.getSelectedCellText('ColNom');
			document.getElementById('Prenom').value = aContacts.getSelectedCellText('ColPrenom');
			document.getElementById('Fonction').value = aContacts.getSelectedCellText('ColFonction');
			document.getElementById('Relation').value = aContacts.getSelectedCellText('ColRelation');
			document.getElementById('Infos').value = aContacts.getSelectedCellText('ColInfos');
			document.getElementById('Denomination').value = aContacts.getSelectedCellText('ColDenomination');
			document.getElementById('Adresse_1').value = aContacts.getSelectedCellText('ColAdresse_1');
			document.getElementById('Adresse_2').value = aContacts.getSelectedCellText('ColAdresse_2');
			document.getElementById('Adresse_3').value = aContacts.getSelectedCellText('ColAdresse_3');
			document.getElementById('Code_Postal').value = aContacts.getSelectedCellText('ColCode_Postal');
			document.getElementById('Ville').value = aContacts.getSelectedCellText('ColVille');
			document.getElementById('Pays').value = aContacts.getSelectedCellText('ColPays');
			document.getElementById('tel1').value = aContacts.getSelectedCellText('ColTel1');
			document.getElementById('tel2').value = aContacts.getSelectedCellText('ColTel2');
			document.getElementById('Fax').value = aContacts.getSelectedCellText('ColFax');
			document.getElementById('Email').value = aContacts.getSelectedCellText('ColEmail');
			document.getElementById('Principal_Fact').checked = (aContacts.getSelectedCellText('ColPrincipal_Fact')=="true");
			document.getElementById('Principal_Liv').checked = (aContacts.getSelectedCellText('ColPrincipal_Liv')=="true");
			document.getElementById('Principal_Envoi').checked = (aContacts.getSelectedCellText('ColPrincipal_Envoi')=="true");
			document.getElementById('Principal_Devis').checked = (aContacts.getSelectedCellText('ColPrincipal_Devis')=="true");
			document.getElementById('Actif').checked = (aContacts.getSelectedCellText('ColActif')=="true");
			document.getElementById('Critere_1').checked = (aContacts.getSelectedCellText('ColValCritere1')=="true");
			document.getElementById('Critere_2').checked = (aContacts.getSelectedCellText('ColValCritere2')=="true");
			document.getElementById('Critere_3').checked = (aContacts.getSelectedCellText('ColValCritere3')=="true");
			document.getElementById('Critere_4').checked = (aContacts.getSelectedCellText('ColValCritere4')=="true");
			document.getElementById('Critere_5').checked = (aContacts.getSelectedCellText('ColValCritere5')=="true");
			adresseContact = aContacts.getSelectedCellText('ColAdresse_Id');
			document.getElementById('Principal').checked = (aContacts.getSelectedCellText('ColPrincipal')=="true");
			document.getElementById('Principal').disabled = document.getElementById('Principal').checked;
			document.getElementById("Civilite").value = aContacts.getSelectedCellText('ColNum_Civ');

			document.getElementById('bSupprimerContact').collapsed = false;
			document.getElementById('bModifierContact').collapsed = false;
			document.getElementById('bNouveauContact').collapsed = false;
			document.getElementById('bCreerContact').collapsed = true;
  	}

 	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerContact() {
	try {

		var prenom = document.getElementById('Prenom').value;
		var nom = document.getElementById('Nom').value;

		if (window.confirm("Confirmez-vous la suppression du contact '"+ prenom +" "+ nom +"' ?")) {

			var qSupContact = new QueryHttp("Facturation/Clients/deleteContactClient.tmpl");
			qSupContact.setParam('Contact_Id', currentContact);
			var result = qSupContact.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('bSupprimerContact').collapsed = true;
				document.getElementById('bModifierContact').collapsed = true;
				document.getElementById('bCreerContact').collapsed = false;
				document.getElementById('bNouveauContact').collapsed = true;
				aContacts.initTree();
				nouveauContact();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrerContact(mode) {
	try {

    var civilite = document.getElementById('Civilite').value;
		var nom = document.getElementById('Nom').value;
		var prenom = document.getElementById('Prenom').value;
		var fonction = document.getElementById('Fonction').value;
		var relation = document.getElementById('Relation').value;
		var infos = document.getElementById('Infos').value;
		var tel1 = document.getElementById('tel1').value;
		var tel2 = document.getElementById('tel2').value;
		var fax = document.getElementById('Fax').value;
		var email = document.getElementById('Email').value;
		var principal_fact = document.getElementById('Principal_Fact').checked;
		var principal_liv = document.getElementById('Principal_Liv').checked;
		var principal_envoi = document.getElementById('Principal_Envoi').checked;
		var principal_devis = document.getElementById('Principal_Devis').checked;
		var actif = document.getElementById('Actif').checked;
		var principal = document.getElementById('Principal').checked;
		var critere1 = document.getElementById('Critere_1').checked;
		var critere2 = document.getElementById('Critere_2').checked;
		var critere3 = document.getElementById('Critere_3').checked;
		var critere4 = document.getElementById('Critere_4').checked;
		var critere5 = document.getElementById('Critere_5').checked;

		if (isEmpty(nom)) {
			showWarning("Veuillez sp\u00E9cifier le nom du contact !");
		}
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("T\u00E9l\u00E9phone 1 invalide"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("T\u00E9l\u00E9phone 2 invalide"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le num\u00E9ro de fax est invalide !"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'adresse e-mail est invalide !"); }
		else if (principal && !actif) { showWarning("Un contact principal ne peut pas \u00EAtre d\u00E9sactiv\u00E9"); }
		else {

			var qSaveContact;

			if (mode=="C") {
				qSaveContact = new QueryHttp("Facturation/Clients/createContactClient.tmpl");
			}
			else {
				qSaveContact = new QueryHttp("Facturation/Clients/updateContactClient.tmpl");
				qSaveContact.setParam('Contact_Id', currentContact);
			}

			qSaveContact.setParam('Client_Id', clientId);
			qSaveContact.setParam('Civilite', civilite);
			qSaveContact.setParam('Nom', nom);
			qSaveContact.setParam('Prenom', prenom);
			qSaveContact.setParam('Fonction', fonction);
			qSaveContact.setParam('Relation', relation);
			qSaveContact.setParam('Infos', infos);
			qSaveContact.setParam('Tel_1', tel1);
			qSaveContact.setParam('Tel_2', tel2);
			qSaveContact.setParam('Fax', fax);
			qSaveContact.setParam('Email', email);
			qSaveContact.setParam('Principal_Fact', principal_fact);
			qSaveContact.setParam('Principal_Liv', principal_liv);
			qSaveContact.setParam('Principal_Envoi', principal_envoi);
			qSaveContact.setParam('Principal_Devis', principal_devis);
			qSaveContact.setParam('Actif', actif);
			qSaveContact.setParam('Adresse_Id', adresseContact);
			qSaveContact.setParam('Principal', principal);
			qSaveContact.setParam('Critere_1', critere1);
			qSaveContact.setParam('Critere_2', critere2);
			qSaveContact.setParam('Critere_3', critere3);
			qSaveContact.setParam('Critere_4', critere4);
			qSaveContact.setParam('Critere_5', critere5);

			var result = qSaveContact.execute();

			if (mode=="C") {

				currentContact = result.responseXML.documentElement.getAttribute('Contact_Id');

				document.getElementById('bCreerContact').collapsed = true;
				document.getElementById('bModifierContact').collapsed = false;
				document.getElementById('bNouveauContact').collapsed = false;
				document.getElementById('bSupprimerContact').collapsed = false;
			}

			aContacts.initTree(scrollToNum);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function scrollToNum() {
	try {
		var tree = document.getElementById("tree-contacts");

		if (tree.view!=null && tree.view.rowCount>0 && currentContact>-1) {

			var i = 0;
			var trouve = false;

			while (!trouve && i<tree.view.rowCount) {
				if (parseIntBis(aContacts.getCellValue(i,'ColCiv'))==currentContact) {
					aContacts.ensureRowIsVisible(i);
					aContacts.select(i);
					trouve = true;
				}

				i++;
			}
			if (!trouve) aContacts.ensureRowIsVisible(tree.view.rowCount-1);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ouvrirInter() {
  try {

		if (!readOnly) {
			if (currentContact!=-1) {
				var civ = aContacts.getSelectedCellText('ColNum_Civ');
				var nom = aContacts.getSelectedCellText('ColNom');
				var prenom = aContacts.getSelectedCellText('ColPrenom');
				var tel1 = aContacts.getSelectedCellText('ColTel1');
				var tel2 = aContacts.getSelectedCellText('ColTel2');
				var fax = aContacts.getSelectedCellText('ColFax');
				var email = aContacts.getSelectedCellText('ColEmail');

				window.arguments[0](civ, nom, prenom, tel1, tel2, fax, email);
    		window.close();
			}
			else {
				showWarning("Veuillez s\u00E9lectionner un contact !");
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
    	ouvrirInter();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function rechercherAdresse() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', reporterAdresse, clientId, readOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function reporterAdresse(denomination, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("Denomination").value = denomination;
		document.getElementById("Adresse_1").value = adr1;
		document.getElementById("Adresse_2").value = adr2;
		document.getElementById("Adresse_3").value = adr3;
		document.getElementById("Code_Postal").value = cp;
		document.getElementById("Ville").value = ville;
	  document.getElementById("Pays").value = pays;

		adresseContact = adresseId;

	} catch (e) {
  	recup_erreur(e);
  }
}
