/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Type document
		- 2 : Identifiant document
		- 3 : Commentaires de fin
		- 4 : Commentaires non imprimables
		- 5 : Si true, mode lecture seule
		- 6 : Demande de confirmation d'enregistrement spcifique (argument facultatif)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var docId;
var typeDoc;
var tmplSave;
var pDocId;
var msgConfirm = null;



function init() {
  try {

		var readOnly = window.arguments[5];

		document.getElementById('boxValider').collapsed = readOnly;
		document.getElementById('boxQuitter').collapsed = !readOnly;
		document.getElementById('boxModeleFin').collapsed = readOnly;
		document.getElementById('boxModeleInt').collapsed = readOnly;

		if (readOnly) {
			document.getElementById('commentairesFin').setAttribute("readonly", true);
			document.getElementById('commentairesInt').setAttribute("readonly", true);
			document.getElementById('bQuitter').focus();
		}
		else {
			document.getElementById('commentairesFin').focus();
		}

		typeDoc = window.arguments[1];
		docId = window.arguments[2];
		document.getElementById('commentairesFin').value = window.arguments[3];
		document.getElementById('commentairesInt').value = window.arguments[4];
		msgConfirm = window.arguments[6];

		var libellePopup;

		if (typeDoc=="CC") {
			libellePopup = "Commentaires sur commande";
			tmplSave = "Facturation/Affaires/updateCommentairesCommandeClient.tmpl";
			pDocId = "Commande_Id";
		}
		else if (typeDoc=="DC") {
			libellePopup = "Commentaires sur devis";
			tmplSave = "Facturation/Devis/updateCommentairesDevis.tmpl";
			pDocId = "Devis_Id";
		}
		else if (typeDoc=="FC") {
			libellePopup = "Commentaires sur facture";
			tmplSave = "Facturation/FacturesVente/updateCommentairesFactureClient.tmpl";
			pDocId = "Facture_Id";
		}
		else if (typeDoc=="AC") {
			libellePopup = "Commentaires sur avoir";
			tmplSave = "Facturation/Avoirs/updateCommentairesAvoirClient.tmpl";
			pDocId = "Avoir_Id";
		}
		else if (typeDoc=="RC") {
			libellePopup = "Commentaires sur retour";
			tmplSave = "Facturation/Affaires/updateCommentairesRetourClient.tmpl";
			pDocId = "Retour_Id";
		}
		else if (typeDoc=="TS") {
			libellePopup = "Commentaires sur transfert";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesTransfertStock.tmpl";
			pDocId = "Transfert_Id";
		}
		else if (typeDoc=="TE") {
			libellePopup = "Commentaires sur transfert";
			tmplSave = "Facturation/Transferts_Emplacements/updateCommentairesTransfertEmplacement.tmpl";
			pDocId = "Transfert_Id";
		}
		else if (typeDoc=="CF") {
			libellePopup = "Commentaires sur commande";
			tmplSave = "Facturation/Commandes/updateCommentairesCommandeFournisseur.tmpl";
			pDocId = "Commande_Id";
		}
		else if (typeDoc=="FF") {
			libellePopup = "Commentaires sur facture";
			tmplSave = "Facturation/Factu_Fournisseur/updateCommentairesFactureFournisseur.tmpl";
			pDocId = "Facture_Id";
		}
		else if (typeDoc=="AF") {
			libellePopup = "Commentaires sur avoir";
			tmplSave = "Facturation/Avoirs_Fournisseur/updateCommentairesAvoirFournisseur.tmpl";
			pDocId = "Avoir_Id";
		}
		else if (typeDoc=="RF") {
			libellePopup = "Commentaires sur retour";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesRetourFournisseur.tmpl";
			pDocId = "Retour_Id";
		}
		else if (typeDoc=="BR") {
			libellePopup = "Commentaires sur bon de r\u00E9ception";
			tmplSave = "Facturation/Commandes/updateCommentairesBonReception.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BRT") {
			libellePopup = "Commentaires sur bon de r\u00E9ception";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesBonReception.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BRR") {
			libellePopup = "Commentaires sur bon de r\u00E9ception";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesBonReception.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BLT") {
			libellePopup = "Commentaires sur bon de livraison";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesBonLivraison.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BLR") {
			libellePopup = "Commentaires sur bon de livraison";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesBonLivraison.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BL") {
			libellePopup = "Commentaires sur bon de livraison";
			tmplSave = "Facturation/Affaires/updateCommentairesBonLivraison.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="OL") {
			libellePopup = "Commentaires sur ordre de livraison";
			tmplSave = "Facturation/Affaires/updateCommentairesBonLivraison.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="LF") {
			libellePopup = "Commentaires sur livraison fournisseur";
			tmplSave = "Facturation/Affaires/updateCommentairesBonLivraison.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="MA") {
			libellePopup = "Commentaires sur facture";
			tmplSave = "Facturation/Abonnements/updateCommentairesModeleAbonnement.tmpl";
			pDocId = "Modele_Id";
		}
		else if (typeDoc=="CA") {
			libellePopup = "Commentaires sur facture";
			tmplSave = "Facturation/Abonnements/updateCommentairesContratAbonnement.tmpl";
			pDocId = "Contrat_Id";
		}

		document.getElementById('lblPopup').value = libellePopup;

		var aModelesFin = new Arbre('ComboListe/combo-modeleCommentaire.tmpl', 'modeleFin');
		aModelesFin.setParam("Code_Document", typeDoc);
		aModelesFin.setParam("Type_Commentaire", "F");
		aModelesFin.initTree();

		var aModelesInt = new Arbre('ComboListe/combo-modeleCommentaire.tmpl', 'modeleInt');
		aModelesInt.setParam("Code_Document", typeDoc);
		aModelesInt.setParam("Type_Commentaire", "I");
		aModelesInt.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerCommentaires() {
  try {

		if (msgConfirm==null || window.confirm(msgConfirm)) {
			var commentairesFin = document.getElementById('commentairesFin').value;
			var commentairesInt = document.getElementById('commentairesInt').value;

			if (!isEmpty(docId)) {
				// docId est vide si le document n'est pas enregistr, on reporte simplement les commentaires dans ce cas.

				var qSave = new QueryHttp(tmplSave);
				qSave.setParam(pDocId, docId);
				qSave.setParam("Commentaires_Fin", commentairesFin);
				qSave.setParam("Commentaires_Int", commentairesInt);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}

			window.arguments[0](commentairesFin, commentairesInt);
		}

		window.close();

	} catch (e) {
    recup_erreur(e);
  }
}


function insererModeleFin() {
	try {

		var modeleId = document.getElementById('modeleFin').value;

		if (isEmpty(modeleId)) {
			showWarning("Veuillez choisir un mod\u00E8le");
		}
		else {
			var qModele = new QueryHttp("Config/globale/getModeleCommentaire.tmpl");
			qModele.setParam("Modele_Id", modeleId);

			var result = qModele.execute();

			var cursor = document.getElementById('commentairesFin').selectionStart;
			var curCommentaire = document.getElementById('commentairesFin').value;

			document.getElementById('commentairesFin').value = curCommentaire.substring(0,cursor) + result.responseXML.documentElement.getAttribute('Commentaire') + curCommentaire.substring(cursor,curCommentaire.length);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function insererModeleInt() {
	try {

		var modeleId = document.getElementById('modeleInt').value;

		if (isEmpty(modeleId)) {
			showWarning("Veuillez choisir un mod\u00E8le");
		}
		else {
			var qModele = new QueryHttp("Config/globale/getModeleCommentaire.tmpl");
			qModele.setParam("Modele_Id", modeleId);

			var result = qModele.execute();

			var cursor = document.getElementById('commentairesInt').selectionStart;
			var curCommentaire = document.getElementById('commentairesInt').value;

			document.getElementById('commentairesInt').value = curCommentaire.substring(0,cursor) + result.responseXML.documentElement.getAttribute('Commentaire') + curCommentaire.substring(cursor,curCommentaire.length);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}
