/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var typeDoc;
var ligneId;
var prixVente;
var tmplUpdate;


function init() {
  try {

		typeDoc = window.arguments[1];
		ligneId = window.arguments[2];

		var tmplLoad;

		switch (typeDoc) {
			case "CC" :
				tmplLoad = "Facturation/Affaires/loadLigneCommandeClient.tmpl";
				tmplUpdate = "Facturation/Affaires/updatePrixAchatLigneCC.tmpl";
				break;
			case "FC" :
				tmplLoad = "Facturation/FacturesVente/loadLigneFactureClient.tmpl";
				tmplUpdate = "Facturation/FacturesVente/updatePrixAchatLigneFC.tmpl";
				break;
			case "DC" :
				tmplLoad = "Facturation/Devis/loadLigneDevis.tmpl";
				tmplUpdate = "Facturation/Devis/updatePrixAchatLigneDC.tmpl";
				break;
		}

		var qLoad = new QueryHttp(tmplLoad);
		qLoad.setParam("Ligne_Id", ligneId);
		var result = qLoad.execute();

		prixVente = result.responseXML.documentElement.getAttribute("Prix_Unitaire");

		var fpu = new NumberFormat("0.00##", true);
		document.getElementById('curPrixAchat').value = fpu.format(result.responseXML.documentElement.getAttribute("Prix_Achat"));

		document.getElementById('prixAchat').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function modifierPrixAchat() {
  try {

		var prixAchat = document.getElementById('prixAchat').value;

		if (isEmpty(prixAchat) || !isPositiveOrNull(prixAchat) || !checkDecimal(prixAchat,4)) { showWarning("Prix d'achat incorrect"); }
		else {
			var ok = true;

			if (parseFloat(prixAchat)>parseFloat(prixVente)) {
				ok = window.confirm("Attention : Le prix d'achat est sup\u00E9rieur au prix de vente. Voulez-vous continuer ?");
			}

			if (ok) {
				var qUpdate = new QueryHttp(tmplUpdate);
				qUpdate.setParam("Ligne_Id", ligneId);
				qUpdate.setParam("Prix_Achat", prixAchat);
				var result = qUpdate.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					if (typeDoc=="CC") {
						var message = result.responseXML.documentElement.getAttribute("Alerte");
						if (message!=null) {
							showWarning(message);
						}
					}

					window.arguments[0]();
					window.close();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
