/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Mode d'ouverture du popup (S=Saisie, C=Consultation)
		- 1 : Type de document
		- 2 : Identifiant de ligne (Ligne_Id)
		- 3 : Localisation (Client_Id, Depot_Id)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aSerieLigne;
var aSerieDispo;

var ligneId;
var docType;
var mode;
var isSuiviSerie;
var dispDispo = false;
var tmplAdd;
var tmplDel;



function init() {
	try {
	
		var config = getConfig();
				
		if (!config.isActSerieDLC()) {
			document.getElementById("colDatePeremptionSL").setAttribute("hidden", true);
		}

		mode = window.arguments[0];
		docType = window.arguments[1];
		ligneId = window.arguments[2];
		var depotId = null;
		var clientId = null;

		var tmplGI;					// Infos sur le N Srie
		var tmplSL;					// N Srie rattachs  la ligne
		var tmplSD = null;	// N Srie disponibles

		switch (docType) {
			case "AC":
				clientId = window.arguments[3];
				tmplGI = "Facturation/Avoirs/getInfoLigneACNS.tmpl";
				tmplSL = "Facturation/Avoirs/list-numSerieLigneAC.tmpl";
				tmplSD = "Facturation/Avoirs/list-numSerieDispoAC.tmpl";
				tmplAdd = "Facturation/Avoirs/addNumSerieLigneAC.tmpl";
				tmplDel = "Facturation/Avoirs/deleteNumSerieLigneAC.tmpl";
				break;
			case "AF":
				tmplGI = "Facturation/Avoirs_Fournisseur/getInfoLigneAFNS.tmpl";
				tmplSL = "Facturation/Avoirs_Fournisseur/list-numSerieLigneAF.tmpl";
				tmplAdd = "Facturation/Avoirs_Fournisseur/addNumSerieLigneAF.tmpl";
				tmplDel = "Facturation/Avoirs_Fournisseur/deleteNumSerieLigneAF.tmpl";
				break;
			case "BL":
				depotId = window.arguments[3];
				tmplGI = "Facturation/Affaires/getInfoLigneBLNS.tmpl";
				tmplSL = "Facturation/Affaires/list-numSerieLigneBL.tmpl";
				tmplSD = "Facturation/Affaires/list-numSerieDispoBL.tmpl";
				tmplAdd = "Facturation/Affaires/addNumSerieLigneBL.tmpl";
				tmplDel = "Facturation/Affaires/deleteNumSerieLigneBL.tmpl";
				break;
			case "BLT":
				depotId = window.arguments[3];
				tmplGI = "Facturation/Transferts_Stocks/getInfoLigneBLNS.tmpl";
				tmplSL = "Facturation/Transferts_Stocks/list-numSerieLigneBL.tmpl";
				tmplSD = "Facturation/Transferts_Stocks/list-numSerieDispoBL.tmpl";
				tmplAdd = "Facturation/Transferts_Stocks/addNumSerieLigneBL.tmpl";
				tmplDel = "Facturation/Transferts_Stocks/deleteNumSerieLigneBL.tmpl";
				break;
			case "BLR":
				depotId = window.arguments[3];
				tmplGI = "Facturation/Retours_Fournisseurs/getInfoLigneBLNS.tmpl";
				tmplSL = "Facturation/Retours_Fournisseurs/list-numSerieLigneBL.tmpl";
				tmplSD = "Facturation/Retours_Fournisseurs/list-numSerieDispoBL.tmpl";
				tmplAdd = "Facturation/Retours_Fournisseurs/addNumSerieLigneBL.tmpl";
				tmplDel = "Facturation/Retours_Fournisseurs/deleteNumSerieLigneBL.tmpl";
				break;
			case "BR":
				tmplGI = "Facturation/Commandes/getInfoLigneBRNS.tmpl";
				tmplSL = "Facturation/Commandes/list-numSerieLigneBR.tmpl";
				tmplAdd = "Facturation/Commandes/addNumSerieLigneBR.tmpl";
				tmplDel = "Facturation/Commandes/deleteNumSerieLigneBR.tmpl";
				break;
			case "BRT":
				tmplGI = "Facturation/Transferts_Stocks/getInfoLigneBRNS.tmpl";
				tmplSL = "Facturation/Transferts_Stocks/list-numSerieLigneBR.tmpl";
				tmplSD = "Facturation/Transferts_Stocks/list-numSerieDispoBR.tmpl";
				tmplAdd = "Facturation/Transferts_Stocks/addNumSerieLigneBR.tmpl";
				tmplDel = "Facturation/Transferts_Stocks/deleteNumSerieLigneBR.tmpl";
				break;
			case "BRR":
				tmplGI = "Facturation/Retours_Fournisseurs/getInfoLigneBRNS.tmpl";
				tmplSL = "Facturation/Retours_Fournisseurs/list-numSerieLigneBR.tmpl";
				tmplAdd = "Facturation/Retours_Fournisseurs/addNumSerieLigneBR.tmpl";
				tmplDel = "Facturation/Retours_Fournisseurs/deleteNumSerieLigneBR.tmpl";
				break;
			case "FC":
				depotId = window.arguments[3];
				tmplGI = "Facturation/FacturesVente/getInfoLigneFCNS.tmpl";
				tmplSL = "Facturation/FacturesVente/list-numSerieLigneFC.tmpl";
				tmplSD = "Facturation/FacturesVente/list-numSerieDispoFC.tmpl";
				tmplAdd = "Facturation/FacturesVente/addNumSerieLigneFC.tmpl";
				tmplDel = "Facturation/FacturesVente/deleteNumSerieLigneFC.tmpl";
				break;
			case "FF":
				tmplGI = "Facturation/Factu_Fournisseur/getInfoLigneFFNS.tmpl";
				tmplSL = "Facturation/Factu_Fournisseur/list-numSerieLigneFF.tmpl";
				tmplAdd = "Facturation/Factu_Fournisseur/addNumSerieLigneFF.tmpl";
				tmplDel = "Facturation/Factu_Fournisseur/deleteNumSerieLigneFF.tmpl";
				break;
			case "RC":
				clientId = window.arguments[3];
			case "RCA":
				document.getElementById("boxSaisie").collapsed = true;
				tmplGI = "Facturation/Retours_Clients/getInfoLigneRCNS.tmpl";
				tmplSL = "Facturation/Retours_Clients/list-numSerieLigneRC.tmpl";
				tmplSD = "Facturation/Retours_Clients/list-numSerieDispoRC.tmpl";
				tmplAdd = "Facturation/Retours_Clients/addNumSerieLigneRC.tmpl";
				tmplDel = "Facturation/Retours_Clients/deleteNumSerieLigneRC.tmpl";
				break;
			case "RL":
				tmplGI = "Facturation/Reception/getInfoLigneRLNS.tmpl";
				tmplSL = "Facturation/Reception/list-numSerieLigneRL.tmpl";
				tmplAdd = "Facturation/Reception/addNumSerieLigneRL.tmpl";
				tmplDel = "Facturation/Reception/deleteNumSerieLigneRL.tmpl";
				break;
			case "PE":
				depotId = window.arguments[3];
				tmplGI = "Facturation/Preparation_Expedition/getInfoLignePENS.tmpl";
				tmplSL = "Facturation/Preparation_Expedition/list-numSerieLignePE.tmpl";
				tmplSD = "Facturation/Preparation_Expedition/list-numSerieDispoPE.tmpl";
				tmplAdd = "Facturation/Preparation_Expedition/addNumSerieLignePE.tmpl";
				tmplDel = "Facturation/Preparation_Expedition/deleteNumSerieLignePE.tmpl";
				break;
			case "OF":
				depotId = window.arguments[3];
				tmplGI = "Facturation/Fabrication/getInfoComposantAssemblageNS.tmpl";
				tmplSL = "Facturation/Fabrication/list-numSerieComposantAssemblage.tmpl";
				tmplSD = "Facturation/Fabrication/list-numSerieDispoComposantAssemblage.tmpl";
				tmplAdd = "Facturation/Fabrication/addNumSerieComposantAssemblage.tmpl";
				tmplDel = "Facturation/Fabrication/deleteNumSerieComposantAssemblage.tmpl";
				break;
		}

		if (mode=="S") {
			document.getElementById("titre").value = "AFFECTATION DES N\u00B0 DE SERIE";
			document.getElementById("boxLigne").collapsed = false;

			if (tmplSD!=null && (depotId==null || !isEmpty(depotId))) {
				document.getElementById("boxDispo").collapsed = false;
				dispDispo = true;

				aSerieDispo = new Arbre(tmplSD, "listSerieDispo");
				aSerieDispo.setParam("Ligne_Id", ligneId);

				if (clientId!=null) {
					aSerieDispo.setParam("Client_Id", clientId);
				}

				if (depotId!=null) {
					aSerieDispo.setParam("Depot_Id", depotId);
				}

				aSerieDispo.initTree();
				
				if (!config.isActSerieDLC()) {
					document.getElementById("colDatePeremptionSD").setAttribute("hidden", true);
				}
			}
			
			if (tmplSD==null && config.isActSerieDLC()) {
				document.getElementById("boxDatePeremption").collapsed = false;
			}
		}

		var qGet = new QueryHttp(tmplGI);
		qGet.setParam("Ligne_Id", ligneId);
		var result = qGet.execute();

		isSuiviSerie = result.responseXML.documentElement.getAttribute('Suivi_Serie')=="true";

		if (docType=="FF" || docType=="AF") {
			isSuiviSerie = isSuiviSerie && config.isTracabiliteNSFF();
		}

		document.getElementById("reference").value = result.responseXML.documentElement.getAttribute('Reference');
		document.getElementById("designation").value = result.responseXML.documentElement.getAttribute('Designation');
		document.getElementById("quantite").value = result.responseXML.documentElement.getAttribute('Quantite');

		aSerieLigne = new Arbre(tmplSL, "listSerieLigne");
		aSerieLigne.setParam("Ligne_Id", ligneId);
		aSerieLigne.initTree(checkAddLine);

	}	catch (e) {
	  recup_erreur(e);
	}
}


function pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			addNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDatePeremption(ev) {
	try {

		if (ev.keyCode==13) {
			addNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function addNumSerie(pNumero) {
	try {

		var numero = pNumero==null?document.getElementById('numSerie').value:pNumero;
		var datePeremption = pNumero==null?document.getElementById('datePeremption').value:"";

		if (isEmpty(numero)) {
			showWarning("Veuillez saisir un n\u00B0 de s\u00E9rie");
		}
		else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
			showWarning("Date de p\u00E9remption incorrecte");
		}
		else {
			var qAdd = new QueryHttp(tmplAdd);
			qAdd.setParam("Numero", numero);
			qAdd.setParam("Date_Peremption", datePeremption);
			qAdd.setParam("Ligne_Id", ligneId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('numSerie').value = "";
				document.getElementById('datePeremption').value = "";
				if (dispDispo) {
					aSerieDispo.initTree();
				}
				aSerieLigne.initTree(checkAddLine);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function checkAddLine() {
	try {

		var quantite = document.getElementById('quantite').value;
		var nbLignes = aSerieLigne.nbLignes();
		document.getElementById("nb").value = nbLignes;
		var canAdd = (quantite>nbLignes);

		document.getElementById('numSerie').disabled = !canAdd;
		document.getElementById('datePeremption').disabled = !canAdd;
		document.getElementById('bValider').disabled = !canAdd;
		document.getElementById('bTransferToAffect').disabled = true;
		document.getElementById('bTransferToDispo').disabled = true;
		document.getElementById('bDesaffecter').disabled = true;
		if (!canAdd) {
			document.getElementById('bQuitter').focus();
		}
		else {
			document.getElementById('numSerie').focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transferToAffect() {
	try {

		var nbSelection = aSerieDispo.nbSelection();
		var quantite = document.getElementById('quantite').value;
		var nbLignes = aSerieLigne.nbLignes();

		if (nbLignes+nbSelection>quantite) {
			var restant = quantite - nbLignes;
			showWarning("Vous ne pouvez s\u00E9lectionner au maximum que "+ restant +" n\u00B0 s\u00E9rie");
		}
		else {
			var nonTrans = false;
			var start = new Object();
			var end = new Object();
			var rangeCount = aSerieDispo.getRangeCount();
			var listSerieId = new Array();

			for (var t=0; t<rangeCount; t++) {
				aSerieDispo.getRangeAt(t,start,end);
				for (var v=start.value; v<=end.value; v++) {
					if (aSerieDispo.getCellText(v, "colBloqueSD")=="true" && (docType=="BL" || docType=="FC")) {
						nonTrans = true;
					}
					else {
						listSerieId.push(aSerieDispo.getCellText(v, "colNumeroSD"));
					}
				}
			}

			for (var i=0; i<listSerieId.length; i++){
				addNumSerie(listSerieId[i]);
			}

			if (nonTrans) {
				showWarning("Les n\u00B0 de s\u00E9rie bloqu\u00E9s n'ont pas \u00E9t\u00E9 affect\u00E9s");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transferToDispo() {
	try {

		var start = new Object();
		var end = new Object();
		var rangeCount = aSerieLigne.getRangeCount();
		var listSerieId = new Array();

		for (var t=0; t<rangeCount; t++) {
			aSerieLigne.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				listSerieId.push(aSerieLigne.getCellText(v, "colSerieIdSL"));
			}
		}

		for (var i=0; i<listSerieId.length; i++){
			deleteNumSerie(listSerieId[i]);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function deleteNumSerie(serieId) {
	try {

		var qDelete = new QueryHttp(tmplDel);
		qDelete.setParam("Ligne_Id", ligneId);
		qDelete.setParam("Serie_Id", serieId);
		qDelete.execute();

		if (dispDispo) {
			aSerieDispo.initTree();
		}
		aSerieLigne.initTree(checkAddLine);

	} catch (e) {
		recup_erreur(e);
	}
}


function quit() {
	try {

		if (mode=="S") {
			var nbAffect = aSerieLigne.nbLignes();
			var quantite = document.getElementById('quantite').value;

			if (nbAffect<quantite && isSuiviSerie) {
				if (!window.confirm("La saisie des n\u00B0 de s\u00E9rie est obligatoire sur cet article. Tous les n\u00B0 de s\u00E9rie n'ont pas \u00E9t\u00E9 affect\u00E9s. \nVoulez-vous continuer la saisie ?")) {
					window.close();
				}
			}
			else {
				window.close();
			}
		}
		else {
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function degriserBoutonsTransfert() {
	try {

		if (dispDispo && aSerieDispo.isSelected()) {
			var quantite = document.getElementById('quantite').value;
			var nbAffect = aSerieLigne.nbLignes();
			document.getElementById('bTransferToAffect').disabled = (nbAffect>=quantite);
		}

		if (aSerieLigne.isSelected()) {
			document.getElementById('bTransferToDispo').disabled = false;
			document.getElementById('bDesaffecter').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
