/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Mode d'expdition
		- 2 : Code pays de livraison
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aRelais = new Arbre("Facturation/Fournisseurs/list-pointRelais.tmpl", "listeRelais");
var qListPR = new QueryHttp("Facturation/Fournisseurs/getDataListPR.tmpl");

var pageCourante;
var nbPages;

var fournisseurId;
var codePaysLiv;



function init() {
  try {

		var modeExpId = window.arguments[1];
		codePaysLiv = window.arguments[2];

		var qFour = new QueryHttp("Facturation/Fournisseurs/getTransporteurModeExpedition.tmpl");
		qFour.setParam("Mode_Exp_Id", modeExpId);

		var result = qFour.execute();

		fournisseurId = result.responseXML.documentElement.getAttribute("Fournisseur_Id");

		if (isEmpty(fournisseurId)) {
			showWarning("Le mode d'exp\u00E9dition n'est reli\u00E9 \u00E0 aucun transporteur");
			setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup
		}
		else {
    	document.getElementById('codeRelais').focus();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerRelais();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixRelais();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function choixRelais() {
	try {

		if (aRelais.isSelected()) {

			var actif = aRelais.getSelectedCellText('colActif')=="true";

			if (!actif) {
				showWarning("Impossible de choisir un point relais inactif");
			}
			else {
				var codeRelais = aRelais.getSelectedCellText('colCodeRelais');
				var denomination = aRelais.getSelectedCellText('colDenomination');
				var adresse1 = aRelais.getSelectedCellText('colAdresse1');
				var adresse2 = aRelais.getSelectedCellText('colAdresse2');
				var adresse3 = aRelais.getSelectedCellText('colAdresse3');
				var codePostal = aRelais.getSelectedCellText('colCodePostal');
				var ville = aRelais.getSelectedCellText('colVille');
				var codePays = aRelais.getSelectedCellText('colCodePays');

				window.arguments[0](codeRelais, denomination, adresse1, adresse2, adresse3, codePostal, ville, codePays);
				window.close();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('codeRelais').value = "";
		document.getElementById('denomination').value = "";
		document.getElementById('actif').checked = true;
		document.getElementById('ville').value = "";

		listerRelais();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerRelais() {
	try {

		var codeRelais = document.getElementById('codeRelais').value;
		var denomination = document.getElementById('denomination').value;
		var ville = document.getElementById('ville').value;
		var actif = document.getElementById('actif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeRelais').disabled = true;
		aRelais.deleteTree();

		qListPR.setParam("Code_Relais", codeRelais);
		qListPR.setParam("Denomination", denomination);
		qListPR.setParam("Ville", ville);
		qListPR.setParam("Actif", actif);
		qListPR.setParam("Fournisseur_Id", fournisseurId);
		qListPR.setParam("Code_Pays", codePaysLiv);
		qListPR.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListPR.setParam("Current_Page", pageCourante);

		var result = qListPR.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listRelaisId = contenu.getAttribute("List_Relais_Id");

		aRelais.setParam("List_Relais_Id", listRelaisId);
		aRelais.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeRelais').disabled = true;

		qListPR.setParam("Current_Page", pageCourante);
		var result = qListPR.execute();
		var listRelaisId = result.responseXML.documentElement.getAttribute("List_Relais_Id");

		aRelais.setParam("List_Relais_Id", listRelaisId);
		aRelais.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeRelais').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}
