/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oop_aPrevisions = new Arbre("Facturation/Controle_Achats/list-previsionEcartFacturation.tmpl", "oop-listePrevisions");
var oop_aMotifs = new Arbre("ComboListe/combo-motifsEcartFacturation.tmpl", "oop-motifIdFP");

var oop_qListPEF = new QueryHttp("Facturation/Controle_Achats/getDataListPEF.tmpl");

var oop_pageCourante;
var oop_nbPages;

var oop_currentPrevisionId = "";
var oop_selMotifId = "";



function oop_initOngletPrevisionsEcart() {
	try {

		oop_initCriteres();

	} catch (e) {
		recup_erreur(e);
  }
}


function oop_initCriteres() {
	try {

		document.getElementById('oop-numCommande').value = "";
		document.getElementById('oop-numFournisseur').value = "";
		document.getElementById('oop-etat').value = "T";
		document.getElementById('oop-typeEcart').value = "";
		document.getElementById('oop-dateCommandeDebut').value = "";
		document.getElementById('oop-dateCommandeFin').value = "";

		oop_listerPrevisions();

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_listerPrevisions() {
	try {

		var numCommande = document.getElementById('oop-numCommande').value;
		var numFournisseur = document.getElementById('oop-numFournisseur').value;
		var etat = document.getElementById('oop-etat').value;
		var typeEcart = document.getElementById('oop-typeEcart').value;
		var dateCommandeDebut = document.getElementById('oop-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('oop-dateCommandeFin').value;
		var nbLignesParPage = document.getElementById('oop-nbLignesParPage').value;

		if (!isEmpty(dateCommandeDebut) && !isDate(dateCommandeDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateCommandeFin) && !isDate(dateCommandeFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			oop_pageCourante = 1;
			oop_nbPages = 1;
			document.getElementById('oop-pageDeb').value = 1;
			document.getElementById('oop-pageFin').value = 1;
			document.getElementById('oop-bPrec').disabled = true;
			document.getElementById('oop-bSuiv').disabled = true;

			document.getElementById('oop-listePrevisions').disabled = true;
			document.getElementById('oop-bEditionCsv').disabled = true;
			oop_aPrevisions.deleteTree();

			oop_qListPEF.setParam("Num_Commande", numCommande);
			oop_qListPEF.setParam("Num_Fournisseur", numFournisseur);
			oop_qListPEF.setParam("Etat", etat);
			oop_qListPEF.setParam("Type_Ecart", typeEcart);
			oop_qListPEF.setParam("Date_Commande_Debut", dateCommandeDebut);
			oop_qListPEF.setParam("Date_Commande_Fin", dateCommandeFin);
			oop_qListPEF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oop_qListPEF.setParam("Current_Page", oop_pageCourante);

			var result = oop_qListPEF.execute();

			var contenu = result.responseXML.documentElement;

			oop_nbPages = contenu.getAttribute("Nb_Pages");
			var listPrevisionId = contenu.getAttribute("List_Prevision_Id");

			oop_aPrevisions.setParam("List_Prevision_Id", listPrevisionId);
			oop_aPrevisions.initTree(oop_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_initPagination() {
	try {

		document.getElementById('oop-pageDeb').value = oop_pageCourante;
		document.getElementById('oop-pageFin').value = (oop_nbPages>0?oop_nbPages:1);
		document.getElementById('oop-bPrec').disabled = (oop_pageCourante==1);
		document.getElementById('oop-bSuiv').disabled = (oop_pageCourante>=oop_nbPages); // peut se produire si oop_nbPages=0

		oop_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_pressOnPagePrec() {
	try {

		oop_pageCourante--;
		oop_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_pressOnPageSuiv() {
	try {

		oop_pageCourante++;
		oop_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_majPagination() {
	try {

		document.getElementById('oop-pageDeb').value = oop_pageCourante;
		document.getElementById('oop-bPrec').disabled = (oop_pageCourante==1);
		document.getElementById('oop-bSuiv').disabled = (oop_pageCourante==oop_nbPages);

		document.getElementById('oop-listePrevisions').disabled = true;
		document.getElementById('oop-bEditionCsv').disabled = true;

		oop_qListPEF.setParam("Current_Page", oop_pageCourante);
		var result = oop_qListPEF.execute();
		var listPrevisionId = result.responseXML.documentElement.getAttribute("List_Prevision_Id");

		oop_aPrevisions.setParam("List_Prevision_Id", listPrevisionId);
		oop_aPrevisions.initTree(oop_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_afterMajPagination() {
	try {

		document.getElementById('oop-listePrevisions').disabled = false;
		document.getElementById('oop-bEditionCsv').disabled = (oop_aPrevisions.nbLignes()==0);
		oop_nouveauPrevision();

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_nouveauPrevision() {
	try {

		oop_currentPrevisionId = "";
		document.getElementById("oop-typeEcartFP").value = "";
		document.getElementById("oop-etatFP").value = "";
		oop_chargerMotif("");
		document.getElementById("oop-valeurCommandeFP").value = "";
		document.getElementById("oop-valeurAttendueFP").value = "";
		document.getElementById("oop-commentairesFP").value = "";

		document.getElementById("oop-dateCommandeFP").value = "";
		document.getElementById("oop-numCommandeFP").value = "";
		document.getElementById("oop-numFournisseurFP").value = "";
		document.getElementById("oop-denominationFP").value = "";
		document.getElementById("oop-referenceFP").value = "";
		document.getElementById("oop-refFournisseurFP").value = "";
		document.getElementById("oop-designationFP").value = "";

		document.getElementById("oop-typeEcartFP").disabled = false;
		document.getElementById("oop-valeurAttendueFP").disabled = false;
		document.getElementById("oop-commentairesFP").disabled = false;
		document.getElementById("oop-motifIdFP").disabled = false;

		document.getElementById("oop-groupLigne").collapsed = true;

		document.getElementById("oop-bSupprimer").collapsed = true;
		document.getElementById("oop-bEnregistrer").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_selectOnListePrevisions() {
	try {

		if (oop_aPrevisions.isSelected()) {
			oop_currentPrevisionId = oop_aPrevisions.getSelectedCellText('oop-colPrevisionId');
			oop_chargerPrevision();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_chargerPrevision() {
	try {

		if (!isEmpty(oop_currentPrevisionId)) {
			var qLoad = new QueryHttp("Facturation/Controle_Achats/loadPrevisionEcartFacturation.tmpl");
			qLoad.setParam("Prevision_Id", oop_currentPrevisionId);

			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById("oop-typeEcartFP").value = contenu.getAttribute("Type_Ecart");
				document.getElementById("oop-etatFP").value = contenu.getAttribute("Lib_Etat");
				oop_chargerMotif(contenu.getAttribute("Motif_Id"));
				document.getElementById("oop-valeurCommandeFP").value = contenu.getAttribute("Valeur_Commande");
				document.getElementById("oop-valeurAttendueFP").value = contenu.getAttribute("Valeur_Attendue");
				document.getElementById("oop-commentairesFP").value = contenu.getAttribute("Commentaires");

				document.getElementById("oop-dateCommandeFP").value = contenu.getAttribute("Date_Commande");
				document.getElementById("oop-numCommandeFP").value = contenu.getAttribute("Num_Commande");
				document.getElementById("oop-numFournisseurFP").value = contenu.getAttribute("Num_Fournisseur");
				document.getElementById("oop-denominationFP").value = contenu.getAttribute("Denomination");
				document.getElementById("oop-referenceFP").value = contenu.getAttribute("Reference");
				document.getElementById("oop-refFournisseurFP").value = contenu.getAttribute("Ref_Fournisseur");
				document.getElementById("oop-designationFP").value = contenu.getAttribute("Designation");
				document.getElementById("oop-groupLigne").collapsed = isEmpty(contenu.getAttribute("Reference"));

				var etat = contenu.getAttribute("Etat");

				document.getElementById("oop-typeEcartFP").disabled = true;
				document.getElementById("oop-valeurAttendueFP").disabled = etat!="T";
				document.getElementById("oop-commentairesFP").disabled = etat!="T";
				document.getElementById("oop-motifIdFP").disabled = etat!="T";

				document.getElementById("oop-bSupprimer").collapsed = etat!="T";
				document.getElementById("oop-bEnregistrer").disabled = etat!="T";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oop_listerPrevisions();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oop_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oop_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('oop-numFournisseur').value = numFournisseur;
  	oop_listerPrevisions();

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_chargerMotif(selection) {
	try {

		oop_selMotifId = selection;
		oop_aMotifs.setParam("Selection", oop_selMotifId);
		oop_aMotifs.initTree(oop_initMotifId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_initMotifId() {
  try {

		document.getElementById('oop-motifIdFP').value = oop_selMotifId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oop_enregistrerPrevision() {
  try {

		var typeEcart = document.getElementById("oop-typeEcartFP").value;
		var valeurAttendue = document.getElementById("oop-valeurAttendueFP").value;
		var commentaires = document.getElementById("oop-commentairesFP").value;
		var motifId = document.getElementById("oop-motifIdFP").value;

		if (isEmpty(typeEcart)) {
			showWarning("Veuillez s\u00E9lectionner un type d'\u00E9cart");
		}
		else if (!isPositiveOrNull(valeurAttendue)) {
			showWarning("Valeur attendue incorrecte");
		}
		else if (isEmpty(motifId)) {
			showWarning("Veuillez s\u00E9lectionner un motif");
		}
		else {
			var qSave;

			if (isEmpty(oop_currentPrevisionId)) {
				qSave = new QueryHttp("Facturation/Controle_Achats/createPrevisionEcartFacturation.tmpl");
				qSave.setParam("Type_Ecart", typeEcart);

				var url;

				if (typeEcart.startsWith("C")) {
					url = "chrome://opensi/content/facturation/user/controle_achats/popup-choixCommandeFournisseur.xul";
				}
				else {
					url = "chrome://opensi/content/facturation/user/controle_achats/popup-choixLigneCommandeFournisseur.xul";
				}

				window.openDialog(url,'','chrome,modal,centerscreen', qSave, valeurAttendue);
			}
			else {
				qSave = new QueryHttp("Facturation/Controle_Achats/updatePrevisionEcartFacturation.tmpl");
				qSave.setParam("Prevision_Id", oop_currentPrevisionId);
			}

			qSave.setParam("Valeur_Attendue", valeurAttendue);
			qSave.setParam("Motif_Id", motifId);
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oop_listerPrevisions();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oop_supprimerPrevision() {
  try {

		if (!isEmpty(oop_currentPrevisionId) && window.confirm("Confirmez-vous la suppression de la pr\u00E9vision d'\u00E9cart ?")) {
			var qClose = new QueryHttp("Facturation/Controle_Achats/deletePrevisionEcartFacturation.tmpl");
			qClose.setParam("Prevision_Id", oop_currentPrevisionId);

			var result = qClose.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oop_listerPrevisions();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oop_pressOnEditionCsv() {
	try {

		var numCommande = document.getElementById('oop-numCommande').value;
		var numFournisseur = document.getElementById('oop-numFournisseur').value;
		var etat = document.getElementById('oop-etat').value;
		var typeEcart = document.getElementById('oop-typeEcart').value;
		var dateCommandeDebut = document.getElementById('oop-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('oop-dateCommandeFin').value;

		if (!isEmpty(dateCommandeDebut) && !isDate(dateCommandeDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateCommandeFin) && !isDate(dateCommandeFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Controle_Achats/csvPrevisionEcartFacturation.tmpl");

			qEditionCsv.setParam("Num_Commande", numCommande);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Type_Ecart", typeEcart);
			qEditionCsv.setParam("Date_Commande_Debut", dateCommandeDebut);
			qEditionCsv.setParam("Date_Commande_Fin", dateCommandeFin);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
