/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oee_aLignesEcoPart = new Arbre('Facturation/EcoPart/list-ligneDeclarationEcoPart.tmpl', 'oee-tLignesEcoPart');
var oee_aDetailFactureAvoir = new Arbre('Facturation/EcoPart/list-detailFactureAvoir.tmpl', 'oee-tDetailFactureAvoir');

var oee_declarationId;
var oee_mode;
var oee_etat;
var oee_modified = false;
var oee_typeEcoPart;
var oee_currentIndex = 0;



function oee_init() {
	try {



	} catch (e) {
		recup_erreur(e);
	}
}


function oee_initIHM() {
	try {

		document.getElementById('oee-bEnregistrerEcoPart').collapsed = oee_etat=="A";
		document.getElementById('oee-bSupprimerEcoPart').collapsed = oee_mode!="M";
		document.getElementById('oee-bAnnulerEcoPart').collapsed = oee_mode!="V" || oee_etat=="A";
		document.getElementById('oee-bValiderEcoPart').collapsed = oee_mode!="M";
		document.getElementById('oee-bExportEM').collapsed = oee_mode!="V" || oee_typeEcoPart!="M";

		oee_currentIndex = 0;

		document.getElementById('oee-commentaires').disabled = oee_etat=="A";

		document.getElementById('oee-tLignesEcoPart').disabled = false;
		oee_aDetailFactureAvoir.deleteTree();

		oee_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oee_chargerEcoPart() {
  try {

		document.getElementById('oee-deckEcoPart').selectedIndex = 0;
		document.getElementById('oee-tLignesEcoPart').disabled = true;

		var qLoad = new QueryHttp('Facturation/EcoPart/loadDeclarationEcoPart.tmpl');
		qLoad.setParam("Declaration_Id", oee_declarationId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oee_etat = contenu.getAttribute("Etat");
		oee_mode = (oee_etat=="N"?"M":"V");

		document.getElementById('oee-numero').value = contenu.getAttribute("Numero");
		document.getElementById('oee-typeEcoPart').value = contenu.getAttribute("Libelle_Type_Eco_Part");
		document.getElementById('oee-periodeDebut').value = contenu.getAttribute("Periode_Debut");
		document.getElementById('oee-periodeFin').value = contenu.getAttribute("Periode_Fin");
		document.getElementById('oee-etat').value = contenu.getAttribute("Libelle_Etat");
		document.getElementById('oee-totalHT').value = contenu.getAttribute("Total_HT");
		document.getElementById('oee-commentaires').value = contenu.getAttribute("Commentaires");
		document.getElementById('oee-nbLignes').value = contenu.getAttribute("Nb_Lignes");
		document.getElementById('oee-masseTotale').value = contenu.getAttribute("Masse_Totale");

		document.getElementById('oee-creation').setAttribute("label","D\u00E9claration cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oee-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oee-document').setAttribute("label","D\u00E9claration N\u00B0 "+ contenu.getAttribute('Numero'));

		oee_aLignesEcoPart.setParam('Declaration_Id', oee_declarationId);
		oee_aLignesEcoPart.initTree();

		oee_typeEcoPart = contenu.getAttribute("Type_Eco_Part");

		oee_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oee_enregistrerEcoPart(rafraichir) {
  try {

  	var ok = false;

		var commentaires = document.getElementById('oee-commentaires').value;

		var qSave = new QueryHttp("Facturation/EcoPart/updateDeclarationEcoPart.tmpl");
		qSave.setParam("Declaration_Id", oee_declarationId);
		qSave.setParam("Commentaires", commentaires);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			oee_setModified(false);
			ok = true;
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oee_supprimerEcoPart() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la d\u00E9claration ?")) {

			var qSup = new QueryHttp("Facturation/EcoPart/deleteDeclarationEcoPart.tmpl");
			qSup.setParam("Declaration_Id", oee_declarationId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La d\u00E9claration a \u00E9t\u00E9 supprim\u00E9e.");
				retourMenuEcoPart();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oee_selectOnLignesEcoPart() {
	try {

		if (oee_aLignesEcoPart.isSelected()) {
			oee_aDetailFactureAvoir.setParam("Ligne_Id", oee_aLignesEcoPart.getSelectedCellText("oee-colLigneId"));
			oee_aDetailFactureAvoir.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oee_demandeEnregistrement() {
  try {

		if (oee_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la d\u00E9claration ?")) {
				oee_enregistrerEcoPart(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oee_setModified(m) {
  try {

  	oee_modified = m;
		if (m) {
			document.getElementById('oee-capEcoPart').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oee-bValiderEcoPart').disabled = true;
		}
		else {
			document.getElementById('oee-capEcoPart').setAttribute('image', null);
			document.getElementById('oee-bValiderEcoPart').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oee_validerEcoPart() {
  try {

		if (oee_aLignesEcoPart.nbLignes()==0) {
			showWarning("La d\u00E9claration ne contient aucune ligne.");
		}
  	else if (window.confirm("Confirmez-vous la validation de la d\u00E9claration ?")) {

			var qValider = new QueryHttp("Facturation/EcoPart/validDeclarationEcoPart.tmpl");
			qValider.setParam('Declaration_Id', oee_declarationId);
			var result = qValider.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oee_chargerEcoPart();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oee_annulerEcoPart() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la d\u00E9claration ?")) {
			var qAnnuler = new QueryHttp("Facturation/EcoPart/cancelDeclarationEcoPart.tmpl");
			qAnnuler.setParam('Declaration_Id', oee_declarationId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La d\u00E9claration a \u00E9t\u00E9 annul\u00E9e.");
				oee_chargerEcoPart();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oee_exportCSV() {
	try {

		var qExp = new QueryHttp("Facturation/EcoPart/csvLigneDeclarationEcoPart.tmpl");
		qExp.setParam("Declaration_Id", oee_declarationId);

		var result = qExp.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oee_exportEcoMobilier() {
	try {

		var qExp = new QueryHttp("Facturation/EcoPart/exportEcoMobilier.tmpl");
		qExp.setParam("Declaration_Id", oee_declarationId);

		var result = qExp.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierEcoMobilier');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
