/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ooz_aZones = new Arbre("Facturation/Emplacements/list-zoneStockage.tmpl", "ooz-listeZones");
var ooz_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "ooz-depotId");

var ooz_currentZoneId = "";
var ooz_selDepotId = "";



function ooz_initOngletZones() {
	try {

		ooz_listerZones();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooz_listerZones() {
	try {

		ooz_aZones.setParam("Actif", document.getElementById("ooz-filtreActif").checked);
		ooz_aZones.initTree();
		ooz_nouveauZone();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooz_nouveauZone() {
	try {

		ooz_currentZoneId = "";
		ooz_aZones.clearSelection();

		ooz_chargerDepot("");
		document.getElementById('ooz-intitule').value = "";
		document.getElementById('ooz-typeZone').value = "";
		document.getElementById('ooz-codeZone').value = "";
		document.getElementById('ooz-actif').checked = true;

		document.getElementById('ooz-depotId').disabled = false;
		document.getElementById('ooz-bSupprimer').collapsed = true;
		document.getElementById('ooz-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ooz_chargerZone() {
	try {

		if (ooz_aZones.isSelected()) {
			ooz_currentZoneId = ooz_aZones.getSelectedCellText("ooz-colZoneId");

			var qLoad = new QueryHttp("Facturation/Emplacements/loadZoneStockage.tmpl");
			qLoad.setParam("Zone_Id", ooz_currentZoneId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				ooz_chargerDepot(contenu.getAttribute('Depot_Id'));
				document.getElementById('ooz-intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('ooz-typeZone').value = contenu.getAttribute('Type_Zone');
				document.getElementById('ooz-codeZone').value = contenu.getAttribute('Code_Zone');
				document.getElementById('ooz-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('ooz-depotId').disabled = true;
				document.getElementById('ooz-bSupprimer').collapsed = false;
				document.getElementById('ooz-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooz_enregistrerZone() {
	try {

		var depotId = document.getElementById('ooz-depotId').value;
		var intitule = document.getElementById('ooz-intitule').value;
		var typeZone = document.getElementById('ooz-typeZone').value;
		var codeZone = document.getElementById('ooz-codeZone').value;
		var actif = document.getElementById('ooz-actif').checked;

		if (isEmpty(intitule)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else if (isEmpty(depotId)) {
			showWarning("D\u00E9p\u00F4t manquant");
		}
		else {
			var qSave;

			if (!isEmpty(ooz_currentZoneId)) {
				qSave = new QueryHttp("Facturation/Emplacements/updateZoneStockage.tmpl");
				qSave.setParam("Zone_Id", ooz_currentZoneId);
			}
			else {
				qSave = new QueryHttp("Facturation/Emplacements/createZoneStockage.tmpl");
				qSave.setParam("Depot_Id", depotId);
			}

			qSave.setParam("Intitule", intitule);
			qSave.setParam("Type_Zone", typeZone);
			qSave.setParam("Code_Zone", codeZone);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ooz_listerZones();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooz_supprimerZone() {
	try {

		if (!isEmpty(ooz_currentZoneId) && window.confirm("Confirmez-vous la suppression de la zone s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Facturation/Emplacements/deleteZoneStockage.tmpl");
			qDelete.setParam("Zone_Id", ooz_currentZoneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ooz_listerZones();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooz_chargerDepot(selection) {
	try {

		ooz_selDepotId = selection;
		ooz_aDepots.setParam("Selection", selection);
		ooz_aDepots.initTree(ooz_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooz_initDepot() {
	try {

		document.getElementById('ooz-depotId').value = ooz_selDepotId;

	} catch (e) {
		recup_erreur(e);
	}
}
