/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/calculDocument.js");


var ordreId = "";
var etablissementDefaut;
var depotDefaut;
var gConfig;



function init() {
  try {

		gConfig = getConfig();

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		var result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

  	omof_init();
  	oeof_init();
		document.getElementById('deck').selectedIndex = 0;

		if (!isEmpty(ParamValeur("Ordre_Id"))) {
			ordreId = ParamValeur("Ordre_Id");
			oef_chargerFabrication();
			document.getElementById("bMenuFabrication").collapsed=false;
			document.getElementById("deck").selectedIndex=1;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuOrdreFabrications() {
	try {

		document.getElementById('oeof-pdfOrdreFabricationEtiquettes').setAttribute("src", "");
		document.getElementById('oeof-pdfOrdreFabrication').setAttribute("src", "");
		document.getElementById('omof-pdfOrdres').setAttribute("src", "");
		document.getElementById('omof-deckMenu').selectedIndex = 0;
		oeof_ordreId = 0;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById("oeof-deckOrdreFabrication").selectedIndex = 0;
		document.getElementById('bMenuFabrication').collapsed = true;
		document.getElementById('bRetourOF').collapsed = true;

		document.activeElement.blur();
		omof_listerOrdreFabrications();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourOrdreFabrication() {
  try {

		document.getElementById('oeof-pdfOrdreFabricationEtiquettes').setAttribute("src", "");
		document.getElementById('oeof-pdfOrdreFabrication').setAttribute("src", "");
    document.getElementById('deck').selectedIndex = 1;
		document.getElementById("oeof-deckOrdreFabrication").selectedIndex = 0;
    document.getElementById('bRetourOF').collapsed = true;

    oeof_chargerOF();

  } catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 1: oeof_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
