/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omof_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omof-etablissement');
var omof_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'omof-depot');
var omof_aApercuOrdreFabrication = new Arbre("Facturation/Fabrication/listeApercuOrdreFabrication.tmpl", "omof-apercuOrdreFabrication");
var omof_aOrdresFabrication = new Arbre("Facturation/Fabrication/list-ordreFabrication.tmpl", "omof-listeOrdreFabrications");
var omof_qListOF = new QueryHttp("Facturation/Fabrication/getDataListOF.tmpl");

var omof_pageCourante;
var omof_nbPages;

var omof_defautDepot;



function omof_init() {
  try {

		var specTriCS = gConfig.isSpecTRICS();

		document.getElementById('omof-colCodeStats').collapsed = !specTriCS;
		if (!specTriCS) {
			document.getElementById('omof-colCodeStats').setAttribute("ignoreincolumnpicker", true);
		}

		omof_defautDepot = gConfig.getGDFDefFiltreDepot();

		omof_aEtablissements.initTree(omof_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_initEtablissement() {
	try {

		document.getElementById('omof-etablissement').value = etablissementDefaut;
		omof_aDepots.initTree(omof_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_initDepot() {
	try {

		document.getElementById('omof-depot').value = omof_defautDepot=="0"?depotDefaut:omof_defautDepot;
		omof_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_initCriteres() {
	try {

		document.getElementById('omof-numOrdreFabrication').value = "";
		document.getElementById('omof-refArticle').value = "";
		document.getElementById('omof-composant').value = "";
		document.getElementById('omof-numCommande').value = "";
		document.getElementById('omof-etablissement').value = etablissementDefaut;
		document.getElementById('omof-depot').value = omof_defautDepot=="0"?depotDefaut:omof_defautDepot;
		document.getElementById('omof-etatOrdreFabrication').value = "T";
		document.getElementById('omof-dateOrdreFabricationDebut').value = "";
		document.getElementById('omof-dateOrdreFabricationFin').value = "";
		document.getElementById('omof-commandeUniquement').value = "";

		omof_listerOrdreFabrications();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			omof_listerOrdreFabrications();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_listerOrdreFabrications() {
	try {

		var numeroOF = document.getElementById('omof-numOrdreFabrication').value;
		var refArticle = document.getElementById('omof-refArticle').value;
		var composant = document.getElementById('omof-composant').value;
		var numCommande = document.getElementById('omof-numCommande').value;
		var etablissement = document.getElementById('omof-etablissement').value;
		var depot = document.getElementById('omof-depot').value;
		var etat = document.getElementById('omof-etatOrdreFabrication').value;
		var dateOFDebut = document.getElementById('omof-dateOrdreFabricationDebut').value;
		var dateOFFin = document.getElementById('omof-dateOrdreFabricationFin').value;
		var commandeOnly = document.getElementById('omof-commandeUniquement').checked;
		var nbLignesParPage = document.getElementById('omof-nbLignesParPage').value;

		if (!isEmpty(dateOFDebut) && !isDate(dateOFDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateOFFin) && !isDate(dateOFFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateOFDebut) && !isEmpty(dateOFFin) && !isDateInterval(dateOFDebut, dateOFFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			omof_pageCourante = 1;
			omof_nbPages = 1;
			document.getElementById('omof-pageDeb').value = 1;
			document.getElementById('omof-pageFin').value = 1;
			document.getElementById('omof-bPrec').disabled = true;
			document.getElementById('omof-bSuiv').disabled = true;

			document.getElementById('omof-listeOrdreFabrications').disabled = true;
			document.getElementById('omof-bEditionCsv').disabled = true;
			document.getElementById('omof-bEditerOrdres').disabled = true;
			document.getElementById('omof-numOrdreFabricationSelect').value = "";
			omof_aApercuOrdreFabrication.deleteTree();
			omof_aOrdresFabrication.deleteTree();

			omof_qListOF.setParam("Numero_OF", numeroOF);
			omof_qListOF.setParam("Ref_Article", refArticle);
			omof_qListOF.setParam("Composant", composant);
			omof_qListOF.setParam("Num_Commande", numCommande);
			omof_qListOF.setParam("Etablissement", etablissement);
			omof_qListOF.setParam("Depot_Stock", depot);
			omof_qListOF.setParam("Etat", etat);
			omof_qListOF.setParam("Date_OF_Debut", dateOFDebut);
			omof_qListOF.setParam("Date_OF_Fin", dateOFFin);
			omof_qListOF.setParam("Commande_Only", commandeOnly);
			omof_qListOF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omof_qListOF.setParam("Current_Page", omof_pageCourante);

			var result = omof_qListOF.execute();
			var contenu = result.responseXML.documentElement;

			omof_nbPages = contenu.getAttribute("Nb_Pages");
			var listOrdreId = contenu.getAttribute("List_Ordre_Id");

			omof_aOrdresFabrication.setParam("List_Ordre_Id", listOrdreId);
			omof_aOrdresFabrication.initTree(omof_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_initPagination() {
	try {

		document.getElementById('omof-pageDeb').value = omof_pageCourante;
		document.getElementById('omof-pageFin').value = (omof_nbPages>0?omof_nbPages:1);
		document.getElementById('omof-bPrec').disabled = (omof_pageCourante==1);
		document.getElementById('omof-bSuiv').disabled = (omof_pageCourante>=omof_nbPages); // peut se produire si omof_nbPages=0

		omof_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_pressOnPagePrec() {
	try {

		omof_pageCourante--;
		omof_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_pressOnPageSuiv() {
	try {

		omof_pageCourante++;
		omof_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_majPagination() {
	try {

		document.getElementById('omof-pageDeb').value = omof_pageCourante;
		document.getElementById('omof-bPrec').disabled = (omof_pageCourante==1);
		document.getElementById('omof-bSuiv').disabled = (omof_pageCourante==omof_nbPages);

		document.getElementById('omof-numOrdreFabricationSelect').value = "";

		document.getElementById('omof-listeOrdreFabrications').disabled = true;
		document.getElementById('omof-bEditionCsv').disabled = true;
		document.getElementById('omof-bEditerOrdres').disabled = true;
		omof_aApercuOrdreFabrication.deleteTree();

		omof_qListOF.setParam("Current_Page", omof_pageCourante);
		var result = omof_qListOF.execute();
		var listOrdreId = result.responseXML.documentElement.getAttribute("List_Ordre_Id");

		omof_aOrdresFabrication.setParam("List_Ordre_Id", listOrdreId);
		omof_aOrdresFabrication.initTree(omof_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_afterMajPagination() {
	try {

		document.getElementById('omof-listeOrdreFabrications').disabled = false;
		document.getElementById('omof-bEditionCsv').disabled = (omof_aOrdresFabrication.nbLignes()==0);
		document.getElementById('omof-bEditerOrdres').disabled = (omof_aOrdresFabrication.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_selectOnListeOrdreFabrications() {
	try {

		if (omof_aOrdresFabrication.isSelected()) {
			var ordreId = omof_aOrdresFabrication.getSelectedCellText("omof-colOrdreId");
			document.getElementById('omof-numOrdreFabricationSelect').value = "Aper\u00E7u de la nomenclature de l'ordre N\u00B0 "+ omof_aOrdresFabrication.getSelectedCellText("omof-colNumOrdreFabrication") +" :";
			omof_aApercuOrdreFabrication.setParam("Ordre_Id", ordreId);
			omof_aApercuOrdreFabrication.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_pressOnNouvelOrdreFabrication() {
	try {

		document.getElementById("bMenuFabrication").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		oeof_nouvelleFabrication();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_pressOnListeOrdreFabrications(ev) {
	try {

		if (ev.keyCode==13) {
			omof_ouvrirOrdreFabrication();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_ouvrirOrdreFabrication() {
  try {

		if (omof_aOrdresFabrication.isSelected()) {
			oeof_ordreId = omof_aOrdresFabrication.getSelectedCellText("omof-colOrdreId");
			oeof_chargerOF();
			document.getElementById("bMenuFabrication").collapsed = false;
			document.getElementById("deck").selectedIndex = 1;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omof_pressOnEditionCsv() {
	try {

		var numeroOF = document.getElementById('omof-numOrdreFabrication').value;
		var refArticle = document.getElementById('omof-refArticle').value;
		var composant = document.getElementById('omof-composant').value;
		var numCommande = document.getElementById('omof-numCommande').value;
		var etablissement = document.getElementById('omof-etablissement').value;
		var depot = document.getElementById('omof-depot').value;
		var etat = document.getElementById('omof-etatOrdreFabrication').value;
		var dateOFDebut = document.getElementById('omof-dateOrdreFabricationDebut').value;
		var dateOFFin = document.getElementById('omof-dateOrdreFabricationFin').value;
		var commandeOnly = document.getElementById('omof-commandeUniquement').checked;

		if (!isEmpty(dateOFDebut) && !isDate(dateOFDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateOFFin) && !isDate(dateOFFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateOFDebut) && !isEmpty(dateOFFin) && !isDateInterval(dateOFDebut, dateOFFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			var qEditionCsv = new QueryHttp("Facturation/Fabrication/csvOrdreFabrication.tmpl");

			qEditionCsv.setParam("Numero_OF", numeroOF);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Composant", composant);
			qEditionCsv.setParam("Num_Commande", numCommande);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Depot_Stock", depot);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_OF_Debut", dateOFDebut);
			qEditionCsv.setParam("Date_OF_Fin", dateOFFin);
			qEditionCsv.setParam("Commande_Only", commandeOnly);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_pressOnEditerOrdres() {
	try {

		var numeroOF = document.getElementById('omof-numOrdreFabrication').value;
		var refArticle = document.getElementById('omof-refArticle').value;
		var composant = document.getElementById('omof-composant').value;
		var numCommande = document.getElementById('omof-numCommande').value;
		var etablissement = document.getElementById('omof-etablissement').value;
		var depot = document.getElementById('omof-depot').value;
		var etat = document.getElementById('omof-etatOrdreFabrication').value;
		var dateOFDebut = document.getElementById('omof-dateOrdreFabricationDebut').value;
		var dateOFFin = document.getElementById('omof-dateOrdreFabricationFin').value;
		var commandeOnly = document.getElementById('omof-commandeUniquement').checked;

		if (!isEmpty(dateOFDebut) && !isDate(dateOFDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateOFFin) && !isDate(dateOFFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateOFDebut) && !isEmpty(dateOFFin) && !isDateInterval(dateOFDebut, dateOFFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			document.getElementById('omof-pdfOrdres').setAttribute("src", "");

			var qEditionPdf = new QueryHttp("Facturation/Fabrication/pdfEditionOrdresFabrication.tmpl");

			qEditionPdf.setParam("Numero_OF", numeroOF);
			qEditionPdf.setParam("Ref_Article", refArticle);
			qEditionPdf.setParam("Composant", composant);
			qEditionPdf.setParam("Num_Commande", numCommande);
			qEditionPdf.setParam("Etablissement", etablissement);
			qEditionPdf.setParam("Depot_Stock", depot);
			qEditionPdf.setParam("Etat", etat);
			qEditionPdf.setParam("Date_OF_Debut", dateOFDebut);
			qEditionPdf.setParam("Date_OF_Fin", dateOFFin);
			qEditionPdf.setParam("Commande_Only", commandeOnly);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('omof-deckMenu').selectedIndex = 1;
				document.getElementById('bMenuFabrication').collapsed = false;
				document.getElementById('omof-pdfOrdres').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/fabrication/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function omof_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omof_retourRechercherArticle, null, null, null, null, null, true);

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omof-refArticle').value = reference;
  	omof_listerOrdreFabrications();

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_rechercherComposant() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omof_retourRechercherComposant, null, null, null, true);

	} catch (e) {
		recup_erreur(e);
	}
}


function omof_retourRechercherComposant(reference, articleId) {
	try {

  	document.getElementById('omof-composant').value = reference;
  	omof_listerOrdreFabrications();

	} catch (e) {
		recup_erreur(e);
	}
}
