/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aAffaires = new Arbre("Facturation/Factu_Auto/list-affairesFacturables.tmpl", "listeAffaires");
var aCommandes = new Arbre("Facturation/Factu_Auto/list-commandesFacturables.tmpl", "listeCommandes");
var aApercuCommande = new Arbre("Facturation/Affaires/liste-apercuCommande.tmpl", "apercuCommande");
var aApercuAffaire = new Arbre("Facturation/Affaires/liste-apercuAffaire.tmpl", "apercuAffaire");
var aHistorique = new Arbre('Facturation/Factu_Auto/combo-historiqueFacturationLot.tmpl', 'timeEdition');


var modeTraitement;



function init() {
  try {

		var config = getConfig();

		document.getElementById('modeTraitement').value = config.getModeTraitement();

		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourFacturation').collapsed = true;

		var web = config.isECommerce();
		document.getElementById('itemClientsWeb').collapsed = !web;
		document.getElementById('bcProvenance').collapsed = !web;

		if (web) {
			var aProvenance = new Arbre("ComboListe/combo-sitesWeb.tmpl", "provenance");
			aProvenance.initTree();

			document.getElementById('miProvenanceHL').collapsed = !getProfil().isProvenanceHL();
		}

		var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "responsable");
		aResponsables.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "poleActivite");
		aPolesActivite.initTree();

		aHistorique.initTree();

		pressOnModeTraitement();

  } catch (e) {
  	recup_erreur(e);
  }
}


function pressOnFactAvantLiv() {
	try {

		document.getElementById('boxStatutExpedition').collapsed = document.getElementById('factAvantLiv').value=="true";

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnModeTraitement() {
	try {

		modeTraitement = document.getElementById('modeTraitement').value;

		document.getElementById('listeCommandes').collapsed = (modeTraitement=="A");
		document.getElementById('listeAffaires').collapsed = (modeTraitement=="C");
		document.getElementById('boxApercuCommande').collapsed = (modeTraitement=="A");
		document.getElementById('boxApercuAffaire').collapsed = (modeTraitement=="C");
		document.getElementById('bcModeAffaire').collapsed = (modeTraitement=="A");

		document.getElementById('lblFiltreDate').value = (modeTraitement=="C"?"Date de commande :":"Date d'affaire :");

		initCriteres();

	} catch (e) {
  	recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('modeFacturation').value = "";
		document.getElementById('factAvantLiv').value = "";
		document.getElementById('modeEnvoiFacture').value = "";
		document.getElementById('dateDebut').value = "";
		document.getElementById('dateFin').value = "";
		document.getElementById('origineClient').value = "";
		document.getElementById('numClient').value = "";
		document.getElementById('provenance').value = "";
		document.getElementById('statutExpedition').value = "C";
		document.getElementById('No_Fact_LF_NC').checked = true;
		document.getElementById('poleActivite').value = "";
		document.getElementById('etatPaiement').value = "";
		document.getElementById('responsable').value = "";
		document.getElementById('bloque').value = "";

		pressOnFactAvantLiv();
		listerFactuAuto();

	} catch (e) {
  	recup_erreur(e);
  }
}


function listerFactuAuto() {
	try {

		var modeFacturation = document.getElementById('modeFacturation').value;
		if (modeFacturation=="B") {
			document.getElementById('factAvantLiv').value = "false";
			document.getElementById('factAvantLiv').disabled = true;
		}
		else {
			document.getElementById('factAvantLiv').disabled = false;
		}

		var factAvantLiv = document.getElementById('factAvantLiv').value;
		var modeEnvoiFacture = document.getElementById('modeEnvoiFacture').value;
		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var origineClient = document.getElementById('origineClient').value;
		var numClient = document.getElementById('numClient').value;
		var provenance = document.getElementById('provenance').value;
		var statutExpedition = document.getElementById('statutExpedition').value;
		var noFactLFNC = document.getElementById('No_Fact_LF_NC').checked;
		var poleActivite = document.getElementById('poleActivite').value;
		var etatPaiement = document.getElementById('etatPaiement').value;
		var responsable = document.getElementById('responsable').value;
		var bloque = document.getElementById('bloque').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			document.getElementById('totalHT').value = "";
			document.getElementById('numCommandeSelect').value = "";
			document.getElementById('numAffaireSelect').value = "";
			aApercuCommande.deleteTree();
			aApercuAffaire.deleteTree();

			if (modeTraitement=="C") {
				aCommandes.setParam("Mode_Facturation", modeFacturation);
				aCommandes.setParam("Fact_Avant_Liv", factAvantLiv);
				aCommandes.setParam("Mode_Envoi_Facture", modeEnvoiFacture);
				aCommandes.setParam("Date_Commande_Debut", dateDebut);
				aCommandes.setParam("Date_Commande_Fin", dateFin);
				aCommandes.setParam("Origine_Client", origineClient);
				aCommandes.setParam("Num_Client", numClient);
				aCommandes.setParam("Provenance", provenance);
				aCommandes.setParam("Statut_Expedition", statutExpedition);
				aCommandes.setParam("No_Fact_LF_NC", noFactLFNC);
				aCommandes.setParam("Pole_Activite", poleActivite);
				aCommandes.setParam("Etat_Paiement", etatPaiement);
				aCommandes.setParam("Responsable", responsable);
				aCommandes.setParam("Bloque", bloque);
				aCommandes.initTree(calculerTotalHT);
			}
			else {
				aAffaires.setParam("Mode_Facturation", modeFacturation);
				aAffaires.setParam("Fact_Avant_Liv", factAvantLiv);
				aAffaires.setParam("Mode_Envoi_Facture", modeEnvoiFacture);
				aAffaires.setParam("Date_Affaire_Debut", dateDebut);
				aAffaires.setParam("Date_Affaire_Fin", dateFin);
				aAffaires.setParam("Origine_Client", origineClient);
				aAffaires.setParam("Num_Client", numClient);
				aAffaires.setParam("Provenance", provenance);
				aAffaires.setParam("Statut_Expedition", statutExpedition);
				aAffaires.setParam("No_Fact_LF_NC", noFactLFNC);
				aAffaires.setParam("Pole_Activite", poleActivite);
				aAffaires.setParam("Responsable", responsable);
				aAffaires.initTree(calculerTotalHT);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function calculerTotalHT() {
	try {

		var total = 0;

		if (modeTraitement=="C") {
			for (var i=0; i<aCommandes.nbLignes(); i++) {
				if (aCommandes.getCellValue(i, "colSelectTC")=="true") {
					total += parseFloat(aCommandes.getCellValue(i, "colTotalHTTC"));
				}
  		}
		}
		else {
			for (var i=0; i<aAffaires.nbLignes(); i++) {
				if (aAffaires.getCellValue(i, "colSelectTA")=="true") {
					total += parseFloat(aAffaires.getCellValue(i, "colTotalHTTA"));
				}
  		}
		}

		var nf = new NumberFormat("0.00", true);
		document.getElementById('totalHT').value = nf.format(total);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnAffaires(ev) {
	try {

		if (ev.keyCode==32 && aAffaires.isSelected()) {
			aAffaires.setSelectedCellValue("colSelectTA", aAffaires.getSelectedCellValue("colSelectTA")=="false");
			calculerTotalHT();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCommandes(ev) {
	try {

		if (ev.keyCode==32 && aCommandes.isSelected()) {
			aCommandes.setSelectedCellValue("colSelectTC", aCommandes.getSelectedCellValue("colSelectTC")=="false");
			calculerTotalHT();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCommandes() {
	try {

		if (aCommandes.isSelected()) {
			var commandeId = aCommandes.getSelectedCellText('colCommandeIdTC');
			document.getElementById('numCommandeSelect').value = aCommandes.getSelectedCellText('colNumCommandeTC');
			aApercuCommande.setParam("Commande_Id", commandeId);
			aApercuCommande.initTree();

			var editionTTC = (aCommandes.getSelectedCellText("colEditionTTCTC")=="true");
			document.getElementById('acColMontant').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeAffaires() {
	try {

		if (aAffaires.isSelected()) {
			var affaireId = aAffaires.getSelectedCellText('colAffaireIdTA');
			document.getElementById('numAffaireSelect').value = aAffaires.getSelectedCellText('colNumAffaireTA');
			aApercuAffaire.setParam("Affaire_Id", affaireId);
			aApercuAffaire.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		if (modeTraitement=="C") {
			for (var i=0; i<aCommandes.nbLignes(); i++) {
				if (aCommandes.isEditable(i, "colSelectTC")) {
					aCommandes.setCellValue(i, "colSelectTC", b);
  			}
			}
		}
		else {
			for (var i=0; i<aAffaires.nbLignes(); i++) {
				if (aAffaires.isEditable(i, "colSelectTA")) {
					aAffaires.setCellValue(i, "colSelectTA", b);
  			}
			}
		}

		calculerTotalHT();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			listerFactuAuto();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function genererFactures() {
  try {

		document.getElementById('bGenerer').disabled = true;

		var nbCoche = 0;
		var listAffaireId = "";
		var listCommandeId = "";

		if (modeTraitement=="C") {
			for (var i=0; i<aCommandes.nbLignes(); i++) {
				if (aCommandes.getCellValue(i, "colSelectTC")=="true") {
					nbCoche++;
					listCommandeId += aCommandes.getCellText(i, "colCommandeIdTC") +",";
				}
  		}
		}
		else {
			for (var i=0; i<aAffaires.nbLignes(); i++) {
				if (aAffaires.getCellValue(i, "colSelectTA")=="true") {
					nbCoche++;
					listAffaireId += aAffaires.getCellText(i, "colAffaireIdTA") +",";
				}
  		}
		}

		if (nbCoche==0) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration des factures des lignes s\u00E9lectionn\u00E9es ?")) {
			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourFacturation').collapsed = false;

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			var statutExpedition = document.getElementById('statutExpedition').value;
			var noFactLFNC = document.getElementById('No_Fact_LF_NC').checked;

			var qGenerate = new QueryHttp("Facturation/Factu_Auto/generateFacturation.tmpl");
			qGenerate.setParam("List_Affaire_Id", listAffaireId);
			qGenerate.setParam("List_Commande_Id", listCommandeId);
			qGenerate.setParam("Statut_Expedition", statutExpedition);
			qGenerate.setParam("No_Fact_LF_NC", noFactLFNC);

			qGenerate.execute(genererFactures_2);
		}

		document.getElementById('bGenerer').disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function genererFactures_2(result) {
  try {

		var facturationId = result.responseXML.documentElement.getAttribute('Facturation_Id');
		editerFactures(facturationId, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function editerFactures(facturationId, firstEdition) {
  try {

		document.getElementById('pdf').setAttribute("src", "");

		if (!firstEdition) {
  		document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourFacturation').collapsed = false;
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
		}

		var qEdit = new QueryHttp("Facturation/Factu_Auto/editFacturationLot.tmpl");
		qEdit.setParam("Facturation_Id", facturationId);
		qEdit.setParam("First_Edition", firstEdition);
		qEdit.execute(editerFactures_2);

  } catch (e) {
    recup_erreur(e);
  }
}


function editerFactures_2(result) {
  try {

		var editionOk = false;

		if (result.responseXML.documentElement.getAttribute('Exist_Edition')=="true") {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

			document.getElementById('pdf').setAttribute("src", page);
			editionOk = true;
		}

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

		if (!editionOk) { retourFacturation(); }

  } catch (e) {
    recup_erreur(e);
  }
}


function reediter() {
  try {

		var timeEdition = document.getElementById('timeEdition').value;

		if (isEmpty(timeEdition)) {
			showWarning("Veuillez choisir une r\u00E9\u00E9dition !");
		}
		else {
			editerFactures(timeEdition, false);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherClient(numClient) {
	try {

  	document.getElementById('numClient').value = numClient;
  	listerFactuAuto();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourFacturation() {
  try {

		document.getElementById('pdf').setAttribute("src", "");
    document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourFacturation').collapsed = true;
		aHistorique.initTree();
		listerFactuAuto();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
