/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omf_aFactures = new Arbre('Facturation/Factu_Fournisseur/list-factureFournisseur.tmpl', 'omf-listeFactures');
var omf_aApercuFacture = new Arbre('Facturation/Factu_Fournisseur/list-apercuFactureFournisseur.tmpl', 'omf-apercu');
var omf_aApercuAvoir = new Arbre('Facturation/Factu_Fournisseur/list-apercuAvoirFournisseur.tmpl', 'omf-apercu');
var omf_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "omf-poleActivite");
var omf_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omf-etablissement');
var omf_aModesReglements = new Arbre("ComboListe/combo-modesReglement.tmpl","omf-modeReglement");
var omf_qListFF = new QueryHttp("Facturation/Factu_Fournisseur/getDataListFF.tmpl");

var omf_pageCourante;
var omf_nbPages;



function omf_init() {
  try {

  	omf_aModesReglements.initTree(omf_initModeReglement);

		if (!gConfig.isSpecLHCFF()) {
			document.getElementById('omf-colNumDemande').collapsed = true;
			document.getElementById('omf-colNumDemande').setAttribute("ignoreincolumnpicker", true);
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function omf_initModeReglement() {
	try {

		document.getElementById('omf-modeReglement').selectedIndex = 0;
		omf_aPolesActivite.initTree(omf_initSecteurActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_initSecteurActivite() {
	try {

		document.getElementById('omf-poleActivite').selectedIndex = 0;
		omf_aEtablissements.setParam('Selection', etablissementDefaut);
		omf_aEtablissements.initTree(omf_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_initEtablissement() {
	try {

		document.getElementById('omf-etablissement').value = etablissementDefaut;
		omf_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_initCriteres() {
	try {

		document.getElementById('omf-numFacture').value = "";
		document.getElementById('omf-numFournisseur').value = "";
		document.getElementById('omf-denomination').value = "";
		document.getElementById('omf-etat').value = "N";
		document.getElementById('omf-dateDebut').value = "";
		document.getElementById('omf-dateFin').value = "";
		document.getElementById('omf-refArticle').value = "";
		document.getElementById('omf-montantTTC').value = "";
		document.getElementById('omf-numCommande').value = "";
		document.getElementById('omf-etablissement').value = etablissementDefaut;
		document.getElementById('omf-statutPaiement').selectedIndex = 0;
		document.getElementById('omf-modeReglement').selectedIndex = 0;
		document.getElementById('omf-poleActivite').selectedIndex = 0;
		document.getElementById('omf-typeDocument').selectedIndex = 0;

		omf_listerFactures();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_listerFactures() {
	try {

		var numFacture = document.getElementById('omf-numFacture').value;
		var numFournisseur = document.getElementById('omf-numFournisseur').value;
		var denomination = document.getElementById('omf-denomination').value;
		var etat = document.getElementById('omf-etat').value;
		var dateDebut = document.getElementById('omf-dateDebut').value;
		var dateFin = document.getElementById('omf-dateFin').value;
		var refArticle = document.getElementById('omf-refArticle').value;
		var statutPaiement = document.getElementById('omf-statutPaiement').value;
		var modeReglement = document.getElementById('omf-modeReglement').value;
		var poleActivite = document.getElementById('omf-poleActivite').value;
		var etablissement = document.getElementById('omf-etablissement').value;
		var montantTTC = document.getElementById('omf-montantTTC').value;
		var numCommande = document.getElementById('omf-numCommande').value;
		var typeDocument = document.getElementById('omf-typeDocument').value;
		var nbLignesParPage = document.getElementById('omf-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(montantTTC) && !isPositiveOrNull(montantTTC)) { showWarning("Montant TTC incorrect !"); }
		else {

			omf_pageCourante = 1;
			omf_nbPages = 1;
			document.getElementById('omf-pageDeb').value = 1;
			document.getElementById('omf-pageFin').value = 1;
			document.getElementById('omf-bPrec').disabled = true;
			document.getElementById('omf-bSuiv').disabled = true;

			document.getElementById('omf-listeFactures').disabled = true;
			document.getElementById('omf-bEditionCsv').disabled = true;
			document.getElementById('omf-bEditionDetailCsv').disabled = true;
			document.getElementById('omf-bEditerFactures').disabled = true;
			document.getElementById('omf-numFactureSelect').value = "";
			omf_aApercuFacture.deleteTree();
			omf_aFactures.deleteTree();

			omf_qListFF.setParam("Num_Facture", numFacture);
			omf_qListFF.setParam("Num_Commande", numCommande);
			omf_qListFF.setParam("Num_Fournisseur", numFournisseur);
			omf_qListFF.setParam("Denomination", denomination);
			omf_qListFF.setParam("Etat", etat);
			omf_qListFF.setParam("Date_Debut", dateDebut);
			omf_qListFF.setParam("Date_Fin", dateFin);
			omf_qListFF.setParam("Ref_Article", refArticle);
			omf_qListFF.setParam("Statut_Paiement", statutPaiement);
			omf_qListFF.setParam("Type_Doc", typeDocument);
			omf_qListFF.setParam("Mode_Reglement", modeReglement);
			omf_qListFF.setParam("Pole_Activite", poleActivite);
			omf_qListFF.setParam("Etablissement", etablissement);
			omf_qListFF.setParam("Montant_TTC", montantTTC);
			omf_qListFF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omf_qListFF.setParam("Current_Page", omf_pageCourante);

			var result = omf_qListFF.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('omf-totalHT').value = contenu.getAttribute("Total_HT");
			omf_nbPages = contenu.getAttribute("Nb_Pages");
			var listFactureId = contenu.getAttribute("List_Facture_Id");
			var listAvoirId = contenu.getAttribute("List_Avoir_Id");

			omf_aFactures.setParam("List_Facture_Id", listFactureId);
			omf_aFactures.setParam("List_Avoir_Id", listAvoirId);
			omf_aFactures.initTree(omf_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_initPagination() {
	try {

		document.getElementById('omf-pageDeb').value = omf_pageCourante;
		document.getElementById('omf-pageFin').value = (omf_nbPages>0?omf_nbPages:1);
		document.getElementById('omf-bPrec').disabled = (omf_pageCourante==1);
		document.getElementById('omf-bSuiv').disabled = (omf_pageCourante>=omf_nbPages); // peut se produire si omf_nbPages=0

		document.getElementById('omf-listeFactures').disabled = false;
		document.getElementById('omf-bEditionCsv').disabled=(omf_aFactures.nbLignes()==0);
		document.getElementById('omf-bEditionDetailCsv').disabled=(omf_aFactures.nbLignes()==0);
		document.getElementById('omf-bEditerFactures').disabled=(omf_aFactures.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnPagePrec() {
	try {

		omf_pageCourante--;
		omf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnPageSuiv() {
	try {

		omf_pageCourante++;
		omf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_majPagination() {
	try {

		document.getElementById('omf-pageDeb').value = omf_pageCourante;
		document.getElementById('omf-bPrec').disabled = (omf_pageCourante==1);
		document.getElementById('omf-bSuiv').disabled = (omf_pageCourante==omf_nbPages);

		document.getElementById('omf-numFactureSelect').value = "";

		document.getElementById('omf-listeFactures').disabled = true;
		document.getElementById('omf-bEditionCsv').disabled = true;
		document.getElementById('omf-bEditionDetailCsv').disabled = true;
		document.getElementById('omf-bEditerFactures').disabled = true;
		omf_aApercuFacture.deleteTree();

		omf_qListFF.setParam("Current_Page", omf_pageCourante);
		var result = omf_qListFF.execute();
		var listFactureId = result.responseXML.documentElement.getAttribute("List_Facture_Id");
		var listAvoirId = result.responseXML.documentElement.getAttribute("List_Avoir_Id");

		omf_aFactures.setParam("List_Facture_Id", listFactureId);
		omf_aFactures.setParam("List_Avoir_Id", listAvoirId);
		omf_aFactures.initTree(omf_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_afterMajPagination() {
	try {

		document.getElementById('omf-listeFactures').disabled = false;
		document.getElementById('omf-bEditionCsv').disabled = (omf_aFactures.nbLignes()==0);
		document.getElementById('omf-bEditionDetailCsv').disabled = (omf_aFactures.nbLignes()==0);
		document.getElementById('omf-bEditerFactures').disabled = (omf_aFactures.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_selectOnListeFactures() {
	try {

		if (omf_aFactures.isSelected()) {
			var documentId = omf_aFactures.getSelectedCellText('omf-colFactureId');
			var typeDoc = omf_aFactures.getSelectedCellText('omf-colTypeDoc');
			document.getElementById('omf-numFactureSelect').value = omf_aFactures.getSelectedCellText('omf-colNumFacture');

			if (typeDoc=="FF") {
				omf_aApercuFacture.setParam("Facture_Id", documentId);
				omf_aApercuFacture.initTree();
			}
			else {
				omf_aApercuAvoir.setParam("Avoir_Id", documentId);
				omf_aApercuAvoir.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnNouvelleFacture() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuFactures').collapsed = false;
		oef_nouvelleFacture();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnNouvelAvoir() {
	try {

		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('bMenuFactures').collapsed = false;
		oea_nouvelAvoir();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omf_listerFactures();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omf_pressOnListeFactures(ev) {
  try {

		if (ev.keyCode==13) {
			omf_ouvrirFacture();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omf_ouvrirFacture() {
  try {

  	if (omf_aFactures.isSelected()) {
	  	var typeDoc = omf_aFactures.getSelectedCellText('omf-colTypeDoc');
	  	if (typeDoc=="FF") {
				oef_factureId = omf_aFactures.getSelectedCellText('omf-colFactureId');
				oef_chargerFacture();
				document.getElementById('deck').selectedIndex = 1;
	  	}
			else {
	  		oea_avoirId = omf_aFactures.getSelectedCellText('omf-colFactureId');
				oea_chargerAvoir();
				document.getElementById('deck').selectedIndex = 2;
	  	}
			document.getElementById('bMenuFactures').collapsed = false;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omf_pressOnEditionCsv(detail) {
	try {

		var numFacture = document.getElementById('omf-numFacture').value;
		var numFournisseur = document.getElementById('omf-numFournisseur').value;
		var denomination = document.getElementById('omf-denomination').value;
		var etat = document.getElementById('omf-etat').value;
		var dateDebut = document.getElementById('omf-dateDebut').value;
		var dateFin = document.getElementById('omf-dateFin').value;
		var refArticle = document.getElementById('omf-refArticle').value;
		var statutPaiement = document.getElementById('omf-statutPaiement').value;
		var modeReglement = document.getElementById('omf-modeReglement').value;
		var poleActivite = document.getElementById('omf-poleActivite').value;
		var etablissement = document.getElementById('omf-etablissement').value;
		var montantTTC = document.getElementById('omf-montantTTC').value;
		var numCommande = document.getElementById('omf-numCommande').value;
		var typeDocument = document.getElementById('omf-typeDocument').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(montantTTC) && !isPositive(montantTTC)) { showWarning("Montant TTC incorrect !"); }
		else {
			var qEditionCsv = new QueryHttp("Facturation/Factu_Fournisseur/"+ (detail?"csvDetailFactureFournisseur.tmpl":"csvFactureFournisseur.tmpl"));

			qEditionCsv.setParam("Num_Facture", numFacture);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Statut_Paiement", statutPaiement);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Pole_Activite", poleActivite);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Montant_TTC", montantTTC);
			qEditionCsv.setParam("Num_Commande", numCommande);
			qEditionCsv.setParam("Type_Doc", typeDocument);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnEditerFactures() {
	try {

		var numFacture = document.getElementById('omf-numFacture').value;
		var numFournisseur = document.getElementById('omf-numFournisseur').value;
		var denomination = document.getElementById('omf-denomination').value;
		var etat = document.getElementById('omf-etat').value;
		var dateDebut = document.getElementById('omf-dateDebut').value;
		var dateFin = document.getElementById('omf-dateFin').value;
		var refArticle = document.getElementById('omf-refArticle').value;
		var statutPaiement = document.getElementById('omf-statutPaiement').value;
		var modeReglement = document.getElementById('omf-modeReglement').value;
		var poleActivite = document.getElementById('omf-poleActivite').value;
		var etablissement = document.getElementById('omf-etablissement').value;
		var montantTTC = document.getElementById('omf-montantTTC').value;
		var numCommande = document.getElementById('omf-numCommande').value;
		var typeDocument = document.getElementById('omf-typeDocument').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(montantTTC) && !isPositive(montantTTC)) { showWarning("Montant TTC incorrect !"); }
		else {
			document.getElementById('omf-pdfFactures').setAttribute("src", "");

			var qGenPdf = new QueryHttp("Facturation/Factu_Fournisseur/pdfEditionFactures.tmpl");

			qGenPdf.setParam("Num_Facture", numFacture);
			qGenPdf.setParam("Num_Fournisseur", numFournisseur);
			qGenPdf.setParam("Denomination", denomination);
			qGenPdf.setParam("Etat", etat);
			qGenPdf.setParam("Date_Debut", dateDebut);
			qGenPdf.setParam("Date_Fin", dateFin);
			qGenPdf.setParam("Ref_Article", refArticle);
			qGenPdf.setParam("Statut_Paiement", statutPaiement);
			qGenPdf.setParam("Mode_Reglement", modeReglement);
			qGenPdf.setParam("Pole_Activite", poleActivite);
			qGenPdf.setParam("Etablissement", etablissement);
			qGenPdf.setParam("Montant_TTC", montantTTC);
			qGenPdf.setParam("Num_Commande", numCommande);
			qGenPdf.setParam("Type_Doc", typeDocument);

			var result = qGenPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('omf-deckMenu').selectedIndex = 1;
				document.getElementById('bMenuFactures').collapsed = false;
				document.getElementById('omf-pdfFactures').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omf_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('omf-numFournisseur').value = numFournisseur;
  	omf_listerFactures();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omf_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omf-refArticle').value = reference;
  	omf_listerFactures();

	} catch (e) {
		recup_erreur(e);
	}
}
