/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");

var factureId;
var nf2 = new NumberFormat("0.00", true);
var aAcomptesNonImputes = new Arbre("Facturation/Factu_Fournisseur/list-acomptesNonImputes.tmpl", "listeAcomptesNonImputes");
var aAcomptesImputes = new Arbre("Facturation/Factu_Fournisseur/list-acompteFournisseur.tmpl", "listeAcomptesImputes");


function init() {
	try {

		factureId = window.arguments[0];
		aAcomptesNonImputes.setParam("Facture_Id", factureId);
		aAcomptesImputes.setParam("Facture_Id", factureId);

		reinitialiser();

	} catch (e) {
  	recup_erreur(e);
  }
}


function reinitialiser() {
	try {
		document.getElementById('montantEntree').value = "";
		document.getElementById('montantSortie').value = "";
		document.getElementById('acompteTotal').value = "";

		document.getElementById('listeAcomptesNonImputes').disabled = true;
		document.getElementById('listeAcomptesImputes').disabled = true;
		document.getElementById('montantEntree').disabled = true;
		document.getElementById('montantSortie').disabled = true;
		document.getElementById('bAjouter').disabled = true;
		document.getElementById('bEnlever').disabled = true;
		document.getElementById('bQuitter').disabled = true;

		aAcomptesNonImputes.initTree(reinitialiser2);
	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser2() {
	try {
		aAcomptesImputes.initTree(reinitialiser3);
	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser3() {
	try {
		var montantTotal = 0;
		var nbLignes = aAcomptesImputes.nbLignes();
		for (var i=0; i<nbLignes; i++) {
			montantTotal += parseFloat(aAcomptesImputes.getCellText(i, 'colMontantSortie'));
		}
		document.getElementById('acompteTotal').value = nf2.format(montantTotal);

		document.getElementById('listeAcomptesNonImputes').disabled = false;
		document.getElementById('listeAcomptesImputes').disabled = false;
		document.getElementById('bQuitter').disabled = false;
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnAcomptesNonImputes() {
	try {
		if (aAcomptesImputes.isSelected()) {
			aAcomptesImputes.clearSelection();
			document.getElementById('montantSortie').value = "";
			document.getElementById('montantSortie').disabled = true;
			document.getElementById('bEnlever').disabled = true;
		}
		if (aAcomptesNonImputes.isSelected()) {
			var i = aAcomptesNonImputes.getCurrentIndex();
			document.getElementById('montantEntree').value = aAcomptesNonImputes.getCellText(i, 'colMontantEntree');
			document.getElementById('montantEntree').disabled = false;
			document.getElementById('bAjouter').disabled = false;
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnAcomptesImputes() {
	try {
		if (aAcomptesNonImputes.isSelected()) {
			aAcomptesNonImputes.clearSelection();
			document.getElementById('montantEntree').value = "";
			document.getElementById('montantEntree').disabled = true;
			document.getElementById('bAjouter').disabled = true;
		}
		if (aAcomptesImputes.isSelected()) {
			var i = aAcomptesImputes.getCurrentIndex();
			document.getElementById('montantSortie').value = aAcomptesImputes.getCellText(i, 'colMontantSortie');
			document.getElementById('montantSortie').disabled = false;
			document.getElementById('bEnlever').disabled = false;
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnAjouter() {
	try {
		if (aAcomptesNonImputes.isSelected()) {
			var i = aAcomptesNonImputes.getCurrentIndex();
			var montantMax = parseFloat(aAcomptesNonImputes.getCellText(i, 'colMontantEntree'));
			var montant = document.getElementById('montantEntree').value;
			if (isEmpty(montant) || !isPositive(montant)) { showWarning("Le montant est incorrect !"); }
			else if (montant>montantMax) { showWarning("Veuillez saisir un montant inf\u00E9rieur ou \u00E9gal au montant restant \u00E0 imputer."); }
			else {
				var acompteId = aAcomptesNonImputes.getCellText(i, 'colAcompteIdEntree');
				var qAjouter = new QueryHttp("Facturation/Factu_Fournisseur/ajouterImputationAcompte.tmpl");
				qAjouter.setParam("Facture_Id", factureId);
				qAjouter.setParam("Acompte_Id", acompteId);
				qAjouter.setParam("Montant", montant);
		  	qAjouter.execute();
				reinitialiser();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnEnlever() {
	try {
		if (aAcomptesImputes.isSelected()) {
			var i = aAcomptesImputes.getCurrentIndex();
			var montantMax = parseFloat(aAcomptesImputes.getCellText(i, 'colMontantSortie'));
			var montant = document.getElementById('montantSortie').value;
			if (isEmpty(montant) || !isPositive(montant)) { showWarning("Le montant est incorrect !"); }
			else if (montant>montantMax) { showWarning("Veuillez saisir un montant inf\u00E9rieur ou \u00E9gal au montant imput\u00E9."); }
			else {
				var acompteId = aAcomptesImputes.getCellText(i, 'colAcompteIdSortie');
				var qEnlever = new QueryHttp("Facturation/Factu_Fournisseur/enleverImputationAcompte.tmpl");
				qEnlever.setParam("Facture_Id", factureId);
				qEnlever.setParam("Acompte_Id", acompteId);
				qEnlever.setParam("Montant", montant);
				qEnlever.execute();
				reinitialiser();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function quitter() {
	try {
		var qCheckImputation = new QueryHttp("Facturation/Factu_Fournisseur/checkImputationsAcomptes.tmpl");
  	qCheckImputation.setParam("Facture_Id", factureId);
  	var result = qCheckImputation.execute();
  	var errors = new Errors(result);

		if (errors.hasNext()) { errors.show(); }
		else { window.close(); }
	} catch (e) {
  	recup_erreur(e);
  }
}

