/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/calculDocument.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");


var etablissementDefaut;
var gProfil;
var gConfig;
var gAccesCoutAchat;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gProfil = getProfil();
		gConfig = getConfig();
		gAccesCoutAchat = gProfil.isAccesCoutAchat();

		etablissementDefaut = gProfil.getEtabId();

  	document.getElementById('deck').selectedIndex = 0;
  	omf_init();
		oef_init();
  	oea_init();

		if (!isEmpty(ParamValeur("Facture_Id"))) {
			oef_factureId = ParamValeur("Facture_Id");
			oef_chargerFacture();
			document.getElementById("bMenuFactures").collapsed = false;
			document.getElementById("deck").selectedIndex = 1;
		}
		else if (!isEmpty(ParamValeur("Avoir_Id"))) {
			oea_avoirId = ParamValeur("Avoir_Id");
			oea_chargerAvoir();
			document.getElementById("bMenuFactures").collapsed = false;
			document.getElementById("deck").selectedIndex = 2;
		}

		document.getElementById('bcAccesCoutAchat').collapsed = !gAccesCoutAchat;

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oef_pressOnWindow(ev);
		}
		else if (currentDeck==2) {
			oea_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuFactures() {
	try {

		document.getElementById('oef-pdfFacture').setAttribute("src", "");
		document.getElementById('oea-pdfAvoir').setAttribute("src", "");
		document.getElementById('omf-pdfFactures').setAttribute("src", "");
		document.getElementById('omf-deckMenu').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuFactures').collapsed = true;
		document.getElementById('bRetourFacture').collapsed = true;
		document.getElementById('bRetourAvoir').collapsed = true;

		document.activeElement.blur();
		omf_listerFactures();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourFacture() {
  try {

		document.getElementById('oef-pdfFacture').setAttribute("src", "");
		oef_chargerFacture();
		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('bRetourFacture').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourAvoir() {
  try {

		document.getElementById('oea-pdfAvoir').setAttribute("src", "");
		oea_chargerAvoir();
		document.getElementById('oea-deckAvoir').selectedIndex = 0;
		document.getElementById('bRetourAvoir').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 1: oef_demandeEnregistrement(); break;
			case 2: oea_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
