/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oos_aStatistiques = new Arbre('Facturation/Fournisseurs/list-statistiqueFournisseur.tmpl', 'oos-listeStatistiques');
var oos_qListSF = new QueryHttp("Facturation/Fournisseurs/getDataListSF.tmpl");

var oos_pageCourante;
var oos_nbPages;



function oos_initOngletStatistiques() {
  try {

		oos_enableCriteres();
		oos_changeVue();
		oos_aStatistiques.deleteTree();

		var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'oos-marque');
		aMarques.setParam("Search_Mode", true);
		aMarques.initTree();

  } catch (e) {
  	recup_erreur(e);
  }
}


function oos_enableCriteres() {
	try {

		var periode = document.getElementById('oos-periode').value;

		document.getElementById("oos-dateDebut").disabled = periode!="DD";
		document.getElementById("oos-dateFin").disabled = periode!="DD";
		document.getElementById('oos-nbMois').disabled = periode!="DM";

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_changeVue() {
	try {

		var vue = document.getElementById('oos-vue').value;

		if (vue=="A") {
			document.getElementById('oos-colDateDocument').collapsed = true;
			document.getElementById('oos-colNumDocument').collapsed = true;
			document.getElementById('oos-colDateDocument').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oos-colNumDocument').setAttribute("ignoreincolumnpicker", true);
		}
		else {
			document.getElementById('oos-colDateDocument').collapsed = false;
			document.getElementById('oos-colNumDocument').collapsed = false;
			document.getElementById('oos-colDateDocument').removeAttribute("ignoreincolumnpicker");
			document.getElementById('oos-colNumDocument').removeAttribute("ignoreincolumnpicker");
		}

		if (vue=="D") {
			document.getElementById('oos-colReference').collapsed = true;
			document.getElementById('oos-colDesignation').collapsed = true;
			document.getElementById('oos-colQuantite').collapsed = true;
			document.getElementById('oos-colReference').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oos-colDesignation').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oos-colQuantite').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oos-rowQteTotale').collapsed = true;
			document.getElementById('oos-rowMarque').collapsed = true;
		}
		else {
			document.getElementById('oos-colReference').collapsed = false;
			document.getElementById('oos-colDesignation').collapsed = false;
			document.getElementById('oos-colQuantite').collapsed = false;
			document.getElementById('oos-colReference').removeAttribute("ignoreincolumnpicker");
			document.getElementById('oos-colDesignation').removeAttribute("ignoreincolumnpicker");
			document.getElementById('oos-colQuantite').removeAttribute("ignoreincolumnpicker");
			document.getElementById('oos-rowQteTotale').collapsed = false;
			document.getElementById('oos-rowMarque').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_initCriteres() {
	try {

		document.getElementById('oos-type').value = "F";
		document.getElementById('oos-vue').value = "A";
		document.getElementById('oos-periode').value = "MC";
		document.getElementById('oos-dateDebut').value = "";
		document.getElementById('oos-dateFin').value = "";
		document.getElementById('oos-nbMois').value = "12";
		document.getElementById('oos-marque').value = "";

		oos_enableCriteres();
		oos_changeVue();
		oos_listerStatistiques();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_listerStatistiques() {
	try {

		var typeStatistique = document.getElementById('oos-type').value;
		var vue = document.getElementById('oos-vue').value;
		var periode = document.getElementById('oos-periode').value;
		var dateDebut = document.getElementById('oos-dateDebut').value;
		var dateFin = document.getElementById('oos-dateFin').value;
		var nbMois = document.getElementById('oos-nbMois').value;
		var marque = document.getElementById('oos-marque').value;
		var nbLignesParPage = document.getElementById('oos-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (periode=="DM" && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {

			oos_pageCourante = 1;
			oos_nbPages = 1;
			document.getElementById('oos-pageDeb').value = 1;
			document.getElementById('oos-pageFin').value = 1;
			document.getElementById('oos-bPrec').disabled = true;
			document.getElementById('oos-bSuiv').disabled = true;

			document.getElementById('oos-listeStatistiques').disabled = true;
			document.getElementById('oos-bEditionCsv').disabled = true;
			oos_aStatistiques.deleteTree();

			oos_qListSF.setParam("Fournisseur_Id", off_fournisseurId);
			oos_qListSF.setParam("Type_Statistique", typeStatistique);
			oos_qListSF.setParam("Vue", vue);
			oos_qListSF.setParam("Periode", periode);
			oos_qListSF.setParam("Date_Debut", dateDebut);
			oos_qListSF.setParam("Date_Fin", dateFin);
			oos_qListSF.setParam("Nb_Mois", nbMois);
			oos_qListSF.setParam("Marque", marque);
			oos_qListSF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oos_qListSF.setParam("Current_Page", oos_pageCourante);

			var result = oos_qListSF.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('oos-totalHT').value = contenu.getAttribute("Total_HT");
			document.getElementById('oos-qteTotale').value = contenu.getAttribute("Qte_Totale");
			oos_nbPages = contenu.getAttribute("Nb_Pages");

			oos_aStatistiques.setParam("List_Item_Id", contenu.getAttribute("List_Item_Id"));
			oos_aStatistiques.setParam("List_Avoir_Item_Id", contenu.getAttribute("List_Avoir_Item_Id"));
			oos_aStatistiques.setParam("List_Comp_Id", contenu.getAttribute("List_Comp_Id"));
			oos_aStatistiques.setParam("List_Avoir_Comp_Id", contenu.getAttribute("List_Avoir_Comp_Id"));
			oos_aStatistiques.setParam("Type_Statistique", typeStatistique);
			oos_aStatistiques.setParam("Vue", vue);
			oos_aStatistiques.initTree(oos_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_initPagination() {
	try {

		document.getElementById('oos-pageDeb').value = oos_pageCourante;
		document.getElementById('oos-pageFin').value = (oos_nbPages>0?oos_nbPages:1);
		document.getElementById('oos-bPrec').disabled = (oos_pageCourante==1);
		document.getElementById('oos-bSuiv').disabled = (oos_pageCourante>=oos_nbPages); // peut se produire si oos_nbPages=0

		oos_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_pressOnPagePrec() {
	try {

		oos_pageCourante--;
		oos_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_pressOnPageSuiv() {
	try {

		oos_pageCourante++;
		oos_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_majPagination() {
	try {

		document.getElementById('oos-pageDeb').value = oos_pageCourante;
		document.getElementById('oos-bPrec').disabled = (oos_pageCourante==1);
		document.getElementById('oos-bSuiv').disabled = (oos_pageCourante==oos_nbPages);

		document.getElementById('oos-listeStatistiques').disabled = true;
		document.getElementById('oos-bEditionCsv').disabled = true;

		oos_qListSF.setParam("Current_Page", oos_pageCourante);
		var result = oos_qListSF.execute();
		var contenu = result.responseXML.documentElement;

		oos_aStatistiques.setParam("List_Item_Id", contenu.getAttribute("List_Item_Id"));
		oos_aStatistiques.setParam("List_Avoir_Item_Id", contenu.getAttribute("List_Avoir_Item_Id"));
		oos_aStatistiques.setParam("List_Comp_Id", contenu.getAttribute("List_Comp_Id"));
		oos_aStatistiques.setParam("List_Avoir_Comp_Id", contenu.getAttribute("List_Avoir_Comp_Id"));
		oos_aStatistiques.initTree(oos_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_afterMajPagination() {
	try {

		document.getElementById('oos-listeStatistiques').disabled = false;
		document.getElementById('oos-bEditionCsv').disabled = (oos_aStatistiques.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oos_listerStatistiques();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oos_pressOnEditionCsv() {
	try {

		var typeStatistique = document.getElementById('oos-type').value;
		var vue = document.getElementById('oos-vue').value;
		var periode = document.getElementById('oos-periode').value;
		var dateDebut = document.getElementById('oos-dateDebut').value;
		var dateFin = document.getElementById('oos-dateFin').value;
		var nbMois = document.getElementById('oos-nbMois').value;
		var marque = document.getElementById('oos-marque').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (periode=="DM" && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Fournisseurs/csvStatistiqueFournisseur.tmpl");

			qEditionCsv.setParam("Fournisseur_Id", off_fournisseurId);
			qEditionCsv.setParam("Type_Statistique", typeStatistique);
			qEditionCsv.setParam("Vue", vue);
			qEditionCsv.setParam("Periode", periode);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Nb_Mois", nbMois);
			qEditionCsv.setParam("Marque", marque);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
