/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var fournisseurId;



function init() {
  try {

  	window.resizeTo(380,200);
  	fournisseurId = ParamValeur("Fournisseur_Id");

		document.getElementById('lblAncienNumeroCompte').value = ParamValeur("Num_Compte");
		document.getElementById('lblFournisseurId').value = ParamValeur("Num_Fournisseur");

  } catch (e) {
    recup_erreur(e);
  }
}


function rechcompte() {
	try {

    var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte, "", "F", "FOURNISSEUR", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById('numeroCompte').value = numCompte;

	} catch (e) {
	  recup_erreur(e);
	}
}


function enregistrer() {
	try {

		var numCompte = document.getElementById('numeroCompte').value;

		if (isEmpty(numCompte)) {
			showWarning("Veuillez choisir un num\u00E9ro de compte");
		}
		else if (window.confirm("Voulez-vous modifier le num\u00E9ro de compte ?")) {
			var qSet = new QueryHttp("Facturation/Fournisseurs/setNumeroCompte.tmpl");
			qSet.setParam("Fournisseur_Id", fournisseurId);
			qSet.setParam("Num_Compte", numCompte);
			qSet.execute();

			window.arguments[0]();
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}

