/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var suiviLoaded = false;
var profil = getProfil();
var clotureFactAuto = false;


function init() {
  try {

		document.getElementById('tabSuivi').collapsed = !profil.isDirection();

		var config = getConfig();

		var tarification_client = config.getModeTarif()=="G";
		var suivi_serie = config.isActSuiviSerie();
		var suivi_lot = config.isActSuiviLot();
		var accesRetourSav = config.isSpecAGMRS();
		clotureFactAuto = config.getModeClotureFact()=="A";

		document.getElementById('accessRetouSav').collapsed = !accesRetourSav;

		document.getElementById('TClients').collapsed = !profil.isMenuGC_TClients();
		document.getElementById('TFournisseurs').collapsed = !profil.isMenuGC_TFournisseurs();
		document.getElementById('TCommerciaux').collapsed = !profil.isMenuGC_TCommerciaux();
		document.getElementById('VDevis').collapsed = !profil.isMenuGC_VDevis();
		document.getElementById('VAffaires').collapsed = !profil.isMenuGC_VAffaires();
		document.getElementById('VRetours').collapsed = !profil.isMenuGC_VRetours() || accesRetourSav;
		document.getElementById('VFactures').collapsed = !profil.isMenuGC_VFactures();
		document.getElementById('VFactuAuto').collapsed = !profil.isMenuGC_VFactuAuto();
		document.getElementById('VEnvoiFact').collapsed = !profil.isMenuGC_VEnvoiFact();
		document.getElementById('VAbonnements').collapsed = !profil.isMenuGC_VAbonnements();
		document.getElementById('EExpesCC').collapsed = !profil.isMenuGC_EExpesCC();
		document.getElementById('EExpesTS').collapsed = !profil.isMenuGC_EExpesTS();
		document.getElementById('EPrepaExpes').collapsed = !profil.isMenuGC_EPrepaExpes();
		document.getElementById('EExpCrossDock').collapsed = !profil.isMenuGC_EExpCrossDock() || !config.isActCrossDock();
		document.getElementById('ESuiviLog').collapsed = !profil.isMenuGC_ESuiviLog();
		document.getElementById('ESuiviTrans').collapsed = !profil.isMenuGC_ESuiviTrans();
		document.getElementById('ACommandes').collapsed = !profil.isMenuGC_ACommandes();
		document.getElementById('APrepaCom').collapsed = !profil.isMenuGC_APrepaCom();
		document.getElementById('ARecepCom').collapsed = !profil.isMenuGC_ARecepCom();
		document.getElementById('ARetours').collapsed = !profil.isMenuGC_ARetours();
		document.getElementById('AFactures').collapsed = !profil.isMenuGC_AFactures();
		document.getElementById('AControle').collapsed = !profil.isMenuGC_AControle() || !config.isSpecLHCFF();
		document.getElementById('SArticles').collapsed = !profil.isMenuGC_SArticles();
		document.getElementById('STarifs').collapsed = !profil.isMenuGC_STarifs() || !tarification_client;
		document.getElementById('SFabrication').collapsed = !profil.isMenuGC_SFabrication();
		document.getElementById('SInventaire').collapsed = !profil.isMenuGC_SInventaire();
		document.getElementById('STracabilite').collapsed = !profil.isMenuGC_STracabilite() || (!suivi_serie && !suivi_lot);
		document.getElementById('STransferts').collapsed = !profil.isMenuGC_STransferts();
		document.getElementById('SIOStocks').collapsed = !profil.isMenuGC_SIOStocks();
		document.getElementById('SParamStocks').collapsed = !profil.isMenuGC_SParamStocks();
		document.getElementById('SMouvements').collapsed = !profil.isMenuGC_SMouvements();
		document.getElementById('SEmplacements').collapsed = !profil.isMenuGC_SEmplacements() || !config.isActEmplacements();
		document.getElementById('STransEmp').collapsed = !profil.isMenuGC_STransEmp() || !config.isActEmplacements();
		document.getElementById('DRegFour').collapsed = !profil.isMenuGC_DRegFour();
		document.getElementById('DRegCli').collapsed = !profil.isMenuGC_DRegCli();
		document.getElementById('DRemises').collapsed = !profil.isMenuGC_DRemises();
		document.getElementById('DEditions').collapsed = !profil.isMenuGC_DEditions();
		document.getElementById('DTabBord').collapsed = !profil.isMenuGC_DTabBord();
		document.getElementById('DTransCpta').collapsed = !profil.isMenuGC_DTransCpta();
		document.getElementById('DExportIdep').collapsed = !profil.isMenuGC_DExportIdep();
		document.getElementById('DDeclEcoPart').collapsed = !profil.isMenuGC_DDeclEcoPart();
		document.getElementById('DImpExpCsv').collapsed = !profil.isMenuGC_DImpExpCsv();
		document.getElementById('DPassword').collapsed = !profil.isMenuGC_DPassword();

		document.getElementById('bouton_tiers').collapsed = document.getElementById('TClients').collapsed && document.getElementById('TFournisseurs').collapsed && document.getElementById('TCommerciaux').collapsed;

		document.getElementById('bouton_ventes').collapsed = document.getElementById('VDevis').collapsed && document.getElementById('VAffaires').collapsed && document.getElementById('VFactures').collapsed
																													&& document.getElementById('VFactuAuto').collapsed && document.getElementById('VEnvoiFact').collapsed && document.getElementById('VAbonnements').collapsed
																													&& document.getElementById('VRetours').collapsed;

		document.getElementById('bouton_expeditions').collapsed = document.getElementById('EExpesCC').collapsed && document.getElementById('EExpesTS').collapsed && document.getElementById('EPrepaExpes').collapsed
																													&& document.getElementById('EExpCrossDock').collapsed && document.getElementById('ESuiviLog').collapsed && document.getElementById('ESuiviTrans').collapsed;

		document.getElementById('bouton_achats').collapsed = document.getElementById('ACommandes').collapsed && document.getElementById('APrepaCom').collapsed && document.getElementById('ARecepCom').collapsed
																													&& document.getElementById('ARetours').collapsed && document.getElementById('AFactures').collapsed && document.getElementById('AControle').collapsed;

		document.getElementById('bouton_articles').collapsed = document.getElementById('SArticles').collapsed && document.getElementById('STarifs').collapsed && document.getElementById('SFabrication').collapsed
																													&& document.getElementById('STracabilite').collapsed;

		document.getElementById('bouton_stock').collapsed = document.getElementById('SInventaire').collapsed && document.getElementById('STransferts').collapsed && document.getElementById('SIOStocks').collapsed
																													&& document.getElementById('SMouvements').collapsed && document.getElementById('SParamStocks').collapsed
																													&& document.getElementById('SEmplacements').collapsed && document.getElementById('STransEmp').collapsed;

		document.getElementById('bouton_opdiv').collapsed = document.getElementById('DRegFour').collapsed && document.getElementById('DRegCli').collapsed && document.getElementById('DRemises').collapsed
																													&& document.getElementById('DEditions').collapsed && document.getElementById('DTabBord').collapsed && document.getElementById('DTransCpta').collapsed
																													&& document.getElementById('DExportIdep').collapsed && document.getElementById('DImpExpCsv').collapsed && document.getElementById('DPassword').collapsed
																													&& document.getElementById('DDeclEcoPart').collapsed;

		initAlertes();

		document.getElementById('news').setAttribute("src", "https://connect.opensi.fr/actus-frame");

	} catch (e) {
    recup_erreur(e);
  }
}


function initAlertes() {
	try {

		var queryAlertes = new QueryHttp("Facturation/Alertes/checkAlertes.tmpl");
		queryAlertes.execute(initAlertesFin);

	} catch (e) {
    recup_erreur(e);
  }
}


function initAlertesFin(result) {
	try {

		var alerte = false;
		var info = false;

		var contenu = result.responseXML.documentElement;

		if (profil.isMenuGC_SArticles()) {
			var nbArtNC8 = parseIntBis(contenu.getAttribute('Nb_ArtNC8'));
			if (nbArtNC8>0) {
				alerte = true;
				document.getElementById('lblArtNC8').value = "Il y a "+ nbArtNC8 +" "+ (nbArtNC8==1?"article":"articles") +" en commande \u00E0 l'export sans code douanier ou pays d'origine";
				document.getElementById('boxArtNC8').collapsed = false;

				var aArtNC8 = new Arbre("Facturation/Alertes/list-articlesSansNC8PaysOrigine.tmpl", "listArtNC8");
				aArtNC8.initTree();
			}
		}

		if (profil.isMenuGC_SIOStocks()) {
			var nbArtStkNeg = parseIntBis(contenu.getAttribute('Nb_ArtStkNeg'));
			if (nbArtStkNeg>0) {
				alerte = true;
				document.getElementById('lblArtStkNeg').value = "Il y a "+ nbArtStkNeg +" "+ (nbArtStkNeg==1?"article":"articles") +" avec un stock r\u00E9el n\u00E9gatif";
				document.getElementById('boxArtStkNeg').collapsed = false;

				var aArtStkNeg = new Arbre("Facturation/Alertes/list-articlesStockNegatif.tmpl", "listArtStkNeg");
				aArtStkNeg.initTree();
			}
		}

		if (profil.isMenuGC_SInventaire()) {
			var nbInvOuv = parseIntBis(contenu.getAttribute('Nb_InvOuv'));
			if (nbInvOuv>0) {
				alerte = true;
				document.getElementById('lblInvOuv').value = "Il y a "+ nbInvOuv +" "+ (nbInvOuv==1?"inventaire":"inventaires") +" ouverts depuis plus de 1 jour";
				document.getElementById('boxInvOuv').collapsed = false;

				var aInvOuv = new Arbre("Facturation/Alertes/list-inventairesOuverts.tmpl", "listInvOuv");
				aInvOuv.initTree();
			}
		}

		if (profil.isMenuGC_VAffaires()) {
			var nbFactures = parseIntBis(contenu.getAttribute('Nb_NonGenFC'));
			if (nbFactures>0) {
				alerte = true;
				document.getElementById('lblNbFactures').value = "Il y a "+ nbFactures +" "+ (nbFactures==1?"facture":"factures") +" \u00E0 l'\u00E9tat non g\u00E9n\u00E9r\u00E9 depuis plus de 1 jour dans les affaires :";
				document.getElementById('boxAffaireFact').collapsed = false;

				var aListeAffairesFact = new Arbre("Facturation/Alertes/list-facturesNonGenerees.tmpl", "numAffairesFact");
				aListeAffairesFact.initTree();
			}

			var nbAvoirs = parseIntBis(contenu.getAttribute('Nb_NonGenAC'));
			if (nbAvoirs>0) {
				alerte = true;
				document.getElementById('lblNbAvoirs').value = "Il y a "+ nbAvoirs +" "+ (nbAvoirs==1?"avoir":"avoirs") +" \u00E0 l'\u00E9tat non g\u00E9n\u00E9r\u00E9 depuis plus de 1 jour dans les affaires :";
				document.getElementById('boxAffaireAvoir').collapsed = false;

				var aListeAffairesAvoir = new Arbre("Facturation/Alertes/list-avoirsNonGeneres.tmpl", "numAffairesAvoir");
				aListeAffairesAvoir.initTree();
			}

			var nbBL = parseIntBis(contenu.getAttribute('Nb_NonGenBL'));
			if (nbBL>0) {
				alerte = true;
				document.getElementById('lblNbBL').value = "Il y a "+ nbBL +" BL \u00E0 l'\u00E9tat non g\u00E9n\u00E9r\u00E9 depuis plus de 1 jour dans les affaires :";
				document.getElementById('boxAffaireBL').collapsed = false;

				var aListeAffairesBL = new Arbre("Facturation/Alertes/list-bonsLivraisonNonGeneres.tmpl", "numAffairesBL");
				aListeAffairesBL.initTree();
			}

			var nbCdes = parseIntBis(contenu.getAttribute('Nb_CdesClot'));
			if (nbCdes>0) {
				alerte = true;
				document.getElementById('lblNbCdesClot').value = "Il y a "+ nbCdes +" commandes client cl\u00F4turables depuis plus de 1 jour dans les affaires :";
				document.getElementById('boxCdesClot').collapsed = false;

				var aListeCdesClot = new Arbre("Facturation/Alertes/list-commandesCloturables.tmpl", "numCommandesClot");
				aListeCdesClot.initTree();
			}

			var nbRC = parseIntBis(contenu.getAttribute('Nb_NonGenRC'));
			if (nbRC>0) {
				alerte = true;
				document.getElementById('lblNbRC').value = "Il y a "+ nbRC +" retours client \u00E0 l'\u00E9tat non g\u00E9n\u00E9r\u00E9 depuis plus de 1 jour dans les affaires :";
				document.getElementById('boxAffaireRC').collapsed = false;

				var aListeAffairesRC = new Arbre("Facturation/Alertes/list-retoursClientNonGeneres.tmpl", "numAffairesRC");
				aListeAffairesRC.initTree();
			}

			var nbRCW = parseIntBis(contenu.getAttribute('Nb_RWAValid'));
			if (nbRCW>0) {
				alerte = true;
				document.getElementById('lblNbRWAValid').value = "Il y a "+ nbRCW +" retours client web \u00E0 traiter :";
				document.getElementById('boxRetoursWAValid').collapsed = false;

				var aListeRetoursWAValid = new Arbre("Facturation/Alertes/list-retoursWebAValider.tmpl", "numRetoursWAValid");
				aListeRetoursWAValid.initTree();
			}

			var nbRCARecep = parseIntBis(contenu.getAttribute('Nb_RCARecep'));
			if (nbRCARecep>0) {
				document.getElementById('lblNbRCARecep').value = "Il y a "+ nbRCARecep +" retours client en attente de r\u00E9ception :";
				document.getElementById('boxRetoursARecep').collapsed = false;

				var aListeRetoursARecep = new Arbre("Facturation/Alertes/list-retoursAReceptionner.tmpl", "numRetoursARecep");
				aListeRetoursARecep.initTree();
			}
		}

		if (profil.isMenuGC_VAbonnements()) {
			var nbFactures = parseIntBis(contenu.getAttribute('Nb_FactAEmet'));
			if (nbFactures>0) {
				alerte = true;
				document.getElementById('lblNbFactAEmettre').value = "Il y a " + nbFactures + " "+ (nbFactures==1?"facture":"factures") +" \u00E0 \u00E9mettre dans les abonnements.";
				document.getElementById('boxAbonnement').collapsed = false;
			}
		}

		if (profil.isMenuGC_SFabrication()) {
			var nbCreerOF = parseIntBis(contenu.getAttribute('Nb_CreerOF'));
			if (nbCreerOF>0) {
				info = true;
				document.getElementById('lblFabrications').value = "Il y a " + nbCreerOF + " "+ (nbCreerOF==1?"ordre de fabrication":"ordres de fabrication") +" \u00E0 cr\u00E9er";
				document.getElementById('boxFabrications').collapsed = false;
			}

			var nbLancerOF = parseIntBis(contenu.getAttribute('Nb_LancerOF'));
			if (nbLancerOF>0) {
				info = true;
				document.getElementById('lblFabricationsValides').value = "Il y a " + nbLancerOF + " "+ (nbLancerOF==1?"ordre de fabrication valid\u00E9":"ordres de fabrication valid\u00E9s") +" \u00E0 lancer";
				document.getElementById('boxFabricationsValides').collapsed = false;
			}
		}

		if (profil.isMenuGC_DRegCli()) {
			var nbRelAGen = parseIntBis(contenu.getAttribute('Nb_RelAGen'));
    	if (nbRelAGen>0) {
				info = true;
      	document.getElementById('lblRelances').value = nbRelAGen +" "+ (nbRelAGen==1?"relance client":"relances clients") +" \u00E0 g\u00E9n\u00E9rer...";
      	document.getElementById('boxRelances').collapsed = false;
    	}
		}

		if (profil.isMenuGC_DRegFour()) {
			var nbEchARegl = parseIntBis(contenu.getAttribute('Nb_EchARegl'));
    	if (nbEchARegl>0) {
				info = true;
      	document.getElementById('lblFournisseur').value = nbEchARegl +" "+ (nbEchARegl==1?"\u00E9ch\u00E9ance fournisseur":"\u00E9ch\u00E9ances fournisseurs") +" \u00E0 r\u00E9gler...";
      	document.getElementById('boxFournisseur').collapsed = false;
    	}
		}

		if (!clotureFactAuto && profil.isClotureFact()) {
			if (contenu.getAttribute('Fact_Cloturable')=="true") {
				alerte = true;
				document.getElementById('boxCloture').collapsed = false;
				document.getElementById('lblPeriode').value = contenu.getAttribute('Mois_Facturation').toUpperCase();
			}
		}

		if (profil.isDirection()) {
			var nbAttLog = parseIntBis(contenu.getAttribute('Nb_AttLog'));
    	if (nbAttLog>0) {
				alerte = true;
      	document.getElementById('lblAttLog1').value = "Vous avez "+ (nbAttLog==1?"une attestation":"des attestations") +" logiciel "+ (nbAttLog==1?"disponible.":"disponibles.");
				document.getElementById('lblAttLog2').value = "Veuillez vous rendre en Configuration, rubrique Documents l\u00E9gaux, afin de "+ (nbAttLog==1?"la":"les") +" t\u00E9l\u00E9charger.";
      	document.getElementById('boxAttLog').collapsed = false;
    	}
		}

		var queryMessages = new QueryHttp("Commun/checkMessages.tmpl");
		result = queryMessages.execute();
		var message = parseIntBis(result.responseXML.documentElement.getAttribute('Nb_Messages'))>0;

		if (message) {
			var aMessages = new Arbre("Commun/list-messages.tmpl", "boxMessages");
			aMessages.initTree();

			document.getElementById('tabMessages').collapsed = false;
			document.getElementById('tbActivite').selectedIndex = 3;
		}

		if (info || alerte) {
			document.getElementById('boxNoAlertes').collapsed = true;
			document.getElementById('tabAlertes').setAttribute('image', 'chrome://opensi/content/design/icones/ampoule.png');
			if (alerte && !message) {
				document.getElementById('tbActivite').selectedIndex = 2;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initActivite() {
  try {

		if (!suiviLoaded) {

			suiviLoaded = true;

			var querySuivi = new QueryHttp("Facturation/getSuiviActiviteGC.tmpl");
			var result = querySuivi.execute();

    	var contenu = result.responseXML.documentElement;

    	document.getElementById('ComEnCours').value = contenu.getAttribute('Montant_HT_Commandes_A_Facturer') +" \u20AC";
    	document.getElementById('CANMois').value = contenu.getAttribute('CA_Mois_N') +" \u20AC";
    	document.getElementById('CAN1Mois').value = contenu.getAttribute('CA_Mois_N1') +" \u20AC";
    	document.getElementById('CAN').value = contenu.getAttribute('CA_Annee_N') +" \u20AC";
    	document.getElementById('CAN1').value = contenu.getAttribute('CA_Annee_N1') +" \u20AC";
			document.getElementById('TDVMois').value = contenu.getAttribute('Taux_Devis_Valides_Mois') +" %";
			document.getElementById('TDVAnnee').value = contenu.getAttribute('Taux_Devis_Valides_Annee') +" %";

			document.getElementById('GraphCA').setAttribute("src", getDirGraph() + contenu.getAttribute('Image_Graph_CA'));
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function goToMenu(m) {
  try {

		switch(m) {
			case 1:		window.location = "chrome://opensi/content/facturation/user/clients/gestionClients.xul";														break;
			case 2:		window.location = "chrome://opensi/content/facturation/user/fournisseurs/gestionFournisseurs.xul";									break;
			case 3:		window.location = "chrome://opensi/content/facturation/user/articles/gestionArticles.xul";													break;
			case 4:		window.location = "chrome://opensi/content/facturation/user/commandes/gestionCommandes.xul";												break;
			case 5:		window.location = "chrome://opensi/content/facturation/user/devis/gestionDevis.xul";																break;
			case 6:		window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul";													break;
			case 7:		window.location = "chrome://opensi/content/facturation/user/factures_vente/gestionFactures.xul";          					break;
			case 8:		window.location = "chrome://opensi/content/facturation/user/factu_auto/menuFactuAuto.xul";													break;
			case 9:		window.location = "chrome://opensi/content/facturation/user/expedition_transfert/expedition_ts.xul";								break;
			case 10:	window.location = "chrome://opensi/content/facturation/user/tabbord/gestionTableauxBord.xul";												break;
			case 11:	window.location = "chrome://opensi/content/facturation/user/editions/gestionEditions.xul";													break;
			case 12:	window.location = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/gestionReglementsFournisseurs.xul";	break;
			case 13:	window.location = "chrome://opensi/content/facturation/user/transfert/menuTransfert.xul";														break;
			case 14:	window.location = "chrome://opensi/content/facturation/user/factu_fournisseur/gestionFactures.xul";									break;
			case 16:	window.location = "chrome://opensi/content/facturation/user/abonnements/gestionAbonnements.xul";										break;
			case 17:	window.location = "chrome://opensi/content/facturation/user/commandes/prep_commandes.xul";													break;
			case 20:	window.location = "chrome://opensi/content/facturation/user/reception/reception.xul";																break;
			case 21:	window.location = "chrome://opensi/content/facturation/user/commerciaux/gestionCommerciaux.xul";										break;
			case 22:	window.location = "chrome://opensi/content/facturation/user/suivi_logistique/gestionSuiviLogistique.xul";						break;
			case 23:	window.location = "chrome://opensi/content/facturation/user/inventaires/gestionInventaires.xul";										break;
			case 24:	window.location = "chrome://opensi/content/facturation/user/deb/gestionDEB.xul";																		break;
			case 26:	window.location = "chrome://opensi/content/facturation/user/fabrication/gestionOrdreFabrications.xul";							break;
			case 27:	window.location = "chrome://opensi/content/facturation/user/expedition_lot/expedition_lot.xul";											break;
			case 28:	window.location = "chrome://opensi/content/facturation/user/changement_mdp/change_user_password.xul";								break;
			case 29:	window.location = "chrome://opensi/content/facturation/user/gestionTarifs/gestionTarifs.xul";												break;
			case 32:	window.location = "chrome://opensi/content/facturation/user/envoi_factures/menuEnvoiFactures.xul";									break;
			case 33:	window.location = "chrome://opensi/content/facturation/user/suivi_reglements_clients/gestionReglementsClients.xul";	break;
			case 34:	window.location = "chrome://opensi/content/facturation/user/remises_banque/gestionRemisesBanque.xul";								break;
			case 35:	window.location = "chrome://opensi/content/facturation/user/retours_fournisseurs/gestionRetours.xul";								break;
			case 36:	window.location = "chrome://opensi/content/facturation/user/transferts_stocks/gestionTransferts.xul";								break;
			case 37:	window.location = "chrome://opensi/content/facturation/user/csv/csv.xul";																						break;
			case 38:	window.location = "chrome://opensi/content/facturation/user/mouvements_stocks/gestionMouvements.xul";								break;
			case 39:	window.location = "chrome://opensi/content/facturation/user/tracabilite_articles/tracabilite.xul";									break;
			case 40:	window.location = "chrome://opensi/content/facturation/user/retours_clients/gestionRetours.xul";										break;
			case 41:	window.location = "chrome://opensi/content/facturation/user/preparation_expedition/preparationExp.xul";							break;
			case 42:	window.location = "chrome://opensi/content/facturation/user/stocks/entreessorties-stock.xul";												break;
			case 43:	window.location = "chrome://opensi/content/facturation/user/stocks/parametrage-stocks.xul";													break;
			case 44:	window.location = "chrome://opensi/content/facturation/user/traitement_retours/gestionRetours.xul";									break;
			case 45:	window.location = "chrome://opensi/content/facturation/user/ecopart/gestionEcoPart.xul";														break;
			case 46:	window.location = "chrome://opensi/content/facturation/user/controle_achats/gestionControleFacturation.xul";				break;
			case 47:	window.location = "chrome://opensi/content/facturation/user/expedition/expedition.xul";															break;
			case 48:	window.location = "chrome://opensi/content/facturation/user/emplacements/gestionEmplacements.xul";									break;
			case 49:	window.location = "chrome://opensi/content/facturation/user/crossdock/gestionCrossDock.xul";												break;
			case 50:	window.location = "chrome://opensi/content/facturation/user/transemp/gestionTransfertsEmplacements.xul";						break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirSousMenu(idSM) {

	document.getElementById('smTiers').collapsed = true;
	document.getElementById('smVentes').collapsed = true;
	document.getElementById('smExpeditions').collapsed = true;
	document.getElementById('smAchats').collapsed = true;
	document.getElementById('smArticles').collapsed = true;
	document.getElementById('smStocks').collapsed = true;
	document.getElementById('smOD').collapsed = true;

	document.getElementById(idSM).collapsed = false;
}


function chargerAffaire(affaireId) {
  try {

    window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Affaire_Id="+ affaireId;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerCommande(commandeId) {
  try {

    window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Commande_Id="+ commandeId;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerRetourClient(retourId) {
  try {

    window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Retour_Id="+ retourId;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerFicheArticle(articleId) {
  try {

    window.location = "chrome://opensi/content/facturation/user/articles/gestionArticles.xul?Article_Id="+ articleId;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerESStock(reference) {
  try {

    window.location = "chrome://opensi/content/facturation/user/stocks/entreessorties-stock.xul?Reference="+ reference;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerInventaire(inventaireId) {
  try {

		window.location = "chrome://opensi/content/facturation/user/inventaires/gestionInventaires.xul?Inventaire_Id="+ inventaireId;

	} catch (e) {
    recup_erreur(e);
  }
}


function relances() {
  try {

    window.location = "chrome://opensi/content/facturation/user/suivi_reglements_clients/gestionReglementsClients.xul?Relances=1";

	} catch (e) {
    recup_erreur(e);
  }
}


function echeancesFournisseur() {
	try {

  	window.location = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/gestionReglementsFournisseurs.xul";

  } catch (e) {
  	recup_erreur(e);
  }
}


function facturesAEmettre() {
  try {

    window.location = "chrome://opensi/content/facturation/user/abonnements/gestionAbonnements.xul?Facturation=true";

	} catch (e) {
    recup_erreur(e);
  }
}


function fabrications() {
  try {

		var qGenerate = new QueryHttp("Facturation/Fabrication/generateReassort.tmpl");
		qGenerate.execute();

    window.location = "chrome://opensi/content/facturation/user/fabrication/gestionOrdreFabrications.xul";

	} catch (e) {
    recup_erreur(e);
  }
}


function fabricationsValides() {
  try {

    window.location = "chrome://opensi/content/facturation/user/fabrication/gestionOrdreFabrications.xul";

	} catch (e) {
    recup_erreur(e);
  }
}


function cloturerFacturation() {
  try {

		var queryCloturer = new QueryHttp("Facturation/Transfert/CloturerMois.tmpl");
		queryCloturer.execute();

		showMessage("Facturation de la p\u00E9riode "+ document.getElementById('lblPeriode').value +" clotur\u00E9e");

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}


function retourChoixDossier() {
	try {

    window.location = "chrome://opensi/content/facturation/user/menu.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}
