/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aPrepEnCours = new Arbre("Facturation/Preparation_Expedition/list-prepaNonValid.tmpl", "prepaNonValid");
var aLignesPrepExpedition = new Arbre("Facturation/Preparation_Expedition/list-lignePrepExpedition.tmpl", "prepa");
var aNumerosSerie = new Arbre("Facturation/Preparation_Expedition/liste-numerosSerie.tmpl", "liste_numero_serie");
var aNumerosLot = new Arbre("Facturation/Preparation_Expedition/list-numLotLignePrepExpedition.tmpl", "listeNumLot");
var aColis = new Arbre('Facturation/Preparation_Expedition/liste-colis.tmpl', 'listeColis');
var aHistorique = new Arbre("Facturation/Preparation_Expedition/liste-historique.tmpl", "Reedition");
var aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl", "modeExpedition");
var aCartons = new Arbre("ComboListe/combo-cartons.tmpl", "cartonId");

var r3 = new Arrondi(3);
var f3 = new NumberFormat("0.000", false);

var prepId;
var suiviSerie = false;
var suiviLot = false;
var actQRCode = false;
var pexEdit = false;
var exlBacPrepa = false;
var calculAutomatique = false;
var curDepotId;
var curColisId = "";
var curCartonId = "";
var switchCount = 1;
var switchPosition = 0;
var chargerModeExpedition = "";
var currentLotId = "";
var courrierSuivi = false;
var specILNFW = false;
var newPrepa = true;
var nonPaye;
var pexAlerteNP;



function init() {
	try {

		document.getElementById("modifierSeries").disabled = true;

		document.getElementById("NouveauColis").disabled = true;
		document.getElementById("ValiderColis").disabled = true;
		document.getElementById("ValiderNbColis").disabled = true;
		document.getElementById("bCsvColisage").disabled = true;
		document.getElementById("bPdfColisage").disabled = true;
		document.getElementById("bPdfEtiqColis").disabled = true;
		document.getElementById("SupprimerColis").disabled = true;
		document.getElementById("bColisage").disabled = true;
		document.getElementById("nbColis").disabled = true;
		document.getElementById("poids").disabled = true;
		document.getElementById("volume").disabled = true;
		document.getElementById("cartonId").disabled = true;

		document.getElementById("NouveauNumLot").disabled = true;
		document.getElementById("ValiderNumLot").disabled = true;
		document.getElementById("SupprimerNumLot").disabled = true;

		var config = getConfig();

		pexEdit = !config.isPEXEnvoiDocFTP() && (config.isPEXEditBL() || config.isPEXEditFC());
		suiviSerie = config.isActSuiviSerie();
		suiviLot = config.isActSuiviLot();
		actQRCode = config.isPEXQRCode();
		exlBacPrepa = config.isEXLBacPrepa();
		calculAutomatique = config.isPEXAvoidChk();
		specILNFW = config.isSpecILNFW();
		pexAlerteNP = config.isPEXAlerteNP();

		document.getElementById("vboxDetailLigneArticle").collapsed = !(suiviSerie || suiviLot);
		document.getElementById("vboxNumSerie").collapsed = !suiviSerie;
		document.getElementById("vboxNumLot").collapsed = !suiviLot;
		document.getElementById("bSwitchMode").collapsed = !(suiviSerie || actQRCode);
		document.getElementById("symboleUnitePoids").value = config.getSymboleUnitePoids();
		document.getElementById("lblVolume").value = "Volume ("+ config.getSymboleUniteVolume() +") :";
		document.getElementById("lcColVolume").setAttribute("label", "Volume ("+ config.getSymboleUniteVolume() +")");

		if (!config.isActSerieDLC()) {
			document.getElementById("colDatePeremptionNS").setAttribute("hidden", true);
		}

		if (suiviSerie || actQRCode) {
			switchCount = 1 + ((suiviSerie)?1:0) + ((actQRCode)?1:0);
			nextModeSaisie();
		}

		document.getElementById("rowChariot").collapsed = !exlBacPrepa;
		document.getElementById("rowBac").collapsed = !exlBacPrepa;

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("colAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("colAttribut"+ i).collapsed = true;
				document.getElementById("colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		nouvellePrepa();

		var aPreparateurs = new Arbre("ComboListe/combo-responsables.tmpl", "Login_Resp");
		aPreparateurs.initTree(initResponsable);

		var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "filterResponsable");
		aResponsables.initTree();

		aModesExpedition.initTree(initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
		recup_erreur(e);
	}
}


function pressAltLeft(ev) {
	try {

		if (ev.keyCode==37 && ev.altKey && document.getElementById("deck").selectedIndex==1) {
			ev.preventDefault();
			retourPrepaExpedition();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherExpedition() {
	try {

		var url = "chrome://opensi/content/facturation/user/preparation_expedition/popup-selectionBP.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherExpedition(documentId, typeDoc) {
	try {

		var qNewPrepa = new QueryHttp("Facturation/Preparation_Expedition/createPrepExpedition.tmpl");
		qNewPrepa.setParam("Document_Id", documentId);
		qNewPrepa.setParam("Type_Doc", typeDoc);
		var result = qNewPrepa.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;
			if (!isEmpty(contenu.getAttribute("Alerte"))) {
				showWarning(contenu.getAttribute("Alerte"));
			}
			prepId = contenu.getAttribute("Prep_Id");
			aPrepEnCours.initTree();
			chargerPrepa();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerPrepa() {
	try {

		document.getElementById("bAnnuler").disabled = false;
		document.getElementById("bReinitialiser").disabled = false;
		document.getElementById("Login_Resp").disabled = false;
		reinitSaisieLigne();
		document.getElementById("codeBarre").value = "";
		document.getElementById("codeBarre").disabled = false;
		document.getElementById("bValiderCB").disabled = false;

		if (suiviSerie) {
			document.getElementById("numeroSerie").value = "";
			document.getElementById("numeroSerie").disabled = false;
			document.getElementById("bValiderNS").disabled = false;
		}
		if (actQRCode) {
			document.getElementById("qrCode").value = "";
			document.getElementById("qrCode").disabled = false;
			document.getElementById("bValiderQRC").disabled = false;
		}

		var qLoad = new QueryHttp("Facturation/Preparation_Expedition/loadPrepExpedition.tmpl");
		qLoad.setParam("Prep_Id", prepId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			curDepotId = contenu.getAttribute("Depot_Id");
			var modeExpedition = contenu.getAttribute("Mode_Expedition");
			chargerModesExpedition(modeExpedition);

			document.getElementById("numBP").value = contenu.getAttribute("Num_Expedition");
			document.getElementById("numClient").value = contenu.getAttribute("Num_Tiers");
			document.getElementById("depotExp").value = contenu.getAttribute("Depot_Expedition");
			document.getElementById("denominationClient").value = contenu.getAttribute("Denomination");
			document.getElementById("numChariot").value = contenu.getAttribute("Num_Chariot");
			document.getElementById("numBac").value = contenu.getAttribute("Num_Bac");
			document.getElementById("poidsPreparation").value = contenu.getAttribute("Poids");
			document.getElementById("Login_Resp").value = contenu.getAttribute("Util_R");
			document.getElementById("nouveauClient").collapsed = contenu.getAttribute("Nouveau_Client")=="false";
			courrierSuivi = contenu.getAttribute("Courrier_Suivi")=="true";
			nonPaye = contenu.getAttribute("Non_Paye")=="true";

			aLignesPrepExpedition.setParam("Prep_Id", prepId);
			aLignesPrepExpedition.initTree(afterInit);
			listerColis();
			document.getElementById("bCsvColisage").disabled = false;
			document.getElementById("bPdfColisage").disabled = false;
			document.getElementById("bPdfEtiqColis").disabled = false;
			aNumerosSerie.deleteTree();
			aNumerosLot.deleteTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerModesExpedition(selection) {
	try {

		chargerModeExpedition = selection;
		aModesExpedition.setParam("Selection", chargerModeExpedition);
		aModesExpedition.initTree(initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function initModeExpedition() {
	try {

		document.getElementById('modeExpedition').value = chargerModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerCartons(selection) {
	try {

		curCartonId = selection;
		aCartons.setParam("Selection", curCartonId);
		aCartons.initTree(initCarton);

	} catch (e) {
		recup_erreur(e);
	}
}


function initCarton() {
	try {

		document.getElementById('cartonId').value = curCartonId;

	} catch (e) {
		recup_erreur(e);
	}
}


function initResponsable() {
  try {

		document.getElementById('Login_Resp').value = getProfil().getLoggedUser();

	} catch (e) {
  	recup_erreur(e);
	}
}


function majPoids() {
	try {

		var qGetPoids = new QueryHttp("Facturation/Preparation_Expedition/getPoids.tmpl");
		qGetPoids.setParam("Prep_Id", prepId);
		var result = qGetPoids.execute();
		var poidsPreparation = result.responseXML.documentElement.getAttribute("Poids");
		document.getElementById("poidsPreparation").value = poidsPreparation;

	} catch (e) {
		recup_erreur(e);
	}
}


function dblClickPrepaNonValid() {
	try {

		if (aPrepEnCours.isSelected()) {
			prepId = aPrepEnCours.getSelectedCellText('Prep_Id');
			chargerPrepa();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function afterInit() {
	try {

		document.getElementById("modifierSeries").disabled = true;

		var nbLignes = aLignesPrepExpedition.nbLignes();
		var ok = true;
		for(var i=0; i<nbLignes; i++) {
			var qteBP = parseFloat(aLignesPrepExpedition.getCellText(i,'colQteBP'));
			var qtePrepa = parseFloat(aLignesPrepExpedition.getCellText(i,'colQtePrepa'));
			var qteManquante = parseFloat(aLignesPrepExpedition.getCellText(i,'colQteManquante'));
			if((qtePrepa+qteManquante)<qteBP) {
				ok = false;
			}
		}

		if (ok) {
			document.getElementById("bValider").disabled = false;
			if (calculAutomatique) {
				document.getElementById("bValider").focus();
			}
		}
		else {
			document.getElementById("bValider").disabled = true;
			selectModeSaisie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectionLignePrepa() {
	try {

		if (aLignesPrepExpedition.isSelected()) {
			document.getElementById("saisieQuantite").disabled = false;
			document.getElementById("saisieQuantiteManquante").disabled = false;
			var i = aLignesPrepExpedition.getCurrentIndex();
			var ref = aLignesPrepExpedition.getCellText(i, 'colReference');
			var typeLigne = aLignesPrepExpedition.getCellText(i, 'colTypeLigne');
			var designation = aLignesPrepExpedition.getCellText(i, 'colDesignation');
			var qte = aLignesPrepExpedition.getCellText(i, 'colQtePrepa');
			var qteManquante = aLignesPrepExpedition.getCellText(i, 'colQteManquante');
			document.getElementById("saisieReference").value = ref;
			document.getElementById("saisieDesignation").value = designation;
			document.getElementById("saisieQuantite").value = qte;
			document.getElementById("saisieQuantiteManquante").value = qteManquante;
			document.getElementById("bValiderLigne").disabled = false;

			if (suiviSerie && (typeLigne=='S' || typeLigne=='C')) {
				aNumerosSerie.setParam('Ligne_Id',aLignesPrepExpedition.getCellText(i, 'colLigneId'));
				aNumerosSerie.initTree();
				document.getElementById("modifierSeries").disabled = false;
			}
			else {
				aNumerosSerie.deleteTree();
				document.getElementById("modifierSeries").disabled = true;
			}

			if (suiviLot && (typeLigne=='S' || typeLigne=='C')) {
				aNumerosLot.setParam('Ligne_Id',aLignesPrepExpedition.getCellText(i, 'colLigneId'));
				aNumerosLot.initTree();
				currentLotId = "";
				document.getElementById('numeroLot').value = "";
				document.getElementById('quantiteLot').value = "";
				document.getElementById('datePeremption').value = "";
				document.getElementById("NouveauNumLot").disabled = false;
				document.getElementById("ValiderNumLot").disabled = false;
				document.getElementById("SupprimerNumLot").disabled = true;
				document.getElementById("quantiteLot").disabled = false;
				document.getElementById("datePeremption").disabled = false;
				document.getElementById("numeroLot").disabled = false;
				document.getElementById("bRechLot").disabled = false;
			}
			else {
				aNumerosLot.deleteTree();
				currentLotId = "";
				document.getElementById('numeroLot').value = "";
				document.getElementById('quantiteLot').value = "";
				document.getElementById('datePeremption').value = "";
				document.getElementById("NouveauNumLot").disabled = true;
				document.getElementById("ValiderNumLot").disabled = true;
				document.getElementById("SupprimerNumLot").disabled = true;
				document.getElementById("quantiteLot").disabled = true;
				document.getElementById("datePeremption").disabled = true;
				document.getElementById("numeroLot").disabled = true;
				document.getElementById("bRechLot").disabled = true;
			}

			if (calculAutomatique) {
				document.getElementById("saisieQuantiteManquante").select();
			}
			else {
				document.getElementById("saisieQuantite").select();
			}

		}

	} catch (e) {
		recup_erreur(e);
	}
}


function listerColis() {
	try {

		aColis.setParam("Prep_Id", prepId);
		aColis.initTree(initColis);
		nouveauColis();

	} catch (e) {
    recup_erreur(e);
  }
}


function initColis() {
	try {

		document.getElementById('labelPoidsColisKg').collapsed = false;
		var poidsColis = 0;
		var nbLignes = aColis.nbLignes();
		if (nbLignes>0) {
			for(var i=0; i<nbLignes; i++) {
				poidsColis += r3.round(aColis.getCellText(i,'lcColPoids'));
			}
		}
		else {
			poidsColis = "Automatique";
			document.getElementById('labelPoidsColisKg').collapsed = true;
		}

		document.getElementById('poidsColis').value = f3.format(poidsColis);

	} catch (e) {
    recup_erreur(e);
  }
}


function validerColis() {
	try {

		var poids = document.getElementById('poids').value;
		var volume = document.getElementById('volume').value;
		var cartonId = document.getElementById('cartonId').value;

		if (isEmpty(volume)) {
			volume = 0;
		}

		if (!isPositiveOrNull(poids) || !checkNumber(poids,10,3)) {
			showWarning("Poids du colis incorrect");
		}
		else if (!isPositiveOrNull(volume) || !checkNumber(volume,9,3)) {
			showWarning("Volume du colis incorrect");
		}
		else {
			var qSave;

			if (isEmpty(curColisId)) {
				qSave = new QueryHttp("Facturation/Preparation_Expedition/createColis.tmpl");
				qSave.setParam("Prep_Id", prepId);
			}
			else {
				qSave = new QueryHttp("Facturation/Preparation_Expedition/updateColis.tmpl");
				qSave.setParam("Colis_Id", curColisId);
			}

			qSave.setParam("Poids", poids);
			qSave.setParam("Volume", volume);
			qSave.setParam("Carton_Id", cartonId);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aColis.initTree(initColis);
			nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerColis() {
	try {

		var qDelete = new QueryHttp("Facturation/Preparation_Expedition/deleteColis.tmpl");
		qDelete.setParam("Colis_Id", curColisId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		aColis.initTree(initColis);
		nouveauColis();

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauColis() {
	try {

		curColisId = "";
		document.getElementById('interne').value = "";
		document.getElementById('poids').value = "";
		document.getElementById('volume').value = "";
		document.getElementById('nbColis').value = "";
		document.getElementById("NouveauColis").disabled = false;
		document.getElementById("ValiderColis").disabled = false;
		document.getElementById("ValiderNbColis").disabled = false;
		document.getElementById("SupprimerColis").disabled = true;
		document.getElementById("bColisage").disabled = true;
		document.getElementById("nbColis").disabled = false;
		document.getElementById("poids").disabled = false;
		document.getElementById("volume").disabled = false;
		document.getElementById("cartonId").disabled = false;
		chargerCartons("");

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeColis() {
	try {

		if (aColis.isSelected()) {
			curColisId = aColis.getSelectedCellText("lcColColisId");
			document.getElementById('interne').value = aColis.getSelectedCellText("lcColNumInterne");
			document.getElementById('poids').value = aColis.getSelectedCellText("lcColPoids");
			document.getElementById('volume').value = aColis.getSelectedCellText("lcColVolume");
			document.getElementById("NouveauColis").disabled = false;
			document.getElementById("ValiderColis").disabled = false;
			document.getElementById("ValiderNbColis").disabled = false;
			document.getElementById("SupprimerColis").disabled = false;
			document.getElementById("bColisage").disabled = false;
			document.getElementById("nbColis").disabled = false;
			document.getElementById("poids").disabled = false;
			document.getElementById("volume").disabled = false;
			document.getElementById("cartonId").disabled = false;
			document.getElementById('poids').select();
			chargerCartons(aColis.getSelectedCellText("lcColCartonId"));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerNbColis() {
	try {

		var nbColis = document.getElementById('nbColis').value;

		if (!isPositiveOrNullInteger(nbColis)) {
			showWarning("Veuillez v\u00E9rifier la quantit\u00E9 saisie");
		}
		else {
			var qAjNbColis = new QueryHttp("Facturation/Preparation_Expedition/createNbColis.tmpl");
			qAjNbColis.setParam("Prep_Id", prepId);
			qAjNbColis.setParam("Nb", nbColis);
			var result = qAjNbColis.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aColis.initTree(initColis);
			nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerColisageCSV() {
  try {

		if (aColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionCsv = new QueryHttp("Facturation/Preparation_Expedition/csvColisagePE.tmpl");
			qEditionCsv.setParam("Prep_Id", prepId);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerColisagePDF() {
  try {

		if (aColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionPdf = new QueryHttp("Facturation/Preparation_Expedition/pdfColisagePE.tmpl");
			qEditionPdf.setParam("Prep_Id", prepId);

			newPrepa = false;
			document.getElementById('deck').selectedIndex = 1;

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				retourPrepaExpedition();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('editionPDF').setAttribute("src", page);

				document.getElementById('bRetourPreparation').collapsed = false;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerEtiquettesColisage() {
	try {

		if (aColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEdit = new QueryHttp("Facturation/Preparation_Expedition/pdfEtiquetteColisage.tmpl");
			qEdit.setParam("Prep_Id", prepId);

			newPrepa = false;
			document.getElementById('deck').selectedIndex = 1;

			var result = qEdit.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				retourPrepaExpedition();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('editionPDF').setAttribute("src", page);

				document.getElementById('bRetourPreparation').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNbColis(ev) {
	try {

		if (ev.keyCode==13) {
			validerNbColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPoids(ev) {
	try {

		if (ev.keyCode==13) {
			validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnVolume(ev) {
	try {

		if (ev.keyCode==13) {
			validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function colisageColis() {
	try {

		if (aColis.isSelected()) {
			var colisId = aColis.getSelectedCellText("lcColColisId");
			var numIntraExp = aColis.getSelectedCellText("lcColNumInterne");

			var url = "chrome://opensi/content/facturation/user/preparation_expedition/popup-colisage.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', prepId, colisId, numIntraExp);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerNumLot() {
	try {

		if (aLignesPrepExpedition.isSelected()) {

			var ligneId = aLignesPrepExpedition.getSelectedCellText('colLigneId');
			var numeroLot = document.getElementById('numeroLot').value;
			var datePeremption = document.getElementById('datePeremption').value;
			var quantite = document.getElementById('quantiteLot').value;

			if (isEmpty(numeroLot)) {
				showWarning("Num\u00E9ro de lot incorrect");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				showWarning("Date de p\u00E9remption incorrecte");
			}
			else if (!isPositive(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else {
				var qSave = new QueryHttp("Facturation/Preparation_Expedition/saveNumLotLignePrepExpedition.tmpl");

				qSave.setParam("Ligne_Id", ligneId);
				qSave.setParam("Num_Lot", numeroLot);
				qSave.setParam("Date_Peremption", datePeremption);
				qSave.setParam("Quantite", quantite);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				aNumerosLot.initTree();
				nouveauNumLot();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerNumLot() {
	try {

		if (aLignesPrepExpedition.isSelected() && !isEmpty(currentLotId)) {
			var ligneId = aLignesPrepExpedition.getSelectedCellText('colLigneId');

			var qDelete = new QueryHttp("Facturation/Preparation_Expedition/deleteNumLotLignePrepExpedition.tmpl");
			qDelete.setParam("Ligne_Id", ligneId);
			qDelete.setParam("Lot_Id", currentLotId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
		}

		aNumerosLot.initTree();
		nouveauNumLot();

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauNumLot() {
	try {

		currentLotId = "";
		document.getElementById('numeroLot').value = "";
		document.getElementById('quantiteLot').value = "";
		document.getElementById('datePeremption').value = "";
		document.getElementById("NouveauNumLot").disabled = false;
		document.getElementById("ValiderNumLot").disabled = false;
		document.getElementById("SupprimerNumLot").disabled = true;
		document.getElementById("quantiteLot").disabled = false;
		document.getElementById("datePeremption").disabled = false;
		document.getElementById("numeroLot").disabled = false;
		document.getElementById("bRechLot").disabled = false;
		document.getElementById('numeroLot').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeNumLot() {
	try {

		if (aNumerosLot.isSelected()) {
			var i = aNumerosLot.getCurrentIndex();
			currentLotId = aNumerosLot.getCellText(i, "lcColLotId");
			document.getElementById('numeroLot').value = aNumerosLot.getCellText(i, "lcColNumLot");
			document.getElementById('quantiteLot').value = aNumerosLot.getCellText(i, "lcColQuantite");
			document.getElementById('datePeremption').value = aNumerosLot.getCellText(i, "lcColDatePeremption");
			document.getElementById("NouveauNumLot").disabled = false;
			document.getElementById("ValiderNumLot").disabled = false;
			document.getElementById("SupprimerNumLot").disabled = false;
			document.getElementById("quantiteLot").disabled = false;
			document.getElementById("datePeremption").disabled = false;
			document.getElementById("numeroLot").disabled = true;
			document.getElementById("bRechLot").disabled = true;
			document.getElementById('quantiteLot').select();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13) {
			rechercherLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherLot() {
	try {

		if (aLignesPrepExpedition.isSelected()) {
			var articleId = aLignesPrepExpedition.getSelectedCellText('colArticleId');
			var numero = document.getElementById('numeroLot').value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherLot, articleId, numero, curDepotId, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById('numeroLot').value = numero;
		document.getElementById('datePeremption').value = datePeremption;
		document.getElementById('quantiteLot').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressQuantiteLot(event) {
	try {

		if (event.keyCode==13) {
			validerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressDatePeremption(event) {
	try {

		if (event.keyCode==13) {
			validerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressQuantite(event) {
	try {

		if (event.keyCode==13) {
			validerLigne();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressQuantiteManquante(event) {
	try {

		if (event.keyCode==13) {
			validerLigne();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onCommandQuantiteManquante() {
	try {

		if (calculAutomatique) {
			if (aLignesPrepExpedition.isSelected()) {
				var qte = aLignesPrepExpedition.getSelectedCellText('colQteBP');
				document.getElementById('saisieQuantite').value = f3.format(r3.round(qte)-r3.round(document.getElementById('saisieQuantiteManquante').value));
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLigne() {
	try {

		if (aLignesPrepExpedition.isSelected()) {
			var i = aLignesPrepExpedition.getCurrentIndex();
			var qteManquante = parseFloat(document.getElementById("saisieQuantiteManquante").value);
			var qtePrepa = parseFloat(document.getElementById("saisieQuantite").value);
			var qteBP = parseFloat(aLignesPrepExpedition.getCellText(i, 'colQteBP'));
			var lignePrepaId = aLignesPrepExpedition.getCellText(i, 'colLigneId');
			var type = aLignesPrepExpedition.getCellText(i, 'colType');
			if (!isPositiveOrNull(qtePrepa)) {
				showWarning("Veuillez v\u00E9rifier le format de la quantit\u00E9 saisie");
			}
			else if (!isPositiveOrNull(qteManquante)) {
				showWarning("Veuillez v\u00E9rifier le format de la quantit\u00E9 manquante saisie");
			}
			else if ((qtePrepa+qteManquante) > qteBP) {
				showWarning("Vous ne pouvez pas affecter une quantit\u00E9 sup\u00E9rieure \u00E0 celle du BP");
			}
			else if (type == "Forfait") {
				showWarning("Impossible de modifier la quantit\u00E9 d'un forfait, il faut modifier les quantit\u00E9s des composants");
			}
			else {
				var qUpdateQteLigne = new QueryHttp("Facturation/Preparation_Expedition/updateQteLigne.tmpl");
				qUpdateQteLigne.setParam("Ligne_Id", lignePrepaId);
				qUpdateQteLigne.setParam("Quantite", qtePrepa);
				qUpdateQteLigne.setParam("QuantiteManquante", qteManquante);
				qUpdateQteLigne.execute();

				reinitSaisieLigne();
				aLignesPrepExpedition.initTree(afterInit);
				majPoids();
				aNumerosSerie.deleteTree();
				aNumerosLot.deleteTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function modifierSeries() {
	try {

		if (suiviSerie) {
			if (aLignesPrepExpedition.isSelected()) {
				var ligneId = aLignesPrepExpedition.getSelectedCellText('colLigneId');
    		var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', "S", "PE", ligneId, curDepotId);
			}
			aLignesPrepExpedition.initTree(afterInit);
			aNumerosSerie.deleteTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitSaisieLigne() {
	try {

		document.getElementById("saisieReference").value = "";
		document.getElementById("saisieDesignation").value = "";
		document.getElementById("saisieQuantite").value = "";
		document.getElementById("saisieQuantite").disabled = true;
		document.getElementById("saisieQuantiteManquante").value = "";
		document.getElementById("saisieQuantiteManquante").disabled = true;
		document.getElementById("bValiderLigne").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function annulerPrepa() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la pr\u00E9paration ?")) {

			var qCancel = new QueryHttp("Facturation/Preparation_Expedition/cancelPrepExpedition.tmpl");
			qCancel.setParam("Prep_Id", prepId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				nouvellePrepa();
				showWarning("La pr\u00E9paration a \u00E9t\u00E9 annul\u00E9e");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiserPrepa() {
	try {

		if (window.confirm("Confirmez-vous la r\u00E9initialisation de la pr\u00E9paration ? (Attention toutes les quantit\u00E9s saisies seront r\u00E9initialis\u00E9es)")) {
			var qReset = new QueryHttp("Facturation/Preparation_Expedition/resetPrepExpedition.tmpl");
			qReset.setParam("Prep_Id", prepId);
			var result = qReset.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				reinitSaisieLigne();
				aLignesPrepExpedition.initTree(afterInit);
				majPoids();
				aNumerosSerie.deleteTree();
				aNumerosLot.deleteTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function nouvellePrepa() {
	try {

		courrierSuivi = false;
		nonPaye = false;
		document.getElementById("deck").selectedIndex = 0;
		document.getElementById("bRetourPreparation").collapsed = true;
		document.getElementById("nouveauClient").collapsed = true;

		document.getElementById("searchNumExpeditionSaisie").focus();
		document.getElementById("searchNumExpeditionSaisie").value = "";
		document.getElementById("Login_Resp").disabled = true;
		document.getElementById("numBP").value = "";
		document.getElementById("numClient").value = "";
		document.getElementById("depotExp").value = "";
		document.getElementById("denominationClient").value = "";
		document.getElementById("numChariot").value = "";
		document.getElementById("numBac").value = "";

		document.getElementById('nbColis').value = "";
		document.getElementById('poidsPreparation').value = "0.0";
		document.getElementById('poidsColis').value = "0.0";

		document.getElementById("saisieReference").value = "";
		document.getElementById("saisieDesignation").value = "";
		document.getElementById("saisieQuantite").value = "";
		document.getElementById("saisieQuantiteManquante").value = "";
		document.getElementById("saisieQuantite").disabled = true;
		document.getElementById("saisieQuantiteManquante").disabled = true;
		document.getElementById("bValiderLigne").disabled = true;

		document.getElementById("codeBarre").value = "";
		document.getElementById("codeBarre").disabled = true;
		document.getElementById("bValiderCB").disabled = true;
		document.getElementById("numeroSerie").value = "";
		document.getElementById("numeroSerie").disabled = true;
		document.getElementById("bValiderNS").disabled = true;
		document.getElementById("qrCode").value = "";
		document.getElementById("qrCode").disabled = true;
		document.getElementById("bValiderQRC").disabled = true;

		document.getElementById("bAnnuler").disabled = true;
		document.getElementById("bValider").disabled = true;
		document.getElementById("bReinitialiser").disabled = true;

		document.getElementById("NouveauColis").disabled = true;
		document.getElementById("ValiderColis").disabled = true;
		document.getElementById("ValiderNbColis").disabled = true;
		document.getElementById("bCsvColisage").disabled = true;
		document.getElementById("bPdfColisage").disabled = true;
		document.getElementById("bPdfEtiqColis").disabled = true;
		document.getElementById("SupprimerColis").disabled = true;
		document.getElementById("bColisage").disabled = true;
		document.getElementById("nbColis").disabled = true;
		document.getElementById("poids").disabled = true;
		document.getElementById("volume").disabled = true;
		document.getElementById("cartonId").disabled = true;

		aLignesPrepExpedition.deleteTree();
		aColis.deleteTree();
		aPrepEnCours.initTree();
		aNumerosSerie.deleteTree();
		aNumerosLot.deleteTree();

		document.getElementById("Reedition").selectedIndex = 0;
		document.getElementById("filterResponsable").value = "";

		aHistorique.setParam("Util_V", "");
		aHistorique.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function reediter() {
	try {

		if (document.getElementById('Reedition').selectedIndex!=0) {
			document.getElementById('editionPDF').setAttribute("src", "");
			document.getElementById("bRetourPreparation").collapsed = false;
			document.getElementById("boxReedition").collapsed = false;
			document.getElementById("rappelLoi").collapsed = true;
			document.getElementById("deck").selectedIndex = 1;

			var qGenPdf = new QueryHttp("Facturation/Preparation_Expedition/pdfBonLivraisonFacture.tmpl");
			qGenPdf.setParam('Prep_Id', document.getElementById('Reedition').value);
			qGenPdf.setParam('Reedition', true);
			var result = qGenPdf.execute();

			document.getElementById("rappelLoi").collapsed = result.responseXML.documentElement.getAttribute('Has_Factures')=="false";

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('editionPDF').setAttribute("src", page);
		}
		else {
			showWarning("Veuillez s\u00E9lectionner une date de r\u00E9\u00E9dition !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnFilterResponsable() {
	try {

		document.getElementById("Reedition").selectedIndex = 0;

		var utilV = document.getElementById("filterResponsable").value;

		aHistorique.setParam("Util_V", utilV);
		aHistorique.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function verifTypeModeExpedition() {
	try {

		var modeExpedition = document.getElementById("modeExpedition").value;

		if (isEmpty(modeExpedition)) {
			courrierSuivi = false;
		}
		else {
			var qType = new QueryHttp("Facturation/Preparation_Expedition/isModeExpeditionCourrierSuivi.tmpl");
			qType.setParam("Mode_Expedition", modeExpedition);
			var result = qType.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				courrierSuivi = result.responseXML.documentElement.getAttribute('Courrier_Suivi')=="true";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerPrepa() {
	try {

		if (!pexAlerteNP || !nonPaye || window.confirm("ATTENTION : La commande n'est pas pay\u00E9e !\nConfirmez-vous la validation de la pr\u00E9paration d'exp\u00E9dition ?")) {
			if (courrierSuivi) {
				var url = "chrome://opensi/content/facturation/user/preparation_expedition/popup-courrierSuivi.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', validerPrepExpedition);
			}
			else {
				validerPrepExpedition("");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerPrepExpedition(numeroSuivi) {
	try {

		document.getElementById("bValider").disabled = true;
		document.getElementById("bAnnuler").disabled = true;
		document.getElementById("bReinitialiser").disabled = true;

		var qValid = new QueryHttp("Facturation/Preparation_Expedition/validPrepExpedition.tmpl");
		qValid.setParam("Prep_Id", prepId);
		qValid.setParam("Mode_Expedition", document.getElementById("modeExpedition").value);
		qValid.setParam("Numero_Suivi", numeroSuivi);
		var result = qValid.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			document.getElementById("bValider").disabled = false;
			document.getElementById("bAnnuler").disabled = false;
			document.getElementById("bReinitialiser").disabled = false;
		}
		else {
			if (pexEdit) {
				document.getElementById('editionPDF').setAttribute("src", "");
				document.getElementById("bRetourPreparation").collapsed = false;
				document.getElementById("boxReedition").collapsed = true;
				document.getElementById("rappelLoi").collapsed = true;
				document.getElementById("deck").selectedIndex = 1;
				var qGenPdf = new QueryHttp("Facturation/Preparation_Expedition/pdfBonLivraisonFacture.tmpl");
				qGenPdf.setParam('Prep_Id', prepId);
				var result2 = qGenPdf.execute();

				var errors = new Errors(result2);
				if (errors.hasNext()) {
					errors.show();
					retourPrepaExpedition();
				}
				else {
					document.getElementById("rappelLoi").collapsed = result2.responseXML.documentElement.getAttribute('Has_Factures')=="false";

					var page = getDirPdf() + result2.responseXML.documentElement.getAttribute('FichierPDF');
					document.getElementById('editionPDF').setAttribute("src", page);
				}
			}
			else {
				nouvellePrepa();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourPrepaExpedition() {
	try {

		if (newPrepa) {
			nouvellePrepa();
			setTimeout(this.window.focus, 500);
		}
		else {
			document.getElementById("deck").selectedIndex = 0;
			document.getElementById("bRetourPreparation").collapsed = true;
			newPrepa = true;
		}
		document.getElementById('editionPDF').setAttribute("src", "");

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressCB(event) {
	try {

		if (event.keyCode==13) {
			validerLigneCB();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLigneCB() {
	try {

		var codeBarre = document.getElementById("codeBarre").value;

		if (!isEmpty(codeBarre)) {
			var qajouterArticlePrepa = new QueryHttp("Facturation/Preparation_Expedition/ajouterArticlePreparation.tmpl");
			qajouterArticlePrepa.setParam("Prep_Id", prepId);
			qajouterArticlePrepa.setParam("Code_Barre", codeBarre);
			var result = qajouterArticlePrepa.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				document.getElementById("codeBarre").value = "";
				if (!specILNFW) {
					errors.show();
				}
				else {
					showWarning(errors.getMessage(), true);
				}
			}
			else {
				document.getElementById("codeBarre").value = "";
				aLignesPrepExpedition.initTree(afterInit);
				majPoids();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressNS(event) {
	try {

		if (event.keyCode==13) {
			validerLigneNS();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLigneNS(ligneId) {
	try {

		var listLignePE = ligneId;

		if (listLignePE==null) {
			listLignePE = "";
			var nbLignes = aLignesPrepExpedition.nbLignes();
			for (i=0; i<nbLignes; i++) {
				if (parseFloat(aLignesPrepExpedition.getCellText(i, 'colQteBP')) > parseFloat(aLignesPrepExpedition.getCellText(i, 'colQtePrepa')) + parseFloat(aLignesPrepExpedition.getCellText(i, 'colQteManquante'))) {
					listLignePE += aLignesPrepExpedition.getCellText(i, 'colLigneId') +",";
				}
			}
		}

		var numSerie = document.getElementById("numeroSerie").value;

		if (!isEmpty(numSerie)) {

			var qAddNS = new QueryHttp("Facturation/Preparation_Expedition/addNumSeriePE.tmpl");
			qAddNS.setParam("Prep_Id", prepId);
			qAddNS.setParam("Num_Serie", numSerie);
			qAddNS.setParam("List_Ligne_PE", listLignePE);
			var result = qAddNS.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
				if (conflit) {
					var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
					var url = "chrome://opensi/content/facturation/user/preparation_expedition/popup-conflitNumSeriePE.xul";
					window.openDialog(url,'','chrome,modal,centerscreen', listConflit, retourChoixConflit);
				}
				else {
					document.getElementById("numeroSerie").value = "";
					aLignesPrepExpedition.initTree(afterInit);
					majPoids();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourChoixConflit(ligneId) {
	try {

		validerLigneNS(ligneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressQRC(event) {
	try {

		if (event.keyCode==13) {
			validerLigneQRC();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLigneQRC() {
	try {

		var qrCode = document.getElementById("qrCode").value;
		if(qrCode!="") {

			var qajouterArticlePrepaByQRC = new QueryHttp("Facturation/Preparation_Expedition/ajouterArticlePreparationByQRC.tmpl");
			qajouterArticlePrepaByQRC.setParam("Prep_Id",prepId);
			qajouterArticlePrepaByQRC.setParam("Depot_Id", curDepotId);
			qajouterArticlePrepaByQRC.setParam("QR_Code",qrCode);
			var result = qajouterArticlePrepaByQRC.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				document.getElementById("qrCode").value = "";
				errors.show();
			}
			else {
				document.getElementById("qrCode").value = "";
				aLignesPrepExpedition.initTree(afterInit);
				majPoids();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function nextModeSaisie() {
	try {

		switchPosition = ((switchPosition +1) % switchCount);
		selectModeSaisie();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectModeSaisie() {
	try {

		document.getElementById("labelCB").collapsed = switchPosition!=0;
		document.getElementById("codeBarre").collapsed = switchPosition!=0;
		document.getElementById("bValiderCB").collapsed = switchPosition!=0;
		if (switchPosition==0) {
			document.getElementById("codeBarre").focus();
		}

		if (switchCount==2 && actQRCode) {
			document.getElementById("labelQRC").collapsed = switchPosition!=1;
			document.getElementById("qrCode").collapsed = switchPosition!=1;
			document.getElementById("bValiderQRC").collapsed = switchPosition!=1;
			if (switchPosition==1) {
				document.getElementById("qrCode").focus();
			}
		}
		else if (switchCount==2 && suiviSerie) {

			document.getElementById("labelNS").collapsed = switchPosition!=1;
			document.getElementById("numeroSerie").collapsed = switchPosition!=1;
			document.getElementById("bValiderNS").collapsed = switchPosition!=1;
			if (switchPosition==1) {
				document.getElementById("numeroSerie").focus();
			}
		}
		else if (switchCount==3) {
			document.getElementById("labelQRC").collapsed = switchPosition!=1;
			document.getElementById("qrCode").collapsed = switchPosition!=1;
			document.getElementById("bValiderQRC").collapsed = switchPosition!=1;
			document.getElementById("labelNS").collapsed = switchPosition!=2;
			document.getElementById("numeroSerie").collapsed = switchPosition!=2;
			document.getElementById("bValiderNS").collapsed = switchPosition!=2;
			if (switchPosition==2) {
				document.getElementById("numeroSerie").focus();
			}
			else if (switchPosition==1) {
				document.getElementById("qrCode").focus();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirBP() {
	try {

		var searchNumExpedition = document.getElementById("searchNumExpeditionSaisie").value;

		if (!isEmpty(searchNumExpedition)) {
			var qSearch = new QueryHttp("Facturation/Preparation_Expedition/searchBP.tmpl");
			qSearch.setParam("Num_Expedition", searchNumExpedition);
			var result = qSearch.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				rechercherExpedition();
			}
			else {
				var documentId = result.responseXML.documentElement.getAttribute('Document_Id');
				var typeDoc = result.responseXML.documentElement.getAttribute('Type_Doc');
				prepId = result.responseXML.documentElement.getAttribute('Prep_Id');
				if (prepId!="") {
					aPrepEnCours.initTree();
					chargerPrepa();
				}
				else {
					retourRechercherExpedition(documentId, typeDoc);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function updateResponsable() {
	try {

		var qUpdateResp = new QueryHttp("Facturation/Preparation_Expedition/updateResponsable.tmpl");
		qUpdateResp.setParam("User_Id", document.getElementById("Login_Resp").value);
		qUpdateResp.setParam("Prep_Id", prepId);
		qUpdateResp.execute(initPrepanonValid);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPrepanonValid() {
	try {

		aPrepEnCours.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnSaisieBP(event) {
	try {

		if (event.keyCode==13) {
			ouvrirBP();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function genererEtiquetteTransport() {
	try {

		var prepReedition = document.getElementById('Reedition').value;

		if (!isEmpty(prepReedition)) {
			var qGen = new QueryHttp("Facturation/Preparation_Expedition/genEtiquetteTransport.tmpl");
			qGen.setParam("Prep_Id", prepReedition);
			var result = qGen.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Une nouvelle demande d'\u00E9tiquette transport a \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9e");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
