/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var bonRetourId = "";
var etablissementDefaut;
var depotRC;
var nfQte = new NumberFormat("0.###", false);



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		var result = qDepotDefaut.execute();
		depotRC = result.responseXML.documentElement.getAttribute('Depot_RC');

  	omr_init();
  	oebr_init();
		document.getElementById('deck').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 1: oebr_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuRetours() {
	try {

		document.getElementById('oebr-pdfBonRetour').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuRetours').collapsed = true;
		document.getElementById('bRetourBonRetour').collapsed = true;

		omr_listerRetours();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonRetour() {
  try {

		document.getElementById('oebr-pdfBonRetour').setAttribute("src", "");
  	oebr_initVersion();
		document.getElementById('oebr-deckBonRetour').selectedIndex = 0;
		document.getElementById('bRetourBonRetour').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
