/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var etablissementDefaut;
var depotDefaut;
var gConfig;



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gConfig = getConfig();

		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();

		if (!actUnites) {
			document.getElementById('oebr-colSymboleUnite').collapsed = true;
			document.getElementById('oebr-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebr-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oebr-colNbPieces').collapsed = true;
			document.getElementById('oebr-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebr-fieldNbPieces').collapsed = true;
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				var intituleGroupe = contenu.getAttribute("Intitule_"+ i);
				document.getElementById("oebr-colAttribut"+ i).setAttribute("label", intituleGroupe);
				document.getElementById("oerf-colAttribut"+ i +"RF").setAttribute("label", intituleGroupe);
				document.getElementById("orrf-colAttribut"+ i +"RF").setAttribute("label", intituleGroupe);
			}
			else {
				document.getElementById("oebr-colAttribut"+ i).collapsed = true;
				document.getElementById("oerf-colAttribut"+ i +"RF").collapsed = true;
				document.getElementById("orrf-colAttribut"+ i +"RF").collapsed = true;
				document.getElementById("oebr-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
				document.getElementById("oerf-colAttribut"+ i +"RF").setAttribute("ignoreincolumnpicker", true);
				document.getElementById("orrf-colAttribut"+ i +"RF").setAttribute("ignoreincolumnpicker", true);
			}
		}

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		document.getElementById('deck').selectedIndex = 0;
  	omr_init();
  	oebr_init();
		oerf_init();
		orrf_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oebr_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		switch (currentDeck) {
			case 1: oebr_demandeEnregistrement(); break;
			case 2: oerf_demandeEnregistrement(); break;
			case 3: orrf_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuRetours() {
	try {

		document.getElementById('oebr-pdfRetour').setAttribute("src", "");
		document.getElementById('oerf-pdfBonLivraison').setAttribute("src", "");
		document.getElementById('orrf-pdfBonReception').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuRetours').collapsed = true;
		document.getElementById('bRetourBonRetour').collapsed = true;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourBR').collapsed = true;

		document.activeElement.blur();
		omr_listerRetours();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonRetour() {
  try {

		document.getElementById('oebr-pdfRetour').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('oebr-deckRetour').selectedIndex = 0;
		document.getElementById('bRetourBonRetour').collapsed = true;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourBR').collapsed = true;
		oebr_chargerRetour();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonLivraison() {
  try {

		document.getElementById('oerf-pdfBonLivraison').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('oerf-deckBonLivraison').selectedIndex = 0;
		document.getElementById('bRetourExpedition').collapsed = true;
		oerf_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonReception() {
  try {

		document.getElementById('orrf-pdfBonReception').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('orrf-deckBonReception').selectedIndex = 0;
		document.getElementById('bRetourBR').collapsed = true;
		orrf_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
