/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omr_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omr-etablissement');
var omr_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'omr-depot');
var omr_aRetours = new Arbre("Facturation/Retours_Fournisseurs/list-retourFournisseur.tmpl", "omr-listeRetours");
var omr_aApercuRetour = new Arbre("Facturation/Retours_Fournisseurs/list-apercuRetourFournisseur.tmpl", "omr-apercuRetour");
var omr_qListRF = new QueryHttp("Facturation/Retours_Fournisseurs/getDataListRF.tmpl");

var omr_pageCourante;
var omr_nbPages;


function omr_init() {
	try {

		omr_aEtablissements.setParam('Selection', etablissementDefaut);
		omr_aEtablissements.initTree(omr_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initEtablissement() {
	try {

		omr_aDepots.setParam('Selection', depotDefaut);
		omr_aDepots.initTree(omr_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnNouveauRetour() {
	try {

		document.getElementById("bMenuRetours").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		oebr_nouveauRetour();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initCriteres() {
	try {

		document.getElementById('omr-numRetour').value = "";
		document.getElementById('omr-numFournisseur').value = "";
		document.getElementById('omr-denomination').value = "";
		document.getElementById('omr-etablissement').value = etablissementDefaut;
		document.getElementById('omr-depot').value = depotDefaut;
		document.getElementById('omr-dateDebut').value = "";
		document.getElementById('omr-dateFin').value = "";
		document.getElementById('omr-refArticle').value = "";
		document.getElementById('omr-etatRetour').value = "T";
		document.getElementById('omr-typeRetour').value = "";
		document.getElementById('omr-intitule').value = "";

		omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_listerRetours() {
	try {

		var numRetour = document.getElementById('omr-numRetour').value;
		var numFournisseur = document.getElementById('omr-numFournisseur').value;
		var denomination = document.getElementById('omr-denomination').value;
		var etablissement = document.getElementById('omr-etablissement').value;
		var depot = document.getElementById('omr-depot').value;
		var dateDebut = document.getElementById('omr-dateDebut').value;
		var dateFin = document.getElementById('omr-dateFin').value;
		var refArticle = document.getElementById('omr-refArticle').value;
		var etat = document.getElementById('omr-etatRetour').value;
		var typeRetour = document.getElementById('omr-typeRetour').value;
		var intitule = document.getElementById('omr-intitule').value;
		var nbLignesParPage = document.getElementById('omr-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			omr_pageCourante = 1;
			omr_nbPages = 1;
			document.getElementById('omr-pageDeb').value = 1;
			document.getElementById('omr-pageFin').value = 1;
			document.getElementById('omr-bPrec').disabled = true;
			document.getElementById('omr-bSuiv').disabled = true;

			document.getElementById('omr-listeRetours').disabled = true;
			document.getElementById('omr-bEditionCsv').disabled = true;
			document.getElementById('omr-numRetourSelect').value = "";
			omr_aApercuRetour.deleteTree();
			omr_aRetours.deleteTree();

			omr_qListRF.setParam("Num_Retour", numRetour);
			omr_qListRF.setParam("Num_Fournisseur", numFournisseur);
			omr_qListRF.setParam("Denomination", denomination);
			omr_qListRF.setParam("Etablissement", etablissement);
			omr_qListRF.setParam("Depot", depot);
			omr_qListRF.setParam("Date_Debut", dateDebut);
			omr_qListRF.setParam("Date_Fin", dateFin);
			omr_qListRF.setParam("Ref_Article", refArticle);
			omr_qListRF.setParam("Etat", etat);
			omr_qListRF.setParam("Type_Retour", typeRetour);
			omr_qListRF.setParam("Intitule", intitule);
			omr_qListRF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omr_qListRF.setParam("Current_Page", omr_pageCourante);

			var result = omr_qListRF.execute();

			var contenu = result.responseXML.documentElement;

			omr_nbPages = contenu.getAttribute("Nb_Pages");
			var listRetourId = contenu.getAttribute("List_Retour_Id");

			omr_aRetours.setParam("List_Retour_Id", listRetourId);
			omr_aRetours.initTree(omr_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initPagination() {
	try {

		document.getElementById('omr-pageDeb').value = omr_pageCourante;
		document.getElementById('omr-pageFin').value = (omr_nbPages>0?omr_nbPages:1);
		document.getElementById('omr-bPrec').disabled = (omr_pageCourante==1);
		document.getElementById('omr-bSuiv').disabled = (omr_pageCourante>=omr_nbPages); // peut se produire si omr_nbPages=0

		omr_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnPagePrec() {
	try {

		omr_pageCourante--;
		omr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnPageSuiv() {
	try {

		omr_pageCourante++;
		omr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_majPagination() {
	try {

		document.getElementById('omr-pageDeb').value = omr_pageCourante;
		document.getElementById('omr-bPrec').disabled = (omr_pageCourante==1);
		document.getElementById('omr-bSuiv').disabled = (omr_pageCourante==omr_nbPages);

		document.getElementById('omr-numRetourSelect').value = "";

		document.getElementById('omr-listeRetours').disabled = true;
		document.getElementById('omr-bEditionCsv').disabled = true;
		omr_aApercuRetour.deleteTree();

		omr_qListRF.setParam("Current_Page", omr_pageCourante);
		var result = omr_qListRF.execute();
		var listRetourId = result.responseXML.documentElement.getAttribute("List_Retour_Id");

		omr_aRetours.setParam("List_Retour_Id", listRetourId);
		omr_aRetours.initTree(omr_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_afterMajPagination() {
	try {

		document.getElementById('omr-listeRetours').disabled = false;
		document.getElementById('omr-bEditionCsv').disabled = (omr_aRetours.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_selectOnListeRetours() {
	try {

		if (omr_aRetours.isSelected()) {
			var retourId = omr_aRetours.getSelectedCellText("omr-colRetourId");
			document.getElementById('omr-numRetourSelect').value = omr_aRetours.getSelectedCellText("omr-colNumRetour");
			omr_aApercuRetour.setParam("Retour_Id", retourId);
			omr_aApercuRetour.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omr_listerRetours();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnListeRetours(ev) {
	try {

		if (ev.keyCode==13) {
			omr_ouvrirRetour();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_ouvrirRetour() {
  try {

  	if (omr_aRetours.isSelected()) {

			oebr_retourId = omr_aRetours.getSelectedCellText('omr-colRetourId');
			document.getElementById('bMenuRetours').collapsed = false;

			oebr_chargerRetour();

			document.getElementById('deck').selectedIndex = 1;

			/*var mode = document.getElementById('omr-modeTraitement').value;

			oebt_retourId = retourId;

			if (mode=="T") {
				document.getElementById('deck').selectedIndex = 1;
				orf_chargerBon();
			}
			else if (mode=="E") {
				document.getElementById('deck').selectedIndex = 2;
				oerf_retourId = retourId;
				oerf_start();
				document.getElementById('bRetourRetour').collapsed = false;
			}
			else if (mode=="R") {
				document.getElementById('deck').selectedIndex = 3;
				orrf_retourId = retourId;
				orrf_start();
				document.getElementById('bRetourRetour').collapsed = false;
			}*/
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnEditionCsv() {
	try {

		var numRetour = document.getElementById('omr-numRetour').value;
		var numFournisseur = document.getElementById('omr-numFournisseur').value;
		var denomination = document.getElementById('omr-denomination').value;
		var etablissement = document.getElementById('omr-etablissement').value;
		var depot = document.getElementById('omr-depot').value;
		var dateDebut = document.getElementById('omr-dateDebut').value;
		var dateFin = document.getElementById('omr-dateFin').value;
		var refArticle = document.getElementById('omr-refArticle').value;
		var etat = document.getElementById('omr-etatRetour').value;
		var intitule = document.getElementById('omr-intitule').value;
		var typeRetour = document.getElementById('omr-typeRetour').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Retours_Fournisseurs/csvRetourFournisseur.tmpl");
			qEditionCsv.setParam("Num_Retour", numRetour);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Depot", depot);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Type_Retour", typeRetour);
			qEditionCsv.setParam("Intitule", intitule);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omr_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('omr-numFournisseur').value = numFournisseur;
  	omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omr_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omr-refArticle').value = reference;
  	omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}
