/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oopk_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oopk-etablissement');
var oopk_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oopk-depot');
var oopk_aProvenances = new Arbre("ComboListe/combo-sitesWeb.tmpl","oopk-provenance");
var oopk_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oopk-responsable");
var oopk_aPicking = new Arbre("Facturation/Suivi_Logistique/list-picking.tmpl", "oopk-listePicking");
var oopk_aApercuLignePK = new Arbre("Facturation/Suivi_Logistique/list-apercuLignePK.tmpl", "oopk-apercuLignePK");
var oopk_aApercuPreparationPK = new Arbre("Facturation/Suivi_Logistique/list-apercuPreparationPK.tmpl", "oopk-apercuPreparationPK");
var oopk_qListPK = new QueryHttp("Facturation/Suivi_Logistique/getDataListPK.tmpl");

var oopk_pageCourante;
var oopk_nbPages;

var oopk_currentPickingId = "";



function oopk_initOngletPicking() {
	try {

		oopk_aProvenances.initTree();
		oopk_aResponsables.initTree();

		oopk_aEtablissements.setParam('Selection', gEtablissementDefaut);
		oopk_aEtablissements.initTree(oopk_initEtablissement);

		document.getElementById('oopk-boxProvenance').collapsed = !gSiteWeb;
		document.getElementById('oopk-colFirstCartonAP').collapsed = !gConfig.isSpecLNSL();

		if (!gEXLBacPrepa) {
			document.getElementById('oopk-colNumChariot').collapsed = true;
			document.getElementById('oopk-colNumChariot').setAttribute("ignoreincolumnpicker", true);

			document.getElementById('oopk-colNumBacAP').collapsed = true;
			document.getElementById('oopk-bImprEtiqBac').collapsed = true;
			document.getElementById('oopk-bEditEtiqBac').collapsed = true;
		}

		document.getElementById('oopk-boxEtat').collapsed = !gEtapePicking;
		document.getElementById('oopk-boxResponsable').collapsed = !gEtapePicking;

		if (!gEtapePicking) {
			document.getElementById('oopk-bImprEtiqBac').collapsed = true;
			document.getElementById('oopk-bEditEtiqBac').collapsed = true;

			document.getElementById('oopk-colLibEtat').collapsed = true;
			document.getElementById('oopk-colLibEtat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oopk-colResponsable').collapsed = true;
			document.getElementById('oopk-colResponsable').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oopk-colDateDebut').collapsed = true;
			document.getElementById('oopk-colDateDebut').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oopk-colDateFin').collapsed = true;
			document.getElementById('oopk-colDateFin').setAttribute("ignoreincolumnpicker", true);
		}

		if (gMWMModePicking!="C") {
			document.getElementById('oopk-bImprEtiqBac').collapsed = true;
			document.getElementById('oopk-bEditEtiqBac').collapsed = true;
		}

		if (!gEtapePicking || gMWMModePicking!='F') {
			document.getElementById('oopk-colRefBacAP').collapsed = true;
			document.getElementById('oopk-colRefBacAP').setAttribute("ignoreincolumnpicker", true);
		}

		var aAffectResp = new Arbre("ComboListe/combo-responsables.tmpl","oopk-affectResp");
		aAffectResp.initTree();

		document.getElementById('oopk-colPoids').setAttribute("label", "Poids en "+ gSymboleUnitePoids);
		document.getElementById('oopk-colVolume').setAttribute("label", "Volume en "+ gSymboleUniteVolume);

		document.getElementById('oopk-miProvenanceHL').collapsed = !gProfil.isProvenanceHL();

	} catch (e) {
		recup_erreur(e);
  }
}


function oopk_initEtablissement() {
	try {

		oopk_aDepots.setParam('Selection', gDepotDefaut);
		oopk_aDepots.initTree(oopk_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_initCriteres() {
	try {

		document.getElementById('oopk-numPicking').value = "";
		document.getElementById('oopk-datePickingDebut').value = "";
		document.getElementById('oopk-datePickingFin').value = "";
		document.getElementById('oopk-numClient').value = "";
		document.getElementById('oopk-denomination').value = "";
		document.getElementById('oopk-etablissement').value = gEtablissementDefaut;
		document.getElementById('oopk-depot').value = gDepotDefaut;
		document.getElementById('oopk-refArticle').value = "";
		document.getElementById('oopk-etatPicking').value = gEtapePicking?"N":"";
		document.getElementById('oopk-provenance').value = "";
		document.getElementById('oopk-responsable').value = "";
		document.getElementById('oopk-numCommande').value = "";
		document.getElementById('oopk-numTransfert').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_listerPicking() {
	try {

		var numPicking = document.getElementById('oopk-numPicking').value;
		var numClient = document.getElementById('oopk-numClient').value;
		var denomination = document.getElementById('oopk-denomination').value;
		var etatPicking = document.getElementById('oopk-etatPicking').value;
		var refArticle = document.getElementById('oopk-refArticle').value;
		var etablissement = document.getElementById('oopk-etablissement').value;
		var depot = document.getElementById('oopk-depot').value;
		var provenance = document.getElementById('oopk-provenance').value;
		var datePickingDebut = document.getElementById('oopk-datePickingDebut').value;
		var datePickingFin = document.getElementById('oopk-datePickingFin').value;
		var responsable = document.getElementById('oopk-responsable').value;
		var numCommande = document.getElementById('oopk-numCommande').value;
		var numTransfert = document.getElementById('oopk-numTransfert').value;
		var nbLignesParPage = document.getElementById('oopk-nbLignesParPage').value;

		if (!isEmpty(datePickingDebut) && !isDate(datePickingDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePickingFin) && !isDate(datePickingFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePickingDebut) && !isEmpty(datePickingFin) && !isDateInterval(datePickingDebut, datePickingFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			oopk_pageCourante = 1;
			oopk_nbPages = 1;
			document.getElementById('oopk-pageDeb').value = 1;
			document.getElementById('oopk-pageFin').value = 1;
			document.getElementById('oopk-bPrec').disabled = true;
			document.getElementById('oopk-bSuiv').disabled = true;

			document.getElementById('oopk-listePicking').disabled = true;
			document.getElementById('oopk-bEditionCSV').disabled = true;
			document.getElementById('oopk-bEditionPK').disabled = true;
			document.getElementById('oopk-bEditionRE').disabled = true;
			document.getElementById('oopk-bImprEtiqBac').disabled = true;
			document.getElementById('oopk-bEditEtiqBac').disabled = true;
			document.getElementById('oopk-numPickingSelect').value = "";
			oopk_aApercuLignePK.deleteTree();
			oopk_aApercuPreparationPK.deleteTree();
			oopk_aPicking.deleteTree();

			oopk_qListPK.setParam("Num_Picking", numPicking);
			oopk_qListPK.setParam("Num_Client", numClient);
			oopk_qListPK.setParam("Denomination", denomination);
			oopk_qListPK.setParam("Etat_Picking", etatPicking);
			oopk_qListPK.setParam("Ref_Article", refArticle);
			oopk_qListPK.setParam("Etablissement", etablissement);
			oopk_qListPK.setParam("Depot", depot);
			oopk_qListPK.setParam("Provenance", provenance);
			oopk_qListPK.setParam("Date_Picking_Debut", datePickingDebut);
			oopk_qListPK.setParam("Date_Picking_Fin", datePickingFin);
			oopk_qListPK.setParam("Responsable", responsable);
			oopk_qListPK.setParam("Num_Commande", numCommande);
			oopk_qListPK.setParam("Num_Transfert", numTransfert);
			oopk_qListPK.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oopk_qListPK.setParam("Current_Page", oopk_pageCourante);

			var result = oopk_qListPK.execute();

			var contenu = result.responseXML.documentElement;

			oopk_nbPages = contenu.getAttribute("Nb_Pages");
			var listPickingId = contenu.getAttribute("List_Picking_Id");

			oopk_aPicking.setParam("List_Picking_Id", listPickingId);
			oopk_aPicking.initTree(oopk_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_initPagination() {
	try {

		document.getElementById('oopk-pageDeb').value = oopk_pageCourante;
		document.getElementById('oopk-pageFin').value = (oopk_nbPages>0?oopk_nbPages:1);
		document.getElementById('oopk-bPrec').disabled = (oopk_pageCourante==1);
		document.getElementById('oopk-bSuiv').disabled = (oopk_pageCourante>=oopk_nbPages); // peut se produire si oopk_nbPages=0

		oopk_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_pressOnPagePrec() {
	try {

		oopk_pageCourante--;
		oopk_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_pressOnPageSuiv() {
	try {

		oopk_pageCourante++;
		oopk_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_majPagination() {
	try {

		document.getElementById('oopk-pageDeb').value = oopk_pageCourante;
		document.getElementById('oopk-bPrec').disabled = (oopk_pageCourante==1);
		document.getElementById('oopk-bSuiv').disabled = (oopk_pageCourante==oopk_nbPages);

		document.getElementById('oopk-listePicking').disabled = true;
		document.getElementById('oopk-bEditionCSV').disabled = true;
		document.getElementById('oopk-bEditionPK').disabled = true;
		document.getElementById('oopk-bEditionRE').disabled = true;
		document.getElementById('oopk-bImprEtiqBac').disabled = true;
		document.getElementById('oopk-bEditEtiqBac').disabled = true;
		document.getElementById('oopk-numPickingSelect').value = "";
		oopk_aApercuLignePK.deleteTree();
		oopk_aApercuPreparationPK.deleteTree();

		oopk_qListPK.setParam("Current_Page", oopk_pageCourante);
		var result = oopk_qListPK.execute();
		var listPickingId = result.responseXML.documentElement.getAttribute("List_Picking_Id");

		oopk_aPicking.setParam("List_Picking_Id", listPickingId);
		oopk_aPicking.initTree(oopk_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_afterMajPagination() {
	try {

		document.getElementById('oopk-listePicking').disabled = false;
		document.getElementById('oopk-bEditionCSV').disabled=(oopk_aPicking.nbLignes()==0);
		oopk_changeFiltreEtat();

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_selectOnListePicking() {
	try {

		if (oopk_aPicking.isSelected()) {
			oopk_currentPickingId = oopk_aPicking.getSelectedCellText('oopk-colPickingId');
			document.getElementById('oopk-numPickingSelect').value = oopk_aPicking.getSelectedCellText("oopk-colNumPicking");
			oopk_aApercuLignePK.setParam("Picking_Id", oopk_currentPickingId);
			oopk_aApercuLignePK.initTree();
			oopk_aApercuPreparationPK.setParam("Picking_Id", oopk_currentPickingId);
			oopk_aApercuPreparationPK.initTree();

			document.getElementById('oopk-bEditionPK').disabled = false;
			document.getElementById('oopk-bEditionRE').disabled = false;
			document.getElementById('oopk-bImprEtiqBac').disabled = (oopk_aPicking.getSelectedCellText('oopk-colEtat')=="N");
			document.getElementById('oopk-bEditEtiqBac').disabled = (oopk_aPicking.getSelectedCellText('oopk-colEtat')=="N");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oopk_listerPicking();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oopk_changeFiltreEtat() {
  try {

		if (document.getElementById('oopk-etatPicking').value=="N") {
			document.getElementById('oopk-boxAffectResp').collapsed = !gEtapePicking;
			document.getElementById('oopk-colSelect').collapsed = !gEtapePicking;
			document.getElementById('oopk-bCocher').collapsed = !gEtapePicking;
			document.getElementById('oopk-bDecocher').collapsed = !gEtapePicking;
		}
		else {
			document.getElementById('oopk-boxAffectResp').collapsed = true;
			document.getElementById('oopk-colSelect').collapsed = true;
			document.getElementById('oopk-bCocher').collapsed = true;
			document.getElementById('oopk-bDecocher').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oopk_toutCocherPicking(b) {
	try {

		for (var i=0; i<oopk_aPicking.nbLignes(); i++) {
			if (oopk_aPicking.isEditable(i, "oopk-colSelect")) {
				oopk_aPicking.setCellValue(i, "oopk-colSelect", b);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_pressOnListePicking(ev) {
	try {

		if (ev.keyCode==32 && oopk_aPicking.isSelected()) {
			oopk_aPicking.setSelectedCellValue("oopk-colSelect", oopk_aPicking.getSelectedCellValue("oopk-colSelect")=="false");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_affecterResponsable() {
  try {

		var responsable = document.getElementById('oopk-affectResp').value;
		var listPickingId = "";

		for (var i=0; i<oopk_aPicking.nbLignes(); i++) {
			if (oopk_aPicking.getCellValue(i, "oopk-colSelect")=="true") {
				listPickingId += oopk_aPicking.getCellText(i, "oopk-colPickingId") +",";
			}
  	}

		if (isEmpty(responsable)) {
			showWarning("Veuillez s\u00E9lectionner le responsable \u00E0 affecter aux picking");
		}
		else if (isEmpty(listPickingId)) {
			showWarning("Veuillez cocher au moins un picking");
		}
		else {
			var qAffect = new QueryHttp("Facturation/Suivi_Logistique/affectResponsablePicking.tmpl");

			qAffect.setParam("List_Picking_Id", listPickingId);
			qAffect.setParam("Util_R", responsable);

			var result = qAffect.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oopk_listerPicking();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oopk_pressOnEditionCSV() {
	try {

		var numPicking = document.getElementById('oopk-numPicking').value;
		var numClient = document.getElementById('oopk-numClient').value;
		var denomination = document.getElementById('oopk-denomination').value;
		var etatPicking = document.getElementById('oopk-etatPicking').value;
		var refArticle = document.getElementById('oopk-refArticle').value;
		var etablissement = document.getElementById('oopk-etablissement').value;
		var depot = document.getElementById('oopk-depot').value;
		var provenance = document.getElementById('oopk-provenance').value;
		var datePickingDebut = document.getElementById('oopk-datePickingDebut').value;
		var datePickingFin = document.getElementById('oopk-datePickingFin').value;
		var responsable = document.getElementById('oopk-responsable').value;
		var numCommande = document.getElementById('oopk-numCommande').value;
		var numTransfert = document.getElementById('oopk-numTransfert').value;

		if (!isEmpty(datePickingDebut) && !isDate(datePickingDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePickingFin) && !isDate(datePickingFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePickingDebut) && !isEmpty(datePickingFin) && !isDateInterval(datePickingDebut, datePickingFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			var qEditionCSV = new QueryHttp("Facturation/Suivi_Logistique/csvPicking.tmpl");

			qEditionCSV.setParam("Num_Picking", numPicking);
			qEditionCSV.setParam("Num_Client", numClient);
			qEditionCSV.setParam("Denomination", denomination);
			qEditionCSV.setParam("Etat_Picking", etatPicking);
			qEditionCSV.setParam("Ref_Article", refArticle);
			qEditionCSV.setParam("Etablissement", etablissement);
			qEditionCSV.setParam("Depot", depot);
			qEditionCSV.setParam("Provenance", provenance);
			qEditionCSV.setParam("Date_Picking_Debut", datePickingDebut);
			qEditionCSV.setParam("Date_Picking_Fin", datePickingFin);
			qEditionCSV.setParam("Responsable", responsable);
			qEditionCSV.setParam("Num_Commande", numCommande);
			qEditionCSV.setParam("Num_Transfert", numTransfert);

			var result = qEditionCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_editionPK() {
	try {

		if (oopk_aPicking.isSelected()) {

			var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfBonPicking.tmpl");
			qEditionPDF.setParam('Picking_Id', oopk_currentPickingId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEditionPDF.execute(oopk_editionPK_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_editionPK_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_editionRE() {
	try {

		if (oopk_aPicking.isSelected()) {

			var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfRecapitulatifExpedition.tmpl");
			qEditionPDF.setParam('Picking_Id', oopk_currentPickingId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEditionPDF.execute(oopk_editionRE_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_editionRE_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_imprimerEtiquettesBacs() {
	try {

		if (oopk_aPicking.isSelected()) {
			var qPrint = new QueryHttp("Facturation/Suivi_Logistique/printEtiquetteBacPicking.tmpl");
			qPrint.setParam("Picking_Id", oopk_currentPickingId);
			var result = qPrint.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Les \u00E9tiquettes ont \u00E9t\u00E9 envoy\u00E9es en impression");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_editerEtiquettesBacs() {
	try {

		if (oopk_aPicking.isSelected()) {
			var qEtiq = new QueryHttp("Facturation/Suivi_Logistique/pdfEtiquetteBacPicking.tmpl");
			qEtiq.setParam("Picking_Id", oopk_currentPickingId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEtiq.execute(oopk_editerEtiquettesBacs_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_editerEtiquettesBacs_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oopk_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_retourRechercherClient(numClient) {
	try {

  	document.getElementById('oopk-numClient').value = numClient;
  	oopk_listerPicking();

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oopk_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function oopk_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('oopk-refArticle').value = reference;
  	oopk_listerPicking();

	} catch (e) {
		recup_erreur(e);
	}
}
