/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oarnf_aReglements = new Arbre("Facturation/Suivi_Reglements_Clients/list-acompteRecuNonFacture.tmpl", "oarnf-listeReglements");
var oarnf_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oarnf-filtreModeReglement');
var oarnf_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oarnf-etablissement');

var oarnf_qListAR = new QueryHttp("Facturation/Suivi_Reglements_Clients/getDataListAR.tmpl");

var oarnf_currentReglementId;
var oarnf_tabLoaded = false;

var oarnf_pageCourante;
var oarnf_nbPages;



function oarnf_init() {
  try {

		if (!oarnf_tabLoaded) {
			oarnf_tabLoaded = true;

			oarnf_aModesReglements.initTree(oarnf_initFiltreModeReglement);

			if (gReadOnly) {
				document.getElementById('oarnf-bChangerReglement').collapsed = true;
				document.getElementById('oarnf-bChangerCommande').collapsed = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oarnf_initFiltreModeReglement() {
  try {

  	document.getElementById('oarnf-filtreModeReglement').selectedIndex=0;
  	oarnf_aEtablissements.setParam('Selection', etablissementDefaut);
		oarnf_aEtablissements.initTree(oarnf_initEtablissement);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oarnf_initEtablissement() {
	try {

		document.getElementById('oarnf-etablissement').value = etablissementDefaut;
		oarnf_initListeReglements();

	} catch (e) {
    recup_erreur(e);
  }
}


function oarnf_initListeReglements() {
	try {

		var dateDebut = document.getElementById('oarnf-dateDebut').value;
		var dateFin = document.getElementById('oarnf-dateFin').value;
		var modeReglement = document.getElementById('oarnf-filtreModeReglement').value;
		var numClient = document.getElementById('oarnf-numClient').value;
		var chkAffecter = document.getElementById('oarnf-chkAffecter').checked;
		var etablissement = document.getElementById('oarnf-etablissement').value;
		var nbLignesParPage = document.getElementById('oarnf-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else {

			oarnf_pageCourante = 1;
			oarnf_nbPages = 1;
			document.getElementById('oarnf-pageDeb').value = 1;
			document.getElementById('oarnf-pageFin').value = 1;
			document.getElementById('oarnf-bPrec').disabled = true;
			document.getElementById('oarnf-bSuiv').disabled = true;

			document.getElementById('oarnf-bEditionCsv').disabled = true;
			document.getElementById('oarnf-bChangerReglement').disabled = true;
			document.getElementById('oarnf-bChangerCommande').disabled = true;
			document.getElementById('oarnf-listeReglements').disabled = true;

			oarnf_currentReglementId = "";
			oarnf_aReglements.deleteTree();

			oarnf_qListAR.setParam("Date_Debut", dateDebut);
			oarnf_qListAR.setParam("Date_Fin", dateFin);
			oarnf_qListAR.setParam("Mode_Reglement", modeReglement);
			oarnf_qListAR.setParam("Num_Client", numClient);
			oarnf_qListAR.setParam("Affecter", chkAffecter);
			oarnf_qListAR.setParam("Etablissement", etablissement);
			oarnf_qListAR.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oarnf_qListAR.setParam("Current_Page", oarnf_pageCourante);

			var result = oarnf_qListAR.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('oarnf-totalReglement').value = contenu.getAttribute("Total");
			document.getElementById('oarnf-totalRestant').value = contenu.getAttribute("Restant");

			oarnf_nbPages = contenu.getAttribute("Nb_Pages");
			var listReglementId = contenu.getAttribute("List_Reglement_Id");

			oarnf_aReglements.setParam("List_Reglement_Id", listReglementId);
			oarnf_aReglements.initTree(oarnf_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_initPagination() {
	try {

		document.getElementById('oarnf-pageDeb').value = oarnf_pageCourante;
		document.getElementById('oarnf-pageFin').value = (oarnf_nbPages>0?oarnf_nbPages:1);
		document.getElementById('oarnf-bPrec').disabled = (oarnf_pageCourante==1);
		document.getElementById('oarnf-bSuiv').disabled = (oarnf_pageCourante>=oarnf_nbPages); // peut se produire si nbPages=0

		oarnf_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_pressOnPagePrec() {
	try {

		oarnf_pageCourante--;
		oarnf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_pressOnPageSuiv() {
	try {

		oarnf_pageCourante++;
		oarnf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_majPagination() {
	try {

		document.getElementById('oarnf-pageDeb').value = oarnf_pageCourante;
		document.getElementById('oarnf-bPrec').disabled = (oarnf_pageCourante==1);
		document.getElementById('oarnf-bSuiv').disabled = (oarnf_pageCourante==oarnf_nbPages);

		document.getElementById('oarnf-bChangerReglement').disabled = true;
		document.getElementById('oarnf-bChangerCommande').disabled = true;
		document.getElementById('oarnf-listeReglements').disabled = true;
		oarnf_currentReglementId = "";

		oarnf_qListAR.setParam("Current_Page", oarnf_pageCourante);
		var result = oarnf_qListAR.execute();
		var listReglementId = result.responseXML.documentElement.getAttribute("List_Reglement_Id");

		oarnf_aReglements.setParam("List_Reglement_Id", listReglementId);
		oarnf_aReglements.initTree(oarnf_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_afterMajPagination() {
	try {

		document.getElementById('oarnf-bEditionCsv').disabled = (oarnf_aReglements.nbLignes()==0);
		document.getElementById('oarnf-listeReglements').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_reinitialiser() {
	try {

		document.getElementById('oarnf-dateDebut').value = "";
		document.getElementById('oarnf-dateFin').value = "";
		document.getElementById('oarnf-filtreModeReglement').selectedIndex = 0;
		document.getElementById('oarnf-numClient').value = "";
		document.getElementById('oarnf-chkAffecter').checked = true;
		document.getElementById('oarnf-etablissement').value = etablissementDefaut;

		oarnf_initListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oarnf_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_retourRechercherClient(numClient) {
	try {

  	document.getElementById('oarnf-numClient').value = numClient;
  	oarnf_initListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_onKeyPress(event) {
	try {
		document.getElementById('oarnf-bEditionCsv').disabled = true;
		if (event.keyCode==13) {
			oarnf_initListeReglements();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_selectOnListeReglements() {
	try {

		if (oarnf_aReglements.isSelected()) {
			var nbSelection = oarnf_aReglements.nbSelection();
			var i = oarnf_aReglements.getCurrentIndex();
			var surplus = false;
			oarnf_currentReglementId = "";

			if (nbSelection>0) {
				var checkSurplus = true;
				surplus = true;
				var rangeCount = oarnf_aReglements.getRangeCount();
				for (var j=0; j<rangeCount; j++) {
					var start = {};
					var end = {};
					oarnf_aReglements.getRangeAt(j,start,end);

					for (var c=start.value; c<=end.value; c++) {
						if (!isEmpty(oarnf_currentReglementId)) { oarnf_currentReglementId += ",";  }
						oarnf_currentReglementId += oarnf_aReglements.getCellText(c, 'oarnf-colReglementId');

						if (checkSurplus && oarnf_aReglements.getCellText(c, 'oarnf-colSurplus')=="false") {
							surplus = false;
							checkSurplus = false;
						}
					}
				}
			}

			document.getElementById('oarnf-bChangerReglement').disabled = (nbSelection==0 || !surplus);
			document.getElementById('oarnf-bChangerCommande').disabled = (nbSelection!=1 || !surplus);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_pressOnChangerReglement() {
	try {

		if (window.confirm("Voulez-vous d\u00E9placer les r\u00E8glements s\u00E9lectionn\u00E9s dans l'onglet R\u00E8glements ?")) {
			var qUnlink = new QueryHttp("Facturation/Suivi_Reglements_Clients/unlinkReglementCommandeLot.tmpl");
			qUnlink.setParam("List_Reglement_Id", oarnf_currentReglementId);
			var result = qUnlink.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oarnf_retourDesaffecter();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_pressOnChangerCommande() {
	try {

		var numCommande = oarnf_aReglements.getSelectedCellText("oarnf-colNumCommande");
		var clientId = oarnf_aReglements.getSelectedCellText("oarnf-colClientId");

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-changerCommandeReglAnticipe.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oarnf_currentReglementId, oarnf_retourDesaffecter, numCommande, clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_retourDesaffecter() {
	try {

		oarnf_initListeReglements();
		orbt_initListeRemboursements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oarnf_pressOnEditionCsv() {
	try {

		var dateDebut = document.getElementById('oarnf-dateDebut').value;
		var dateFin = document.getElementById('oarnf-dateFin').value;
		var modeReglement = document.getElementById('oarnf-filtreModeReglement').value;
		var numClient = document.getElementById('oarnf-numClient').value;
		var chkAffecter = document.getElementById('oarnf-chkAffecter').checked;
		var etablissement = document.getElementById('oarnf-etablissement').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Clients/csvAcompteRecuNonFacture.tmpl");

			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Affecter", chkAffecter);
			qEditionCsv.setParam("Etablissement", etablissement);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


