/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var orf_aReleves = new Arbre("Facturation/Suivi_Reglements_Clients/list-releveFacturation.tmpl", "orf-listeReleves");
var orf_aFiltreModesReglement = new Arbre('ComboListe/combo-modesReglement.tmpl', 'orf-filtreModeReglement');
var orf_aFiltreEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'orf-filtreEtablissement');

var orf_tabLoaded = false;



function orf_init() {
  try {

		if (!orf_tabLoaded) {
			orf_tabLoaded = true;
 			orf_aFiltreModesReglement.initTree(orf_initFiltreModeReglement);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orf_initFiltreModeReglement() {
	try {

    orf_aFiltreEtablissements.initTree(orf_initCriteres);

	} catch (e) {
    recup_erreur(e);
  }
}


function orf_initCriteres() {
	try {

		document.getElementById('orf-filtreEtablissement').value = etablissementDefaut;
		document.getElementById('orf-filtreNumClient').value = "";
		document.getElementById('orf-filtreDenomination').value = "";
		document.getElementById('orf-filtreDateDebut').value = "";
		document.getElementById('orf-filtreDateFin').value = "";
		document.getElementById('orf-filtreModeReglement').value = "";
		document.getElementById('orf-filtreNonSolde').checked = true;
		document.getElementById('orf-filtreNonAffecte').checked = true;

		orf_manageFiltreNonAffecte();

		orf_listerReleveFacturation();

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_pressOnCritere(ev) {
  try {

		document.getElementById('orf-bEditionPDF').disabled = true;

		if (ev.keyCode==13) {
			orf_listerReleveFacturation();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function orf_toutCocher(b) {
	try {

		for (var i=0; i<orf_aReleves.nbLignes(); i++) {
			orf_aReleves.setCellValue(i, "orf-colSelReleve", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_manageFiltreNonAffecte() {
	try {

		if (document.getElementById('orf-filtreNonAffecte').checked) {
			document.getElementById('orf-colDontNonAffecte').collapsed = false;
			document.getElementById('orf-colDontNonAffecte').removeAttribute('ignoreincolumnpicker');
		}
		else {
			document.getElementById('orf-colDontNonAffecte').collapsed = true;
			document.getElementById('orf-colDontNonAffecte').setAttribute('ignoreincolumnpicker', true);
		}

	} catch (e) {
		recup_erreur(e);
	}

}


function orf_listerReleveFacturation() {
	try {

		var etablissement = document.getElementById('orf-filtreEtablissement').value;
		var numClient = document.getElementById('orf-filtreNumClient').value;
		var denomination = document.getElementById('orf-filtreDenomination').value;
		var dateDebut = document.getElementById('orf-filtreDateDebut').value;
		var dateFin = document.getElementById('orf-filtreDateFin').value;
		var modeReglement = document.getElementById('orf-filtreModeReglement').value;
		var nonSolde = document.getElementById('orf-filtreNonSolde').checked;
		var nonAffecte = document.getElementById('orf-filtreNonAffecte').checked;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			orf_aReleves.setParam("Etablissement", etablissement);
			orf_aReleves.setParam("Num_Client", numClient);
			orf_aReleves.setParam("Denomination", denomination);
			orf_aReleves.setParam("Date_Debut", dateDebut);
			orf_aReleves.setParam("Date_Fin", dateFin);
			orf_aReleves.setParam("Mode_Reglement", modeReglement);
			orf_aReleves.setParam("Non_Solde", nonSolde);
			orf_aReleves.setParam("Non_Affecte", nonAffecte);

			orf_aReleves.initTree();

			document.getElementById('orf-bEditionPDF').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_pressOnEditionPDF() {
	try {

		orf_editerPDF();

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_editerPDF() {
	try {

		var listClientId = "";

		for (var i=0; i<orf_aReleves.nbLignes(); i++) {
			if (orf_aReleves.getCellValue(i, "orf-colSelReleve")=="true") {
				listClientId += orf_aReleves.getCellText(i, "orf-colClientId") +",";
			}
  	}

		var etablissement = document.getElementById('orf-filtreEtablissement').value;
		var dateDebut = document.getElementById('orf-filtreDateDebut').value;
		var dateFin = document.getElementById('orf-filtreDateFin').value;
		var modeReglement = document.getElementById('orf-filtreModeReglement').value;
		var nonSolde = document.getElementById('orf-filtreNonSolde').checked;
		var nonAffecte = document.getElementById('orf-filtreNonAffecte').checked;

		var optionDetail = document.getElementById('optionDetailRF').checked;
		var optionTri = document.getElementById('optionTriRF').value;
		var optionSousTotaux = document.getElementById('optionSousTotauxRF').checked;

		if (isEmpty(listClientId)) {
			showWarning("Veuillez cocher au moins un relev\u00E9");
		}
		else if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionPdf = new QueryHttp("Facturation/Suivi_Reglements_Clients/pdfReleveFacturation.tmpl");

			qEditionPdf.setParam('List_Client_Id', listClientId);
			qEditionPdf.setParam("Etablissement", etablissement);
			qEditionPdf.setParam("Date_Debut", dateDebut);
			qEditionPdf.setParam("Date_Fin", dateFin);
			qEditionPdf.setParam("Mode_Reglement", modeReglement);
			qEditionPdf.setParam("Non_Solde", nonSolde);
			qEditionPdf.setParam("Non_Affecte", nonAffecte);
			qEditionPdf.setParam("Detail", optionDetail);
      qEditionPdf.setParam("Tri", optionTri);
      qEditionPdf.setParam("Sous_Totaux", optionSousTotaux);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
      	var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				switchPdf(page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_pressOnEnvoyer() {
	try {

		var listClientId = "";

		for (var i=0; i<orf_aReleves.nbLignes(); i++) {
			if (orf_aReleves.getCellValue(i, "orf-colSelReleve")=="true") {
				listClientId += orf_aReleves.getCellText(i, "orf-colClientId") +",";
			}
  	}

		var etablissement = document.getElementById('orf-filtreEtablissement').value;
		var dateDebut = document.getElementById('orf-filtreDateDebut').value;
		var dateFin = document.getElementById('orf-filtreDateFin').value;
		var modeReglement = document.getElementById('orf-filtreModeReglement').value;
		var nonSolde = document.getElementById('orf-filtreNonSolde').checked;
		var nonAffecte = document.getElementById('orf-filtreNonAffecte').checked;

		var optionDetail = document.getElementById('optionDetailRF').checked;
		var optionTri = document.getElementById('optionTriRF').value;
		var optionSousTotaux = document.getElementById('optionSousTotauxRF').checked;

		if (isEmpty(listClientId)) {
			showWarning("Veuillez cocher au moins un relev\u00E9");
		}
		else if (window.confirm("Confirmez-vous l'envoi par e-mail des relev\u00E9s de facturation ?")) {

			var qSend = new QueryHttp("Facturation/Suivi_Reglements_Clients/sendReleveFacturation.tmpl");

			qSend.setParam('List_Client_Id', listClientId);
			qSend.setParam("Etablissement", etablissement);
			qSend.setParam("Date_Debut", dateDebut);
			qSend.setParam("Date_Fin", dateFin);
			qSend.setParam("Mode_Reglement", modeReglement);
			qSend.setParam("Non_Solde", nonSolde);
			qSend.setParam("Non_Affecte", nonAffecte);
			qSend.setParam("Detail", optionDetail);
      qSend.setParam("Tri", optionTri);
      qSend.setParam("Sous_Totaux", optionSousTotaux);

			var result = qSend.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
      	showMessage("Les relev\u00E9s de facturation ont \u00E9t\u00E9 envoy\u00E9s aux clients");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orf_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function orf_retourRechercherClient(codeClient) {
	try {

		document.getElementById('orf-filtreNumClient').value = codeClient;
  	orf_listerReleveFacturation();

	} catch (e) {
		recup_erreur(e);
	}
}
