/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var remboursementId;



function init() {
  try {

  	window.resizeTo(800,400);

  	remboursementId = window.arguments[0];

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "codePays");
		aPays.initTree(initPays);

  } catch (e) {
    recup_erreur(e);
  }
}


function initPays() {
	try {

    document.getElementById('codePays').value = "FR";
    preRemplir();

	} catch (e) {
    recup_erreur(e);
  }
}


function preRemplir() {
	try {

    var qGet = new QueryHttp("Facturation/Suivi_Reglements_Clients/getAdresseDefautRemboursementClient.tmpl");
    qGet.setParam("Remboursement_Id", remboursementId);
    var result = qGet.execute();
    var contenu = result.responseXML.documentElement;

    document.getElementById('denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('adresse1').value = contenu.getAttribute("Adresse_1");
		document.getElementById('adresse2').value = contenu.getAttribute("Adresse_2");
		document.getElementById('adresse3').value = contenu.getAttribute("Adresse_3");
		document.getElementById('codePostal').value = contenu.getAttribute("Code_Postal");
		document.getElementById('ville').value = contenu.getAttribute("Ville");
		document.getElementById('codePays').value = contenu.getAttribute("Code_Pays");

	} catch (e) {
    recup_erreur(e);
  }
}


function valider() {
  try {

    var denomination = document.getElementById('denomination').value;
		var adresse1 = document.getElementById('adresse1').value;
		var adresse2 = document.getElementById('adresse2').value;
		var adresse3 = document.getElementById('adresse3').value;
		var codePostal = document.getElementById('codePostal').value;
		var ville = document.getElementById('ville').value;
		var codePays = document.getElementById('codePays').value;

		if (isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination du destinataire !"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez sp\u00E9cifier l'adresse !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville !"); }
		else if (window.confirm("Voulez-vous \u00E9diter une lettre de remboursement pour cette adresse ?")) {
			window.arguments[1](denomination, adresse1, adresse2, adresse3, codePostal, ville, codePays);
			window.close();
		}

  } catch (e) {
  	recup_erreur(e);
  }
}

