/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var echeanceId;
var chargerModeReg;
var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');



function init() {
  try {

  	echeanceId = window.arguments[0];

  	var qEcheance = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/getEcheanceFournisseur.tmpl");
  	qEcheance.setParam("Echeance_Id", echeanceId);
		var result = qEcheance.execute();
		document.getElementById('lblAncienneDateEch').value = result.responseXML.documentElement.getAttribute("Echeance_Initiale");
		document.getElementById('nouvelleDateEch').value = result.responseXML.documentElement.getAttribute("Date_Echeance");
		chargerModesReglements(result.responseXML.documentElement.getAttribute("Mode_Reg_Id"));
		document.getElementById('commentaires').value = result.responseXML.documentElement.getAttribute("Commentaires");

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerModesReglements(selection) {
	try {

		chargerModeReg = selection;
		aModesReglements.setParam("Selection", chargerModeReg);
		aModesReglements.initTree(initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function initModeReglement() {
	try {

    document.getElementById('modeReglement').value = chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrer() {
	try {

		var dateEcheance = document.getElementById('nouvelleDateEch').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var commentaires = document.getElementById('commentaires').value;

		if (isEmpty(dateEcheance) || !isDate(dateEcheance)) { showWarning("Date incorrecte !"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else {
			var qModifierEcheance = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/updateEcheanceFournisseur.tmpl");
			qModifierEcheance.setParam("Echeance_Id", echeanceId);
			qModifierEcheance.setParam("Date_Echeance", dateEcheance);
			qModifierEcheance.setParam("Mode_Reg_Id", modeReglement);
			qModifierEcheance.setParam("Commentaires", commentaires);
			qModifierEcheance.execute();

			window.arguments[1]();
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
