/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omtb_aFamille2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'omtb-famille2');
var omtb_aFamille3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'omtb-famille3');

var omtb_web;
var omtb_graphs;
var omtb_direction;


function omtb_init() {
  try {

		document.getElementById('omtb-typeGraphique').disabled = true;
		document.getElementById('omtb-bEditionCSV').disabled = true;
		document.getElementById('omtb-bEditionDetailCSV').disabled = true;

		var profil = getProfil();

		document.getElementById('omtb-miProvenanceHL').collapsed = !profil.isProvenanceHL();

		omtb_direction = profil.isDirection();

		if (!omtb_direction) {
			document.getElementById('omtb-responsable').disabled = true;
		}

		var aFamilleClient = new Arbre('ComboListe/combo-famillesClient.tmpl', 'omtb-familleClient');
		aFamilleClient.initTree();

		var aFamilleFournisseur = new Arbre('ComboListe/combo-famillesFournisseur.tmpl', 'omtb-familleFournisseur');
		aFamilleFournisseur.initTree();

		var aFamille1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'omtb-famille1');
		aFamille1.initTree();

		var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'omtb-marque');
		aMarques.initTree();

		var aPoles = new Arbre("ComboListe/combo-polesActivite.tmpl", "omtb-poleActivite");
		aPoles.initTree();

		var aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omtb-etablissement');
		aEtablissements.initTree();

		omtb_web = getConfig().isECommerce();

		if (!omtb_web && document.getElementById("omtb-typeGraphique").value=="RP") document.getElementById("omtb-typeGraphique").value = "RE";

		var aProvenance = new Arbre("ComboListe/combo-sitesWeb.tmpl", "omtb-provenance");
		aProvenance.initTree();

		if (document.getElementById("omtb-periodeRep").value=="PP") document.getElementById("omtb-periodeRep").value = "J";

		omtb_switchCategorie('V');

		var aResponsable = new Arbre('ComboListe/combo-responsables.tmpl', 'omtb-responsable');
		aResponsable.initTree(omtb_initResponsable);

	} catch (e) {
  	recup_erreur(e);
  }
}


function omtb_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('omtb-famille1').value;

		if (isEmpty(famille1)) {
			omtb_aFamille2.deleteTree();
			omtb_initFamille2();
		}
		else {
			omtb_aFamille2.setParam('Parent_Id', famille1);
			omtb_aFamille2.initTree(omtb_initFamille2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_initFamille2() {
  try {

		document.getElementById('omtb-famille2').selectedIndex = 0;
		omtb_chargerFamilles3();

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('omtb-famille2').value;

		if (isEmpty(famille2)) {
			omtb_aFamille3.deleteTree();
			omtb_initFamille3();
		}
		else {
			omtb_aFamille3.setParam('Parent_Id', famille2);
			omtb_aFamille3.initTree(omtb_initFamille3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_initFamille3() {
  try {

		document.getElementById('omtb-famille3').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_initResponsable() {
	try {

		if (!omtb_direction) {
			document.getElementById('omtb-responsable').value = getProfil().getLoggedUser();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_switchCategorie() {
  try {

		if (document.getElementById("omtb-categorie").value=="V") {
			document.getElementById('omtb-bcWeb').collapsed = !omtb_web;
			document.getElementById("omtb-bcVente").collapsed = false;
			document.getElementById("omtb-bcAchat").collapsed = true;
		}
		else {
			document.getElementById('omtb-bcWeb').collapsed = true;
			document.getElementById("omtb-bcAchat").collapsed = false;
			document.getElementById("omtb-bcVente").collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omtb_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', omtb_retourRechercherClient);

  } catch (e) {
    recup_erreur(e);
  }
}


function omtb_retourRechercherClient(numClient) {
	try {

		document.getElementById('omtb-numClient').value = numClient;
		omtb_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', omtb_retourRechercherFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function omtb_retourRechercherFournisseur(numFournisseur) {
	try {

		document.getElementById('omtb-numFournisseur').value = numFournisseur;
		omtb_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omtb_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omtb-refArticle').value = reference;
		omtb_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_calcPercent(numerateur, denominateur) {
	try {

		var fper = new NumberFormat("0", false);

		return parseFloat(denominateur)!=0?fper.format(numerateur / denominateur * 100) +" %":"-";

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_formatTaux(taux) {
	try {

		var ftx = new NumberFormat("0.00", false);

		return isEmpty(taux)?"-":ftx.format(taux) +" %";

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_initCriteres() {
	try {

		document.getElementById('omtb-marque').value = "";
		document.getElementById('omtb-famille1').value = "";
		document.getElementById('omtb-famille2').value = "";
		document.getElementById('omtb-famille3').value = "";
		document.getElementById('omtb-refArticle').value = "";
		document.getElementById('omtb-provenance').value = "";
		document.getElementById('omtb-etablissement').value = "";
		document.getElementById('omtb-poleActivite').value = "";
		document.getElementById('omtb-numClient').value = "";
		document.getElementById('omtb-numFournisseur').value = "";
		document.getElementById('omtb-familleFournisseur').value = "";
		document.getElementById('omtb-familleClient').value = "";
		document.getElementById('omtb-responsable').value = "";

		omtb_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_changeTypeAndCat(typeTB, categorie) {
	try {

		if (typeTB=="F") {
			document.getElementById("omtb-lblGraphEvolCA").value = "Evolution du CA HT factur\u00E9 :";
			document.getElementById("omtb-lblGraphEvolNB").value = "Evolution du nombre de factures :";
			document.getElementById("omtb-lblGraphEvolMA").value = "Evolution de la marge HT factur\u00E9e :";
			document.getElementById("omtb-lblGraphEvolDetailCA").value = "Evolution du CA HT factur\u00E9 pour le mois de";
			document.getElementById("omtb-lblGraphEvolDetailNB").value = "Evolution du nombre de factures pour le mois de";
			document.getElementById("omtb-lblTitreTableau").value = "Chiffre d'affaires et nombre de factures par p\u00E9riodes :";
			document.getElementById("omtb-colNbFiltre").value = "Nb factures filtr\u00E9";
			document.getElementById("omtb-colCAFiltre").value = "CA factur\u00E9 filtr\u00E9";
			document.getElementById("omtb-colNbTotal").value = "Nb factures total";
			document.getElementById("omtb-colCATotal").value = "CA factur\u00E9 total";
			document.getElementById("omtb-colPNbTotal").value = "% Nb factures filtr\u00E9 / total";
			document.getElementById("omtb-colPCATotal").value = "% CA factur\u00E9 filtr\u00E9 / total";
			document.getElementById("omtb-colTmqFiltre").value = "Tx marque % filtr\u00E9";
			document.getElementById("omtb-colTmqTotal").value = "Tx marque % total";
			document.getElementById("omtb-lblTitreTableauDetail").value = "D\u00E9tail journalier des factures pour le mois de";
			document.getElementById("omtb-colNbFiltreDetail").value = "Nb factures filtr\u00E9";
			document.getElementById("omtb-colCAFiltreDetail").value = "CA factur\u00E9 filtr\u00E9";
			document.getElementById("omtb-colNbTotalDetail").value = "Nb factures total";
			document.getElementById("omtb-colCATotalDetail").value = "CA factur\u00E9 total";
			document.getElementById("omtb-colPNbTotalDetail").value = "% Nb factures filtr\u00E9 / total";
			document.getElementById("omtb-colPCATotalDetail").value = "% CA factur\u00E9 filtr\u00E9 / total";
		}
		else {
			document.getElementById("omtb-lblGraphEvolCA").value = "Evolution du CA HT command\u00E9 :";
			document.getElementById("omtb-lblGraphEvolNB").value = "Evolution du nombre de commandes :";
			document.getElementById("omtb-lblGraphEvolMA").value = "Evolution de la marge HT command\u00E9e :";
			document.getElementById("omtb-lblGraphEvolDetailCA").value = "Evolution du CA HT command\u00E9 pour le mois de";
			document.getElementById("omtb-lblGraphEvolDetailNB").value = "Evolution du nombre de commandes pour le mois de";
			document.getElementById("omtb-lblTitreTableau").value = "Chiffre d'affaires et nombre de commandes par p\u00E9riodes :";
			document.getElementById("omtb-colNbFiltre").value = "Nb commandes filtr\u00E9";
			document.getElementById("omtb-colCAFiltre").value = "CA command\u00E9 filtr\u00E9";
			document.getElementById("omtb-colNbTotal").value = "Nb commandes total";
			document.getElementById("omtb-colCATotal").value = "CA command\u00E9 total";
			document.getElementById("omtb-colPNbTotal").value = "% Nb commandes filtr\u00E9 / total";
			document.getElementById("omtb-colPCATotal").value = "% CA command\u00E9 filtr\u00E9 / total";
			document.getElementById("omtb-colTmqFiltre").value = "Tx marque % filtr\u00E9";
			document.getElementById("omtb-colTmqTotal").value = "Tx marque % total";
			document.getElementById("omtb-lblTitreTableauDetail").value = "D\u00E9tail journalier des commandes pour le mois de";
			document.getElementById("omtb-colNbFiltreDetail").value = "Nb commandes filtr\u00E9";
			document.getElementById("omtb-colCAFiltreDetail").value = "CA command\u00E9 filtr\u00E9";
			document.getElementById("omtb-colNbTotalDetail").value = "Nb commandes total";
			document.getElementById("omtb-colCATotalDetail").value = "CA command\u00E9 total";
			document.getElementById("omtb-colPNbTotalDetail").value = "% Nb commandes filtr\u00E9 / total";
			document.getElementById("omtb-colPCATotalDetail").value = "% CA command\u00E9 filtr\u00E9 / total";
		}

		var typeG = document.getElementById("omtb-typeGraphique").value;

		if (categorie=="V") {
			document.getElementById("omtb-gcVente").collapsed = false;
			document.getElementById("omtb-lblTabRepartition").setAttribute("label", "R\u00E9partition des ventes");
			document.getElementById("omtb-lblTabEvolution").setAttribute("label", "Evolution des ventes");
			if (typeG=="RF") document.getElementById("omtb-typeGraphique").value = "RC";
			if (typeG=="RFF") document.getElementById("omtb-typeGraphique").value = "RFC";
		}
		else {
			document.getElementById("omtb-gcVente").collapsed = true;
			document.getElementById("omtb-lblTabRepartition").setAttribute("label", "R\u00E9partition des achats");
			document.getElementById("omtb-lblTabEvolution").setAttribute("label", "Evolution des achats");
			if (typeG=="RC") document.getElementById("omtb-typeGraphique").value = "RF";
			if (typeG=="RFC") document.getElementById("omtb-typeGraphique").value = "RFF";
			if (typeG=="RP") document.getElementById("omtb-typeGraphique").value = "RE";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_switchGraphique() {
	try {

		var typeTB = document.getElementById('omtb-type').value;
		var lblTypeP = typeTB=="F"?"factures":"commandes";
		var lblTypeM = typeTB=="F"?"factur\u00E9":"command\u00E9";
		var lblTypeF = typeTB=="F"?"factur\u00E9e":"command\u00E9e";

		var typeG = document.getElementById("omtb-typeGraphique").value;
		var titreRepCA = "";
		var titreRepNB = "";
		var titreRepMA = "";

		switch(typeG) {
			case "RC":		titreRepCA = "CA HT "+ lblTypeM +" par client :";
										titreRepNB = "Nb de "+ lblTypeP +" par client :";
										titreRepMA = "Marge HT "+ lblTypeF +" par client :";
										break;
			case "RFC":		titreRepCA = "CA HT "+ lblTypeM +" par famille de client :";
										titreRepNB = "Nb de "+ lblTypeP +" par famille client :";
										titreRepMA = "Marge HT "+ lblTypeF +" par famille client :";
										break;
			case "RF":		titreRepCA = "CA HT "+ lblTypeM +" par fournisseur :";
										titreRepNB = "Nb de "+ lblTypeP +" par fournisseur :";
										break;
			case "RFF":		titreRepCA = "CA HT "+ lblTypeM +" par famille de fournisseur :";
										titreRepNB = "Nb de "+ lblTypeP +" par famille fournisseur :";
										break;
			case "RA":		titreRepCA = "CA HT "+ lblTypeM +" par article :";
										titreRepNB = "Quantit\u00E9 "+ lblTypeF +" par article :";
										titreRepMA = "Marge HT "+ lblTypeF +" par article :";
										break;
			case "RFA":		titreRepCA = "CA HT "+ lblTypeM +" par famille d'article :";
										titreRepNB = "Quantit\u00E9 "+ lblTypeF +" par famille d'article :";
										titreRepMA = "Marge HT "+ lblTypeF +" par famille d'article :";
										break;
			case "RM":		titreRepCA = "CA HT "+ lblTypeM +" par marque :";
										titreRepNB = "Quantit\u00E9 "+ lblTypeF +" par marque :";
										titreRepMA = "Marge HT "+ lblTypeF +" par marque :";
										break;
			case "RPA":		titreRepCA = "CA HT "+ lblTypeM +" par p\u00F4le d'activit\u00E9 :";
										titreRepNB = "Nb de "+ lblTypeP +" par p\u00F4le d'activit\u00E9 :";
										titreRepMA = "Marge HT "+ lblTypeF +" par p\u00F4le d'activit\u00E9 :";
										break;
			case "RR":		titreRepCA = "CA HT "+ lblTypeM +" par responsable :";
										titreRepNB = "Nb de "+ lblTypeP +" par responsable :";
										titreRepMA = "Marge HT "+ lblTypeF +" par responsable :";
										break;
			case "RP":		titreRepCA = "CA HT "+ lblTypeM +" par provenance :";
										titreRepNB = "Nb de "+ lblTypeP +" par provenance :";
										titreRepMA = "Marge HT "+ lblTypeF +" par provenance :";
										break;
			case "RE":		titreRepCA = "CA HT "+ lblTypeM +" par \u00E9tablissement :";
										titreRepNB = "Nb de "+ lblTypeP +" par \u00E9tablissement :";
										titreRepMA = "Marge HT "+ lblTypeF +" par \u00E9tablissement :";
										break;
		}

		document.getElementById("omtb-lblGraphRepCA").value = titreRepCA;
		document.getElementById("omtb-lblGraphRepNB").value = titreRepNB;
		document.getElementById("omtb-lblGraphRepMA").value = titreRepMA;

		document.getElementById("omtb-graphRepCA").setAttribute("src", getDirGraph() + omtb_graphs["CA_"+ typeG]);
		document.getElementById("omtb-graphRepNB").setAttribute("src", getDirGraph() + omtb_graphs["NB_"+ typeG]);
		if (document.getElementById('omtb-categorie').value=="V") {
			document.getElementById("omtb-graphRepMA").setAttribute("src", getDirGraph() + omtb_graphs["MA_"+ typeG]);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_bloquerIHM(b) {
	try {

		document.getElementById('omtb-dateDebut').disabled = b;
		document.getElementById('omtb-dateFin').disabled = b;
		document.getElementById('omtb-marque').disabled = b;
		document.getElementById('omtb-famille1').disabled = b;
		document.getElementById('omtb-famille2').disabled = b;
		document.getElementById('omtb-famille3').disabled = b;
		document.getElementById('omtb-refArticle').disabled = b;
		document.getElementById('omtb-provenance').disabled = b;
		document.getElementById('omtb-etablissement').disabled = b;
		document.getElementById('omtb-poleActivite').disabled = b;
		document.getElementById('omtb-numClient').disabled = b;
		document.getElementById('omtb-numFournisseur').disabled = b;
		document.getElementById('omtb-familleFournisseur').disabled = b;
		document.getElementById('omtb-familleClient').disabled = b;
		document.getElementById('omtb-responsable').disabled = b;
		document.getElementById('omtb-categorie').disabled = b;
		document.getElementById('omtb-type').disabled = b;
		document.getElementById('omtb-periodeRep').disabled = b;
		document.getElementById('omtb-bReinit').disabled = b;
		document.getElementById('omtb-bRechArticle').disabled = b;
		document.getElementById('omtb-bRechFournisseur').disabled = b;
		document.getElementById('omtb-bRechClient').disabled = b;
		document.getElementById('omtb-typeGraphique').disabled = b;
		document.getElementById('omtb-bEditionCSV').disabled = b;
		document.getElementById('omtb-bEditionDetailCSV').disabled = b;

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_chargerTableaux() {
	try {

		var dateDebut = document.getElementById('omtb-dateDebut').value;
		var dateFin = document.getElementById('omtb-dateFin').value;
		var marque = document.getElementById('omtb-marque').value;
		var famille1 = document.getElementById('omtb-famille1').value;
		var famille2 = document.getElementById('omtb-famille2').value;
		var famille3 = document.getElementById('omtb-famille3').value;
		var refArticle = document.getElementById('omtb-refArticle').value;
		var provenance = document.getElementById('omtb-provenance').value;
		var etablissement = document.getElementById('omtb-etablissement').value;
		var poleActivite = document.getElementById('omtb-poleActivite').value;
		var numClient = document.getElementById('omtb-numClient').value;
		var numFournisseur = document.getElementById('omtb-numFournisseur').value;
		var familleFournisseur = document.getElementById('omtb-familleFournisseur').value;
		var familleClient = document.getElementById('omtb-familleClient').value;
		var responsable = document.getElementById('omtb-responsable').value;
		var categorie = document.getElementById('omtb-categorie').value;
		var typeTB = document.getElementById('omtb-type').value;
		var periodeRep = document.getElementById('omtb-periodeRep').value;

		var periodePers = !isEmpty(dateDebut) || !isEmpty(dateFin);

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de date incorrecte"); }
		else if (periodeRep=="PP" && !periodePers) { showWarning("Plage de date incorrecte"); }
		else {

			omtb_changeTypeAndCat(typeTB, categorie);
			omtb_bloquerIHM(true);

			document.getElementById('omtb-bGenererTB').disabled = true;
			document.getElementById('omtb-bGenererTB').collapsed = true;
			document.getElementById('omtb-gen-pmbox').collapsed = false;
			document.getElementById('omtb-gen-pm').setAttribute('mode', 'undetermined');

			var qLoad;

			if (categorie=="V") {
				qLoad = new QueryHttp("Facturation/TableauxBord/getTableauxBordVentes.tmpl");
				qLoad.setParam("NumClient", numClient);
				qLoad.setParam("FamilleClient", familleClient);
			}
			else {
				qLoad = new QueryHttp("Facturation/TableauxBord/getTableauxBordAchats.tmpl");
				qLoad.setParam("NumFournisseur", numFournisseur);
				qLoad.setParam("FamilleFournisseur", familleFournisseur);
			}

			qLoad.setParam("DateDebut", dateDebut);
			qLoad.setParam("DateFin", dateFin);
			qLoad.setParam("Marque", marque);
			qLoad.setParam("Famille1", famille1);
			qLoad.setParam("Famille2", famille2);
			qLoad.setParam("Famille3", famille3);
			qLoad.setParam("RefArticle", refArticle);
			qLoad.setParam("Provenance", provenance);
			qLoad.setParam("Etablissement", etablissement);
			qLoad.setParam("PoleActivite", poleActivite);
			qLoad.setParam("Responsable", responsable);
			qLoad.setParam("Type", typeTB);
			qLoad.setParam("Periode_Rep", periodeRep);

			qLoad.execute(omtb_chargerTableaux_2, periodePers);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_chargerTableaux_2(result, periodePers) {
	try {

		var contenu = result.responseXML.documentElement;

		var fmon = new NumberFormat("0", true);
		var fqte = new NumberFormat("0", true);

		var catVente = document.getElementById('omtb-categorie').value=="V";

		document.getElementById("omtb-nbF-J").value = fqte.format(contenu.getAttribute("NB_F_J"));
		document.getElementById("omtb-caF-J").value = fmon.format(contenu.getAttribute("CA_F_J")) +" \u20AC";
		document.getElementById("omtb-nbT-J").value = fqte.format(contenu.getAttribute("NB_T_J"));
		document.getElementById("omtb-caT-J").value = fmon.format(contenu.getAttribute("CA_T_J")) +" \u20AC";
		document.getElementById("omtb-pnbTF-J").value = omtb_calcPercent(contenu.getAttribute("NB_F_J"), contenu.getAttribute("NB_T_J"));
		document.getElementById("omtb-pcaTF-J").value = omtb_calcPercent(contenu.getAttribute("CA_F_J"), contenu.getAttribute("CA_T_J"));
		if (catVente) {
			document.getElementById("omtb-tmqF-J").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_J"));
			document.getElementById("omtb-tmqT-J").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_J"));
		}

		document.getElementById("omtb-nbF-H").value = fqte.format(contenu.getAttribute("NB_F_H"));
		document.getElementById("omtb-caF-H").value = fmon.format(contenu.getAttribute("CA_F_H")) +" \u20AC";
		document.getElementById("omtb-nbT-H").value = fqte.format(contenu.getAttribute("NB_T_H"));
		document.getElementById("omtb-caT-H").value = fmon.format(contenu.getAttribute("CA_T_H")) +" \u20AC";
		document.getElementById("omtb-pnbTF-H").value = omtb_calcPercent(contenu.getAttribute("NB_F_H"), contenu.getAttribute("NB_T_H"));
		document.getElementById("omtb-pcaTF-H").value = omtb_calcPercent(contenu.getAttribute("CA_F_H"), contenu.getAttribute("CA_T_H"));
		if (catVente) {
			document.getElementById("omtb-tmqF-H").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_H"));
			document.getElementById("omtb-tmqT-H").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_H"));
		}

		document.getElementById("omtb-nbF-MC").value = fqte.format(contenu.getAttribute("NB_F_MC"));
		document.getElementById("omtb-caF-MC").value = fmon.format(contenu.getAttribute("CA_F_MC")) +" \u20AC";
		document.getElementById("omtb-nbT-MC").value = fqte.format(contenu.getAttribute("NB_T_MC"));
		document.getElementById("omtb-caT-MC").value = fmon.format(contenu.getAttribute("CA_T_MC")) +" \u20AC";
		document.getElementById("omtb-pnbTF-MC").value = omtb_calcPercent(contenu.getAttribute("NB_F_MC"), contenu.getAttribute("NB_T_MC"));
		document.getElementById("omtb-pcaTF-MC").value = omtb_calcPercent(contenu.getAttribute("CA_F_MC"), contenu.getAttribute("CA_T_MC"));
		if (catVente) {
			document.getElementById("omtb-tmqF-MC").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_MC"));
			document.getElementById("omtb-tmqT-MC").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_MC"));
		}

		document.getElementById("omtb-nbF-MP").value = fqte.format(contenu.getAttribute("NB_F_MP"));
		document.getElementById("omtb-caF-MP").value = fmon.format(contenu.getAttribute("CA_F_MP")) +" \u20AC";
		document.getElementById("omtb-nbT-MP").value = fqte.format(contenu.getAttribute("NB_T_MP"));
		document.getElementById("omtb-caT-MP").value = fmon.format(contenu.getAttribute("CA_T_MP")) +" \u20AC";
		document.getElementById("omtb-pnbTF-MP").value = omtb_calcPercent(contenu.getAttribute("NB_F_MP"), contenu.getAttribute("NB_T_MP"));
		document.getElementById("omtb-pcaTF-MP").value = omtb_calcPercent(contenu.getAttribute("CA_F_MP"), contenu.getAttribute("CA_T_MP"));
		if (catVente) {
			document.getElementById("omtb-tmqF-MP").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_MP"));
			document.getElementById("omtb-tmqT-MP").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_MP"));
		}

		document.getElementById("omtb-nbF-N").value = fqte.format(contenu.getAttribute("NB_F_N"));
		document.getElementById("omtb-caF-N").value = fmon.format(contenu.getAttribute("CA_F_N")) +" \u20AC";
		document.getElementById("omtb-nbT-N").value = fqte.format(contenu.getAttribute("NB_T_N"));
		document.getElementById("omtb-caT-N").value = fmon.format(contenu.getAttribute("CA_T_N")) +" \u20AC";
		document.getElementById("omtb-pnbTF-N").value = omtb_calcPercent(contenu.getAttribute("NB_F_N"), contenu.getAttribute("NB_T_N"));
		document.getElementById("omtb-pcaTF-N").value = omtb_calcPercent(contenu.getAttribute("CA_F_N"), contenu.getAttribute("CA_T_N"));
		if (catVente) {
			document.getElementById("omtb-tmqF-N").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_N"));
			document.getElementById("omtb-tmqT-N").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_N"));
		}

		document.getElementById("omtb-nbF-N1").value = fqte.format(contenu.getAttribute("NB_F_N1"));
		document.getElementById("omtb-caF-N1").value = fmon.format(contenu.getAttribute("CA_F_N1")) +" \u20AC";
		document.getElementById("omtb-nbT-N1").value = fqte.format(contenu.getAttribute("NB_T_N1"));
		document.getElementById("omtb-caT-N1").value = fmon.format(contenu.getAttribute("CA_T_N1")) +" \u20AC";
		document.getElementById("omtb-pnbTF-N1").value = omtb_calcPercent(contenu.getAttribute("NB_F_N1"), contenu.getAttribute("NB_T_N1"));
		document.getElementById("omtb-pcaTF-N1").value = omtb_calcPercent(contenu.getAttribute("CA_F_N1"), contenu.getAttribute("CA_T_N1"));
		if (catVente) {
			document.getElementById("omtb-tmqF-N1").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_N1"));
			document.getElementById("omtb-tmqT-N1").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_N1"));
		}

		document.getElementById("omtb-nbF-N2").value = fqte.format(contenu.getAttribute("NB_F_N2"));
		document.getElementById("omtb-caF-N2").value = fmon.format(contenu.getAttribute("CA_F_N2")) +" \u20AC";
		document.getElementById("omtb-nbT-N2").value = fqte.format(contenu.getAttribute("NB_T_N2"));
		document.getElementById("omtb-caT-N2").value = fmon.format(contenu.getAttribute("CA_T_N2")) +" \u20AC";
		document.getElementById("omtb-pnbTF-N2").value = omtb_calcPercent(contenu.getAttribute("NB_F_N2"), contenu.getAttribute("NB_T_N2"));
		document.getElementById("omtb-pcaTF-N2").value = omtb_calcPercent(contenu.getAttribute("CA_F_N2"), contenu.getAttribute("CA_T_N2"));
		if (catVente) {
			document.getElementById("omtb-tmqF-N2").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_N2"));
			document.getElementById("omtb-tmqT-N2").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_N2"));
		}

		document.getElementById("omtb-rowPP").collapsed = !periodePers;

		if (periodePers) {
			document.getElementById("omtb-nbF-PP").value = fqte.format(contenu.getAttribute("NB_F_PP"));
			document.getElementById("omtb-caF-PP").value = fmon.format(contenu.getAttribute("CA_F_PP")) +" \u20AC";
			document.getElementById("omtb-nbT-PP").value = fqte.format(contenu.getAttribute("NB_T_PP"));
			document.getElementById("omtb-caT-PP").value = fmon.format(contenu.getAttribute("CA_T_PP")) +" \u20AC";
			document.getElementById("omtb-pnbTF-PP").value = omtb_calcPercent(contenu.getAttribute("NB_F_PP"), contenu.getAttribute("NB_T_PP"));
			document.getElementById("omtb-pcaTF-PP").value = omtb_calcPercent(contenu.getAttribute("CA_F_PP"), contenu.getAttribute("CA_T_PP"));
			if (catVente) {
				document.getElementById("omtb-tmqF-PP").value = omtb_formatTaux(contenu.getAttribute("TMQ_F_PP"));
				document.getElementById("omtb-tmqT-PP").value = omtb_formatTaux(contenu.getAttribute("TMQ_T_PP"));
			}
		}

		var nbPeriodeDetail = contenu.getAttribute("Nb_Periode_Detail");
		if (nbPeriodeDetail>0) {
			document.getElementById("omtb-intitulePeriodeDetail").value = contenu.getAttribute("Intitule_Periode_Detail") +" :";
			document.getElementById("omtb-intitulePeriodeDetailNB").value = contenu.getAttribute("Intitule_Periode_Detail") +" :";
			document.getElementById("omtb-intitulePeriodeDetailCA").value = contenu.getAttribute("Intitule_Periode_Detail") +" :";

			document.getElementById('omtb-graphEvolDetailCA').setAttribute("src", getDirGraph() + contenu.getAttribute("Graph_Evol_Detail_CA"));
			document.getElementById('omtb-graphEvolDetailNB').setAttribute("src", getDirGraph() + contenu.getAttribute("Graph_Evol_Detail_NB"));

			for (var i=1; i<=31; i++) {
				document.getElementById("omtb-rowPeriodeDetail"+ i).collapsed = true;
			}

			for (var i=1; i<=nbPeriodeDetail; i++) {
				document.getElementById("omtb-periodeDetail"+ i).value = contenu.getAttribute("Periode_Detail_"+ i);
				document.getElementById("omtb-nbF-PD"+ i).value = fqte.format(contenu.getAttribute("NB_F_PD"+ i));
				document.getElementById("omtb-caF-PD"+ i).value = fmon.format(contenu.getAttribute("CA_F_PD"+ i)) +" \u20AC";
				document.getElementById("omtb-nbT-PD"+ i).value = fqte.format(contenu.getAttribute("NB_T_PD"+ i));
				document.getElementById("omtb-caT-PD"+ i).value = fmon.format(contenu.getAttribute("CA_T_PD"+ i)) +" \u20AC";
				document.getElementById("omtb-pnbTF-PD"+ i).value = omtb_calcPercent(contenu.getAttribute("NB_F_PD"+ i), contenu.getAttribute("NB_T_PD"+ i));
				document.getElementById("omtb-pcaTF-PD"+ i).value = omtb_calcPercent(contenu.getAttribute("CA_F_PD"+ i), contenu.getAttribute("CA_T_PD"+ i));
				document.getElementById("omtb-rowPeriodeDetail"+ i).collapsed = false;
			}

			document.getElementById("omtb-lblTabDetail").collapsed = false;
		}
		else {
			document.getElementById("omtb-lblTabDetail").collapsed = true;
			document.getElementById('omtb-panneau').selectedIndex = 0;
		}

		// Graphiques

		document.getElementById('omtb-graphEvolCA').setAttribute("src", getDirGraph() + contenu.getAttribute("Graph_Evol_CA"));
		document.getElementById('omtb-graphEvolNB').setAttribute("src", getDirGraph() + contenu.getAttribute("Graph_Evol_NB"));
		if (catVente) {
			document.getElementById('omtb-graphEvolMA').setAttribute("src", getDirGraph() + contenu.getAttribute("Graph_Evol_MA"));
		}

		omtb_graphs = new Array();

		omtb_graphs.CA_RC = contenu.getAttribute("Graph_RepCA_Tiers");
		omtb_graphs.NB_RC = contenu.getAttribute("Graph_RepNB_Tiers");
		omtb_graphs.MA_RC = contenu.getAttribute("Graph_RepMA_Tiers");
		omtb_graphs.CA_RFC = contenu.getAttribute("Graph_RepCA_Famille_Tiers");
		omtb_graphs.NB_RFC = contenu.getAttribute("Graph_RepNB_Famille_Tiers");
		omtb_graphs.MA_RFC = contenu.getAttribute("Graph_RepMA_Famille_Tiers");
		omtb_graphs.CA_RF = contenu.getAttribute("Graph_RepCA_Tiers");
		omtb_graphs.NB_RF = contenu.getAttribute("Graph_RepNB_Tiers");
		omtb_graphs.CA_RFF = contenu.getAttribute("Graph_RepCA_Famille_Tiers");
		omtb_graphs.NB_RFF = contenu.getAttribute("Graph_RepNB_Famille_Tiers");
		omtb_graphs.CA_RE = contenu.getAttribute("Graph_RepCA_Etablissement");
		omtb_graphs.NB_RE = contenu.getAttribute("Graph_RepNB_Etablissement");
		omtb_graphs.MA_RE = contenu.getAttribute("Graph_RepMA_Etablissement");
		omtb_graphs.CA_RP = contenu.getAttribute("Graph_RepCA_Provenance");
		omtb_graphs.NB_RP = contenu.getAttribute("Graph_RepNB_Provenance");
		omtb_graphs.MA_RP = contenu.getAttribute("Graph_RepMA_Provenance");
		omtb_graphs.CA_RA = contenu.getAttribute("Graph_RepCA_Article");
		omtb_graphs.NB_RA = contenu.getAttribute("Graph_RepNB_Article");
		omtb_graphs.MA_RA = contenu.getAttribute("Graph_RepMA_Article");
		omtb_graphs.CA_RFA = contenu.getAttribute("Graph_RepCA_Famille_Article");
		omtb_graphs.NB_RFA = contenu.getAttribute("Graph_RepNB_Famille_Article");
		omtb_graphs.MA_RFA = contenu.getAttribute("Graph_RepMA_Famille_Article");
		omtb_graphs.CA_RM = contenu.getAttribute("Graph_RepCA_Marque");
		omtb_graphs.NB_RM = contenu.getAttribute("Graph_RepNB_Marque");
		omtb_graphs.MA_RM = contenu.getAttribute("Graph_RepMA_Marque");
		omtb_graphs.CA_RPA = contenu.getAttribute("Graph_RepCA_Pole_Activite");
		omtb_graphs.NB_RPA = contenu.getAttribute("Graph_RepNB_Pole_Activite");
		omtb_graphs.MA_RPA = contenu.getAttribute("Graph_RepMA_Pole_Activite");
		omtb_graphs.CA_RR = contenu.getAttribute("Graph_RepCA_Responsable");
		omtb_graphs.NB_RR = contenu.getAttribute("Graph_RepNB_Responsable");
		omtb_graphs.MA_RR = contenu.getAttribute("Graph_RepMA_Responsable");

		omtb_switchGraphique();

		omtb_setModified(false);

		document.getElementById('omtb-gen-pmbox').collapsed = true;
		document.getElementById('omtb-gen-pm').setAttribute('mode', 'none');
		document.getElementById('omtb-bGenererTB').collapsed = false;
		omtb_bloquerIHM(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function omtb_editionPDF() {
	try {

		var dateDebut = document.getElementById('omtb-dateDebut').value;
		var dateFin = document.getElementById('omtb-dateFin').value;
		var marque = document.getElementById('omtb-marque').value;
		var famille1 = document.getElementById('omtb-famille1').value;
		var famille2 = document.getElementById('omtb-famille2').value;
		var famille3 = document.getElementById('omtb-famille3').value;
		var refArticle = document.getElementById('omtb-refArticle').value;
		var provenance = document.getElementById('omtb-provenance').value;
		var etablissement = document.getElementById('omtb-etablissement').value;
		var poleActivite = document.getElementById('omtb-poleActivite').value;
		var numClient = document.getElementById('omtb-numClient').value;
		var numFournisseur = document.getElementById('omtb-numFournisseur').value;
		var familleFournisseur = document.getElementById('omtb-familleFournisseur').value;
		var familleClient = document.getElementById('omtb-familleClient').value;
		var responsable = document.getElementById('omtb-responsable').value;
		var categorie = document.getElementById('omtb-categorie').value;
		var typeTB = document.getElementById('omtb-type').value;
		var periodeRep = document.getElementById('omtb-periodeRep').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de date incorrecte"); }
		else {

			var qEditionPdf;

			if (categorie=="V") {
				qEditionPdf = new QueryHttp("Facturation/TableauxBord/pdfTableauxBordVentes.tmpl");
				qEditionPdf.setParam("NumClient", numClient);
				qEditionPdf.setParam("FamilleClient", familleClient);
			}
			else {
				qEditionPdf = new QueryHttp("Facturation/TableauxBord/pdfTableauxBordAchats.tmpl");
				qEditionPdf.setParam("NumFournisseur", numFournisseur);
				qEditionPdf.setParam("FamilleFournisseur", familleFournisseur);
			}

			qEditionPdf.setParam("DateDebut", dateDebut);
			qEditionPdf.setParam("DateFin", dateFin);
			qEditionPdf.setParam("Marque", marque);
			qEditionPdf.setParam("Famille1", famille1);
			qEditionPdf.setParam("Famille2", famille2);
			qEditionPdf.setParam("Famille3", famille3);
			qEditionPdf.setParam("RefArticle", refArticle);
			qEditionPdf.setParam("Provenance", provenance);
			qEditionPdf.setParam("Etablissement", etablissement);
			qEditionPdf.setParam("PoleActivite", poleActivite);
			qEditionPdf.setParam("Responsable", responsable);
			qEditionPdf.setParam("Type", typeTB);
			qEditionPdf.setParam("Periode_Rep", periodeRep);

			document.getElementById('omtb-pmbox').collapsed = false;
			document.getElementById('omtb-pm').setAttribute('mode', 'undetermined');

			qEditionPdf.execute(omtb_editionPDF_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omtb_editionPDF_2(result) {
	try {

		document.getElementById('omtb-pmbox').collapsed = true;
		document.getElementById('omtb-pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bMenuTableauxBord').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omtb_editionCSV() {
	try {

		var dateDebut = document.getElementById('omtb-dateDebut').value;
		var dateFin = document.getElementById('omtb-dateFin').value;
		var marque = document.getElementById('omtb-marque').value;
		var famille1 = document.getElementById('omtb-famille1').value;
		var famille2 = document.getElementById('omtb-famille2').value;
		var famille3 = document.getElementById('omtb-famille3').value;
		var refArticle = document.getElementById('omtb-refArticle').value;
		var provenance = document.getElementById('omtb-provenance').value;
		var etablissement = document.getElementById('omtb-etablissement').value;
		var poleActivite = document.getElementById('omtb-poleActivite').value;
		var numClient = document.getElementById('omtb-numClient').value;
		var numFournisseur = document.getElementById('omtb-numFournisseur').value;
		var familleFournisseur = document.getElementById('omtb-familleFournisseur').value;
		var familleClient = document.getElementById('omtb-familleClient').value;
		var responsable = document.getElementById('omtb-responsable').value;
		var categorie = document.getElementById('omtb-categorie').value;
		var typeTB = document.getElementById('omtb-type').value;
		var periodeRep = document.getElementById('omtb-periodeRep').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de date incorrecte"); }
		else {

			document.getElementById('omtb-bEditionCSV').collapsed = true;
			document.getElementById('omtb-bEditionDetailCSV').disabled = true;
			document.getElementById('omtb-csv-pmbox').collapsed = false;
			document.getElementById('omtb-csv-pm').setAttribute('mode', 'undetermined');

			var qEditionCsv;

			if (categorie=="V") {
				qEditionCsv = new QueryHttp("Facturation/TableauxBord/csvTableauxBordVentes.tmpl");
				qEditionCsv.setParam("NumClient", numClient);
				qEditionCsv.setParam("FamilleClient", familleClient);
			}
			else {
				qEditionCsv = new QueryHttp("Facturation/TableauxBord/csvTableauxBordAchats.tmpl");
				qEditionCsv.setParam("NumFournisseur", numFournisseur);
				qEditionCsv.setParam("FamilleFournisseur", familleFournisseur);
			}

			qEditionCsv.setParam("DateDebut", dateDebut);
			qEditionCsv.setParam("DateFin", dateFin);
			qEditionCsv.setParam("Marque", marque);
			qEditionCsv.setParam("Famille1", famille1);
			qEditionCsv.setParam("Famille2", famille2);
			qEditionCsv.setParam("Famille3", famille3);
			qEditionCsv.setParam("RefArticle", refArticle);
			qEditionCsv.setParam("Provenance", provenance);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("PoleActivite", poleActivite);
			qEditionCsv.setParam("Responsable", responsable);
			qEditionCsv.setParam("Type", typeTB);
			qEditionCsv.setParam("Periode_Rep", periodeRep);

			qEditionCsv.execute(omtb_editionCSV_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omtb_editionCSV_2(result) {
	try {

		document.getElementById('omtb-csv-pmbox').collapsed = true;
		document.getElementById('omtb-csv-pm').setAttribute('mode', 'none');
		document.getElementById('omtb-bEditionCSV').collapsed = false;
		document.getElementById('omtb-bEditionDetailCSV').disabled = false;

		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omtb_editionDetailCSV() {
	try {

		var dateDebut = document.getElementById('omtb-dateDebut').value;
		var dateFin = document.getElementById('omtb-dateFin').value;
		var marque = document.getElementById('omtb-marque').value;
		var famille1 = document.getElementById('omtb-famille1').value;
		var famille2 = document.getElementById('omtb-famille2').value;
		var famille3 = document.getElementById('omtb-famille3').value;
		var refArticle = document.getElementById('omtb-refArticle').value;
		var provenance = document.getElementById('omtb-provenance').value;
		var etablissement = document.getElementById('omtb-etablissement').value;
		var poleActivite = document.getElementById('omtb-poleActivite').value;
		var numClient = document.getElementById('omtb-numClient').value;
		var numFournisseur = document.getElementById('omtb-numFournisseur').value;
		var familleFournisseur = document.getElementById('omtb-familleFournisseur').value;
		var familleClient = document.getElementById('omtb-familleClient').value;
		var responsable = document.getElementById('omtb-responsable').value;
		var categorie = document.getElementById('omtb-categorie').value;
		var typeTB = document.getElementById('omtb-type').value;
		var periodeRep = document.getElementById('omtb-periodeRep').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de date incorrecte"); }
		else {

			document.getElementById('omtb-bEditionCSV').disabled = true;
			document.getElementById('omtb-bEditionDetailCSV').collapsed = true;
			document.getElementById('omtb-csv-detail-pmbox').collapsed = false;
			document.getElementById('omtb-csv-detail-pm').setAttribute('mode', 'undetermined');

			var qEditionCsv;

			if (categorie=="V") {
				qEditionCsv = new QueryHttp("Facturation/TableauxBord/csvDetailTableauxBordVentes.tmpl");
				qEditionCsv.setParam("NumClient", numClient);
				qEditionCsv.setParam("FamilleClient", familleClient);
			}
			else {
				qEditionCsv = new QueryHttp("Facturation/TableauxBord/csvDetailTableauxBordAchats.tmpl");
				qEditionCsv.setParam("NumFournisseur", numFournisseur);
				qEditionCsv.setParam("FamilleFournisseur", familleFournisseur);
			}

			qEditionCsv.setParam("DateDebut", dateDebut);
			qEditionCsv.setParam("DateFin", dateFin);
			qEditionCsv.setParam("Marque", marque);
			qEditionCsv.setParam("Famille1", famille1);
			qEditionCsv.setParam("Famille2", famille2);
			qEditionCsv.setParam("Famille3", famille3);
			qEditionCsv.setParam("RefArticle", refArticle);
			qEditionCsv.setParam("Provenance", provenance);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("PoleActivite", poleActivite);
			qEditionCsv.setParam("Responsable", responsable);
			qEditionCsv.setParam("Type", typeTB);
			qEditionCsv.setParam("Periode_Rep", periodeRep);

			qEditionCsv.execute(omtb_editionDetailCSV_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omtb_editionDetailCSV_2(result) {
	try {

		document.getElementById('omtb-csv-detail-pmbox').collapsed = true;
		document.getElementById('omtb-csv-detail-pm').setAttribute('mode', 'none');
		document.getElementById('omtb-bEditionCSV').disabled = false;
		document.getElementById('omtb-bEditionDetailCSV').collapsed = false;

		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omtb_setModified(m) {
  try {

		if (m) {
			document.getElementById('omtb-cFiltres').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('omtb-cTabBord').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('omtb-bEditionPDF').disabled = true;
			document.getElementById('omtb-bEditionCSV').disabled = true;
			document.getElementById('omtb-bEditionDetailCSV').disabled = true;
			document.getElementById('omtb-bGenererTB').disabled = false;
		}
		else {
			document.getElementById('omtb-cFiltres').setAttribute('image', null);
			document.getElementById('omtb-cTabBord').setAttribute('image', null);
			document.getElementById('omtb-bEditionPDF').disabled = false;
			document.getElementById('omtb-bEditionCSV').disabled = false;
			document.getElementById('omtb-bEditionDetailCSV').disabled = false;
			document.getElementById('omtb-bGenererTB').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}
