/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var transfertEnc;
var formatExport;
var nomFichierDefaut;
var gConfig;


function init() {
	try {

		gConfig = getConfig();

		var qParam = new QueryHttp("Facturation/Transfert/isTransfertEnc.tmpl");
		var result = qParam.execute();
		transfertEnc = (result.responseXML.documentElement.getAttribute("Transfert_Enc")=="true");
		document.getElementById('tabTransfertEnc').collapsed = !transfertEnc;
		document.getElementById('tabTransfertEnc').disabled = !transfertEnc;

		otv_init();
		ota_init();
		if (transfertEnc) { ote_init(); }
		otr_init();

	} catch (e) {
		recup_erreur(e);
	}
}


function testcheck(listitem) {
	try {
		var cks = listitem.getElementsByTagName("listcell");
		if (cks.item(1).getAttribute("label")=="non") {
			if (cks.item(0).getAttribute("checked")=="false") {
				cks.item(0).setAttribute("checked","true");
			} else {
				cks.item(0).setAttribute("checked","false");
			}
		}
	} catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(id, b) {
	try {

		var listbox = document.getElementById(id);
		var nbLignes = listbox.getRowCount();
		if (nbLignes>0) {
			var i = 0;

			while (i<nbLignes) {
				var item = listbox.getItemAtIndex(i);
				var cks = item.getElementsByTagName("listcell");
				if (cks.item(1).getAttribute("label")=="non") {
					cks.item(0).setAttribute("checked", b);
				}
				i++;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterCompte(listitem, indexNumTiers, indexTiersId, indexTypeTiers, indexNumCompte) {
	try {
		var cks = listitem.getElementsByTagName("listcell");
		var typeTiers = cks.item(indexTypeTiers).getAttribute("label");
		if (typeTiers=="C") { affecterCompteClient(listitem, indexNumTiers, indexTiersId, indexNumCompte); }
		else { affecterCompteFournisseur(listitem, indexNumTiers, indexTiersId, indexNumCompte); }
	} catch (e) {
    recup_erreur(e);
  }
}


function affecterCompteClient(listitem, indexNumTiers, indexTiersId, indexNumCompte) {
	try {

		var cks = listitem.getElementsByTagName("listcell");
		var clientId = cks.item(indexTiersId).getAttribute("label");
		var numClient = cks.item(indexNumTiers).getAttribute("label");
		var numCompte = cks.item(indexNumCompte).getAttribute("label");
		if (!isEmpty(clientId)) {
			var url = "chrome://opensi/content/facturation/user/clients/popup-modifierCompteClient.xul?"+ cookie() +"&Client_Id="+ clientId +"&Num_Client="+ urlEncode(numClient) +"&Num_Compte="+ urlEncode(numCompte);
			window.openDialog(url,'','chrome,modal,centerscreen',reinitialiserListesClients);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function reinitialiserListesClients() {
	try {
		otv_actualiserSelection();
		if (transfertEnc) { ote_actualiserSelection(); }
		otr_actualiserSelection();
	} catch (e) {
		recup_erreur(e);
	}
}


function affecterCompteFournisseur(listitem, indexNumTiers, indexTiersId, indexNumCompte) {
	try {

		var cks = listitem.getElementsByTagName("listcell");
		var fournisseurId = cks.item(indexTiersId).getAttribute("label");
		var numFournisseur = cks.item(indexNumTiers).getAttribute("label");
		var numCompte = cks.item(indexNumCompte).getAttribute("label");
		if (!isEmpty(fournisseurId)) {
			var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-modifierCompteFournisseur.xul?"+ cookie() +"&Fournisseur_Id="+ fournisseurId +"&Num_Fournisseur="+ urlEncode(numFournisseur) +"&Num_Compte="+ urlEncode(numCompte);
			window.openDialog(url,'','chrome,modal,centerscreen',reinitialiserListesFournisseurs);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function reinitialiserListesFournisseurs() {
	try {
		ota_actualiserSelection();
		if (transfertEnc) { ote_actualiserSelection(); }
		otr_actualiserSelection();
	} catch (e) {
		recup_erreur(e);
	}
}


function getCodeExport(exportId) {
	try {
		var qCodeExport = new QueryHttp("Facturation/Transfert/getCodeExport.tmpl");
		qCodeExport.setParam('Export_Id', exportId);
		var result = qCodeExport.execute();
		return result.responseXML.documentElement.getAttribute('Code_Export');
	} catch (e) {
		recup_erreur(e);
	}
}


function checkNomFichierExport(formatExport) {
	try {

		nomFichierDefaut = "";
		var codeExport = getCodeExport(formatExport);

		if (codeExport=="CADOR") {
			var url="chrome://opensi/content/facturation/user/transfert/popup-exportCador.xul?"+ cookie();
			window.openDialog(url,'','chrome,modal,centerscreen',retourExportCador);
		}

		return true;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourExportCador(nomFichier) {
	try {

		nomFichierDefaut = nomFichier;

	} catch (e) {
		recup_erreur(e);
	}
}


function telechargerFichier(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierServ = result.responseXML.documentElement.getAttribute('fileName');
			var fichierSugg = result.responseXML.documentElement.getAttribute('suggestedName');

			if (!isEmpty(nomFichierDefaut)) {
				fichierSugg = nomFichierDefaut;
			}

			var file = fileChooser("save", fichierSugg);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichierServ, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
