/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var otr_aRemisesBanque = new Arbre('Facturation/Transfert/list-transfertComptaRemiseBanque.tmpl', 'otr-remisesBanque');
var otr_aDetailReglements = new Arbre('Facturation/Remises_Banque/list-ligneRemiseStandard.tmpl', 'otr-listeReglements');
var otr_aDetailEspeces = new Arbre('Facturation/Remises_Banque/list-ligneRemiseEspeces.tmpl', 'otr-listeReglementsEspeces');

var otr_aRemboursements = new Arbre('Facturation/Transfert/list-transfertComptaDecaissement.tmpl', 'otr-remboursements');
var otr_aRegulEcheances = new Arbre('Facturation/Transfert/list-transfertComptaRegularisationPerte.tmpl', 'otr-regulEcheances');
var otr_aRegulReglements = new Arbre('Facturation/Transfert/list-transfertComptaRegularisationProfit.tmpl', 'otr-regulReglements');

var otr_aPeriodes = new Arbre('ComboListe/combo-dernieresPeriodes.tmpl', 'otr-periode');
var otr_aFormats = new Arbre('ComboListe/combo-formatsExportCompta.tmpl', 'otr-formatExport');



function otr_init() {
  try {

  	document.getElementById('otr-boxDetails').collapsed=true;
		document.getElementById('otr-listeReglements').collapsed=true;
		document.getElementById('otr-listeReglementsEspeces').collapsed=true;

		document.getElementById('otr-typePeriode').value = 'P';
		document.getElementById('otr-dateDebut').disabled = true;
		document.getElementById('otr-dateFin').disabled = true;
		document.getElementById('otr-typeTransfert').value = "RR";
		otr_switchTypeTransfert();

		otr_aFormats.initTree(otr_initFormat);

	} catch (e) {
  	recup_erreur(e);
  }
}


function otr_initFormat() {
	try {
		document.getElementById('otr-formatExport').selectedIndex = 0;
		otr_aPeriodes.initTree(otr_initPeriode);
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_initPeriode() {
  try {

		document.getElementById('otr-periode').selectedIndex = 0;
		var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'otr-modeReglement');
		aModesReglements.initTree(otr_initModeReglement);

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_initModeReglement() {
  try {

  	document.getElementById('otr-modeReglement').selectedIndex=0;
  	var aBanques = new Arbre("ComboListe/combo-banques.tmpl", "otr-comboBanques");
  	aBanques.initTree(otr_initBanque);

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_initBanque() {
  try {
		document.getElementById('otr-comboBanques').selectedIndex = 0;
		var aJournauxRemise = new Arbre('ComboListe/combo-journaux.tmpl', 'otr-journal');
		aJournauxRemise.setParam('Type_Journal', 'TR');
		aJournauxRemise.initTree(otr_initJournalRemise);
	} catch (e) {
    recup_erreur(e);
  }
}


function otr_initJournalRemise() {
  try {

		document.getElementById('otr-journal').selectedIndex = 0;
		document.getElementById('otr-journal').disabled = true;

		var aJournauxRegul = new Arbre('ComboListe/combo-journaux.tmpl', 'otr-journalRegul');
  	aJournauxRegul.setParam('Type_Journal', 'OD');
  	aJournauxRegul.initTree(otr_initJournalRegul);

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_initJournalRegul() {
  try {

		document.getElementById('otr-journalRegul').value = gConfig.getJournalRegul();

		otr_aRemisesBanque.setParam('Comptabilise', false);
		otr_aRemboursements.setParam('Comptabilise', false);
		otr_aRegulEcheances.setParam('Comptabilise', false);
		otr_aRegulReglements.setParam('Comptabilise', false);
		otr_actualiserSelection();

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_initCriteres() {
	try {
		document.getElementById('otr-typePeriode').value = 'P';
		document.getElementById('otr-periode').selectedIndex = 0;
		document.getElementById('otr-dateDebut').value = "";
		document.getElementById('otr-dateFin').value = "";
		document.getElementById('otr-dateDebut').disabled = true;
		document.getElementById('otr-dateFin').disabled = true;

		document.getElementById('otr-modeReglement').selectedIndex = 0;
		document.getElementById('otr-comboBanques').selectedIndex = 0;
		document.getElementById('otr-numClient').value = "";
		document.getElementById('otr-numFournisseur').value = "";

		otr_actualiserSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_pressOnBanque() {
	try {

		var banqueId = document.getElementById('otr-comboBanques').value;
		document.getElementById('otr-journal').disabled = isEmpty(banqueId);

		if (isEmpty(banqueId)) {
			document.getElementById('otr-journal').selectedIndex = 0;
		}
		else {
			var qGet = new QueryHttp("Facturation/Transfert/getJournalBanque.tmpl");
			qGet.setParam("Banque_Id", banqueId);
			var result = qGet.execute();
			document.getElementById('otr-journal').value = result.responseXML.documentElement.getAttribute('Journal_Id');
		}

		otr_actualiserSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			otr_actualiserSelection();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function otr_switchTypeTransfert() {
	try {
		var type = document.getElementById('otr-typeTransfert').value;
		document.getElementById('otr-bcReglements').collapsed = (type!="RR");
		document.getElementById('otr-boxRemisesRemboursements').collapsed = (type!="RR");
		document.getElementById('otr-boxJournalRemise').collapsed = (type!="RR");
		document.getElementById('otr-boxRegularisations').collapsed = (type!="RG");
		document.getElementById('otr-boxJournalRegul').collapsed = (type!="RG");
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_actualiserListeRemise() {
	try {

		var typePeriode = document.getElementById('otr-typePeriode').value;
		var periode = document.getElementById('otr-periode').value;
		var dateDebut = document.getElementById('otr-dateDebut').value;
		var dateFin = document.getElementById('otr-dateFin').value;
		var numClient = document.getElementById('otr-numClient').value;
		var numFournisseur = document.getElementById('otr-numFournisseur').value;
		var modeReglement = document.getElementById('otr-modeReglement').value;
		var banqueId = document.getElementById('otr-comboBanques').value;
		var nonTrans = document.getElementById('otr-chkAffRemiseTransferees').checked;
		var statut = document.getElementById('otr-statut').value;

		document.getElementById('otr-boxDetails').collapsed=true;
		document.getElementById('otr-listeReglements').collapsed=true;
		document.getElementById('otr-listeReglementsEspeces').collapsed=true;
		otr_aDetailReglements.deleteTree();
		otr_aDetailEspeces.deleteTree();

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otr_aRemisesBanque.clearParams();
			otr_aRemisesBanque.setParam('Type_Periode', typePeriode);
			otr_aRemisesBanque.setParam('Periode', periode);
			otr_aRemisesBanque.setParam('Date_Debut', dateDebut);
			otr_aRemisesBanque.setParam('Date_Fin', dateFin);
			otr_aRemisesBanque.setParam('Num_Client', numClient);
			otr_aRemisesBanque.setParam('Num_Fournisseur', numFournisseur);
			otr_aRemisesBanque.setParam('Mode_Reglement', modeReglement);
			otr_aRemisesBanque.setParam('Banque_Remise', banqueId);
			otr_aRemisesBanque.setParam('Comptabilise', nonTrans?"":false);
			otr_aRemisesBanque.setParam('Statut', statut);
			otr_aRemisesBanque.initTree(otr_initListeRemiseBanque);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_actualiserListeRemboursement() {
	try {

		var typePeriode = document.getElementById('otr-typePeriode').value;
		var periode = document.getElementById('otr-periode').value;
		var dateDebut = document.getElementById('otr-dateDebut').value;
		var dateFin = document.getElementById('otr-dateFin').value;
		var numClient = document.getElementById('otr-numClient').value;
		var numFournisseur = document.getElementById('otr-numFournisseur').value;
		var modeReglement = document.getElementById('otr-modeReglement').value;
		var banqueRetrait = document.getElementById('otr-comboBanques').value;
		var nonTrans = document.getElementById('otr-chkAffRembTransferes').checked;
		var statut = document.getElementById('otr-statut').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otr_aRemboursements.clearParams();
			otr_aRemboursements.setParam('Type_Periode', typePeriode);
			otr_aRemboursements.setParam('Periode', periode);
			otr_aRemboursements.setParam('Date_Debut', dateDebut);
			otr_aRemboursements.setParam('Date_Fin', dateFin);
			otr_aRemboursements.setParam('Num_Client', numClient);
			otr_aRemboursements.setParam('Num_Fournisseur', numFournisseur);
			otr_aRemboursements.setParam('Mode_Reglement', modeReglement);
			otr_aRemboursements.setParam('Banque_Retrait', banqueRetrait);
			otr_aRemboursements.setParam('Comptabilise', nonTrans?"":false);
			otr_aRemboursements.setParam('Statut', statut);
			otr_aRemboursements.initTree(otr_initListeRemboursements);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_actualiserListeRegulEcheance() {
	try {

		var typePeriode = document.getElementById('otr-typePeriode').value;
		var periode = document.getElementById('otr-periode').value;
		var dateDebut = document.getElementById('otr-dateDebut').value;
		var dateFin = document.getElementById('otr-dateFin').value;
		var numClient = document.getElementById('otr-numClient').value;
		var numFournisseur = document.getElementById('otr-numFournisseur').value;
		var nonTrans = document.getElementById('otr-chkAffRegulEchTrans').checked;
		var statut = document.getElementById('otr-statut').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otr_aRegulEcheances.clearParams();
			otr_aRegulEcheances.setParam('Type_Periode', typePeriode);
			otr_aRegulEcheances.setParam('Periode', periode);
			otr_aRegulEcheances.setParam('Date_Debut', dateDebut);
			otr_aRegulEcheances.setParam('Date_Fin', dateFin);
			otr_aRegulEcheances.setParam('Num_Client', numClient);
			otr_aRegulEcheances.setParam('Num_Fournisseur', numFournisseur);
			otr_aRegulEcheances.setParam('Comptabilise', nonTrans?"":false);
			otr_aRegulEcheances.setParam('Statut', statut);
			otr_aRegulEcheances.initTree(otr_initListeRegulEcheances);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_actualiserListeRegulReglement() {
	try {

		var typePeriode = document.getElementById('otr-typePeriode').value;
		var periode = document.getElementById('otr-periode').value;
		var dateDebut = document.getElementById('otr-dateDebut').value;
		var dateFin = document.getElementById('otr-dateFin').value;
		var numClient = document.getElementById('otr-numClient').value;
		var numFournisseur = document.getElementById('otr-numFournisseur').value;
		var nonTrans = document.getElementById('otr-chkAffRegulReglTrans').checked;
		var statut = document.getElementById('otr-statut').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otr_aRegulReglements.clearParams();
			otr_aRegulReglements.setParam('Type_Periode', typePeriode);
			otr_aRegulReglements.setParam('Periode', periode);
			otr_aRegulReglements.setParam('Date_Debut', dateDebut);
			otr_aRegulReglements.setParam('Date_Fin', dateFin);
			otr_aRegulReglements.setParam('Num_Client', numClient);
			otr_aRegulReglements.setParam('Num_Fournisseur', numFournisseur);
			otr_aRegulReglements.setParam('Comptabilise', nonTrans?"":false);
			otr_aRegulReglements.setParam('Statut', statut);
			otr_aRegulReglements.initTree(otr_initListeRegulReglements);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_actualiserSelection() {
  try {
  	var typePeriode = document.getElementById('otr-typePeriode').value;
		var dateDebut = document.getElementById('otr-dateDebut').value;
		var dateFin = document.getElementById('otr-dateFin').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
	  	otr_actualiserListeRemise();
	  	otr_actualiserListeRemboursement();
	  	otr_actualiserListeRegulEcheance();
	  	otr_actualiserListeRegulReglement();
		} else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_changerTypePeriode(tp) {
  try {

		var b = (tp=="P");
		document.getElementById('otr-dateDebut').disabled = b;
		document.getElementById('otr-dateFin').disabled = b;
		document.getElementById('otr-periode').disabled = !b;

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_initListeRemiseBanque() {
	try {
		toutCocher('otr-remisesBanque', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_initListeRemboursements() {
	try {
		toutCocher('otr-remboursements', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_initListeRegulEcheances() {
	try {
		toutCocher('otr-regulEcheances', true);
	} catch (e) {
		recup_erreur(e);
	}
}



function otr_initListeRegulReglements() {
	try {
		toutCocher('otr-regulReglements', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_selectOnListeRemisesBanque(listitem) {
	try {
		var cks = listitem.getElementsByTagName("listcell");
		var especes = (cks.item(6).getAttribute("label")=="E");
		var remiseId = listitem.value;

		document.getElementById('otr-boxDetails').collapsed=false;
		document.getElementById('otr-listeReglements').collapsed = especes;
		document.getElementById('otr-listeReglementsEspeces').collapsed = !especes;

		if (especes) {
			document.getElementById('otr-listeReglementsEspeces').disabled=true;
			otr_aDetailEspeces.setParam("Remise_Id", remiseId);
			otr_aDetailEspeces.initTree(otr_initDetailEspeces);
		} else {
			otr_aDetailReglements.setParam("Remise_Id", remiseId);
			otr_aDetailReglements.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_initDetailEspeces() {
	try {
		document.getElementById('otr-listeReglementsEspeces').disabled=false;
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_affecterCompte() {
	try {

		if (otr_aDetailReglements.isSelected()) {
			var i = otr_aDetailReglements.getCurrentIndex();
			var tiersId = otr_aDetailReglements.getCellText(i, 'otr-colTiersId');
			var numTiers = otr_aDetailReglements.getCellText(i, 'otr-colNumTiers');
			var typeTiers = otr_aDetailReglements.getCellText(i, 'otr-colTypeTiers');
			var numCompte = otr_aDetailReglements.getCellText(i, 'otr-colNumeroCompte');
			if (!isEmpty(tiersId)) {
				var url;
				if (typeTiers=="C") { url = "chrome://opensi/content/facturation/user/clients/popup-modifierCompteClient.xul?"+ cookie() +"&Client_Id="+ tiersId +"&Num_Client="+ urlEncode(numTiers) +"&Num_Compte="+ urlEncode(numCompte); }
				else { url = "chrome://opensi/content/facturation/user/fournisseurs/popup-modifierCompteFournisseur.xul?"+ cookie() +"&Fournisseur_Id="+ tiersId +"&Num_Fournisseur="+ urlEncode(numTiers) +"&Num_Compte="+ urlEncode(numCompte); }
				window.openDialog(url,'','chrome,modal,centerscreen',reinitialiserListesClients);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_transferer() {
	try {
		var type = document.getElementById('otr-typeTransfert').value;
		if (type=="RR") { otr_checkRemisesRemboursements("Transfert"); }
		else { otr_checkRegularisations("Transfert"); }
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_checkRemisesRemboursements(type) {
	try {

  	var listboxRemisesBanque = document.getElementById("otr-remisesBanque");
		var listeRemisesBanque="";
		var listeAnnulRemisesBanque="";
		var listeRemisesEspeces="";
		var listeAnnulRemisesEspeces="";
		var nbLignes = listboxRemisesBanque.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxRemisesBanque.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				if (cks.item(5).getAttribute("label")=="V") {
					if (cks.item(6).getAttribute("label")=="E") { listeRemisesEspeces += item.value+","; }
					else { listeRemisesBanque += item.value+","; }
				}
				else {
					if (cks.item(6).getAttribute("label")=="E") { listeAnnulRemisesEspeces += item.value+","; }
					else { listeAnnulRemisesBanque += item.value+","; }
				}
			}
			i++;
		}

		var listboxRemboursements = document.getElementById("otr-remboursements");
		var listeRemboursementsClients="";
		var listeAnnulRemboursementsClients="";
		var listeReglementsFourn="";
		var listeAnnulReglementsFourn="";
		nbLignes = listboxRemboursements.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxRemboursements.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				var typeTiers = cks.item(11).getAttribute("label");
				if (typeTiers=="C") {
					if (cks.item(9).getAttribute("label")=="V") { listeRemboursementsClients += item.value+","; }
					else { listeAnnulRemboursementsClients += item.value+","; }
				} else {
					if (cks.item(9).getAttribute("label")=="V") { listeReglementsFourn += item.value+","; }
					else { listeAnnulReglementsFourn += item.value+","; }
				}
			}
			i++;
		}

		if (!isEmpty(listeRemisesBanque) || !isEmpty(listeAnnulRemisesBanque) || !isEmpty(listeRemisesEspeces) || !isEmpty(listeAnnulRemisesEspeces)
				|| !isEmpty(listeRemboursementsClients) || !isEmpty(listeAnnulRemboursementsClients) || !isEmpty(listeReglementsFourn) || !isEmpty(listeAnnulReglementsFourn)) {

			var journalId = document.getElementById('otr-journal').value;
			var modeReglement = document.getElementById('otr-modeReglement').value;

			if (modeReglement!="" && isEmpty(journalId)) { showWarning("Veuillez s\u00E9lectionner un code journal !"); }
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des r\u00E8glements s\u00E9lectionn\u00E9s ?")) {

				if (type=="Transfert") { otr_transfererRemisesRemboursements(listeRemisesBanque, listeAnnulRemisesBanque, listeRemisesEspeces, listeAnnulRemisesEspeces, listeRemboursementsClients, listeAnnulRemboursementsClients, listeReglementsFourn, listeAnnulReglementsFourn, journalId); }
				else { otr_exporterRemisesRemboursements(listeRemisesBanque, listeAnnulRemisesBanque, listeRemisesEspeces, listeAnnulRemisesEspeces, listeRemboursementsClients, listeAnnulRemboursementsClients, listeReglementsFourn, listeAnnulReglementsFourn, journalId); }
			}

		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_transfererRemisesRemboursements(listeRemisesBanque, listeAnnulRemisesBanque, listeRemisesEspeces, listeAnnulRemisesEspeces, listeRemboursementsClients, listeAnnulRemboursementsClients, listeReglementsFourn, listeAnnulReglementsFourn, journalId) {
	try {

		document.getElementById('otr-bTransfert').disabled = true;
		document.getElementById('otr-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertReglements.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Remises_Banque', listeRemisesBanque);
		qTrans.setParam('Liste_Annul_Remises_Banque', listeAnnulRemisesBanque);
		qTrans.setParam('Liste_Remises_Especes', listeRemisesEspeces);
		qTrans.setParam('Liste_Annul_Remises_Especes', listeAnnulRemisesEspeces);
		qTrans.setParam('Liste_Remboursements_Clients', listeRemboursementsClients);
		qTrans.setParam('Liste_Annul_Remboursements_Clients', listeAnnulRemboursementsClients);
		qTrans.setParam('Liste_Reglements_Fournisseurs', listeReglementsFourn);
		qTrans.setParam('Liste_Annul_Reglements_Fournisseurs', listeAnnulReglementsFourn);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		document.getElementById('otr-boxDetails').collapsed=true;
		document.getElementById('otr-listeReglements').collapsed=true;
		document.getElementById('otr-listeReglementsEspeces').collapsed=true;
		otr_aDetailReglements.deleteTree();
		otr_aDetailEspeces.deleteTree();

		otr_aRemisesBanque.initTree(otr_initListeRemiseBanque);
		otr_aRemboursements.initTree(otr_initListeRemboursements);

		document.getElementById('otr-bTransfert').disabled = false;
		document.getElementById('otr-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_checkRegularisations(type) {
  try {

  	var listboxRegulEcheances = document.getElementById("otr-regulEcheances");
		var listeRegulReglFourn="";
		var listeAnnulRegulReglFourn="";
		var listeRegulAvoirFourn="";
		var listeAnnulRegulAvoirFourn="";
		var listeRegulEchClients="";
		var listeAnnulRegulEchClients="";
		var nbLignes = listboxRegulEcheances.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxRegulEcheances.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				var typeRegul = cks.item(9).getAttribute("label");
				var statut = cks.item(10).getAttribute("label");
				if (typeRegul=="R") {
					if (statut=="V") { listeRegulReglFourn += item.value+","; }
					else { listeAnnulRegulReglFourn += item.value+","; }
				} else if (typeRegul=="A") {
					if (statut=="V") { listeRegulAvoirFourn += item.value+","; }
					else { listeAnnulRegulAvoirFourn += item.value+","; }
				} else if (typeRegul=="E") {
					if (statut=="V") { listeRegulEchClients += item.value+","; }
					else { listeAnnulRegulEchClients += item.value+","; }
				}
			}
			i++;
		}

		var listboxRegulReglements = document.getElementById("otr-regulReglements");
		var listeRegulReglClients="";
		var listeAnnulRegulReglClients="";
		var listeRegulAvoirClients="";
		var listeAnnulRegulAvoirClients="";
		var listeRegulEchFourn="";
		var listeAnnulRegulEchFourn="";
		var nbLignes = listboxRegulReglements.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxRegulReglements.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				var typeRegul = cks.item(9).getAttribute("label");
				var statut = cks.item(10).getAttribute("label");
				if (typeRegul=="R") {
					if (statut=="V") { listeRegulReglClients += item.value+","; }
					else { listeAnnulRegulReglClients += item.value+","; }
				} else if (typeRegul=="A") {
					if (statut=="V") { listeRegulAvoirClients += item.value+","; }
					else { listeAnnulRegulAvoirClients += item.value+","; }
				} else if (typeRegul=="E") {
					if (statut=="V") { listeRegulEchFourn += item.value+","; }
					else { listeAnnulRegulEchFourn += item.value+","; }
				}
			}
			i++;
		}

		if (!isEmpty(listeRegulReglFourn) || !isEmpty(listeAnnulRegulReglFourn) || !isEmpty(listeRegulAvoirFourn) || !isEmpty(listeAnnulRegulAvoirFourn) || !isEmpty(listeRegulEchClients) || !isEmpty(listeAnnulRegulEchClients)
				|| !isEmpty(listeRegulReglClients) || !isEmpty(listeAnnulRegulReglClients) || !isEmpty(listeRegulAvoirClients) || !isEmpty(listeAnnulRegulAvoirClients) || !isEmpty(listeRegulEchFourn) || !isEmpty(listeAnnulRegulEchFourn)) {

			var journalId = document.getElementById('otr-journalRegul').value;

			if (isEmpty(journalId)) { showWarning("Veuillez s\u00E9lectionner un code journal !"); }
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des r\u00E9gularisations s\u00E9lectionn\u00E9es ?")) {

				if (type=="Transfert") { otr_transfererRegularisations(listeRegulReglFourn, listeAnnulRegulReglFourn, listeRegulAvoirFourn, listeAnnulRegulAvoirFourn, listeRegulEchClients, listeAnnulRegulEchClients, listeRegulReglClients, listeAnnulRegulReglClients, listeRegulAvoirClients, listeAnnulRegulAvoirClients, listeRegulEchFourn, listeAnnulRegulEchFourn, journalId); }
				else { otr_exporterRegularisations(listeRegulReglFourn, listeAnnulRegulReglFourn, listeRegulAvoirFourn, listeAnnulRegulAvoirFourn, listeRegulEchClients, listeAnnulRegulEchClients, listeRegulReglClients, listeAnnulRegulReglClients, listeRegulAvoirClients, listeAnnulRegulAvoirClients, listeRegulEchFourn, listeAnnulRegulEchFourn, journalId); }
			}

		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otr_transfererRegularisations(listeRegulReglFourn, listeAnnulRegulReglFourn, listeRegulAvoirFourn, listeAnnulRegulAvoirFourn, listeRegulEchClients, listeAnnulRegulEchClients, listeRegulReglClients, listeAnnulRegulReglClients, listeRegulAvoirClients, listeAnnulRegulAvoirClients, listeRegulEchFourn, listeAnnulRegulEchFourn, journalId) {
	try {

		document.getElementById('otr-bTransfert').disabled = true;
		document.getElementById('otr-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertRegularisations.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Regul_Regl_Fournisseurs', listeRegulReglFourn);
		qTrans.setParam('Liste_Annul_Regul_Regl_Fournisseurs', listeAnnulRegulReglFourn);
		qTrans.setParam('Liste_Regul_Avoir_Fournisseurs', listeRegulAvoirFourn);
		qTrans.setParam('Liste_Annul_Regul_Avoir_Fournisseurs', listeAnnulRegulAvoirFourn);
		qTrans.setParam('Liste_Regul_Echeances_Clients', listeRegulEchClients);
		qTrans.setParam('Liste_Annul_Regul_Echeances_Clients', listeAnnulRegulEchClients);
		qTrans.setParam('Liste_Regul_Regl_Clients', listeRegulReglClients);
		qTrans.setParam('Liste_Annul_Regul_Regl_Clients', listeAnnulRegulReglClients);
		qTrans.setParam('Liste_Regul_Avoir_Clients', listeRegulAvoirClients);
		qTrans.setParam('Liste_Annul_Regul_Avoir_Clients', listeAnnulRegulAvoirClients);
		qTrans.setParam('Liste_Regul_Echeances_Fourn', listeRegulEchFourn);
		qTrans.setParam('Liste_Annul_Regul_Echeances_Fourn', listeAnnulRegulEchFourn);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		otr_aRegulEcheances.initTree(otr_initListeRegulEcheances);
		otr_aRegulReglements.initTree(otr_initListeRegulReglements);

		document.getElementById('otr-bTransfert').disabled = false;
		document.getElementById('otr-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', otr_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}

function otr_retourRechercherClient(codeClient) {
	try {
  	document.getElementById('otr-numClient').value = codeClient;
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', otr_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}

function otr_retourRechercherFournisseur(codeFournisseur) {
	try {
  	document.getElementById('otr-numFournisseur').value = codeFournisseur;
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_exporter() {
	try {
		var type = document.getElementById('otr-typeTransfert').value;
		formatExport = document.getElementById('otr-formatExport').value;
		if (isEmpty(formatExport)) { showWarning("Veuillez choisir un format d'export."); }
		else if (checkNomFichierExport(formatExport)) {
			if (type=="RR") { otr_checkRemisesRemboursements("Export"); }
			else { otr_checkRegularisations("Export"); }
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function otr_exporterRemisesRemboursements(listeRemisesBanque, listeAnnulRemisesBanque, listeRemisesEspeces, listeAnnulRemisesEspeces, listeRemboursementsClients, listeAnnulRemboursementsClients, listeReglementsFourn, listeAnnulReglementsFourn, journalId) {
	try {

		document.getElementById('otr-bTransfert').disabled = true;
		document.getElementById('otr-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Remises_Remboursements");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Remises_Banque', listeRemisesBanque);
		qExport.setParam('Liste_Annul_Remises_Banque', listeAnnulRemisesBanque);
		qExport.setParam('Liste_Remises_Especes', listeRemisesEspeces);
		qExport.setParam('Liste_Annul_Remises_Especes', listeAnnulRemisesEspeces);
		qExport.setParam('Liste_Remboursements_Clients', listeRemboursementsClients);
		qExport.setParam('Liste_Annul_Remboursements_Clients', listeAnnulRemboursementsClients);
		qExport.setParam('Liste_Reglements_Fourn', listeReglementsFourn);
		qExport.setParam('Liste_Annul_Reglements_Fourn', listeAnnulReglementsFourn);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('otr-bTransfert').disabled = false;
		document.getElementById('otr-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function otr_exporterRegularisations(listeRegulReglFourn, listeAnnulRegulReglFourn, listeRegulAvoirFourn, listeAnnulRegulAvoirFourn, listeRegulEchClients, listeAnnulRegulEchClients, listeRegulReglClients, listeAnnulRegulReglClients, listeRegulAvoirClients, listeAnnulRegulAvoirClients, listeRegulEchFourn, listeAnnulRegulEchFourn, journalId) {
	try {

		document.getElementById('otr-bTransfert').disabled = true;
		document.getElementById('otr-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Regularisations");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Regul_Regl_Fourn', listeRegulReglFourn);
		qExport.setParam('Liste_Annul_Regul_Regl_Fourn', listeAnnulRegulReglFourn);
		qExport.setParam('Liste_Regul_Avoir_Fourn', listeRegulAvoirFourn);
		qExport.setParam('Liste_Annul_Regul_Avoir_Fourn', listeAnnulRegulAvoirFourn);
		qExport.setParam('Liste_Regul_Ech_Clients', listeRegulEchClients);
		qExport.setParam('Liste_Annul_Regul_Ech_Clients', listeAnnulRegulEchClients);
		qExport.setParam('Liste_Regul_Regl_Clients', listeRegulReglClients);
		qExport.setParam('Liste_Annul_Regul_Regl_Clients', listeAnnulRegulReglClients);
		qExport.setParam('Liste_Regul_Avoir_Clients', listeRegulAvoirClients);
		qExport.setParam('Liste_Annul_Regul_Avoir_Clients', listeAnnulRegulAvoirClients);
		qExport.setParam('Liste_Regul_Ech_Fourn', listeRegulEchFourn);
		qExport.setParam('Liste_Annul_Regul_Ech_Fourn', listeAnnulRegulEchFourn);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('otr-bTransfert').disabled = false;
		document.getElementById('otr-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}

