/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var etablissementDefaut;
var depotDefaut;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				var intituleGroupe = contenu.getAttribute("Intitule_"+ i);
				document.getElementById("oebt-colAttribut"+ i).setAttribute("label", intituleGroupe);
				document.getElementById("oets-colAttribut"+ i +"TS").setAttribute("label", intituleGroupe);
				document.getElementById("orts-colAttribut"+ i +"TS").setAttribute("label", intituleGroupe);
			}
			else {
				document.getElementById("oebt-colAttribut"+ i).collapsed = true;
				document.getElementById("oets-colAttribut"+ i +"TS").collapsed = true;
				document.getElementById("orts-colAttribut"+ i +"TS").collapsed = true;
				document.getElementById("oebt-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
				document.getElementById("oets-colAttribut"+ i +"TS").setAttribute("ignoreincolumnpicker", true);
				document.getElementById("orts-colAttribut"+ i +"TS").setAttribute("ignoreincolumnpicker", true);
			}
		}

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

  	document.getElementById('deck').selectedIndex = 0;
  	omt_init();
  	oebt_init();
		oets_init();
		orts_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuTransferts() {
	try {

		document.getElementById('oebt-pdfBonTransfert').setAttribute("src", "");
		document.getElementById('oets-pdfBonLivraison').setAttribute("src", "");
		document.getElementById('orts-pdfBonReception').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuTransferts').collapsed = true;
		document.getElementById('bRetourTransfert').collapsed = true;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourBR').collapsed = true;

		document.activeElement.blur();
		omt_listerTransferts();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourTransfert() {
  try {

		document.getElementById('oebt-pdfBonTransfert').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('oebt-deckBonTransfert').selectedIndex = 0;
		document.getElementById('bRetourTransfert').collapsed = true;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourBR').collapsed = true;
		oebt_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonLivraison() {
  try {

		document.getElementById('oets-pdfBonLivraison').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('oets-deckBonLivraison').selectedIndex = 0;
		document.getElementById('bRetourExpedition').collapsed = true;
		oets_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonReception() {
  try {

		document.getElementById('orts-pdfBonReception').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('orts-deckBonReception').selectedIndex = 0;
		document.getElementById('bRetourBR').collapsed = true;
		orts_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oebt_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		switch (currentDeck) {
			case 1: oebt_demandeEnregistrement(); break;
			case 2: oets_demandeEnregistrement(); break;
			case 3: orts_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
