/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omt_aTransferts = new Arbre('Facturation/Transferts_Stocks/list-transfertStock.tmpl', 'omt-listeTransferts');
var omt_aApercuTransfert = new Arbre('Facturation/Transferts_Stocks/list-apercuTransfertStock.tmpl', 'omt-apercu');
var omt_qListTS = new QueryHttp("Facturation/Transferts_Stocks/getDataListTS.tmpl");

var omt_aDepotsDepart = new Arbre("ComboListe/combo-depotsStock.tmpl", "omt-depotDepart");
var omt_aDepotsArrivee = new Arbre("ComboListe/combo-depotsStock.tmpl", "omt-depotArrivee");
var omt_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omt-etablissement');

var omt_pageCourante;
var omt_nbPages;


function omt_init() {
  try {

  	omt_aDepotsDepart.initTree(omt_initDepotDepart);

  } catch (e) {
  	recup_erreur(e);
  }
}


function omt_initDepotDepart() {
	try {

		document.getElementById('omt-depotDepart').value = "";
		omt_aDepotsArrivee.initTree(omt_initDepotArrivee);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initDepotArrivee() {
	try {

		document.getElementById('omt-depotArrivee').value = "";
		omt_aEtablissements.initTree(omt_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initEtablissement() {
	try {

		document.getElementById('omt-etablissement').value = "";
		omt_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initCriteres() {
	try {

		document.getElementById('omt-numTransfert').value = "";
		document.getElementById('omt-intitule').value = "";
		document.getElementById('omt-etat').value = "T";
		document.getElementById('omt-depotDepart').value = "";
		document.getElementById('omt-depotArrivee').value = "";
		document.getElementById('omt-etablissement').value = "";
		document.getElementById('omt-dateDebut').value = "";
		document.getElementById('omt-dateFin').value = "";
		document.getElementById('omt-dateExpeditionDebut').value = "";
		document.getElementById('omt-dateExpeditionFin').value = "";
		document.getElementById('omt-dateReceptionDebut').value = "";
		document.getElementById('omt-dateReceptionFin').value = "";
		document.getElementById('omt-statutExpedition').value = "";
		document.getElementById('omt-statutReception').value = "";
		document.getElementById('omt-refArticle').value = "";
		document.getElementById('omt-numBL').value = "";
		document.getElementById('omt-numBR').value = "";

		omt_changeModeTraitement();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_changeModeTraitement() {
	try {

		var mode = document.getElementById('omt-modeTraitement').value;

		if (mode!="T") {
			document.getElementById('omt-etat').value = "T";
		}

		document.getElementById('omt-etat').disabled = (mode!="T");
		document.getElementById('omt-bLegende').collapsed = (mode!="E");
		document.getElementById('omt-boxStatutExpedition').collapsed = (mode!="E");
		document.getElementById('omt-boxStatutReception').collapsed = (mode!="R");
		document.getElementById('omt-colDispoStock').collapsed = (mode!="E");
		if (mode!="E") {
			document.getElementById('omt-colDispoStock').setAttribute('ignoreincolumnpicker', true);
		}
		else {
			document.getElementById('omt-colDispoStock').removeAttribute('ignoreincolumnpicker');
		}

		omt_listerTransferts();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_listerTransferts() {
	try {

		var modeTraitement = document.getElementById('omt-modeTraitement').value;
		var etat = document.getElementById('omt-etat').value;
		var numTransfert = document.getElementById('omt-numTransfert').value;
		var intitule = document.getElementById('omt-intitule').value;
		var depotDepart = document.getElementById('omt-depotDepart').value;
		var depotArrivee = document.getElementById('omt-depotArrivee').value;
		var etablissement = document.getElementById('omt-etablissement').value;
		var dateDebut = document.getElementById('omt-dateDebut').value;
		var dateFin = document.getElementById('omt-dateFin').value;
		var dateExpeditionDebut = document.getElementById('omt-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('omt-dateExpeditionFin').value;
		var dateReceptionDebut = document.getElementById('omt-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omt-dateReceptionFin').value;
		var statutExpedition = (modeTraitement=="E"?document.getElementById('omt-statutExpedition').value:"");
		var statutReception = (modeTraitement=="R"?document.getElementById('omt-statutReception').value:"");
		var reference = document.getElementById('omt-refArticle').value;
		var numeroBL = document.getElementById('omt-numBL').value;
		var numeroBR = document.getElementById('omt-numBR').value;
		var nbLignesParPage = document.getElementById('omt-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionDebut) && !isDate(dateReceptionDebut)) { showWarning("Date de r\u00E9ception pr\u00E9vue de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateReceptionFin) && !isDate(dateReceptionFin)) { showWarning("Date de r\u00E9ception pr\u00E9vue de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateReceptionDebut) && !isEmpty(dateReceptionFin) && !isDateInterval(dateReceptionDebut, dateReceptionFin)) { showWarning("Plage de dates de r\u00E9ception pr\u00E9vue incorrecte"); }
		else {

			omt_pageCourante = 1;
			omt_nbPages = 1;
			document.getElementById('omt-pageDeb').value = 1;
			document.getElementById('omt-pageFin').value = 1;
			document.getElementById('omt-bPrec').disabled = true;
			document.getElementById('omt-bSuiv').disabled = true;

			document.getElementById('omt-listeTransferts').disabled = true;
			document.getElementById('omt-bEditionCsv').disabled = true;
			document.getElementById('omt-bEditionDetailCsv').disabled = true;
			document.getElementById('omt-numTransfertSelect').value = "";
			omt_aApercuTransfert.deleteTree();
			omt_aTransferts.deleteTree();

			omt_qListTS.setParam("Num_Transfert", numTransfert);
			omt_qListTS.setParam("Intitule", intitule);
			omt_qListTS.setParam("Etat", etat);
			omt_qListTS.setParam("Depot_Depart", depotDepart);
			omt_qListTS.setParam("Depot_Arrivee", depotArrivee);
			omt_qListTS.setParam("Etab_Id", etablissement);
			omt_qListTS.setParam("Date_Debut", dateDebut);
			omt_qListTS.setParam("Date_Fin", dateFin);
			omt_qListTS.setParam("Date_Expedition_Debut", dateExpeditionDebut);
			omt_qListTS.setParam("Date_Expedition_Fin", dateExpeditionFin);
			omt_qListTS.setParam("Date_Reception_Debut", dateReceptionDebut);
			omt_qListTS.setParam("Date_Reception_Fin", dateReceptionFin);
			omt_qListTS.setParam("Statut_Expedition", statutExpedition);
			omt_qListTS.setParam("Statut_Reception", statutReception);
			omt_qListTS.setParam("Reference", reference);
			omt_qListTS.setParam("Numero_BL", numeroBL);
			omt_qListTS.setParam("Numero_BR", numeroBR);
			omt_qListTS.setParam("Mode_Traitement", modeTraitement);
			omt_qListTS.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omt_qListTS.setParam("Current_Page", omt_pageCourante);

			var result = omt_qListTS.execute();

			var contenu = result.responseXML.documentElement;

			omt_nbPages = contenu.getAttribute("Nb_Pages");
			var listTransfertId = contenu.getAttribute("List_Transfert_Id");

			omt_aTransferts.setParam("List_Transfert_Id", listTransfertId);
			omt_aTransferts.setParam("Mode_Traitement", modeTraitement);
			omt_aTransferts.initTree(omt_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initPagination() {
	try {

		document.getElementById('omt-pageDeb').value = omt_pageCourante;
		document.getElementById('omt-pageFin').value = (omt_nbPages>0?omt_nbPages:1);
		document.getElementById('omt-bPrec').disabled = (omt_pageCourante==1);
		document.getElementById('omt-bSuiv').disabled = (omt_pageCourante>=omt_nbPages); // peut se produire si omt_nbPages=0

		document.getElementById('omt-listeTransferts').disabled = false;
		document.getElementById('omt-bEditionCsv').disabled = (omt_aTransferts.nbLignes()==0);
		document.getElementById('omt-bEditionDetailCsv').disabled = (omt_aTransferts.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnPagePrec() {
	try {

		omt_pageCourante--;
		omt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnPageSuiv() {
	try {

		omt_pageCourante++;
		omt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_majPagination() {
	try {

		document.getElementById('omt-pageDeb').value = omt_pageCourante;
		document.getElementById('omt-bPrec').disabled = (omt_pageCourante==1);
		document.getElementById('omt-bSuiv').disabled = (omt_pageCourante==omt_nbPages);

		document.getElementById('omt-numTransfertSelect').value = "";

		document.getElementById('omt-listeTransferts').disabled = true;
		document.getElementById('omt-bEditionCsv').disabled = true;
		document.getElementById('omt-bEditionDetailCsv').disabled = true;
		omt_aApercuTransfert.deleteTree();

		omt_qListTS.setParam("Current_Page", omt_pageCourante);
		var result = omt_qListTS.execute();
		var listTransfertId = result.responseXML.documentElement.getAttribute("List_Transfert_Id");

		omt_aTransferts.setParam("List_Transfert_Id", listTransfertId);
		omt_aTransferts.initTree(omt_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_afterMajPagination() {
	try {

		document.getElementById('omt-listeTransferts').disabled = false;
		document.getElementById('omt-bEditionCsv').disabled = (omt_aTransferts.nbLignes()==0);
		document.getElementById('omt-bEditionDetailCsv').disabled = (omt_aTransferts.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_selectOnListeTransferts() {
	try {

		if (omt_aTransferts.isSelected()) {
			var transfertId = omt_aTransferts.getSelectedCellText('omt-colTransfertId');
			document.getElementById('omt-numTransfertSelect').value = omt_aTransferts.getSelectedCellText('omt-colNumTransfert');
			omt_aApercuTransfert.setParam("Transfert_Id", transfertId);
			omt_aApercuTransfert.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnNouveauTransfert() {
	try {

		document.getElementById('deck').selectedIndex=1;
		document.getElementById('bMenuTransferts').collapsed=false;
		oebt_nouveauBon();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omt_listerTransferts();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omt_pressOnListeTransferts(ev) {
  try {

		if (ev.keyCode==13) {
			omt_ouvrirTransfert();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omt_ouvrirTransfert() {
  try {

  	if (omt_aTransferts.isSelected()) {

			var transfertId = omt_aTransferts.getSelectedCellText('omt-colTransfertId');
			document.getElementById('bMenuTransferts').collapsed = false;

			var mode = document.getElementById('omt-modeTraitement').value;

			oebt_transfertId = transfertId;

			if (mode=="T") {
				document.getElementById('deck').selectedIndex = 1;
				oebt_chargerBon();
			}
			else if (mode=="E") {
				document.getElementById('deck').selectedIndex = 2;
				oets_transfertId = transfertId;
				oets_start();
				document.getElementById('bRetourTransfert').collapsed = false;
			}
			else if (mode=="R") {
				document.getElementById('deck').selectedIndex = 3;
				orts_transfertId = transfertId;
				orts_start();
				document.getElementById('bRetourTransfert').collapsed = false;
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omt_pressOnEditionCsv() {
	try {

		var modeTraitement = document.getElementById('omt-modeTraitement').value;
		var numTransfert = document.getElementById('omt-numTransfert').value;
		var intitule = document.getElementById('omt-intitule').value;
		var etat = document.getElementById('omt-etat').value;
		var depotDepart = document.getElementById('omt-depotDepart').value;
		var depotArrivee = document.getElementById('omt-depotArrivee').value;
		var etablissement = document.getElementById('omt-etablissement').value;
		var dateDebut = document.getElementById('omt-dateDebut').value;
		var dateFin = document.getElementById('omt-dateFin').value;
		var dateExpeditionDebut = document.getElementById('omt-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('omt-dateExpeditionFin').value;
		var dateReceptionDebut = document.getElementById('omt-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omt-dateReceptionFin').value;
		var statutExpedition = (modeTraitement=="E"?document.getElementById('omt-statutExpedition').value:"");
		var statutReception = (modeTraitement=="R"?document.getElementById('omt-statutReception').value:"");
		var reference = document.getElementById('omt-refArticle').value;
		var numeroBL = document.getElementById('omt-numBL').value;
		var numeroBR = document.getElementById('omt-numBR').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Transferts_Stocks/csvTransfertStock.tmpl");
			qEditionCsv.setParam("Num_Transfert", numTransfert);
			qEditionCsv.setParam("Intitule", intitule);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Depot_Depart", depotDepart);
			qEditionCsv.setParam("Depot_Arrivee", depotArrivee);
			qEditionCsv.setParam("Etab_Id", etablissement);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Date_Expedition_Debut", dateExpeditionDebut);
			qEditionCsv.setParam("Date_Expedition_Fin", dateExpeditionFin);
			qEditionCsv.setParam("Date_Reception_Debut", dateReceptionDebut);
			qEditionCsv.setParam("Date_Reception_Fin", dateReceptionFin);
			qEditionCsv.setParam("Statut_Expedition", statutExpedition);
			qEditionCsv.setParam("Statut_Reception", statutReception);
			qEditionCsv.setParam("Mode_Traitement", modeTraitement);
			qEditionCsv.setParam("Reference", reference);
			qEditionCsv.setParam("Numero_BL", numeroBL);
			qEditionCsv.setParam("Numero_BR", numeroBR);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnEditionDetailCsv() {
	try {

		var modeTraitement = document.getElementById('omt-modeTraitement').value;
		var numTransfert = document.getElementById('omt-numTransfert').value;
		var intitule = document.getElementById('omt-intitule').value;
		var etat = document.getElementById('omt-etat').value;
		var depotDepart = document.getElementById('omt-depotDepart').value;
		var depotArrivee = document.getElementById('omt-depotArrivee').value;
		var etablissement = document.getElementById('omt-etablissement').value;
		var dateDebut = document.getElementById('omt-dateDebut').value;
		var dateFin = document.getElementById('omt-dateFin').value;
		var dateExpeditionDebut = document.getElementById('omt-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('omt-dateExpeditionFin').value;
		var dateReceptionDebut = document.getElementById('omt-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omt-dateReceptionFin').value;
		var statutExpedition = (modeTraitement=="E"?document.getElementById('omt-statutExpedition').value:"");
		var statutReception = (modeTraitement=="R"?document.getElementById('omt-statutReception').value:"");
		var reference = document.getElementById('omt-refArticle').value;
		var numeroBL = document.getElementById('omt-numBL').value;
		var numeroBR = document.getElementById('omt-numBR').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Transferts_Stocks/csvDetailTransfertStock.tmpl");
			qEditionCsv.setParam("Num_Transfert", numTransfert);
			qEditionCsv.setParam("Intitule", intitule);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Depot_Depart", depotDepart);
			qEditionCsv.setParam("Depot_Arrivee", depotArrivee);
			qEditionCsv.setParam("Etab_Id", etablissement);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Date_Expedition_Debut", dateExpeditionDebut);
			qEditionCsv.setParam("Date_Expedition_Fin", dateExpeditionFin);
			qEditionCsv.setParam("Date_Reception_Debut", dateReceptionDebut);
			qEditionCsv.setParam("Date_Reception_Fin", dateReceptionFin);
			qEditionCsv.setParam("Statut_Expedition", statutExpedition);
			qEditionCsv.setParam("Statut_Reception", statutReception);
			qEditionCsv.setParam("Mode_Traitement", modeTraitement);
			qEditionCsv.setParam("Reference", reference);
			qEditionCsv.setParam("Numero_BL", numeroBL);
			qEditionCsv.setParam("Numero_BR", numeroBR);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/transferts_stocks/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}
