/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
 * bibliothque de fonctions servant  vrifier des conditions sur des champs de saisie.
 */


function isPositive(val) {
	return !isEmpty(val) && !isNaN(val) && val > 0 && isFinite(val);
}

function isPositiveOrNull(val) {
	return !isEmpty(val) && !isNaN(val) && val >= 0 && isFinite(val);
}

function isPositiveInteger(val) {
	return !isEmpty(val) && !isNaN(val) && val > 0 && parseFloat(val)==parseIntBis(val) && isFinite(val) && val.toString().indexOf(".")==-1;
}

function isPositiveOrNullInteger(val) {
	return !isEmpty(val) && !isNaN(val) && val >= 0 && parseFloat(val)==parseIntBis(val) && isFinite(val) && val.toString().indexOf(".")==-1;
}

function isTaux(val) {
	try {

		return isPositiveOrNull(val) && val <= 100 && checkDecimal(val,2);

	} catch (e) {
    recup_erreur(e);
  }
}

/*
	val -> valeur  examiner
	dec -> nombre de decimales maxi (>=0)
*/
function checkDecimal(val,dec) {
	try {

		if (isEmpty(val) || isNaN(val)) return false;

		val = val.toString();

		var indexOfPoint = val.indexOf(".");

		if (indexOfPoint==-1)
			return true;
		else
			return (val.substring(indexOfPoint+1, val.length).length <= dec);

	} catch (e) {
    recup_erreur(e);
  }
}


/*
	val -> valeur  examiner
	dec -> nombre maxi de chiffres composant la partie entire (>=0)
*/
function checkIPart(val,nbc) {
	try {

		if (isNaN(val)) return false;

		val = val.toString();

		var indexOfPoint = val.indexOf(".");

		if (indexOfPoint==-1)
			return (val.length <= nbc);
		else
			return (val.substring(0, indexOfPoint).length <= nbc);

	} catch (e) {
    recup_erreur(e);
  }
}


function checkNumber(val,nbi,nbd) {
	try {

		return checkIPart(val,nbi-nbd) && checkDecimal(val,nbd);

	} catch (e) {
    recup_erreur(e);
  }
}


function isDigitList(val) {
  try {

		var regex = /^\d*$/;
    return (regex.test(val));

  } catch (e) {
    recup_erreur(e);
  }
}


function isAlpha(val) {
	try {

		var regex = /^[a-zA-Z]*$/;
    return (regex.test(val));

	} catch (e) {
    recup_erreur(e);
  }
}


function isAlphaNum(val) {
	try {

		var regex = /^[a-zA-Z0-9]*$/;
    return (regex.test(val));

	} catch (e) {
    recup_erreur(e);
  }
}


function isEmpty(val) {
  try {

	  return String.trim(val).length < 1;

  } catch (e) {
    recup_erreur(e);
  }
}


function isPhone(val) {
  try {

		var regex = /^[\d()\+\ .\-]+$/;
    return (regex.test(val));

  } catch (e) {
    recup_erreur(e);
  }
}


function isCleAlpha(val) {
  try {

		var regex = /^[a-zA-Z0-9_\-]*$/;
    return (regex.test(val));

  } catch (e) {
    recup_erreur(e);
  }
}


function isCodeBarre(val) {
  try {

		var regex = /^[a-zA-Z0-9_\-.,;:/]*$/;
    return (regex.test(val));

  } catch (e) {
    recup_erreur(e);
  }
}


function isArithmetic(val) {
  try {

		var regex = /^\d*.{0,1}\d+[\+\-/\*]+\d*.{0,1}\d+([\+\-/\*]+\d*.{0,1}\d+)*$/;
    return regex.test(val.replace(/ /gi, ''));

  } catch (e) {
    recup_erreur(e);
  }
}


function isBissextile(a) {
  try {

	  return  a%4==0 && ((a%100==0 && a%400==0) || a%100!=0);

  } catch (e) {
    recup_erreur(e);
  }
}


function isJourValide(j,m,a) {
  try {

  	switch(m) {
	  	case 1:case 3:case 5:case 7: case 8:case 10:case 12:
		  	return j<=31;
			  break;
  		case 4:case 6:case 9:case 11:
	  		return j<=30;
		  	break;
  		case 2:
	  		return isBissextile(a)?j<=29:j<=28;
		  	break;
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function isDate(val) {
  try {

		var regex = /^\d{2}\/\d{2}\/\d{4}$/;

  	if (!regex.test(val)) {
	  	return false;
		}
		else {
			var j = parseIntBis(val.substring(0,2));
		  var m = parseIntBis(val.substring(3,5));
  		var a = parseIntBis(val.substring(6,10));

			if (j>31 || j<1 || m>12 || m<1)
	  		return false;
  		else if (!isJourValide(j,m,a))
	  		return false;
			else if (a>2080 || a<1940) {
				return false;
			}
  		else
	  		return true;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function isDateInterval(d,f) {
  try {

  	var jj1 = parseIntBis(d.substring(0,2));
	  var mm1 = parseIntBis(d.substring(3,5));
  	var aa1 = parseIntBis(d.substring(6,d.length));
	  var jj2 = parseIntBis(f.substring(0,2));
  	var mm2 = parseIntBis(f.substring(3,5));
	  var aa2 = parseIntBis(f.substring(6,f.length));

  	return aa1 < aa2 || (aa1==aa2 && (mm1 < mm2 || (mm1==mm2 && jj1 <= jj2)));

  } catch (e) {
    recup_erreur(e);
  }
}


function isStrictDateInterval(d,f) {
  try {

  	return d!=f && isDateInterval(d,f);

  } catch (e) {
    recup_erreur(e);
  }
}


function isPeriode(val) {
  try {

	  if (val.length==4 && isDigitList(val)) {
		  var mm = parseIntBis(val.substring(0,2));
  		var aa = parseIntBis(val.substring(2,4));
	  	return mm <= 12 && mm >= 1 && aa <= 99 && aa >= 0;
	  }
	  else
		  return false;

  } catch (e) {
    recup_erreur(e);
  }
}


function isPeriodeInterval(d,f) {
  try {

  	var mm1 = parseIntBis(d.substring(0,2));
		var aa1 = parseIntBis(d.substring(2,4));
  	var mm2 = parseIntBis(f.substring(0,2));
	  var aa2 = parseIntBis(f.substring(2,4));

  	return aa1 < aa2 || (aa1==aa2 && mm1 <= mm2);

  } catch (e) {
    recup_erreur(e);
  }
}


function getDate(val) {
  try {

		var jj = parseIntBis(val.substring(0,2));
		var mm = parseIntBis(val.substring(3,5));
		var aa = parseIntBis(val.substring(6,10));
		var hh = 0;
		var m = 0;

		if (val.length==16) {
			hh = parseIntBis(val.substring(11,13));
			m = parseIntBis(val.substring(14,16));
		}

		return new Date(aa,mm-1,jj,hh,m,0);

  } catch (e) {
    recup_erreur(e);
  }
}


function convertXulDateTime(d,t) {
	try {

		var tt = t;
		if (tt.length==7) tt = "0"+ tt;
		if (tt.length==8) tt = tt.substring(0,5);

		return d +" "+ tt;

	} catch (e) {
    recup_erreur(e);
  }
}


function isDateTime(val) {
  try {

		if (val.length==10) {
			return isDate(val);
		}
		else {
			var regex = /^ \d{2}:\d{2}$/;

			if (val.length!=16 || !regex.test(val.substring(10,16))) {
				return false;
			}
			else {
				var hh = parseIntBis(val.substring(11,13));
				var mm = parseIntBis(val.substring(14,16));
				return mm>=0 && mm<=59 && hh>=0 && hh<=23 && isDate(val.substring(0,10));
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function isDateTimeInterval(d,f) {
  try {

		var date1 = getDate(d);
		var date2 = getDate(f);

		if (f.length==10) {
			date2.setDate(date2.getDate()+1);
			date2.setTime(date2.getTime()-1);
		}

		return date1.getTime()<=date2.getTime();

  } catch (e) {
    recup_erreur(e);
  }
}


function isStrictDateTimeInterval(d,f) {
  try {

		return d!=f && isDateTimeInterval(d,f);

  } catch (e) {
    recup_erreur(e);
  }
}


function isEmail(email) {
  try {

		var regex = /^[a-zA-Z0-9._+-]+@[a-zA-Z0-9._-]{1,}\.[a-zA-Z]{2,15}$/;
    return (regex.test(email));

	} catch (e) {
    recup_erreur(e);
  }
}


function isValidPassword(val) {
  try {

		var rgxMin = /^.*[a-z]+.*$/;
		var rgxMaj = /^.*[A-Z]+.*$/;
		var rgxChi = /^.*[0-9]+.*$/;
		var rgxSpe = /^.*[^a-zA-Z0-9]+.*$/;

		var score = 0;

		if (rgxMin.test(val)) { score++; }
		if (rgxMaj.test(val)) { score++; }
		if (rgxChi.test(val)) { score++; }
		if (rgxSpe.test(val)) { score++; }

		return score>=3;

  } catch (e) {
    recup_erreur(e);
  }
}


function isWeb(argvalue) {

  return true;
}


function isCompteCorrect(numc) {
  try {

		var regex = /^[a-zA-Z0-9_\\-]{3,8}$/;
    return (regex.test(numc));

  } catch (e) {
    recup_erreur(e);
  }
}


function checkQte(val) {
	try {

		return !isEmpty(val) && isPositive(val) && checkNumber(val, 10, 3);

	} catch (e) {
    recup_erreur(e);
  }
}
