/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var typeDoc;
var docId;
var langue;
var critere1;
var critere2;
var critere3;
var critere4;

var XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
var tabAttachedFiles = new Array();
var incFileId = 0;
var attachSize = 0;

var tabRecipients = new Array();
var incRecipientId = 0;
var listDestinataire;

var tabCarbonCopies = new Array();
var incCarbonCopyId = 0;
var listCopie;

var tabBlindCopies = new Array();
var incBlindCopyId = 0;
var listBCC;

var clientId;
var fournisseurId;

var aAssoc = null;



function init() {
	try {

		if (getConfig().isMailExpUtil()) {
			document.getElementById('expediteur').setAttribute("readonly", true);
		}

		typeDoc = window.arguments[0];
		docId = window.arguments[1];
		langue = (window.arguments.length>2?window.arguments[2]:"");
		critere1 = (window.arguments.length>3?window.arguments[3]:"");
		critere2 = (window.arguments.length>4?window.arguments[4]:"");
		critere3 = (window.arguments.length>5?window.arguments[5]:"");
		critere4 = (window.arguments.length>6?window.arguments[6]:"");

		var modele = true;

		var libellePopup = "";
		var libelleSujet = "";
		var tmplAssoc = null;

		if (typeDoc=="MP") {
			libellePopup = "ENVOI D'UN MANDAT PAR E-MAIL";
			libelleSujet = "Mandat N\u00B0 ";
		}
		else if (typeDoc=="AC") {
			libellePopup = "ENVOI D'UN AVOIR CLIENT PAR E-MAIL";
			libelleSujet = "Avoir N\u00B0 ";
			tmplAssoc = "Facturation/Avoirs/list-fichierAssocAC.tmpl";
		}
		else if (typeDoc=="TS") {
			libellePopup = "ENVOI D'UN TRANSFERT DE STOCK PAR E-MAIL";
			libelleSujet = "Transfert de stock N\u00B0 ";
		}
		else if (typeDoc=="TE") {
			libellePopup = "ENVOI D'UN TRANSFERT D'EMPLACEMENTS PAR E-MAIL";
			libelleSujet = "Transfert d'emplacements N\u00B0 ";
		}
		else if (typeDoc=="BLT") {
			libellePopup = "ENVOI D'UN BON DE LIVRAISON PAR E-MAIL";
			libelleSujet = "Bon de livraison N\u00B0 ";
		}
		else if (typeDoc=="BRT") {
			libellePopup = "ENVOI D'UN BON DE RECEPTION PAR E-MAIL";
			libelleSujet = "Bon de r\u00E9ception N\u00B0 ";
		}
		else if (typeDoc=="FC") {
			libellePopup = "ENVOI D'UNE FACTURE CLIENT PAR E-MAIL";
			libelleSujet = "Facture N\u00B0 ";
			tmplAssoc = "Facturation/FacturesVente/list-fichierAssocFC.tmpl";
		}
		else if (typeDoc=="PF") {
			libellePopup = "ENVOI D'UNE PROFORMA PAR E-MAIL";
			libelleSujet = "Proforma N\u00B0 ";
		}
		else if (typeDoc=="DC") {
			libellePopup = "ENVOI D'UN DEVIS PAR E-MAIL";
			libelleSujet = "Devis N\u00B0 ";
			tmplAssoc = "Facturation/Devis/list-fichierAssocDC.tmpl";
		}
		else if (typeDoc=="OF") {
			libellePopup = "ENVOI D'UN ORDRE DE FABRICATION PAR E-MAIL";
			libelleSujet = "Ordre de fabrication N\u00B0 ";
		}
		else if (typeDoc=="RC") {
			libellePopup = "ENVOI D'UN RETOUR CLIENT PAR E-MAIL";
			libelleSujet = "Retour N\u00B0 ";
			tmplAssoc = "Facturation/Affaires/list-fichierAssocRC.tmpl";
		}
		else if (typeDoc=="RF") {
			libellePopup = "ENVOI D'UN RETOUR FOURNISSEUR PAR E-MAIL";
			libelleSujet = "Retour N\u00B0 ";
		}
		else if (typeDoc=="BLR") {
			libellePopup = "ENVOI D'UN BON DE LIVRAISON PAR E-MAIL";
			libelleSujet = "Bon de livraison N\u00B0 ";
		}
		else if (typeDoc=="BRR") {
			libellePopup = "ENVOI D'UN BON DE RECEPTION PAR E-MAIL";
			libelleSujet = "Bon de r\u00E9ception N\u00B0 ";
		}
		else if (typeDoc=="FAF") {
			libellePopup = "ENVOI D'UN ACOMPTE FOURNISSEUR PAR E-MAIL";
			libelleSujet = "Acompte N\u00B0 ";
		}
		else if (typeDoc=="CF") {
			libellePopup = "ENVOI D'UNE COMMANDE FOURNISSEUR PAR E-MAIL";
			libelleSujet = "Commande N\u00B0 ";
			tmplAssoc = "Facturation/Commandes/list-fichierAssocCF.tmpl";
		}
		else if (typeDoc=="BR") {
			libellePopup = "ENVOI D'UN BON DE RECEPTION PAR E-MAIL";
			libelleSujet = "Bon de r\u00E9ception N\u00B0 ";
		}
		else if (typeDoc=="AF") {
			libellePopup = "ENVOI D'UN AVOIR FOURNISSEUR PAR E-MAIL";
			libelleSujet = "Avoir N\u00B0 ";
			tmplAssoc = "Facturation/Avoirs_Fournisseur/list-fichierAssocAF.tmpl";
		}
		else if (typeDoc=="FF") {
			libellePopup = "ENVOI D'UNE FACTURE FOURNISSEUR PAR E-MAIL";
			libelleSujet = "Facture N\u00B0 ";
			tmplAssoc = "Facturation/Factu_Fournisseur/list-fichierAssocFF.tmpl";
		}
		else if (typeDoc=="CC") {
			libellePopup = "ENVOI D'UNE COMMANDE CLIENT PAR E-MAIL";
			libelleSujet = "Commande N\u00B0 ";
			tmplAssoc = "Facturation/Affaires/list-fichierAssocCC.tmpl";
		}
		else if (typeDoc=="FAC") {
			libellePopup = "ENVOI D'UN ACOMPTE CLIENT PAR E-MAIL";
			libelleSujet = "Acompte N\u00B0 ";
		}
		else if (typeDoc=="BL") {
			libellePopup = "ENVOI D'UN BON DE LIVRAISON PAR E-MAIL";
			libelleSujet = "Bon de livraison N\u00B0 ";
			tmplAssoc = "Facturation/Affaires/list-fichierAssocBL.tmpl";
		}
		else if (typeDoc=="OL") {
			libellePopup = "ENVOI D'UN ORDRE DE LIVRAISON PAR E-MAIL";
			libelleSujet = "Ordre de livraison N\u00B0 ";
			tmplAssoc = "Facturation/Affaires/list-fichierAssocBL.tmpl";
		}
		else if (typeDoc=="LF") {
			libellePopup = "ENVOI D'UNE COMMANDE FOURNISSEUR PAR E-MAIL";
			libelleSujet = "Commande N\u00B0 ";
			tmplAssoc = "Facturation/Affaires/list-fichierAssocBL.tmpl";
		}
		else if (typeDoc=="CCOF") {
			libellePopup = "ENVOI D'UN ORDRE DE FABRICATION PAR E-MAIL";
			libelleSujet = "Commande N\u00B0 ";
		}
		else if (typeDoc=="FART") {
			libellePopup = "ENVOI D'UNE FICHE ARTICLE PAR E-MAIL";
			libelleSujet = "Fiche article ";
		}
		else if (typeDoc=="DA") {
			libellePopup = "ENVOI D'UNE DEMANDE D'AVOIR PAR E-MAIL";
			libelleSujet = "Demande d'avoir N\u00B0 ";
		}
		else if (typeDoc=="CGBC") {
			libellePopup = "ENVOI DE LA BALANCE PAR E-MAIL";
			libelleSujet = "Balance comptable ";
			modele = false;
		}
		else if (typeDoc=="CGCT") {
			libellePopup = "ENVOI DU CENTRALISATEUR PAR E-MAIL";
			libelleSujet = "Centralisateur ";
			modele = false;
		}
		else if (typeDoc=="CGBA") {
			libellePopup = "ENVOI DE LA BALANCE AGEE PAR E-MAIL";
			libelleSujet = "Balance ag\u00E9e ";
			modele = false;
		}
		else if (typeDoc=="CGPC") {
			libellePopup = "ENVOI DU PLAN COMPTABLE PAR E-MAIL";
			libelleSujet = "Plan comptable ";
			modele = false;
		}
		else if (typeDoc=="CGGL") {
			libellePopup = "ENVOI DU GRAND LIVRE PAR E-MAIL";
			libelleSujet = "Grand livre ";
			modele = false;
		}
		else if (typeDoc=="CGJX") {
			libellePopup = "ENVOI DES JOURNAUX PAR E-MAIL";
			libelleSujet = "Journaux ";
			modele = false;
		}
		else if (typeDoc=="CGBI") {
			libellePopup = "ENVOI DU BILAN PAR E-MAIL";
			libelleSujet = "Bilan ";
			modele = false;
		}
		else if (typeDoc=="CGCR") {
			libellePopup = "ENVOI DU COMPTE DE RESULTAT PAR E-MAIL";
			libelleSujet = "Compte de r\u00E9sultat ";
			modele = false;
		}
		else if (typeDoc=="CGSG") {
			libellePopup = "ENVOI DES SIG PAR E-MAIL";
			libelleSujet = "SIG ";
			modele = false;
		}

		document.getElementById('lblPopup').value = libellePopup;

		var qExp = new QueryHttp("Facturation/Commun/getEmailExpediteur.tmpl");
		var result = qExp.execute();
		document.getElementById('expediteur').value = result.responseXML.documentElement.getAttribute("Email");

		var qDest = new QueryHttp("Facturation/Commun/getInfosEmailDest.tmpl");
		qDest.setParam("Type_Doc", typeDoc);
		qDest.setParam("Doc_Id", docId);
		result = qDest.execute();
		var contenu = result.responseXML.documentElement;
		document.getElementById('destinataire').value = contenu.getAttribute("Email");
		document.getElementById('sujet').value = libelleSujet + contenu.getAttribute("Numero");
		clientId = contenu.getAttribute("Client_Id");
		fournisseurId = contenu.getAttribute("Fournisseur_Id");

		if (!isEmpty(clientId)) {
			chargerEmailsClient(clientId, 'destinataire');
			chargerEmailsClient(clientId, 'copie');
			chargerEmailsClient(clientId, 'bcc');
		}
		else if (!isEmpty(fournisseurId)) {
			chargerEmailsFournisseur(fournisseurId, 'destinataire');
			chargerEmailsFournisseur(fournisseurId, 'copie');
			chargerEmailsFournisseur(fournisseurId, 'bcc');
		}

		if (modele) {
			var aModeles = new Arbre('ComboListe/combo-modeleEmail.tmpl', 'modele');
			aModeles.setParam("Code_Document", typeDoc);
			aModeles.initTree();
		}
		else {
			document.getElementById('rowModele').collapsed = true;
		}

		if (tmplAssoc!=null) {
			document.getElementById('rowAttachAssocs').collapsed = false;

			aAssoc = new Arbre(tmplAssoc, "listFichierAssoc");
    	aAssoc.setParam("Type", typeDoc);
    	aAssoc.setParam("Document_Id", docId);
    	aAssoc.setParam("Acces", true);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function envoyer() {
	try {

		var expediteur = document.getElementById('expediteur').value;
		var destinataire = document.getElementById('destinataire').value;
		var copie = document.getElementById('copie').value;
		var bcc = document.getElementById('bcc').value;
		var sujet = document.getElementById('sujet').value;
		var message = document.getElementById('message').value;
		var attachAssocs = document.getElementById('attachAssocs').checked;

		if (!isEmail(expediteur)) { showWarning("L'adresse e-mail de l'exp\u00E9diteur est invalide"); }
		else if (isEmpty(destinataire)) { showWarning("Adresse e-mail destinataire manquante"); }
		else if (!isEmail(destinataire)) { showWarning("L'adresse e-mail destinataire '"+ destinataire +"' est invalide"); }
		else if (!isEmpty(copie) && !isEmail(copie)) { showWarning("L'adresse e-mail copie carbone '"+ copie +"' est invalide"); }
		else if (!isEmpty(bcc) && !isEmail(bcc)) { showWarning("L'adresse e-mail copie cach\u00E9e '"+ bcc +"' est invalide"); }
		else if (checkRecipients() && checkCarbonCopies() && checkBlindCopies()) {

			var pDocId = "";
			var tmpl = "";
			var msgconf = "";

			if (typeDoc=="MP") {
				tmpl = "TB/Mandats/sendMandat.tmpl";
				pDocId = "Mandat_Id";
				msgconf = "Le mandat a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="AC") {
				tmpl = "Facturation/Avoirs/sendAvoirClient.tmpl";
				pDocId = "Avoir_Id";
				msgconf = "L'avoir a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="TS") {
				tmpl = "Facturation/Transferts_Stocks/sendTransfertStock.tmpl";
				pDocId = "Transfert_Id";
				msgconf = "Le transfert de stock a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="TE") {
				tmpl = "Facturation/Transferts_Emplacements/sendTransfertEmplacement.tmpl";
				pDocId = "Transfert_Id";
				msgconf = "Le transfert d'emplacements a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="BLT") {
				tmpl = "Facturation/Transferts_Stocks/sendBonLivraison.tmpl";
				pDocId = "Bon_Id";
				msgconf = "Le bon de livraison a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="BRT") {
				tmpl = "Facturation/Transferts_Stocks/sendBonReception.tmpl";
				pDocId = "Bon_Id";
				msgconf = "Le bon de r\u00E9ception a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="FC") {
				tmpl = "Facturation/FacturesVente/sendFactureClient.tmpl";
				pDocId = "Facture_Id";
				msgconf = "La facture a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="PF") {
				tmpl = "Facturation/Proforma/sendProforma.tmpl";
				pDocId = "Proforma_Id";
				msgconf = "La proforma a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="DC") {
				tmpl = "Facturation/Devis/sendDevis.tmpl";
				pDocId = "Devis_Id";
				msgconf = "Le devis a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="OF") {
				tmpl = "Facturation/Fabrication/sendOrdreFabrication.tmpl";
				pDocId = "Ordre_Id";
				msgconf = "L'ordre de fabrication a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="RC") {
				tmpl = "Facturation/Affaires/sendRetourClient.tmpl";
				pDocId = "Retour_Id";
				msgconf = "Le retour a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="RF") {
				tmpl = "Facturation/Retours_Fournisseurs/sendRetourFournisseur.tmpl";
				pDocId = "Retour_Id";
				msgconf = "Le retour a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="BLR") {
				tmpl = "Facturation/Retours_Fournisseurs/sendBonLivraison.tmpl";
				pDocId = "Bon_Id";
				msgconf = "Le bon de livraison a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="BRR") {
				tmpl = "Facturation/Retours_Fournisseurs/sendBonReception.tmpl";
				pDocId = "Bon_Id";
				msgconf = "Le bon de r\u00E9ception a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="FAF") {
				tmpl = "Facturation/Commandes/sendAcompteFournisseur.tmpl";
				pDocId = "Acompte_Id";
				msgconf = "L'acompte a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CF") {
				tmpl = "Facturation/Commandes/sendCommandeFournisseur.tmpl";
				pDocId = "Commande_Id";
				msgconf = "La commande a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="BR") {
				tmpl = "Facturation/Commandes/sendBonReception.tmpl";
				pDocId = "Bon_Id";
				msgconf = "Le bon de r\u00E9ception a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="AF") {
				tmpl = "Facturation/Avoirs_Fournisseur/sendAvoirFournisseur.tmpl";
				pDocId = "Avoir_Id";
				msgconf = "L'avoir a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="FF") {
				tmpl = "Facturation/Factu_Fournisseur/sendFactureFournisseur.tmpl";
				pDocId = "Facture_Id";
				msgconf = "La facture a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="FAC") {
				tmpl = "Facturation/Affaires/sendAcompteClient.tmpl";
				pDocId = "Acompte_Id";
				msgconf = "L'acompte a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CC") {
				tmpl = "Facturation/Affaires/sendCommandeClient.tmpl";
				pDocId = "Commande_Id";
				msgconf = "La commande a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="BL") {
				tmpl = "Facturation/Affaires/sendBonLivraison.tmpl";
				pDocId = "Bon_Liv_Id";
				msgconf = "Le bon de livraison a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="OL") {
				tmpl = "Facturation/Affaires/sendBonLivraison.tmpl";
				pDocId = "Bon_Liv_Id";
				msgconf = "L'ordre de livraison a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="LF") {
				tmpl = "Facturation/Affaires/sendBonLivraison.tmpl";
				pDocId = "Bon_Liv_Id";
				msgconf = "La commande fournisseur a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="CCOF") {
				tmpl = "Facturation/Affaires/sendOrdreFabricationCC.tmpl";
				pDocId = "Commande_Id";
				msgconf = "L'ordre de fabrication a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="FART") {
				tmpl = "Facturation/Articles/sendFicheArticle.tmpl";
				pDocId = "Article_Id";
				msgconf = "La fiche article a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="DA") {
				tmpl = "Facturation/Controle_Achats/sendDemandeAvoirFournisseur.tmpl";
				pDocId = "Demande_Id";
				msgconf = "La demande d'avoir a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="CGBC") {
				tmpl = "Compta/Editions/sendBalanceComptable.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "La balance a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="CGCT") {
				tmpl = "Compta/Editions/sendCentralisateur.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Le centralisateur a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CGBA") {
				tmpl = "Compta/Editions/sendBalanceAgee.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "La balance ag\u00E9e a \u00E9t\u00E9 envoy\u00E9e";
			}
			else if (typeDoc=="CGPC") {
				tmpl = "Compta/Editions/sendPlanComptable.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Le plan comptable a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CGGL") {
				tmpl = "Compta/Editions/sendGrandLivre.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Le grand livre a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CGJX") {
				tmpl = "Compta/Editions/sendJournaux.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Les journaux ont \u00E9t\u00E9 envoy\u00E9s";
			}
			else if (typeDoc=="CGBI") {
				tmpl = "Compta/Editions/sendBilan.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Le bilan a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CGCR") {
				tmpl = "Compta/Editions/sendCompteResultat.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Le compte de r\u00E9sultat a \u00E9t\u00E9 envoy\u00E9";
			}
			else if (typeDoc=="CGSG") {
				tmpl = "Compta/Editions/sendSIG.tmpl";
				pDocId = "Fichier_Id";
				msgconf = "Les SIG ont \u00E9t\u00E9 envoy\u00E9s";
			}

			var qMail = new QueryHttp(tmpl);
			qMail.setParam(pDocId, docId);
			qMail.setParam("Langue", langue);
			qMail.setParam("Expediteur", expediteur);
			qMail.setParam("Destinataire", listDestinataire);
			qMail.setParam("Copie", listCopie);
			qMail.setParam("BCC", listBCC);
			qMail.setParam("Sujet", sujet);
			qMail.setParam("Message", message);
			qMail.setParam("AttachedFiles", tabAttachedFiles);
			qMail.setParam("AttachedAssocs", attachAssocs?getAttachedAssocs():"");

			if (typeDoc=="DC") {
				qMail.setParam("Show_Totaux", critere1);
				qMail.setParam("Edition_Init", critere2);
			}
			else if (typeDoc=="CF") {
				qMail.setParam("Show_Totaux", critere1);
			}
			else if (typeDoc=="BR") {
				qMail.setParam("Show_Totaux", critere1);
				qMail.setParam("Ordre_Tri", critere2);
			}
			else if (typeDoc=="RF") {
				qMail.setParam("Chiffre", critere1);
			}
			else if (typeDoc=="CC" || typeDoc=="CCOF") {
				qMail.setParam("Initiale", critere1);
			}
			else if (typeDoc=="LF") {
				qMail.setParam("Show_Totaux", critere1);
				qMail.setParam("Show_Totaux_CF", critere2);
				qMail.setParam("Edit_LF", critere3);
				qMail.setParam("Edit_CF", critere4);
				qMail.setParam("Type_Doc", "LF");
			}
			else if (typeDoc=="BL") {
				qMail.setParam("Show_Totaux", critere1);
				qMail.setParam("Edit_BP", critere2);
				qMail.setParam("Type_Doc", "BL");
			}
			else if (typeDoc=="BLR") {
				qMail.setParam("Edit_BP", critere1);
			}
			else if (typeDoc=="BLT") {
				qMail.setParam("Edit_BP", critere1);
			}
			else if (typeDoc=="OL") {
				qMail.setParam("Type_Doc", "OL");
			}

			var result = qMail.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage(msgconf);
				window.close();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function insererModele() {
	try {

		var modeleId = document.getElementById('modele').value;

		if (isEmpty(modeleId)) {
			showWarning("Veuillez choisir un mod\u00E8le");
		}
		else {
			var qModele = new QueryHttp("Config/globale/getModeleEmail.tmpl");
			qModele.setParam("Modele_Id", modeleId);

			var result = qModele.execute();

			var cursor = document.getElementById('message').selectionStart;
			var curMessage = document.getElementById('message').value;

			document.getElementById('message').value = curMessage.substring(0,cursor) + result.responseXML.documentElement.getAttribute('Message') + curMessage.substring(cursor,curMessage.length);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function chargerEmailsClient(clientId, fieldId) {
	try {

		var aEmails = new Arbre('ComboListe/combo-emailsClient.tmpl', fieldId);
		aEmails.setParam("Client_Id", clientId);
		aEmails.initTree();

	} catch (e) {
  	recup_erreur(e);
  }
}


function chargerEmailsFournisseur(fournisseurId, fieldId) {
	try {

		var aEmails = new Arbre('ComboListe/combo-emailsFournisseur.tmpl', fieldId);
		aEmails.setParam("Fournisseur_Id", fournisseurId);
		aEmails.initTree();

	} catch (e) {
  	recup_erreur(e);
  }
}


function removeFile(fileId, value, size) {
	try {

		var wFile = document.getElementById(fileId);
		document.getElementById("boxFichiers").removeChild(wFile);
		tabAttachedFiles.splice(tabAttachedFiles.indexOf(value), 1);
		attachSize -= size;

		if (tabAttachedFiles.length==0) {
			document.getElementById("rowFichiers").collapsed = true;
		}

		window.sizeToContent();

	}	catch (e) {
		recup_erreur(e);
	}
}


function attachFile() {
	try {

		document.getElementById("rowFichiers").collapsed = false;

		var file = fileChooser("open");
		if (file!=null) {

			if (file.fileSize>5242880) {
				showWarning("Taille de fichier trop importante (5 Mo max.)");
			}
			else if (attachSize+file.fileSize>10485760) {
				showWarning("Impossible d'ajouter le fichier, taille maximale atteinte (10 Mo max.)");
			}
			else if (checkUploadFile(file)) {

				uploadFile(file);

				tabAttachedFiles.push(file.leafName);

				attachSize += file.fileSize;
				var fileId = "FID"+ incFileId++;

				var xulHbox = document.createElementNS(XUL_NS, "xul:hbox");
				xulHbox.setAttribute("id", fileId);
				xulHbox.setAttribute("align", "center");

				var xulLabel = document.createElementNS(XUL_NS, "xul:label");
				xulLabel.setAttribute("value", file.leafName);

				var xulButton = document.createElementNS(XUL_NS, "xul:button");
				xulButton.setAttribute("class", "bIcoSupprimer");
				xulButton.setAttribute("oncommand", "removeFile('"+ fileId +"','"+ file.leafName +"',"+ file.fileSize +")");
				xulButton.setAttribute("tooltiptext", "enlever le fichier");

				xulHbox.appendChild(xulLabel);
				xulHbox.appendChild(xulButton);
				document.getElementById("boxFichiers").appendChild(xulHbox);

				window.sizeToContent();
			}
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function removeRecipient(recipientId, rowId) {
	try {

		var wRecipient = document.getElementById(rowId);
		document.getElementById("boxDestinataires").removeChild(wRecipient);
		tabRecipients.splice(tabRecipients.indexOf(recipientId), 1);

		if (tabRecipients.length==0) {
			document.getElementById("rowDestinataires").collapsed = true;
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function addRecipient() {
	try {

		document.getElementById("rowDestinataires").collapsed = false;

		var recipientId = "RID"+ incRecipientId++;

		tabRecipients.push(recipientId);

		var rowId = "RRID"+ recipientId;

		var xulHbox = document.createElementNS(XUL_NS, "xul:hbox");
		xulHbox.setAttribute("id", rowId);
		xulHbox.setAttribute("align", "center");

		var xulMenulist = document.createElementNS(XUL_NS, "xul:menulist");
		xulMenulist.setAttribute("id", recipientId);
		xulMenulist.setAttribute("maxlength", 75);
		xulMenulist.setAttribute("flex", 1);
		xulMenulist.setAttribute("editable", true);
		xulMenulist.setAttribute("ref", "http://www.opensi.org/stdlist");
		xulMenulist.setAttribute("sizetopopup", "none");
		xulMenulist.setAttribute("datasources", "rdf:null");

		var xulTemplate = document.createElementNS(XUL_NS, "xul:template");

		var xulMenupopup = document.createElementNS(XUL_NS, "xul:menupopup");

		var xulMenuitem = document.createElementNS(XUL_NS, "xul:menuitem");
		xulMenuitem.setAttribute("uri", "rdf:*");
		xulMenuitem.setAttribute("label", "rdf:http://www.opensi.org/stdlist/rdf#Email");
		xulMenuitem.setAttribute("value", "rdf:http://www.opensi.org/stdlist/rdf#Email");

		xulMenupopup.appendChild(xulMenuitem);
		xulTemplate.appendChild(xulMenupopup);
		xulMenulist.appendChild(xulTemplate);

		var xulButton = document.createElementNS(XUL_NS, "xul:button");
		xulButton.setAttribute("class", "bIcoSupprimer");
		xulButton.setAttribute("oncommand", "removeRecipient('"+ recipientId +"','"+ rowId +"')");
		xulButton.setAttribute("tooltiptext", "enlever le destinataire");

		xulHbox.appendChild(xulMenulist);
		xulHbox.appendChild(xulButton);
		document.getElementById("boxDestinataires").appendChild(xulHbox);

		if (!isEmpty(clientId)) {
			chargerEmailsClient(clientId, recipientId);
		}
		else if (!isEmpty(fournisseurId)) {
			chargerEmailsFournisseur(fournisseurId, recipientId);
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function checkRecipients() {
	try {

		var ok = true;
		listDestinataire = document.getElementById('destinataire').value;

		for (var recipientId of tabRecipients) {

			var email = document.getElementById(recipientId).value;

			if (!isEmpty(email)) {
				if (!isEmail(email)) {
					showWarning("L'adresse e-mail destinataire '"+ email +"' est invalide");
					ok = false;
					break;
				}
				else {
					listDestinataire += ","+ email;
				}
			}
		}

		return ok;

	}	catch (e) {
		recup_erreur(e);
	}
}


function removeCarbonCopy(carbonCopyId, rowId) {
	try {

		var wCarbonCopy = document.getElementById(rowId);
		document.getElementById("boxDestCC").removeChild(wCarbonCopy);
		tabCarbonCopies.splice(tabCarbonCopies.indexOf(carbonCopyId), 1);

		if (tabCarbonCopies.length==0) {
			document.getElementById("rowDestCC").collapsed = true;
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function addCarbonCopy() {
	try {

		document.getElementById("rowDestCC").collapsed = false;

		var carbonCopyId = "CID"+ incCarbonCopyId++;

		tabCarbonCopies.push(carbonCopyId);

		var rowId = "RCID"+ carbonCopyId;

		var xulHbox = document.createElementNS(XUL_NS, "xul:hbox");
		xulHbox.setAttribute("id", rowId);
		xulHbox.setAttribute("align", "center");

		var xulMenulist = document.createElementNS(XUL_NS, "xul:menulist");
		xulMenulist.setAttribute("id", carbonCopyId);
		xulMenulist.setAttribute("maxlength", 75);
		xulMenulist.setAttribute("flex", 1);
		xulMenulist.setAttribute("editable", true);
		xulMenulist.setAttribute("ref", "http://www.opensi.org/stdlist");
		xulMenulist.setAttribute("sizetopopup", "none");
		xulMenulist.setAttribute("datasources", "rdf:null");

		var xulTemplate = document.createElementNS(XUL_NS, "xul:template");

		var xulMenupopup = document.createElementNS(XUL_NS, "xul:menupopup");

		var xulMenuitem = document.createElementNS(XUL_NS, "xul:menuitem");
		xulMenuitem.setAttribute("uri", "rdf:*");
		xulMenuitem.setAttribute("label", "rdf:http://www.opensi.org/stdlist/rdf#Email");
		xulMenuitem.setAttribute("value", "rdf:http://www.opensi.org/stdlist/rdf#Email");

		xulMenupopup.appendChild(xulMenuitem);
		xulTemplate.appendChild(xulMenupopup);
		xulMenulist.appendChild(xulTemplate);

		var xulButton = document.createElementNS(XUL_NS, "xul:button");
		xulButton.setAttribute("class", "bIcoSupprimer");
		xulButton.setAttribute("oncommand", "removeCarbonCopy('"+ carbonCopyId +"','"+ rowId +"')");
		xulButton.setAttribute("tooltiptext", "enlever la copie carbone");

		xulHbox.appendChild(xulMenulist);
		xulHbox.appendChild(xulButton);
		document.getElementById("boxDestCC").appendChild(xulHbox);

		if (!isEmpty(clientId)) {
			chargerEmailsClient(clientId, carbonCopyId);
		}
		else if (!isEmpty(fournisseurId)) {
			chargerEmailsFournisseur(fournisseurId, carbonCopyId);
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function checkCarbonCopies() {
	try {

		var ok = true;
		listCopie = document.getElementById('copie').value;

		for (var carbonCopyId of tabCarbonCopies) {

			var email = document.getElementById(carbonCopyId).value;

			if (!isEmpty(email)) {
				if (!isEmail(email)) {
					showWarning("L'adresse e-mail copie carbone '"+ email +"' est invalide");
					ok = false;
					break;
				}
				else {
					listCopie += ","+ email;
				}
			}
		}

		if (listCopie.startsWith(",")) {
			listCopie = listCopie.substring(1);
		}

		return ok;

	}	catch (e) {
		recup_erreur(e);
	}
}


function removeBlindCopy(blindCopyId, rowId) {
	try {

		var wBlindCopy = document.getElementById(rowId);
		document.getElementById("boxDestBCC").removeChild(wBlindCopy);
		tabBlindCopies.splice(tabBlindCopies.indexOf(blindCopyId), 1);

		if (tabBlindCopies.length==0) {
			document.getElementById("rowDestBCC").collapsed = true;
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function addBlindCopy() {
	try {

		document.getElementById("rowDestBCC").collapsed = false;

		var blindCopyId = "BID"+ incBlindCopyId++;

		tabBlindCopies.push(blindCopyId);

		var rowId = "RBID"+ blindCopyId;

		var xulHbox = document.createElementNS(XUL_NS, "xul:hbox");
		xulHbox.setAttribute("id", rowId);
		xulHbox.setAttribute("align", "center");

		var xulMenulist = document.createElementNS(XUL_NS, "xul:menulist");
		xulMenulist.setAttribute("id", blindCopyId);
		xulMenulist.setAttribute("maxlength", 75);
		xulMenulist.setAttribute("flex", 1);
		xulMenulist.setAttribute("editable", true);
		xulMenulist.setAttribute("ref", "http://www.opensi.org/stdlist");
		xulMenulist.setAttribute("sizetopopup", "none");
		xulMenulist.setAttribute("datasources", "rdf:null");

		var xulTemplate = document.createElementNS(XUL_NS, "xul:template");

		var xulMenupopup = document.createElementNS(XUL_NS, "xul:menupopup");

		var xulMenuitem = document.createElementNS(XUL_NS, "xul:menuitem");
		xulMenuitem.setAttribute("uri", "rdf:*");
		xulMenuitem.setAttribute("label", "rdf:http://www.opensi.org/stdlist/rdf#Email");
		xulMenuitem.setAttribute("value", "rdf:http://www.opensi.org/stdlist/rdf#Email");

		xulMenupopup.appendChild(xulMenuitem);
		xulTemplate.appendChild(xulMenupopup);
		xulMenulist.appendChild(xulTemplate);

		var xulButton = document.createElementNS(XUL_NS, "xul:button");
		xulButton.setAttribute("class", "bIcoSupprimer");
		xulButton.setAttribute("oncommand", "removeBlindCopy('"+ blindCopyId +"','"+ rowId +"')");
		xulButton.setAttribute("tooltiptext", "enlever la copie cach\u00E9e");

		xulHbox.appendChild(xulMenulist);
		xulHbox.appendChild(xulButton);
		document.getElementById("boxDestBCC").appendChild(xulHbox);

		if (!isEmpty(clientId)) {
			chargerEmailsClient(clientId, blindCopyId);
		}
		else if (!isEmpty(fournisseurId)) {
			chargerEmailsFournisseur(fournisseurId, blindCopyId);
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function checkBlindCopies() {
	try {

		var ok = true;
		listBCC = document.getElementById('bcc').value;

		for (var blindCopyId of tabBlindCopies) {

			var email = document.getElementById(blindCopyId).value;

			if (!isEmpty(email)) {
				if (!isEmail(email)) {
					showWarning("L'adresse e-mail copie cach\u00E9e '"+ email +"' est invalide");
					ok = false;
					break;
				}
				else {
					listBCC += ","+ email;
				}
			}
		}

		if (listBCC.startsWith(",")) {
			listBCC = listBCC.substring(1);
		}

		return ok;

	}	catch (e) {
		recup_erreur(e);
	}
}


function pressOnAssocs() {
	try {

		var attachAssocs = document.getElementById('attachAssocs').checked;

		document.getElementById('rowAssocs').collapsed = !attachAssocs;

		window.sizeToContent();

		if (attachAssocs) {
    	aAssoc.initTree();
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function getAttachedAssocs() {
	try {

		var listAssocId = "";

		if (aAssoc!=null) {
			for (var i=0; i<aAssoc.nbLignes(); i++) {
				if (aAssoc.getCellValue(i, "colSelect")=="true") {
					listAssocId += aAssoc.getCellText(i, "colAssocId") +",";
				}
  		}
		}

		return listAssocId;

	}	catch (e) {
		recup_erreur(e);
	}
}
