/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofe_entrepriseId;
var ofe_modified = false;
var ofe_mode;

var ofe_aDroits = new Arbre('Superviseur/entreprises/list-dossierEntrepriseAutorise.tmpl', 'ofe-listeDroits');
var ofe_aDossiers = new Arbre('Superviseur/entreprises/list-dossierEntrepriseInterdit.tmpl', 'ofe-listeDossiers');



function ofe_init() {
  try {


	} catch (e) {
  	recup_erreur(e);
	}
}


function ofe_initIHM() {
	try {

		document.getElementById('ofe-panneau').selectedIndex = 0;

		document.getElementById("ofe-Identifiant").disabled = ofe_mode=="M";

		document.getElementById('ofe-tabDroits').collapsed = ofe_mode=="C";

		document.getElementById('ofe-bEnleverDroit').disabled = ofe_mode=="M";
		document.getElementById('ofe-bAjouterDroit').disabled = ofe_mode=="M";

		ofe_pressOnAccBAM();

		ofe_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofe_nouveauEntreprise() {
  try {

		ofe_mode = "C";
		ofe_entrepriseId = "";

		document.getElementById('ofe-lblEntreprise').value = "Fiche entreprise";

		document.getElementById("ofe-Identifiant").value = "";
		document.getElementById("ofe-Denomination").value = "";
		document.getElementById("ofe-Telephone").value = "";
		document.getElementById("ofe-Email").value = "";
		document.getElementById("ofe-Responsable").value = "";
		document.getElementById("ofe-Actif").checked = true;
		document.getElementById("ofe-Num_Assistance").value = "";

		document.getElementById("ofe-gesco").checked = true;
		document.getElementById("ofe-transac").checked = false;
		document.getElementById("ofe-compta").checked = true;
		document.getElementById("ofe-contact").checked = false;
		document.getElementById("ofe-flash").checked = false;
		document.getElementById("ofe-accBAM").checked = false;
		document.getElementById("ofe-accBAMXL").checked = false;

		document.getElementById('ofe-Identifiant').focus();

		ofe_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofe_chargerEntreprise() {
  try {

		ofe_mode = "M";

		var qLoad = new QueryHttp("Superviseur/entreprises/loadEntreprise.tmpl");
		qLoad.setParam('Entreprise_Id', ofe_entrepriseId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('ofe-lblEntreprise').value = "Fiche entreprise "+ contenu.getAttribute('Identifiant');

		document.getElementById("ofe-Identifiant").value = contenu.getAttribute('Identifiant');
		document.getElementById("ofe-Denomination").value = contenu.getAttribute('Denomination');
		document.getElementById("ofe-Telephone").value = contenu.getAttribute('Telephone');
		document.getElementById("ofe-Email").value = contenu.getAttribute('Email');
		document.getElementById("ofe-Responsable").value = contenu.getAttribute('Responsable');
		document.getElementById("ofe-Actif").checked = contenu.getAttribute("Actif")=="true";
		document.getElementById("ofe-Num_Assistance").value = contenu.getAttribute('Num_Assistance');

		document.getElementById("ofe-gesco").checked = contenu.getAttribute('Acc_Gest_Com')=="true";
		document.getElementById("ofe-transac").checked = contenu.getAttribute('Acc_TB')=="true";
		document.getElementById("ofe-compta").checked = contenu.getAttribute('Acc_Compta')=="true";
		document.getElementById("ofe-contact").checked = contenu.getAttribute('Acc_CRM')=="true";
		document.getElementById("ofe-flash").checked = contenu.getAttribute('Acc_MWM')=="true";
		document.getElementById("ofe-accBAM").checked = contenu.getAttribute('Acc_BAM')=="true";
		document.getElementById("ofe-accBAMXL").checked = contenu.getAttribute('Acc_BAM_XL')=="true";

		ofe_aDroits.setParam('Entreprise_Id', ofe_entrepriseId);
		ofe_aDroits.initTree();

		ofe_aDossiers.setParam('Entreprise_Id', ofe_entrepriseId);
		ofe_aDossiers.initTree();

		ofe_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofe_enregistrerEntreprise() {
	try {

		var identifiant = document.getElementById('ofe-Identifiant').value;
		var denomination = document.getElementById('ofe-Denomination').value;
		var telephone = document.getElementById('ofe-Telephone').value;
		var email = document.getElementById('ofe-Email').value;
		var responsable = document.getElementById('ofe-Responsable').value;
		var numAssistance = document.getElementById('ofe-Num_Assistance').value;
		var gesco = document.getElementById("ofe-gesco").checked;
		var transac = document.getElementById("ofe-transac").checked;
		var compta = document.getElementById("ofe-compta").checked;
		var contact = document.getElementById("ofe-contact").checked;
		var flash = document.getElementById("ofe-flash").checked;
		var bam = document.getElementById("ofe-accBAM").checked;
		var bamXL = document.getElementById("ofe-accBAMXL").checked;
		var actif = document.getElementById("ofe-Actif").checked;

		if (ofe_mode=="C" && isEmpty(identifiant)) { showWarning("Veuillez saisir un identifiant"); }
		else if (ofe_mode=="C" && !isCleAlpha(identifiant)) { showWarning("Identifiant incorrect (A-Z,a-z,0-9,_)"); }
		else if (ofe_mode=="C" && (identifiant.toLowerCase()=="root" || identifiant.toLowerCase()=="auto")) { showWarning("Identifiant non autoris\u00E9"); }
		else if (isEmpty(denomination)) { showWarning("Veuillez saisir une d\u00E9nomination"); }
		else if (!isEmpty(telephone) && !isPhone(telephone)) { showWarning("Le t\u00E9l\u00E9phone est invalide"); }
		else if (isEmpty(email)) { showWarning("Veuillez saisir une adresse e-mail"); }
		else if (!isEmail(email)) { showWarning("L'adresse e-mail est incorrecte"); }
		else {

			var qSave;

			if (ofe_mode=="C") {
				qSave = new QueryHttp("Superviseur/entreprises/createEntreprise.tmpl");
				qSave.setParam("Identifiant", identifiant);
			}
			else {
				qSave = new QueryHttp("Superviseur/entreprises/updateEntreprise.tmpl");
				qSave.setParam("Entreprise_Id", ofe_entrepriseId);
			}

			qSave.setParam("Denomination", denomination);
			qSave.setParam("Telephone", telephone);
			qSave.setParam("Email", email);
			qSave.setParam("Responsable", responsable);
			qSave.setParam("Acc_Gest_Com", gesco);
			qSave.setParam("Acc_Compta", compta);
			qSave.setParam("Acc_CRM", contact);
			qSave.setParam("Acc_TB", transac);
			qSave.setParam("Acc_MWM", flash);
			qSave.setParam("Acc_BAM", bam);
			qSave.setParam("Acc_BAM_XL", bamXL);
			qSave.setParam("Actif", actif);
			qSave.setParam("Num_Assistance", numAssistance);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (ofe_mode=="C") {
					ofe_entrepriseId = result.responseXML.documentElement.getAttribute("Entreprise_Id");
					ofe_chargerEntreprise();
				}
				else {
					ofe_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofe_demandeEnregistrement() {
  try {

		if (ofe_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche entreprise ?")) {
				ofe_enregistrerEntreprise();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofe_setModified(m) {
  try {

  	ofe_modified = m;
		if (m) {
			document.getElementById('ofe-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('ofe-tabFiche').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofe_pressOnAccBAM() {
  try {

		document.getElementById("ofe-accBAMXL").disabled = !document.getElementById("ofe-accBAM").checked;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofe_affecterDroits() {
	try {

		var rangeCount = ofe_aDossiers.getRangeCount();

		for(var i=0; i<rangeCount; i++) {
			var start = {};
 			var end = {};
 			ofe_aDossiers.getRangeAt(i,start,end);

 			for(var c=start.value; c<=end.value; c++) {

				var dossierId = ofe_aDossiers.getCellText(c,'ofe-colDossierIdNA');

				if (!isEmpty(dossierId)) {
					var qAffDroits = new QueryHttp("Superviseur/entreprises/addRightsOnDossier.tmpl");
					qAffDroits.setParam('Entreprise_Id', ofe_entrepriseId);
					qAffDroits.setParam('Dossier_Id', dossierId);
					qAffDroits.execute();
				}
 			}
		}

		ofe_aDroits.initTree();
		ofe_aDossiers.initTree();

		document.getElementById('ofe-bAjouterDroit').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofe_supprimerDroits() {
	try {

		var rangeCount = ofe_aDroits.getRangeCount();

		for(var i=0; i<rangeCount; i++) {
			var start = {};
  		var end = {};
  		ofe_aDroits.getRangeAt(i,start,end);

			for(var c=start.value; c<=end.value; c++) {

				var dossierId = ofe_aDroits.getCellText(c,'ofe-colDossierIdDU');

				if (!isEmpty(dossierId)) {
					var qSupDroits = new QueryHttp("Superviseur/entreprises/removeRightsOnDossier.tmpl");
					qSupDroits.setParam('Entreprise_Id', ofe_entrepriseId);
					qSupDroits.setParam('Dossier_Id', dossierId);
					qSupDroits.execute();
				}
			}
		}

		ofe_aDroits.initTree();
		ofe_aDossiers.initTree();

		document.getElementById('ofe-bEnleverDroit').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofe_pressOnDossiersAutorises() {
	try {

		if (ofe_aDroits.isSelected()) {
			document.getElementById('ofe-bEnleverDroit').disabled = false;
			document.getElementById('ofe-bAjouterDroit').disabled = true;
			ofe_aDossiers.clearSelection();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofe_pressOnDossiersInterdits() {
	try {

		if (ofe_aDossiers.isSelected()) {
			document.getElementById('ofe-bEnleverDroit').disabled = true;
			document.getElementById('ofe-bAjouterDroit').disabled = false;
			ofe_aDroits.clearSelection();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
