/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");



function init() {
	try {

		var aEntreprisesMail = new Arbre('Superviseur/notification/list-entrepriseANotifier.tmpl', 'liste_entreprises_mail');
		aEntreprisesMail.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		var sujet = document.getElementById("Sujet").value;
		var message = document.getElementById("Message").value;
		var copie = document.getElementById("Copie").checked;
		var liste = document.getElementById("liste_entreprises_mail");
		var valeur = "";
		var nombreElements = liste.getRowCount();

		for (var i=0; i<nombreElements; i++) {
			if(liste.getItemAtIndex(i).getElementsByTagName("listcell").item(0).getAttribute("checked","true")=="true") {
				valeur += liste.getItemAtIndex(i).value +",";
			}
		}

		if (valeur=="") { showWarning("Veuillez s\u00E9lectionner au moins une entreprise"); }
		else if (sujet=="") { showWarning("Veuillez saisir un sujet"); }
		else if (message=="") { showWarning("Veuillez saisir un message"); }
		else {
			var qEnvoiMail = new QueryHttp("Superviseur/notification/sendNotification.tmpl");
			qEnvoiMail.setParam("List_Entreprise_Id", valeur);
			qEnvoiMail.setParam("Sujet", sujet);
			qEnvoiMail.setParam("Notification", message);
			qEnvoiMail.setParam("Copie_Util", copie);
			qEnvoiMail.execute();

			showWarning("Le mail a \u00E9t\u00E9 envoy\u00E9");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function testcheckEntMail() {
	try {

		var liste = document.getElementById("liste_entreprises_mail");
		if (liste.currentItem!=null && liste.selectedIndex!=-1) {
			var item = liste.getItemAtIndex(liste.selectedIndex);
			var cks = item.getElementsByTagName("listcell");
			cks.item(0).setAttribute("checked",(cks.item(0).getAttribute("checked")=="true"?"false":"true"));
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(b) {
	try {

		var listbox = document.getElementById("liste_entreprises_mail");

		var nbLignes = listbox.getRowCount();
		if (nbLignes>0) {
			var i = 0;

			while (i<nbLignes) {
				var item = listbox.getItemAtIndex(i);
				var cks = item.getElementsByTagName("listcell");
				cks.item(0).setAttribute("checked",b);
				i++;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retour_menuManager() {

  window.location = "chrome://opensi/content/superviseur/menu_superviseur.xul";
}

