/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofu_utilisateurId;
var ofu_curDossierId = "";
var ofu_curEntreprise;
var ofu_curEtablissement;
var ofu_curBorne;
var ofu_modified = false;
var ofu_mode;
var ofu_genMDP;

var ofu_aDroits = new Arbre('Superviseur/utilisateurs/list-dossierUtilisateurAutorise.tmpl', 'ofu-listeDroits');
var ofu_aDossiers = new Arbre('Superviseur/utilisateurs/list-dossierUtilisateurInterdit.tmpl', 'ofu-listeDossiers');
var ofu_aEntreprises = new Arbre('ComboListe/combo-entreprises.tmpl', 'ofu-entrepriseId');
var ofu_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'ofu-etablissementRattachement');
var ofu_aBornes = new Arbre('ComboListe/combo-bornesImpression.tmpl', 'ofu-borneImpression');



function ofu_init() {
  try {


	} catch (e) {
  	recup_erreur(e);
	}
}


function ofu_initIHM() {
	try {

		document.getElementById('ofu-panneau').selectedIndex = 0;

		document.getElementById("ofu-login").disabled = ofu_mode=="M";
		document.getElementById("ofu-civilite").disabled = ofu_mode=="M";
		document.getElementById("ofu-nom").disabled = ofu_mode=="M";
		document.getElementById("ofu-prenom").disabled = ofu_mode=="M";
		document.getElementById("ofu-fonction").disabled = ofu_mode=="M";
		document.getElementById("ofu-telephone").disabled = ofu_mode=="M";
		document.getElementById("ofu-email").disabled = ofu_mode=="M";
		document.getElementById("ofu-notification").disabled = ofu_mode=="M";
		document.getElementById("ofu-emailRecupPW").disabled = ofu_mode=="M";

		document.getElementById('ofu-tabDroits').collapsed = ofu_mode=="C";

		document.getElementById('ofu-rowModifPassword').collapsed = ofu_mode=="C";
		document.getElementById('ofu-rowPassword').collapsed = ofu_mode=="M";
		document.getElementById('ofu-rowPassword2').collapsed = ofu_mode=="M";
		document.getElementById('ofu-rowGenerateMDP').collapsed = ofu_mode=="M";
		document.getElementById('ofu-visiblePassword').collapsed = ofu_mode=="C" || !ofu_genMDP;
		document.getElementById('ofu-hiddenPassword').collapsed = ofu_mode=="C" || ofu_genMDP;

		document.getElementById('ofu-bEnleverDroit').disabled = ofu_mode=="M";
		document.getElementById('ofu-bAjouterDroit').disabled = ofu_mode=="M";
		document.getElementById('ofu-entrepriseId').disabled = ofu_mode=="M";

		ofu_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_nouveauUtilisateur() {
  try {

		ofu_mode = "C";
		ofu_utilisateurId = "";
		ofu_genMDP = false;

		document.getElementById('ofu-lblUtilisateur').value = "Fiche utilisateur";

		document.getElementById("ofu-login").value = "";
		document.getElementById("ofu-password").value = "";
		document.getElementById("ofu-password2").value = "";
		document.getElementById("ofu-civilite").value = "0";
		document.getElementById("ofu-nom").value = "";
		document.getElementById("ofu-prenom").value = "";
		document.getElementById("ofu-fonction").value = "";
		document.getElementById("ofu-telephone").value = "";
		document.getElementById("ofu-email").value = "";
		document.getElementById("ofu-emailRecupPW").value = "";
		document.getElementById('ofu-administrateur').checked = true;
		document.getElementById('ofu-typeUtil').value = "U";
		document.getElementById('ofu-actif').checked = true;
		document.getElementById('ofu-notification').checked = true;
		document.getElementById('ofu-generateMDP').checked = false;
		document.getElementById('ofu-visiblePassword').value = "";

		ofu_chargerEntreprises("");

		document.getElementById('ofu-login').focus();

		ofu_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofu_chargerUtilisateur() {
  try {

		ofu_mode = "M";

		var qLoad = new QueryHttp("Superviseur/utilisateurs/loadUtilisateur.tmpl");
		qLoad.setParam('Utilisateur_Id', ofu_utilisateurId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('ofu-lblUtilisateur').value = "Fiche utilisateur "+ contenu.getAttribute('Login');

		document.getElementById("ofu-login").value = contenu.getAttribute('Login');
		document.getElementById("ofu-civilite").value = contenu.getAttribute('Civilite');
		document.getElementById("ofu-nom").value = contenu.getAttribute('Nom');
		document.getElementById("ofu-prenom").value = contenu.getAttribute('Prenom');
		document.getElementById("ofu-fonction").value = contenu.getAttribute('Fonction');
		document.getElementById("ofu-telephone").value = contenu.getAttribute('Telephone');
		document.getElementById("ofu-email").value = contenu.getAttribute('Email');
		document.getElementById("ofu-emailRecupPW").value = contenu.getAttribute('Email_Recup_PW');
		document.getElementById('ofu-administrateur').checked = contenu.getAttribute('Administrateur')=="true";
		document.getElementById('ofu-typeUtil').value = contenu.getAttribute('Type_Util');
		document.getElementById("ofu-actif").checked = contenu.getAttribute("Actif")=="true";
		document.getElementById("ofu-notification").checked = contenu.getAttribute("Notification")=="true";

		ofu_chargerEntreprises(contenu.getAttribute('Entreprise_Id'));

		ofu_aDroits.setParam('Utilisateur_Id', ofu_utilisateurId);
		ofu_aDroits.initTree();

		ofu_aDossiers.setParam('Utilisateur_Id', ofu_utilisateurId);
		ofu_aDossiers.initTree();

		ofu_activerDroitsDossiers(false);

		ofu_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofu_enregistrerUtilisateur() {
	try {

		var login = document.getElementById('ofu-login').value;
		var password = document.getElementById('ofu-password').value;
		var password2 = document.getElementById('ofu-password2').value;
		var civilite = document.getElementById('ofu-civilite').value;
		var nom = document.getElementById('ofu-nom').value;
		var prenom = document.getElementById('ofu-prenom').value;
		var telephone = document.getElementById('ofu-telephone').value;
		var fonction = document.getElementById('ofu-fonction').value;
		var email = document.getElementById('ofu-email').value;
		var emailRecupPW = document.getElementById('ofu-emailRecupPW').value;
		var entrepriseId = document.getElementById('ofu-entrepriseId').value;
		var typeUtil = document.getElementById('ofu-typeUtil').value;
		var administrateur = document.getElementById('ofu-administrateur').checked;
		var actif = document.getElementById('ofu-actif').checked;
		var notification = document.getElementById('ofu-notification').checked;

		if (ofu_mode=="C" && isEmpty(login)) { showWarning("Login de l'utilisateur manquant"); }
		else if (ofu_mode=="C" && isEmpty(nom)) { showWarning("Nom de l'utilisateur manquant"); }
		else if (ofu_mode=="C" && isEmpty(password)) { showWarning("Mot de passe manquant"); }
		else if (ofu_mode=="C" && password.length<8) { showWarning("Le mot de passe doit contenir au minimum 8 caract\u00E8res"); }
		else if (ofu_mode=="C" && !isValidPassword(password)) { showWarning("Le mot de passe doit contenir au moins 3 des 4 types de caract\u00E8res (minuscule, majuscule, chiffre, car. sp\u00E9cial)"); }
		else if (ofu_mode=="C" && password2!=password) {
			showWarning("Les mots de passe saisis sont diff\u00E9rents ! Veuillez reconfirmer le mot de passe");
			document.getElementById('ofu-password2').value = "";
		}
		else if (ofu_mode=="C" && (login.toLowerCase()=="root" || login.toLowerCase()=="auto")) { showWarning("Login non autoris\u00E9"); }
		else if (ofu_mode=="C" && !isCleAlpha(login)) { showWarning("Login incorrect ! (A-Z,a-z,0-9,_)"); }
		else if (ofu_mode=="C" && !isEmpty(telephone) && !isPhone(telephone)) { showWarning("Le t\u00E9l\u00E9phone est incorrect"); }
		else if (ofu_mode=="C" && !isEmpty(email) && !isEmail(email)) { showWarning("L'adresse e-mail est incorrecte"); }
		else if (ofu_mode=="C" && isEmpty(emailRecupPW)) { showWarning("Adresse e-mail de r\u00E9cup\u00E9ration de mot de passe manquante"); }
		else if (ofu_mode=="C" && !isEmail(emailRecupPW)) { showWarning("L'adresse e-mail de r\u00E9cup\u00E9ration de mot de passe est incorrecte"); }
		else if (ofu_mode=="C" && isEmpty(entrepriseId)) { showWarning("Veuillez s\u00E9lectionner une entreprise"); }
		else {

			var qSave;

			if (ofu_mode=="C") {
				qSave = new QueryHttp("Superviseur/utilisateurs/createUtilisateur.tmpl");
				qSave.setParam('Login', login);
				qSave.setParam('Password', password);
				qSave.setParam('Civilite', civilite);
				qSave.setParam('Nom', nom);
				qSave.setParam('Prenom', prenom);
				qSave.setParam('Fonction', fonction);
				qSave.setParam('Telephone', telephone);
				qSave.setParam('Email', email);
				qSave.setParam('Notification', notification);
				qSave.setParam('Email_Recup_PW', emailRecupPW);
				qSave.setParam('Entreprise_Id', entrepriseId);
			}
			else {
				qSave = new QueryHttp("Superviseur/utilisateurs/updateUtilisateur.tmpl");
				qSave.setParam("Utilisateur_Id", ofu_utilisateurId);
			}

			qSave.setParam('Type_Util', typeUtil);
			qSave.setParam('Actif', actif);
			qSave.setParam('Administrateur', administrateur);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (ofu_mode=="C") {
					ofu_utilisateurId = result.responseXML.documentElement.getAttribute("Utilisateur_Id");
					ofu_chargerUtilisateur();
					ofu_genMDP = false;
				}
				else {
					ofu_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofu_demandeEnregistrement() {
  try {

		if (ofu_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche utilisateur ?")) {
				ofu_enregistrerUtilisateur();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofu_setModified(m) {
  try {

  	ofu_modified = m;
		if (m) {
			document.getElementById('ofu-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('ofu-tabFiche').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofu_chargerEntreprises(selection) {
	try {

		ofu_curEntreprise = selection;
		ofu_aEntreprises.setParam("Selection", ofu_curEntreprise);
		ofu_aEntreprises.initTree(ofu_initEntreprise);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_initEntreprise() {
  try {

		document.getElementById('ofu-entrepriseId').value = ofu_curEntreprise;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerEtablissements(selection) {
	try {

		ofu_curEtablissement = selection;
		ofu_aEtablissements.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aEtablissements.setParam("Selection", ofu_curEtablissement);
		ofu_aEtablissements.setParam("No_Check_Rights", true);
		ofu_aEtablissements.initTree(ofu_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_initEtablissement() {
	try {

		document.getElementById("ofu-etablissementRattachement").value = ofu_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerBornes(selection) {
	try {

		ofu_curBorne = selection;
		ofu_aBornes.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aBornes.setParam("Selection", ofu_curBorne);
		ofu_aBornes.initTree(ofu_initBorne);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_initBorne() {
	try {

		document.getElementById("ofu-borneImpression").value = ofu_curBorne;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_affecterDroits() {
	try {

		var rangeCount = ofu_aDossiers.getRangeCount();

		for(var i=0; i<rangeCount; i++) {
			var start = {};
 			var end = {};
 			ofu_aDossiers.getRangeAt(i,start,end);

 			for(var c=start.value; c<=end.value; c++) {

				var dossierId = ofu_aDossiers.getCellText(c,'ofu-colDossierIdNA');

				if (!isEmpty(dossierId)) {
					var qAffDroits = new QueryHttp("Superviseur/utilisateurs/addRightsOnDossier.tmpl");
					qAffDroits.setParam('Utilisateur_Id', ofu_utilisateurId);
					qAffDroits.setParam('Dossier_Id', dossierId);
					qAffDroits.execute();
				}
 			}
		}

		ofu_aDroits.initTree();
		ofu_aDossiers.initTree();

		document.getElementById('ofu-bAjouterDroit').disabled = true;
		ofu_activerDroitsDossiers(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_supprimerDroits() {
	try {

		var rangeCount = ofu_aDroits.getRangeCount();

		for(var i=0; i<rangeCount; i++) {
			var start = {};
  		var end = {};
  		ofu_aDroits.getRangeAt(i,start,end);

			for(var c=start.value; c<=end.value; c++) {

				var dossierId = ofu_aDroits.getCellText(c,'ofu-colDossierIdDU');

				if (!isEmpty(dossierId)) {
					var qSupDroits = new QueryHttp("Superviseur/utilisateurs/removeRightsOnDossier.tmpl");
					qSupDroits.setParam('Utilisateur_Id', ofu_utilisateurId);
					qSupDroits.setParam('Dossier_Id', dossierId);
					qSupDroits.execute();
				}
			}
		}

		ofu_aDroits.initTree();
		ofu_aDossiers.initTree();

		document.getElementById('ofu-bEnleverDroit').disabled = true;
		ofu_activerDroitsDossiers(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_changerPassword() {
	try {

		var page ="chrome://opensi/content/utilisateurs/utilisateurs/popup-password.xul";
		window.openDialog(page,'','chrome,modal,centerscreen', ofu_utilisateurId);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_changeGenerateMDP() {
	try {

		ofu_genMDP = document.getElementById('ofu-generateMDP').checked;

		if (ofu_genMDP) {
			var mdp = new StringGenerator(CHAR_ALPHA_NUM).generate(2) + new StringGenerator(CHAR_LOWER_CASE).generate(1) + new StringGenerator(CHAR_DIGITS).generate(1) + new StringGenerator(CHAR_UPPER_CASE).generate(1) + new StringGenerator(CHAR_ALPHA_NUM).generate(3);
			document.getElementById('ofu-password').value = mdp;
			document.getElementById('ofu-password2').value = mdp;
			document.getElementById('ofu-visiblePassword').value = mdp;
			document.getElementById('ofu-rowPassword').collapsed = true;
			document.getElementById('ofu-rowPassword2').collapsed = true;
		}
		else {
			document.getElementById('ofu-password').value = "";
			document.getElementById('ofu-password2').value = "";
			document.getElementById('ofu-visiblePassword').value = "";
			document.getElementById('ofu-rowPassword').collapsed = false;
			document.getElementById('ofu-rowPassword2').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_pressOnDossiersAutorises() {
	try {

		if (ofu_aDroits.isSelected()) {
			document.getElementById('ofu-bEnleverDroit').disabled = false;
			document.getElementById('ofu-bAjouterDroit').disabled = true;
			ofu_aDossiers.clearSelection();
			if (ofu_aDroits.nbSelection()==1) {
				ofu_activerDroitsDossiers(true);
			}
			else {
				ofu_activerDroitsDossiers(false);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_pressOnDossiersInterdits() {
	try {

		if (ofu_aDossiers.isSelected()) {
			document.getElementById('ofu-bEnleverDroit').disabled = true;
			document.getElementById('ofu-bAjouterDroit').disabled = false;
			ofu_aDroits.clearSelection();
			ofu_activerDroitsDossiers(false);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_activerDroitsDossiers(b) {
	try {

		if (b) {
			ofu_curDossierId = ofu_aDroits.getSelectedCellText("ofu-colDossierIdDU");
			document.getElementById('ofu-lblDroits').label = "Droits sur le dossier "+ ofu_aDroits.getSelectedCellText("ofu-colCodeDossierDU");
			ofu_chargerDroitsDossier();
		}
		else {
			ofu_curDossierId = "";
			document.getElementById('ofu-lblDroits').label = "Droits sur le dossier";

			ofu_cocherDG(false);
			ofu_cocherGC(false);
			ofu_cocherCompta(false);
			ofu_cocherStats(false);
			ofu_cocherMWM(false);

			document.getElementById("ofu-cReadOnlyGC_SArticles").checked = false;
			document.getElementById("ofu-cReadOnlyGC_VDevis").checked = false;
			document.getElementById("ofu-cReadOnlyGC_VAffaires").checked = false;
			document.getElementById("ofu-cReadOnlyGC_TClients").checked = false;
			document.getElementById("ofu-cReadOnlyGC_SIOStocks").checked = false;
			document.getElementById("ofu-cReadOnlyGC_DRegCli").checked = false;

			document.getElementById("ofu-etablissementRattachement").value = "";
			document.getElementById("ofu-cMaxValidationDC").value = "";

			document.getElementById('ofu-cEditionDES_VLE').collapsed = true;
			document.getElementById('ofu-cEditionDES_VRC').collapsed = true;
			document.getElementById('ofu-cEditionDES_VAR').collapsed = true;
			document.getElementById('ofu-cEditionDES_VCS').collapsed = true;
			document.getElementById('ofu-cEditionDES_VFV').collapsed = true;
			document.getElementById('ofu-cEditionDES_VRE').collapsed = true;
			document.getElementById('ofu-cEditionDES_VCR').collapsed = true;
			document.getElementById('ofu-cEditionDES_VHP').collapsed = true;
			document.getElementById('ofu-cEditionDES_ASF').collapsed = true;
			document.getElementById('ofu-cEditionDES_ASD').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerDroitsDossier() {
	try {

		var qLoad = new QueryHttp("Superviseur/utilisateurs/loadRightsOnDossier.tmpl");
		qLoad.setParam("Utilisateur_Id", ofu_utilisateurId);
		qLoad.setParam("Dossier_Id", ofu_curDossierId);

		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('ofu-cEditionDES_VLE').collapsed = contenu.getAttribute("Spec_LH_ELE")=="false";
		document.getElementById('ofu-cEditionDES_VRC').collapsed = contenu.getAttribute("Act_Reassort_CC")=="false";
		document.getElementById('ofu-cEditionDES_VAR').collapsed = contenu.getAttribute("Spec_SM_EAR")=="false";
		document.getElementById('ofu-cEditionDES_VCS').collapsed = contenu.getAttribute("Act_Code_Stats")=="false";
		document.getElementById('ofu-cEditionDES_VFV').collapsed = contenu.getAttribute("Spec_ED_EFV")=="false";
		document.getElementById('ofu-cEditionDES_VRE').collapsed = contenu.getAttribute("Spec_RE_ERC")=="false";
		document.getElementById('ofu-cEditionDES_VCR').collapsed = contenu.getAttribute("Spec_LM_ECR")=="false";
		document.getElementById('ofu-cEditionDES_VHP').collapsed = contenu.getAttribute("Spec_KE_ESK")=="false";
		document.getElementById('ofu-cEditionDES_ASF').collapsed = contenu.getAttribute("Spec_LH_FNP")=="false";
		document.getElementById('ofu-cEditionDES_ASD').collapsed = contenu.getAttribute("Spec_HM_DNP")=="false";

		// Droits gnraux
		document.getElementById("ofu-cGestionCo").checked = contenu.getAttribute("Acc_Gest_Com")=="true";
		document.getElementById("ofu-cCompta").checked = contenu.getAttribute("Acc_Compta")=="true";
		document.getElementById("ofu-cContact").checked = contenu.getAttribute("Acc_CRM")=="true";
		document.getElementById("ofu-cTransac").checked = contenu.getAttribute("Acc_TB")=="true";
		document.getElementById("ofu-cConfig").checked = contenu.getAttribute("Acc_Config")=="true";
		document.getElementById("ofu-cFlash").checked = contenu.getAttribute("Acc_MWM")=="true";
		document.getElementById("ofu-cAccBAM").checked = contenu.getAttribute("Acc_BAM")=="true";
		document.getElementById("ofu-cDirection").checked = contenu.getAttribute("Direction")=="true";
		document.getElementById("ofu-cValidationCF").checked = contenu.getAttribute("Validation_CF")=="true";
		document.getElementById("ofu-cValidationCC").checked = contenu.getAttribute("Validation_CC")=="true";
		document.getElementById("ofu-cValidationCCZero").checked = contenu.getAttribute("Validation_CC_Zero")=="true";
		document.getElementById("ofu-cAnnulationCC").checked = contenu.getAttribute("Annulation_CC")=="true";
		document.getElementById("ofu-cValidationTS").checked = contenu.getAttribute("Validation_TS")=="true";
		document.getElementById("ofu-cValidationIS").checked = contenu.getAttribute("Validation_IS")=="true";
		document.getElementById("ofu-cValidationRG").checked = contenu.getAttribute("Validation_RG")=="true";
		document.getElementById("ofu-cValidationBR").checked = contenu.getAttribute("Validation_BR")=="true";
		document.getElementById("ofu-cValidationAF").checked = contenu.getAttribute("Validation_AF")=="true";
		document.getElementById("ofu-cValidationAC").checked = contenu.getAttribute("Validation_AC")=="true";
		document.getElementById("ofu-cValidationBP").checked = contenu.getAttribute("Validation_BP")=="true";
		document.getElementById("ofu-cAnnulationBP").checked = contenu.getAttribute("Annulation_BP")=="true";
		document.getElementById("ofu-cValidationBL").checked = contenu.getAttribute("Validation_BL")=="true";
		document.getElementById("ofu-cAnnulationBL").checked = contenu.getAttribute("Annulation_BL")=="true";
		document.getElementById("ofu-cValidationDC").checked = contenu.getAttribute("Validation_DC")=="true";
		document.getElementById("ofu-cMaxValidationDC").value = contenu.getAttribute("Max_Validation_DC");
		document.getElementById("ofu-cClotureFact").checked = contenu.getAttribute("Cloture_Fact")=="true";
		document.getElementById("ofu-cModifElemFinDV").checked = contenu.getAttribute("Modif_Elem_Fin_DV")=="true";
		document.getElementById("ofu-cModifElemFinFCA").checked = contenu.getAttribute("Modif_Elem_Fin_FCA")=="true";
		document.getElementById("ofu-cIgnorePVPlancher").checked = contenu.getAttribute("Ignore_PV_Plancher")=="true";
		document.getElementById("ofu-cEditionListeDL").checked = contenu.getAttribute("Edition_Liste_DL")=="true";
		document.getElementById("ofu-cEditionListeDA").checked = contenu.getAttribute("Edition_Liste_DA")=="true";
		document.getElementById("ofu-cEditionListeDV").checked = contenu.getAttribute("Edition_Liste_DV")=="true";
		document.getElementById("ofu-cShowTotauxDV").checked = contenu.getAttribute("Show_Totaux_DV")=="true";
		document.getElementById("ofu-cAccesCoutAchat").checked = contenu.getAttribute("Acces_Cout_Achat")=="true";
		document.getElementById("ofu-cAccesBanqueCli").checked = contenu.getAttribute("Acces_Banque_Cli")=="true";
		document.getElementById("ofu-cAccesBanqueFou").checked = contenu.getAttribute("Acces_Banque_Fou")=="true";
		document.getElementById("ofu-cRestricAccCDVPA").checked = contenu.getAttribute("Restric_Acc_CDV_PA")=="true";
		document.getElementById("ofu-cGestionDevisType").checked = contenu.getAttribute("Gestion_Devis_Type")=="true";
		document.getElementById("ofu-cShowElemFour").checked = contenu.getAttribute("Show_Elem_Four")=="true";
		document.getElementById("ofu-cGestionRespVente").checked = contenu.getAttribute("Gestion_Resp_Vente")=="true";
		document.getElementById("ofu-cGestionEtabVente").checked = contenu.getAttribute("Gestion_Etab_Vente")=="true";
		document.getElementById("ofu-cGestionPoleVente").checked = contenu.getAttribute("Gestion_Pole_Vente")=="true";
		document.getElementById("ofu-cGestionIntiVente").checked = contenu.getAttribute("Gestion_Inti_Vente")=="true";
		document.getElementById("ofu-cGestionBloqueCli").checked = contenu.getAttribute("Gestion_Bloque_Cli")=="true";
		document.getElementById("ofu-cModifStockES").checked = contenu.getAttribute("Modif_Stock_ES")=="true";
		document.getElementById("ofu-cModifPrixFA").checked = contenu.getAttribute("Modif_Prix_FA")=="true";
		document.getElementById("ofu-cModifPADV").checked = contenu.getAttribute("Modif_PA_DV")=="true";
		document.getElementById("ofu-cAnonymisationFC").checked = contenu.getAttribute("Anonymisation_FC")=="true";
		document.getElementById("ofu-cGCBrightColor").checked = contenu.getAttribute("GC_Bright_Color")=="true";
		ofu_chargerEtablissements(contenu.getAttribute("Etab_Id"));
		ofu_chargerBornes(contenu.getAttribute("Borne_Id"));

		// Accs menus gestion commerciale
		document.getElementById("ofu-cGC_TClients").checked = contenu.getAttribute("MenuGC_TClients")=="true";
		document.getElementById("ofu-cReadOnlyGC_TClients").checked = contenu.getAttribute("ReadOnlyGC_TClients")=="true";
		document.getElementById("ofu-cGC_VDevis").checked = contenu.getAttribute("MenuGC_VDevis")=="true";
		document.getElementById("ofu-cGC_ACommandes").checked = contenu.getAttribute("MenuGC_ACommandes")=="true";
		document.getElementById("ofu-cGC_SArticles").checked = contenu.getAttribute("MenuGC_SArticles")=="true";
		document.getElementById("ofu-cReadOnlyGC_SArticles").checked = contenu.getAttribute("ReadOnlyGC_SArticles")=="true";
		document.getElementById("ofu-cGC_DRegFour").checked = contenu.getAttribute("MenuGC_DRegFour")=="true";
		document.getElementById("ofu-cGC_TFournisseurs").checked = contenu.getAttribute("MenuGC_TFournisseurs")=="true";
		document.getElementById("ofu-cGC_VAffaires").checked = contenu.getAttribute("MenuGC_VAffaires")=="true";
		document.getElementById("ofu-cReadOnlyGC_VDevis").checked = contenu.getAttribute("ReadOnlyGC_VDevis")=="true";
		document.getElementById("ofu-cReadOnlyGC_VAffaires").checked = contenu.getAttribute("ReadOnlyGC_VAffaires")=="true";
		document.getElementById("ofu-cGC_APrepaCom").checked = contenu.getAttribute("MenuGC_APrepaCom")=="true";
		document.getElementById("ofu-cGC_STarifs").checked = contenu.getAttribute("MenuGC_STarifs")=="true";
		document.getElementById("ofu-cGC_DRegCli").checked = contenu.getAttribute("MenuGC_DRegCli")=="true";
		document.getElementById("ofu-cReadOnlyGC_DRegCli").checked = contenu.getAttribute("ReadOnlyGC_DRegCli")=="true";
		document.getElementById("ofu-cGC_TCommerciaux").checked = contenu.getAttribute("MenuGC_TCommerciaux")=="true";
		document.getElementById("ofu-cGC_ARecepCom").checked = contenu.getAttribute("MenuGC_ARecepCom")=="true";
		document.getElementById("ofu-cGC_SFabrication").checked = contenu.getAttribute("MenuGC_SFabrication")=="true";
		document.getElementById("ofu-cGC_DRemises").checked = contenu.getAttribute("MenuGC_DRemises")=="true";
		document.getElementById("ofu-cGC_ARetours").checked = contenu.getAttribute("MenuGC_ARetours")=="true";
		document.getElementById("ofu-cGC_SInventaire").checked = contenu.getAttribute("MenuGC_SInventaire")=="true";
		document.getElementById("ofu-cGC_DEditions").checked = contenu.getAttribute("MenuGC_DEditions")=="true";
		document.getElementById("ofu-cGC_AFactures").checked = contenu.getAttribute("MenuGC_AFactures")=="true";
		document.getElementById("ofu-cGC_AControle").checked = contenu.getAttribute("MenuGC_AControle")=="true";
		document.getElementById("ofu-cGC_STracabilite").checked = contenu.getAttribute("MenuGC_STracabilite")=="true";
		document.getElementById("ofu-cGC_DTabBord").checked = contenu.getAttribute("MenuGC_DTabBord")=="true";
		document.getElementById("ofu-cGC_VRetours").checked = contenu.getAttribute("MenuGC_VRetours")=="true";
		document.getElementById("ofu-cGC_VFactures").checked = contenu.getAttribute("MenuGC_VFactures")=="true";
		document.getElementById("ofu-cGC_STransferts").checked = contenu.getAttribute("MenuGC_STransferts")=="true";
		document.getElementById("ofu-cGC_DTransCpta").checked = contenu.getAttribute("MenuGC_DTransCpta")=="true";
		document.getElementById("ofu-cGC_VFactuAuto").checked = contenu.getAttribute("MenuGC_VFactuAuto")=="true";
		document.getElementById("ofu-cGC_SMouvements").checked = contenu.getAttribute("MenuGC_SMouvements")=="true";
		document.getElementById("ofu-cGC_SEmplacements").checked = contenu.getAttribute("MenuGC_SEmplacements")=="true";
		document.getElementById("ofu-cGC_STransEmp").checked = contenu.getAttribute("MenuGC_STransEmp")=="true";
		document.getElementById("ofu-cGC_SIOStocks").checked = contenu.getAttribute("MenuGC_SIOStocks")=="true";
		document.getElementById("ofu-cReadOnlyGC_SIOStocks").checked = contenu.getAttribute("ReadOnlyGC_SIOStocks")=="true";
		document.getElementById("ofu-cGC_SParamStocks").checked = contenu.getAttribute("MenuGC_SParamStocks")=="true";
		document.getElementById("ofu-cGC_DExportIdep").checked = contenu.getAttribute("MenuGC_DExportIdep")=="true";
		document.getElementById("ofu-cGC_DDeclEcoPart").checked = contenu.getAttribute("MenuGC_DDeclEcoPart")=="true";
		document.getElementById("ofu-cGC_VEnvoiFact").checked = contenu.getAttribute("MenuGC_VEnvoiFact")=="true";
		document.getElementById("ofu-cGC_DImpExpCsv").checked = contenu.getAttribute("MenuGC_DImpExpCsv")=="true";
		document.getElementById("ofu-cGC_VAbonnements").checked = contenu.getAttribute("MenuGC_VAbonnements")=="true";
		document.getElementById("ofu-cGC_DPassword").checked = contenu.getAttribute("MenuGC_DPassword")=="true";
		document.getElementById("ofu-cGC_EExpesCC").checked = contenu.getAttribute("MenuGC_EExpesCC")=="true";
		document.getElementById("ofu-cGC_EExpesTS").checked = contenu.getAttribute("MenuGC_EExpesTS")=="true";
		document.getElementById("ofu-cGC_EPrepaExpes").checked = contenu.getAttribute("MenuGC_EPrepaExpes")=="true";
		document.getElementById("ofu-cGC_EExpCrossDock").checked = contenu.getAttribute("MenuGC_EExpCrossDock")=="true";
		document.getElementById("ofu-cGC_ESuiviLog").checked = contenu.getAttribute("MenuGC_ESuiviLog")=="true";
		document.getElementById("ofu-cGC_ESuiviTrans").checked = contenu.getAttribute("MenuGC_ESuiviTrans")=="true";

		// Accs menus comptabilit
		document.getElementById("ofu-cCG_CSaisie").checked = contenu.getAttribute("MenuCG_CSaisie")=="true";
		document.getElementById("ofu-cCG_EBalance").checked = contenu.getAttribute("MenuCG_EBalance")=="true";
		document.getElementById("ofu-cCG_SBordGest").checked = contenu.getAttribute("MenuCG_SBordGest")=="true";
		document.getElementById("ofu-cCG_AComptes").checked = contenu.getAttribute("MenuCG_AComptes")=="true";
		document.getElementById("ofu-cCG_DComptes").checked = contenu.getAttribute("MenuCG_DComptes")=="true";
		document.getElementById("ofu-cCG_CRevision").checked = contenu.getAttribute("MenuCG_CRevision")=="true";
		document.getElementById("ofu-cCG_ECentral").checked = contenu.getAttribute("MenuCG_ECentral")=="true";
		document.getElementById("ofu-cCG_SBordTres").checked = contenu.getAttribute("MenuCG_SBordTres")=="true";
		document.getElementById("ofu-cCG_AGdLivre").checked = contenu.getAttribute("MenuCG_AGdLivre")=="true";
		document.getElementById("ofu-cCG_DAboEcr").checked = contenu.getAttribute("MenuCG_DAboEcr")=="true";
		document.getElementById("ofu-cCG_CTransCop").checked = contenu.getAttribute("MenuCG_CTransCop")=="true";
		document.getElementById("ofu-cCG_EGdLivre").checked = contenu.getAttribute("MenuCG_EGdLivre")=="true";
		document.getElementById("ofu-cCG_AParametrages").checked = contenu.getAttribute("MenuCG_AParametrages")=="true";
		document.getElementById("ofu-cCG_DModeles").checked = contenu.getAttribute("MenuCG_DModeles")=="true";
		document.getElementById("ofu-cCG_CRappro").checked = contenu.getAttribute("MenuCG_CRappro")=="true";
		document.getElementById("ofu-cCG_EJournaux").checked = contenu.getAttribute("MenuCG_EJournaux")=="true";
		document.getElementById("ofu-cCG_DImpBanque").checked = contenu.getAttribute("MenuCG_DImpBanque")=="true";
		document.getElementById("ofu-cCG_CClotMens").checked = contenu.getAttribute("MenuCG_CClotMens")=="true";
		document.getElementById("ofu-cCG_EBalAgee").checked = contenu.getAttribute("MenuCG_EBalAgee")=="true";
		document.getElementById("ofu-cCG_DImpExpEcr").checked = contenu.getAttribute("MenuCG_DImpExpEcr")=="true";
		document.getElementById("ofu-cCG_CClotExo").checked = contenu.getAttribute("MenuCG_CClotExo")=="true";
		document.getElementById("ofu-cCG_EBilan").checked = contenu.getAttribute("MenuCG_EBilan")=="true";
		document.getElementById("ofu-cCG_DPassword").checked = contenu.getAttribute("MenuCG_DPassword")=="true";
		document.getElementById("ofu-cCG_EResultat").checked = contenu.getAttribute("MenuCG_EResultat")=="true";
		document.getElementById("ofu-cCG_ESoldes").checked = contenu.getAttribute("MenuCG_ESoldes")=="true";
		document.getElementById("ofu-cCG_EPlanCpte").checked = contenu.getAttribute("MenuCG_EPlanCpte")=="true";

		// Accs statistiques
		document.getElementById("ofu-cEditionDES_CPC").checked = contenu.getAttribute("Edition_DES_CPC")=="true";
		document.getElementById("ofu-cEditionDES_CLC").checked = contenu.getAttribute("Edition_DES_CLC")=="true";
		document.getElementById("ofu-cEditionDES_FPF").checked = contenu.getAttribute("Edition_DES_FPF")=="true";
		document.getElementById("ofu-cEditionDES_FLF").checked = contenu.getAttribute("Edition_DES_FLF")=="true";
		document.getElementById("ofu-cEditionDES_SPA").checked = contenu.getAttribute("Edition_DES_SPA")=="true";
		document.getElementById("ofu-cEditionDES_SFA").checked = contenu.getAttribute("Edition_DES_SFA")=="true";
		document.getElementById("ofu-cEditionDES_SMS").checked = contenu.getAttribute("Edition_DES_SMS")=="true";
		document.getElementById("ofu-cEditionDES_SES").checked = contenu.getAttribute("Edition_DES_SES")=="true";
		document.getElementById("ofu-cEditionDES_SRS").checked = contenu.getAttribute("Edition_DES_SRS")=="true";
		document.getElementById("ofu-cEditionDES_SPF").checked = contenu.getAttribute("Edition_DES_SPF")=="true";
		document.getElementById("ofu-cEditionDES_SMA").checked = contenu.getAttribute("Edition_DES_SMA")=="true";
		document.getElementById("ofu-cEditionDES_VJV").checked = contenu.getAttribute("Edition_DES_VJV")=="true";
		document.getElementById("ofu-cEditionDES_VJA").checked = contenu.getAttribute("Edition_DES_VJA")=="true";
		document.getElementById("ofu-cEditionDES_VVA").checked = contenu.getAttribute("Edition_DES_VVA")=="true";
		document.getElementById("ofu-cEditionDES_VFA").checked = contenu.getAttribute("Edition_DES_VFA")=="true";
		document.getElementById("ofu-cEditionDES_VFC").checked = contenu.getAttribute("Edition_DES_VFC")=="true";
		document.getElementById("ofu-cEditionDES_VFD").checked = contenu.getAttribute("Edition_DES_VFD")=="true";
		document.getElementById("ofu-cEditionDES_VSC").checked = contenu.getAttribute("Edition_DES_VSC")=="true";
		document.getElementById("ofu-cEditionDES_VLE").checked = contenu.getAttribute("Edition_DES_VLE")=="true";
		document.getElementById("ofu-cEditionDES_VLC").checked = contenu.getAttribute("Edition_DES_VLC")=="true";
		document.getElementById("ofu-cEditionDES_VEC").checked = contenu.getAttribute("Edition_DES_VEC")=="true";
		document.getElementById("ofu-cEditionDES_VCT").checked = contenu.getAttribute("Edition_DES_VCT")=="true";
		document.getElementById("ofu-cEditionDES_VRC").checked = contenu.getAttribute("Edition_DES_VRC")=="true";
		document.getElementById("ofu-cEditionDES_VAR").checked = contenu.getAttribute("Edition_DES_VAR")=="true";
		document.getElementById("ofu-cEditionDES_VCS").checked = contenu.getAttribute("Edition_DES_VCS")=="true";
		document.getElementById("ofu-cEditionDES_VFV").checked = contenu.getAttribute("Edition_DES_VFV")=="true";
		document.getElementById("ofu-cEditionDES_VRE").checked = contenu.getAttribute("Edition_DES_VRE")=="true";
		document.getElementById("ofu-cEditionDES_VCR").checked = contenu.getAttribute("Edition_DES_VCR")=="true";
		document.getElementById("ofu-cEditionDES_VHP").checked = contenu.getAttribute("Edition_DES_VHP")=="true";
		document.getElementById("ofu-cEditionDES_AJA").checked = contenu.getAttribute("Edition_DES_AJA")=="true";
		document.getElementById("ofu-cEditionDES_AAC").checked = contenu.getAttribute("Edition_DES_AAC")=="true";
		document.getElementById("ofu-cEditionDES_AAA").checked = contenu.getAttribute("Edition_DES_AAA")=="true";
		document.getElementById("ofu-cEditionDES_AEF").checked = contenu.getAttribute("Edition_DES_AEF")=="true";
		document.getElementById("ofu-cEditionDES_ARF").checked = contenu.getAttribute("Edition_DES_ARF")=="true";
		document.getElementById("ofu-cEditionDES_ASF").checked = contenu.getAttribute("Edition_DES_ASF")=="true";
		document.getElementById("ofu-cEditionDES_ASD").checked = contenu.getAttribute("Edition_DES_ASD")=="true";

		// Accs menus module flash
		document.getElementById("ofu-cMWM_ExpMonoBL").checked = contenu.getAttribute("MenuMWM_ExpMonoBL")=="true";
		document.getElementById("ofu-cMWM_ExpMultiBL").checked = contenu.getAttribute("MenuMWM_ExpMultiBL")=="true";
		document.getElementById("ofu-cMWM_CdeClient").checked = contenu.getAttribute("MenuMWM_CdeClient")=="true";
		document.getElementById("ofu-cMWM_PrepExpedition").checked = contenu.getAttribute("MenuMWM_PrepExpedition")=="true";
		document.getElementById("ofu-cMWM_InfoArticle").checked = contenu.getAttribute("MenuMWM_InfoArticle")=="true";
		document.getElementById("ofu-cMWM_Inventaire").checked = contenu.getAttribute("MenuMWM_Inventaire")=="true";
		document.getElementById("ofu-cMWM_Inv_Show_SI").checked = contenu.getAttribute("MWM_Inv_Show_SI")=="true";
		document.getElementById("ofu-cMWM_Reception").checked = contenu.getAttribute("MenuMWM_Reception")=="true";
		document.getElementById("ofu-cMWM_Rangement").checked = contenu.getAttribute("MenuMWM_Rangement")=="true";
		document.getElementById("ofu-cMWM_LocCrossDock").checked = contenu.getAttribute("MenuMWM_LocCrossDock")=="true";
		document.getElementById("ofu-cMWM_ExpCrossDock").checked = contenu.getAttribute("MenuMWM_ExpCrossDock")=="true";
		document.getElementById("ofu-cMWM_EntSortStk").checked = contenu.getAttribute("MenuMWM_EntSortStk")=="true";
		document.getElementById("ofu-cMWM_ChangeEmp").checked = contenu.getAttribute("MenuMWM_ChangeEmp")=="true";
		document.getElementById("ofu-cMWM_TransEmp").checked = contenu.getAttribute("MenuMWM_TransEmp")=="true";
		document.getElementById("ofu-cMWM_ConsultEmp").checked = contenu.getAttribute("MenuMWM_ConsultEmp")=="true";
		document.getElementById("ofu-cMWM_RecepRetCli").checked = contenu.getAttribute("MenuMWM_RecepRetCli")=="true";
		document.getElementById("ofu-cMWM_Picking").checked = contenu.getAttribute("MenuMWM_Picking")=="true";
		document.getElementById("ofu-cMWM_Controle_Picking").checked = contenu.getAttribute("MWM_Controle_Picking")=="true";
		document.getElementById("ofu-cMWM_PrepExpress").checked = contenu.getAttribute("MenuMWM_PrepExpress")=="true";
		document.getElementById("ofu-cMWM_Controle").checked = contenu.getAttribute("MenuMWM_Controle")=="true";
		document.getElementById("ofu-cMWM_Impression").checked = contenu.getAttribute("MenuMWM_Impression")=="true";
		document.getElementById("ofu-cMWM_Localisation").checked = contenu.getAttribute("MenuMWM_Localisation")=="true";
		document.getElementById("ofu-cMWM_PEX_Quantite").checked = contenu.getAttribute("MWM_PEX_Quantite")=="true";
		document.getElementById("ofu-cMWM_PEX_Qte_Manquante").checked = contenu.getAttribute("MWM_PEX_Qte_Manquante")=="true";
		document.getElementById("ofu-cMWM_Scan_Borne").checked = contenu.getAttribute("MWM_Scan_Borne")=="true";
		document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").checked = contenu.getAttribute("MWM_Info_Art_Chg_Emp")=="true";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_cocherCompta(b) {
	try {

		document.getElementById("ofu-cCG_CSaisie").checked = b;
		document.getElementById("ofu-cCG_EBalance").checked = b;
		document.getElementById("ofu-cCG_SBordGest").checked = b;
		document.getElementById("ofu-cCG_AComptes").checked = b;
		document.getElementById("ofu-cCG_DComptes").checked = b;
		document.getElementById("ofu-cCG_CRevision").checked = b;
		document.getElementById("ofu-cCG_ECentral").checked = b;
		document.getElementById("ofu-cCG_SBordTres").checked = b;
		document.getElementById("ofu-cCG_AGdLivre").checked = b;
		document.getElementById("ofu-cCG_DAboEcr").checked = b;
		document.getElementById("ofu-cCG_CTransCop").checked = b;
		document.getElementById("ofu-cCG_EGdLivre").checked = b;
		document.getElementById("ofu-cCG_AParametrages").checked = b;
		document.getElementById("ofu-cCG_DModeles").checked = b;
		document.getElementById("ofu-cCG_CRappro").checked = b;
		document.getElementById("ofu-cCG_EJournaux").checked = b;
		document.getElementById("ofu-cCG_DImpBanque").checked = b;
		document.getElementById("ofu-cCG_CClotMens").checked = b;
		document.getElementById("ofu-cCG_EBalAgee").checked = b;
		document.getElementById("ofu-cCG_DImpExpEcr").checked = b;
		document.getElementById("ofu-cCG_CClotExo").checked = b;
		document.getElementById("ofu-cCG_EBilan").checked = b;
		document.getElementById("ofu-cCG_DPassword").checked = b;
		document.getElementById("ofu-cCG_EResultat").checked = b;
		document.getElementById("ofu-cCG_ESoldes").checked = b;
		document.getElementById("ofu-cCG_EPlanCpte").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherStats(b) {
	try {

		document.getElementById("ofu-cEditionDES_CPC").checked = b;
		document.getElementById("ofu-cEditionDES_CLC").checked = b;
		document.getElementById("ofu-cEditionDES_FPF").checked = b;
		document.getElementById("ofu-cEditionDES_FLF").checked = b;
		document.getElementById("ofu-cEditionDES_SPA").checked = b;
		document.getElementById("ofu-cEditionDES_SFA").checked = b;
		document.getElementById("ofu-cEditionDES_SMS").checked = b;
		document.getElementById("ofu-cEditionDES_SES").checked = b;
		document.getElementById("ofu-cEditionDES_SRS").checked = b;
		document.getElementById("ofu-cEditionDES_SPF").checked = b;
		document.getElementById("ofu-cEditionDES_SMA").checked = b;
		document.getElementById("ofu-cEditionDES_VJV").checked = b;
		document.getElementById("ofu-cEditionDES_VJA").checked = b;
		document.getElementById("ofu-cEditionDES_VVA").checked = b;
		document.getElementById("ofu-cEditionDES_VFA").checked = b;
		document.getElementById("ofu-cEditionDES_VFC").checked = b;
		document.getElementById("ofu-cEditionDES_VFD").checked = b;
		document.getElementById("ofu-cEditionDES_VSC").checked = b;
		document.getElementById("ofu-cEditionDES_VLE").checked = b;
		document.getElementById("ofu-cEditionDES_VLC").checked = b;
		document.getElementById("ofu-cEditionDES_VEC").checked = b;
		document.getElementById("ofu-cEditionDES_VCT").checked = b;
		document.getElementById("ofu-cEditionDES_VRC").checked = b;
		document.getElementById("ofu-cEditionDES_VAR").checked = b;
		document.getElementById("ofu-cEditionDES_VCS").checked = b;
		document.getElementById("ofu-cEditionDES_VFV").checked = b;
		document.getElementById("ofu-cEditionDES_VRE").checked = b;
		document.getElementById("ofu-cEditionDES_VCR").checked = b;
		document.getElementById("ofu-cEditionDES_VHP").checked = b;
		document.getElementById("ofu-cEditionDES_AJA").checked = b;
		document.getElementById("ofu-cEditionDES_AAC").checked = b;
		document.getElementById("ofu-cEditionDES_AAA").checked = b;
		document.getElementById("ofu-cEditionDES_AEF").checked = b;
		document.getElementById("ofu-cEditionDES_ARF").checked = b;
		document.getElementById("ofu-cEditionDES_ASF").checked = b;
		document.getElementById("ofu-cEditionDES_ASD").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherGC(b) {
	try {

		document.getElementById("ofu-cGC_TClients").checked = b;
		document.getElementById("ofu-cGC_VDevis").checked = b;
		document.getElementById("ofu-cGC_ACommandes").checked = b;
		document.getElementById("ofu-cGC_SArticles").checked = b;
		document.getElementById("ofu-cGC_DRegFour").checked = b;
		document.getElementById("ofu-cGC_TFournisseurs").checked = b;
		document.getElementById("ofu-cGC_VAffaires").checked = b;
		document.getElementById("ofu-cGC_APrepaCom").checked = b;
		document.getElementById("ofu-cGC_STarifs").checked = b;
		document.getElementById("ofu-cGC_DRegCli").checked = b;
		document.getElementById("ofu-cGC_TCommerciaux").checked = b;
		document.getElementById("ofu-cGC_ARecepCom").checked = b;
		document.getElementById("ofu-cGC_SFabrication").checked = b;
		document.getElementById("ofu-cGC_DRemises").checked = b;
		document.getElementById("ofu-cGC_ARetours").checked = b;
		document.getElementById("ofu-cGC_SInventaire").checked = b;
		document.getElementById("ofu-cGC_DEditions").checked = b;
		document.getElementById("ofu-cGC_AFactures").checked = b;
		document.getElementById("ofu-cGC_AControle").checked = b;
		document.getElementById("ofu-cGC_STracabilite").checked = b;
		document.getElementById("ofu-cGC_DTabBord").checked = b;
		document.getElementById("ofu-cGC_VRetours").checked = b;
		document.getElementById("ofu-cGC_VFactures").checked = b;
		document.getElementById("ofu-cGC_STransferts").checked = b;
		document.getElementById("ofu-cGC_DTransCpta").checked = b;
		document.getElementById("ofu-cGC_VFactuAuto").checked = b;
		document.getElementById("ofu-cGC_SMouvements").checked = b;
		document.getElementById("ofu-cGC_SEmplacements").checked = b;
		document.getElementById("ofu-cGC_STransEmp").checked = b;
		document.getElementById("ofu-cGC_SIOStocks").checked = b;
		document.getElementById("ofu-cGC_SParamStocks").checked = b;
		document.getElementById("ofu-cGC_DExportIdep").checked = b;
		document.getElementById("ofu-cGC_DDeclEcoPart").checked = b;
		document.getElementById("ofu-cGC_VEnvoiFact").checked = b;
		document.getElementById("ofu-cGC_DImpExpCsv").checked = b;
		document.getElementById("ofu-cGC_VAbonnements").checked = b;
		document.getElementById("ofu-cGC_DPassword").checked = b;
		document.getElementById("ofu-cGC_EExpesCC").checked = b;
		document.getElementById("ofu-cGC_EExpesTS").checked = b;
		document.getElementById("ofu-cGC_EPrepaExpes").checked = b;
		document.getElementById("ofu-cGC_EExpCrossDock").checked = b;
		document.getElementById("ofu-cGC_ESuiviLog").checked = b;
		document.getElementById("ofu-cGC_ESuiviTrans").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherDG(b) {
	try {

		document.getElementById("ofu-cGestionCo").checked = b;
		document.getElementById("ofu-cCompta").checked = b;
		document.getElementById("ofu-cContact").checked = b;
		document.getElementById("ofu-cTransac").checked = b;
		document.getElementById("ofu-cConfig").checked = b;
		document.getElementById("ofu-cFlash").checked = b;
		document.getElementById("ofu-cAccBAM").checked = b;
		document.getElementById("ofu-cDirection").checked = b;
		document.getElementById("ofu-cValidationCF").checked = b;
		document.getElementById("ofu-cValidationCC").checked = b;
		document.getElementById("ofu-cValidationCCZero").checked = b;
		document.getElementById("ofu-cAnnulationCC").checked = b;
		document.getElementById("ofu-cValidationTS").checked = b;
		document.getElementById("ofu-cValidationIS").checked = b;
		document.getElementById("ofu-cValidationRG").checked = b;
		document.getElementById("ofu-cValidationBR").checked = b;
		document.getElementById("ofu-cValidationAF").checked = b;
		document.getElementById("ofu-cValidationAC").checked = b;
		document.getElementById("ofu-cValidationBP").checked = b;
		document.getElementById("ofu-cAnnulationBP").checked = b;
		document.getElementById("ofu-cValidationBL").checked = b;
		document.getElementById("ofu-cAnnulationBL").checked = b;
		document.getElementById("ofu-cValidationDC").checked = b;
		document.getElementById("ofu-cClotureFact").checked = b;
		document.getElementById("ofu-cModifElemFinDV").checked = b;
		document.getElementById("ofu-cModifElemFinFCA").checked = b;
		document.getElementById("ofu-cIgnorePVPlancher").checked = b;
		document.getElementById("ofu-cEditionListeDL").checked = b;
		document.getElementById("ofu-cEditionListeDA").checked = b;
		document.getElementById("ofu-cEditionListeDV").checked = b;
		document.getElementById("ofu-cShowTotauxDV").checked = b;
		document.getElementById("ofu-cAccesCoutAchat").checked = b;
		document.getElementById("ofu-cAccesBanqueCli").checked = b;
		document.getElementById("ofu-cAccesBanqueFou").checked = b;
		document.getElementById("ofu-cRestricAccCDVPA").checked = b;
		document.getElementById("ofu-cGestionDevisType").checked = b;
		document.getElementById("ofu-cShowElemFour").checked = b;
		document.getElementById("ofu-cGestionRespVente").checked = b;
		document.getElementById("ofu-cGestionEtabVente").checked = b;
		document.getElementById("ofu-cGestionPoleVente").checked = b;
		document.getElementById("ofu-cGestionIntiVente").checked = b;
		document.getElementById("ofu-cGestionBloqueCli").checked = b;
		document.getElementById("ofu-cModifStockES").checked = b;
		document.getElementById("ofu-cModifPrixFA").checked = b;
		document.getElementById("ofu-cModifPADV").checked = b;
		document.getElementById("ofu-cAnonymisationFC").checked = b;
		document.getElementById("ofu-cGCBrightColor").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherMWM(b) {
	try {

		document.getElementById("ofu-cMWM_ExpMonoBL").checked = b;
		document.getElementById("ofu-cMWM_ExpMultiBL").checked = b;
		document.getElementById("ofu-cMWM_CdeClient").checked = b;
		document.getElementById("ofu-cMWM_PrepExpedition").checked = b;
		document.getElementById("ofu-cMWM_InfoArticle").checked = b;
		document.getElementById("ofu-cMWM_Inventaire").checked = b;
		document.getElementById("ofu-cMWM_Inv_Show_SI").checked = b;
		document.getElementById("ofu-cMWM_Reception").checked = b;
		document.getElementById("ofu-cMWM_Rangement").checked = b;
		document.getElementById("ofu-cMWM_LocCrossDock").checked = b;
		document.getElementById("ofu-cMWM_ExpCrossDock").checked = b;
		document.getElementById("ofu-cMWM_EntSortStk").checked = b;
		document.getElementById("ofu-cMWM_ChangeEmp").checked = b;
		document.getElementById("ofu-cMWM_TransEmp").checked = b;
		document.getElementById("ofu-cMWM_ConsultEmp").checked = b;
		document.getElementById("ofu-cMWM_RecepRetCli").checked = b;
		document.getElementById("ofu-cMWM_Picking").checked = b;
		document.getElementById("ofu-cMWM_Controle_Picking").checked = b;
		document.getElementById("ofu-cMWM_PrepExpress").checked = b;
		document.getElementById("ofu-cMWM_Controle").checked = b;
		document.getElementById("ofu-cMWM_Impression").checked = b;
		document.getElementById("ofu-cMWM_Localisation").checked = b;
		document.getElementById("ofu-cMWM_PEX_Quantite").checked = b;
		document.getElementById("ofu-cMWM_PEX_Qte_Manquante").checked = b;
		document.getElementById("ofu-cMWM_Scan_Borne").checked = b;
		document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}
