/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/banques.js");


var etablissementDefaut;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

  	document.getElementById('deck').selectedIndex = 0;

		etablissementDefaut = getProfil().getEtabId();

		omm_init();
  	oem_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuMandats() {
	try {

		document.getElementById('oem-pdfMandat').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuMandats').collapsed = true;
		document.getElementById('bRetourMandat').collapsed = true;

		omm_listerMandats();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMandat() {
  try {

		document.getElementById('oem-pdfMandat').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('oem-deckMandat').selectedIndex = 0;
		document.getElementById('bRetourMandat').collapsed = true;
		oem_chargerMandat();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		switch (currentDeck) {
			case 1: oem_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/tb/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
