/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omv_aRemises = new Arbre('TB/Virements/list-remiseVirement.tmpl', 'omv-tRemises');
var omv_aApercuRemise = new Arbre('TB/Virements/list-apercuRemiseVirement.tmpl', 'omv-apercu');
var omv_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'omv-banque');
var omv_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omv-etablissement');
var omv_qListRV = new QueryHttp("TB/Virements/getDataListRV.tmpl");

var omv_pageCourante;
var omv_nbPages;
var omv_prep = false;


function omv_init() {
  try {

		omv_prep = (ParamValeur("Prepa")=="true");
		omv_aBanques.initTree();
		omv_aEtablissements.initTree(omv_initCriteres);

	} catch (e) {
  	recup_erreur(e);
  }
}


function omv_initCriteres() {
	try {

		document.getElementById('omv-numRemise').value = "";
		document.getElementById('omv-etat').value = omv_prep?"P":"N";
		document.getElementById('omv-banque').value = "";
		document.getElementById('omv-etablissement').value = etablissementDefaut;
		document.getElementById('omv-dateDebutRem').value = "";
		document.getElementById('omv-dateFinRem').value = "";
		document.getElementById('omv-dateDebutExe').value = "";
		document.getElementById('omv-dateFinExe').value = "";
		document.getElementById('omv-numVirement').value = "";
		document.getElementById('omv-refLot').value = "";
		document.getElementById('omv-montant').value = "";
		document.getElementById('omv-beneficiaire').value = "";
		document.getElementById('omv-motifPaiement').value = "";
		omv_listerRemises();

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_listerRemises() {
	try {

		var numRemise = document.getElementById('omv-numRemise').value;
		var etat = document.getElementById('omv-etat').value;
		var banque = document.getElementById('omv-banque').value;
		var etablissement = document.getElementById('omv-etablissement').value;
		var dateDebutRem = document.getElementById('omv-dateDebutRem').value;
		var dateFinRem = document.getElementById('omv-dateFinRem').value;
		var dateDebutExe = document.getElementById('omv-dateDebutExe').value;
		var dateFinExe = document.getElementById('omv-dateFinExe').value;
		var numVirement = document.getElementById('omv-numVirement').value;
		var refLot = document.getElementById('omv-refLot').value;
		var montant = document.getElementById('omv-montant').value;
		var beneficiaire = document.getElementById('omv-beneficiaire').value;
		var motifPaiement = document.getElementById('omv-motifPaiement').value;
		var nbLignesParPage = document.getElementById('omv-nbLignesParPage').value;

		if (!isEmpty(montant) && !isPositiveOrNull(montant)) { showWarning("Le montant est incorrect !"); }
		else if (!isEmpty(dateDebutRem) && !isDate(dateDebutRem)) { showWarning("Date de remise de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinRem) && !isDate(dateFinRem)) { showWarning("Date de remise de fin incorrecte !"); }
		else if (!isEmpty(dateDebutRem) && !isEmpty(dateFinRem) && !isDateInterval(dateDebutRem, dateFinRem)) { showWarning("Plage de dates de remise incorrecte !"); }
		else if (!isEmpty(dateDebutExe) && !isDate(dateDebutExe)) { showWarning("Date d'ex\u00E9cution de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinExe) && !isDate(dateFinExe)) { showWarning("Date d'ex\u00E9cution de fin incorrecte !"); }
		else if (!isEmpty(dateDebutExe) && !isEmpty(dateFinExe) && !isDateInterval(dateDebutExe, dateFinExe)) { showWarning("Plage de dates d'ex\u00E9cution incorrecte !"); }
		else {

			omv_pageCourante = 1;
			omv_nbPages = 1;
			document.getElementById('omv-pageDeb').value = 1;
			document.getElementById('omv-pageFin').value = 1;
			document.getElementById('omv-bPrec').disabled = true;
			document.getElementById('omv-bSuiv').disabled = true;

			document.getElementById('omv-tRemises').disabled = true;
			document.getElementById('omv-bEditionCsv').disabled = true;
			document.getElementById('omv-numRemiseSelect').value = "";
			omv_aApercuRemise.deleteTree();
			omv_aRemises.deleteTree();

			omv_qListRV.setParam("Num_Remise", numRemise);
			omv_qListRV.setParam("Etat", etat);
			omv_qListRV.setParam("Banque", banque);
			omv_qListRV.setParam("Etablissement", etablissement);
			omv_qListRV.setParam("Date_Debut_Rem", dateDebutRem);
			omv_qListRV.setParam("Date_Fin_Rem", dateFinRem);
			omv_qListRV.setParam("Date_Debut_Exe", dateDebutExe);
			omv_qListRV.setParam("Date_Fin_Exe", dateFinExe);
			omv_qListRV.setParam("Num_Virement", numVirement);
			omv_qListRV.setParam("Ref_Lot", refLot);
			omv_qListRV.setParam("Montant", montant);
			omv_qListRV.setParam("Beneficiaire", beneficiaire);
			omv_qListRV.setParam("Motif_Paiement", motifPaiement);
			omv_qListRV.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omv_qListRV.setParam("Current_Page", omv_pageCourante);

			var result = omv_qListRV.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('omv-totalRemises').value = contenu.getAttribute("Total");
			omv_nbPages = contenu.getAttribute("Nb_Pages");
			var listRemiseId = contenu.getAttribute("List_Remise_Id");

			omv_aRemises.setParam("List_Remise_Id", listRemiseId);
			omv_aRemises.initTree(omv_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_initPagination() {
	try {

		document.getElementById('omv-pageDeb').value = omv_pageCourante;
		document.getElementById('omv-pageFin').value = (omv_nbPages>0?omv_nbPages:1);
		document.getElementById('omv-bPrec').disabled = (omv_pageCourante==1);
		document.getElementById('omv-bSuiv').disabled = (omv_pageCourante>=omv_nbPages); // peut se produire si omv_nbPages=0

		document.getElementById('omv-tRemises').disabled = false;
		document.getElementById('omv-bEditionCsv').disabled = (omv_aRemises.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_pressOnPagePrec() {
	try {

		omv_pageCourante--;
		omv_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_pressOnPageSuiv() {
	try {

		omv_pageCourante++;
		omv_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_majPagination() {
	try {

		document.getElementById('omv-pageDeb').value = omv_pageCourante;
		document.getElementById('omv-bPrec').disabled = (omv_pageCourante==1);
		document.getElementById('omv-bSuiv').disabled = (omv_pageCourante==omv_nbPages);

		document.getElementById('omv-numRemiseSelect').value = "";

		document.getElementById('omv-tRemises').disabled = true;
		document.getElementById('omv-bEditionCsv').disabled = true;
		omv_aApercuRemise.deleteTree();

		omv_qListRV.setParam("Current_Page", omv_pageCourante);
		var result = omv_qListRV.execute();
		var listRemiseId = result.responseXML.documentElement.getAttribute("List_Remise_Id");

		omv_aRemises.setParam("List_Remise_Id", listRemiseId);
		omv_aRemises.initTree(omv_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_afterMajPagination() {
	try {

		document.getElementById('omv-tRemises').disabled = false;
		document.getElementById('omv-bEditionCsv').disabled=(omv_aRemises.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_selectOnListeRemises() {
	try {

		if (omv_aRemises.isSelected()) {
			var remiseId = omv_aRemises.getSelectedCellText('omv-colRemiseId');
			document.getElementById('omv-numRemiseSelect').value = omv_aRemises.getSelectedCellText('omv-colNumRemise');
			omv_aApercuRemise.setParam("Remise_Id", remiseId);
			omv_aApercuRemise.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_pressOnNouvelleRemise() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuVirements').collapsed = false;
		oerv_nouvelleRemise();

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omv_listerRemises();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omv_pressOnListeRemises(ev) {
  try {

		if (ev.keyCode==13) {
			omv_ouvrirRemise();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omv_ouvrirRemise() {
  try {

  	if (omv_aRemises.isSelected()) {
			var remiseId = omv_aRemises.getSelectedCellText('omv-colRemiseId');
			document.getElementById('bMenuVirements').collapsed = false;

			document.getElementById('deck').selectedIndex = 1;
			oerv_remiseId = remiseId;
			oerv_chargerRemise();
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omv_pressOnEditionCsv() {
	try {

		var numRemise = document.getElementById('omv-numRemise').value;
		var etat = document.getElementById('omv-etat').value;
		var banque = document.getElementById('omv-banque').value;
		var etablissement = document.getElementById('omv-etablissement').value;
		var dateDebutRem = document.getElementById('omv-dateDebutRem').value;
		var dateFinRem = document.getElementById('omv-dateFinRem').value;
		var dateDebutExe = document.getElementById('omv-dateDebutExe').value;
		var dateFinExe = document.getElementById('omv-dateFinExe').value;
		var numVirement = document.getElementById('omv-numVirement').value;
		var refLot = document.getElementById('omv-refLot').value;
		var montant = document.getElementById('omv-montant').value;
		var beneficiaire = document.getElementById('omv-beneficiaire').value;
		var motifPaiement = document.getElementById('omv-motifPaiement').value;

		if (!isEmpty(montant) && !isPositiveOrNull(montant)) { showWarning("Le montant est incorrect !"); }
		else if (!isEmpty(dateDebutRem) && !isDate(dateDebutRem)) { showWarning("Date de remise de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinRem) && !isDate(dateFinRem)) { showWarning("Date de remise de fin incorrecte !"); }
		else if (!isEmpty(dateDebutRem) && !isEmpty(dateFinRem) && !isDateInterval(dateDebutRem, dateFinRem)) { showWarning("Plage de dates de remise incorrecte !"); }
		else if (!isEmpty(dateDebutExe) && !isDate(dateDebutExe)) { showWarning("Date d'ex\u00E9cution de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinExe) && !isDate(dateFinExe)) { showWarning("Date d'ex\u00E9cution de fin incorrecte !"); }
		else if (!isEmpty(dateDebutExe) && !isEmpty(dateFinExe) && !isDateInterval(dateDebutExe, dateFinExe)) { showWarning("Plage de dates d'ex\u00E9cution incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("TB/Virements/csvRemiseVirement.tmpl");
			qEditionCsv.setParam("Num_Remise", numRemise);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Banque", banque);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Date_Debut_Rem", dateDebutRem);
			qEditionCsv.setParam("Date_Fin_Rem", dateFinRem);
			qEditionCsv.setParam("Date_Debut_Exe", dateDebutExe);
			qEditionCsv.setParam("Date_Fin_Exe", dateFinExe);
			qEditionCsv.setParam("Num_Virement", numVirement);
			qEditionCsv.setParam("Ref_Lot", refLot);
			qEditionCsv.setParam("Montant", montant);
			qEditionCsv.setParam("Beneficiaire", beneficiaire);
			qEditionCsv.setParam("Motif_Paiement", motifPaiement);

			var result = qEditionCsv.execute();
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omv_supprimerPreparations() {
  try {

		if (confirm("Confirmez-vous la suppression des remises de virements en pr\u00E9paration ?")) {
			document.getElementById('omv-bSupprimerPrep').disabled = true;
			var qSup = new QueryHttp("TB/Virements/deletePreparations.tmpl");
			qSup.execute(omv_listerRemises);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}
