/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omh_aHistoriques = new Arbre("Utilisateurs/Historiques/list-historique.tmpl", "omh-listeHistoriques");
var omh_qListHD = new QueryHttp("Utilisateurs/Historiques/getDataListHD.tmpl");


var omh_pageCourante;
var omh_nbPages;



function omh_init() {
	try {

		var omh_aDossiers = new Arbre("ComboListe/combo-dossiersEntreprise.tmpl", "omh-dossierId");
		omh_aDossiers.initTree(omh_initDossier);

		var omh_aUtilisateurs = new Arbre("ComboListe/combo-utilisateurs.tmpl", "omh-utilisateurId");
		omh_aUtilisateurs.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_initDossier() {
	try {

		if (document.getElementById("omh-dossierId").itemCount==2) {
			document.getElementById("omh-dossierId").selectedIndex = 1;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_initCriteres() {
	try {

		document.getElementById('omh-utilisateurId').value = "";
		document.getElementById('omh-typeDocument').value = "";
		document.getElementById('omh-dateDebut').value = "";
		document.getElementById('omh-dateFin').value = "";
		document.getElementById('omh-exclureTotaux').checked = false;
		document.getElementById('omh-histoAvantVal').checked = false;

		omh_listerHistoriques();

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_listerHistoriques() {
	try {

		var dossierId = document.getElementById('omh-dossierId').value;

		if (isEmpty(dossierId)) {
			showWarning("Veuillez s\u00E9lectionner un dossier");
		}
		else {
			var utilisateurId = document.getElementById('omh-utilisateurId').value;
			var typeDocument = document.getElementById('omh-typeDocument').value;
			var dateDebut = document.getElementById('omh-dateDebut').value;
			var dateFin = document.getElementById('omh-dateFin').value;
			var exclureTotaux = document.getElementById('omh-exclureTotaux').checked;
			var histoAvantVal = document.getElementById('omh-histoAvantVal').checked;
			var nbLignesParPage = document.getElementById('omh-nbLignesParPage').value;

			omh_pageCourante = 1;
			omh_nbPages = 1;
			document.getElementById('omh-pageDeb').value = 1;
			document.getElementById('omh-pageFin').value = 1;
			document.getElementById('omh-bPrec').disabled = true;
			document.getElementById('omh-bSuiv').disabled = true;

			document.getElementById('omh-listeHistoriques').disabled = true;
			document.getElementById('omh-bEditionCsv').disabled = true;
			omh_aHistoriques.deleteTree();

			omh_qListHD.setParam("Dossier_Id", dossierId);
			omh_qListHD.setParam("Utilisateur_Id", utilisateurId);
			omh_qListHD.setParam("Type_Document", typeDocument);
			omh_qListHD.setParam("Date_Debut", dateDebut);
			omh_qListHD.setParam("Date_Fin", dateFin);
			omh_qListHD.setParam("Exclure_Totaux", exclureTotaux);
			omh_qListHD.setParam("Histo_Avant_Val", histoAvantVal);
			omh_qListHD.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omh_qListHD.setParam("Current_Page", omh_pageCourante);

			var result = omh_qListHD.execute();

			var contenu = result.responseXML.documentElement;

			omh_nbPages = contenu.getAttribute("Nb_Pages");

			omh_aHistoriques.setParam("Dossier_Id", dossierId);
			omh_aHistoriques.setParam("List_Hist_CC", contenu.getAttribute("List_Hist_CC"));
			omh_aHistoriques.setParam("List_Hist_CF", contenu.getAttribute("List_Hist_CF"));
			omh_aHistoriques.setParam("List_Hist_DC", contenu.getAttribute("List_Hist_DC"));
			omh_aHistoriques.initTree(omh_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_initPagination() {
	try {

		document.getElementById('omh-pageDeb').value = omh_pageCourante;
		document.getElementById('omh-pageFin').value = (omh_nbPages>0?omh_nbPages:1);
		document.getElementById('omh-bPrec').disabled = (omh_pageCourante==1);
		document.getElementById('omh-bSuiv').disabled = (omh_pageCourante>=omh_nbPages); // peut se produire si omh_nbPages=0

		omh_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_pressOnPagePrec() {
	try {

		omh_pageCourante--;
		omh_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_pressOnPageSuiv() {
	try {

		omh_pageCourante++;
		omh_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_majPagination() {
	try {

		document.getElementById('omh-pageDeb').value = omh_pageCourante;
		document.getElementById('omh-bPrec').disabled = (omh_pageCourante==1);
		document.getElementById('omh-bSuiv').disabled = (omh_pageCourante==omh_nbPages);

		document.getElementById('omh-listeHistoriques').disabled = true;
		document.getElementById('omh-bEditionCsv').disabled = true;

		omh_qListHD.setParam("Current_Page", omh_pageCourante);
		var result = omh_qListHD.execute();
		var contenu = result.responseXML.documentElement;

		omh_aHistoriques.setParam("List_Hist_CC", contenu.getAttribute("List_Hist_CC"));
		omh_aHistoriques.setParam("List_Hist_CF", contenu.getAttribute("List_Hist_CF"));
		omh_aHistoriques.setParam("List_Hist_DC", contenu.getAttribute("List_Hist_DC"));
		omh_aHistoriques.initTree(omh_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_afterMajPagination() {
	try {

		document.getElementById('omh-listeHistoriques').disabled = false;
		document.getElementById('omh-bEditionCsv').disabled = (omh_aHistoriques.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omh_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omh_listerHistoriques();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omh_pressOnEditionCsv() {
	try {

		var dossierId = document.getElementById('omh-dossierId').value;
		var utilisateurId = document.getElementById('omh-utilisateurId').value;
		var typeDocument = document.getElementById('omh-typeDocument').value;
		var dateDebut = document.getElementById('omh-dateDebut').value;
		var dateFin = document.getElementById('omh-dateFin').value;
		var exclureTotaux = document.getElementById('omh-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('omh-histoAvantVal').checked;

		if (isEmpty(dossierId)) {
			showWarning("Veuillez s\u00E9lectionner un dossier");
		}
		else {
			var qEditionCsv = new QueryHttp("Utilisateurs/Historiques/csvHistorique.tmpl");
			qEditionCsv.setParam("Dossier_Id", dossierId);
			qEditionCsv.setParam("Utilisateur_Id", utilisateurId);
			qEditionCsv.setParam("Type_Document", typeDocument);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Exclure_Totaux", exclureTotaux);
			qEditionCsv.setParam("Histo_Avant_Val", histoAvantVal);

			var result = qEditionCsv.execute();
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
